/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static final String CATEGORY_TRADING = "record_trading";
    public static final String CATEGORY_CUSTOM = "custom_records";
    public static final String CATEGORY_DEBUG = "debug";
    public static boolean debugSoundEvents = false;
    public static boolean debugMusicHelper = false;
    public static boolean debugRecordStoreHelper = false;
    public static boolean debugRecordInfoManager = false;
    public static boolean debugJukeboxTick = false;
    public static boolean debugJukeboxRecordPlay = false;
    public static boolean debugGuiRecordTrading = false;
    public static boolean debugGuiJukebox = false;
    public static boolean debugNetworkJukebox = false;
    public static boolean debugNetworkRecordTrading = false;
    public static boolean debugNetworkCommands = false;
    public static int maxStores;
    public static int expirationTime;
    public static int maxOffers;
    public static int tradeUses;
    public static int recordPriceBuyMin;
    public static int recordPriceBuyMax;
    public static int recordPriceSellMin;
    public static int recordPriceSellMax;
    public static int shopChance;
    public static final int buyingOffersRatio = 60;
    public static int defaultSongTime;
    public static int maxSongTimeSeconds;
    private static final int DEFAULT_maxStores = 256;
    private static final int DEFAULT_expirationTime = 20;
    private static final int DEFAULT_maxOffers = 5;
    private static final int DEFAULT_tradeUses = 3;
    private static final int DEFAULT_recordPriceBuyMin = 5;
    private static final int DEFAULT_recordPriceBuyMax = 11;
    private static final int DEFAULT_recordPriceSellMin = 8;
    private static final int DEFAULT_recordPriceSellMax = 15;
    private static final int DEFAULT_shopChance = 70;
    private static final int DEFAULT_defaultSongTime = 120;
    private static final int DEFAULT_maxSongTimeSeconds = 1800;
    public static Configuration config;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigurationHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        defaultSongTime = config.getInt("song_time", "general", 120, 1, 3600, "", "sidben.redstonejukebox.config.song_time");
        maxSongTimeSeconds = config.getInt("max_song_time", "general", 1800, 1, 86400, "", "sidben.redstonejukebox.config.max_song_time");
        maxStores = config.getInt("max_stores", CATEGORY_TRADING, 256, 16, 1024, "", "sidben.redstonejukebox.config.max_stores");
        expirationTime = config.getInt("expiration_store", CATEGORY_TRADING, 20, 1, 1440, "", "sidben.redstonejukebox.config.expiration_store");
        shopChance = config.getInt("store_chance", CATEGORY_TRADING, 70, 0, 100, "", "sidben.redstonejukebox.config.store_chance");
        maxOffers = config.getInt("max_new_trades", CATEGORY_TRADING, 5, 3, 64, "", "sidben.redstonejukebox.config.max_trades");
        tradeUses = config.getInt("record_trade_count", CATEGORY_TRADING, 3, 1, Integer.MAX_VALUE, "", "sidben.redstonejukebox.config.record_trade_count");
        recordPriceBuyMin = config.getInt("record_buy_price_min", CATEGORY_TRADING, 5, 1, 64, "", "sidben.redstonejukebox.config.record_buy_price_min");
        recordPriceBuyMax = config.getInt("record_buy_price_max", CATEGORY_TRADING, 11, 1, 64, "", "sidben.redstonejukebox.config.record_buy_price_max");
        recordPriceSellMin = config.getInt("record_sell_price_min", CATEGORY_TRADING, 8, 1, 64, "", "sidben.redstonejukebox.config.record_sell_price_min");
        recordPriceSellMax = config.getInt("record_sell_price_max", CATEGORY_TRADING, 15, 1, 64, "", "sidben.redstonejukebox.config.record_sell_price_max");
        debugSoundEvents = config.getBoolean("debug_soundevents", CATEGORY_DEBUG, false, "");
        debugMusicHelper = config.getBoolean("debug_musichelper", CATEGORY_DEBUG, false, "");
        debugRecordStoreHelper = config.getBoolean("debug_recordstonehelper", CATEGORY_DEBUG, false, "");
        debugRecordInfoManager = config.getBoolean("debug_recordinfomanager", CATEGORY_DEBUG, false, "");
        debugJukeboxTick = config.getBoolean("debug_jukebox_tick", CATEGORY_DEBUG, false, "");
        debugJukeboxRecordPlay = config.getBoolean("debug_jukebox_recordplay", CATEGORY_DEBUG, false, "");
        debugGuiRecordTrading = config.getBoolean("debug_gui_trading", CATEGORY_DEBUG, false, "");
        debugGuiJukebox = config.getBoolean("debug_gui_jukebox", CATEGORY_DEBUG, false, "");
        debugNetworkJukebox = config.getBoolean("debug_network_jukebox", CATEGORY_DEBUG, false, "");
        debugNetworkRecordTrading = config.getBoolean("debug_network_trading", CATEGORY_DEBUG, false, "");
        debugNetworkCommands = config.getBoolean("debug_network_commands", CATEGORY_DEBUG, false, "");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("SidbenRedstoneJukebox")) {
            ConfigurationHandler.loadConfig();
        }
    }
}

