/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.helper;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.handler.ConfigurationHandler;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.helper.RecordInfo;

@SideOnly(value=Side.CLIENT)
public class MusicHelper {
    private final Map<ChunkCoordinates, ISound> mapJukeboxesPositions = Maps.newHashMap();
    private final Map<ChunkCoordinates, ISound> vanillaSoundPositions;
    private final HashBiMap<String, ISound> vanillaPlayingSounds;
    private ISound customBackgroundMusic;
    private final Minecraft mc;

    public MusicHelper(Minecraft minecraft) {
        this.mc = minecraft;
        SoundManager auxSndManager = (SoundManager)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)this.mc.func_147118_V(), (String[])new String[]{"field_147694_f", "sndManager"});
        this.vanillaPlayingSounds = (HashBiMap)ObfuscationReflectionHelper.getPrivateValue(SoundManager.class, (Object)auxSndManager, (String[])new String[]{"field_148629_h", "playingSounds"});
        if (this.vanillaPlayingSounds != null) {
            LogHelper.info("Vanilla playing sounds Map loaded.");
        } else {
            LogHelper.warn("Error loading vanilla playing sounds Map.");
        }
        this.vanillaSoundPositions = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)this.mc.field_71438_f, (String[])new String[]{"field_147593_P", "mapSoundPositions"});
        if (this.vanillaSoundPositions != null) {
            LogHelper.info("Vanilla sound positions Map loaded.");
        } else {
            LogHelper.warn("Error loading vanilla sound positions Map.");
        }
    }

    public void playRecordAt(int x, int y, int z, int recordInfoId, boolean showName, float volumeExtender) {
        ChunkCoordinates chunkcoordinates = new ChunkCoordinates(x, y, z);
        RecordInfo recordInfo = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoFromId(recordInfoId);
        if (ConfigurationHandler.debugMusicHelper) {
            LogHelper.info("MusicHelper.playRecordAt()");
            LogHelper.info("    Coords:         " + x + ", " + y + ", " + z);
            LogHelper.info("    Show name:      " + showName);
            LogHelper.info("    Extra volume:   " + volumeExtender);
            LogHelper.info("    Record info id: " + recordInfoId);
            LogHelper.info("    Record info:    " + recordInfo);
        }
        if (recordInfo != null) {
            float volumeRange = 64.0f;
            ResourceLocation recordResource = new ResourceLocation(recordInfo.recordUrl);
            if (volumeExtender >= 1.0f && volumeExtender <= 128.0f) {
                volumeRange += volumeExtender;
            }
            volumeRange /= 16.0f;
            this.stopPlayingAt(chunkcoordinates);
            if (recordResource != null) {
                if (showName && !recordInfo.recordName.isEmpty()) {
                    String recordTitle = StatCollector.func_74838_a((String)recordInfo.recordName);
                    this.mc.field_71456_v.func_73833_a(recordTitle);
                }
                PositionedSoundRecord sound = new PositionedSoundRecord(recordResource, volumeRange, 1.0f, (float)x, (float)y, (float)z);
                this.mapJukeboxesPositions.put(chunkcoordinates, (ISound)sound);
                this.mc.func_147118_V().func_147682_a((ISound)sound);
            }
        } else {
            this.stopPlayingAt(chunkcoordinates);
        }
    }

    public void stopPlayingAt(ChunkCoordinates chunkcoordinates) {
        ISound isound = this.mapJukeboxesPositions.get(chunkcoordinates);
        if (ConfigurationHandler.debugMusicHelper) {
            LogHelper.info("MusicHelper.stopPlayingAt()");
            LogHelper.info("    Coords:  " + chunkcoordinates.field_71574_a + ", " + chunkcoordinates.field_71572_b + ", " + chunkcoordinates.field_71573_c);
            LogHelper.info("    iSound:  " + isound);
        }
        if (isound != null) {
            this.mc.func_147118_V().func_147683_b(isound);
            this.mapJukeboxesPositions.remove(chunkcoordinates);
        }
    }

    public void playRecord(int recordInfoId, boolean showName) {
        ResourceLocation recordResource;
        RecordInfo recordInfo = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoFromId(recordInfoId);
        if (ConfigurationHandler.debugMusicHelper) {
            LogHelper.info("MusicHelper.playRecord()");
            LogHelper.info("    Show name:      " + showName);
            LogHelper.info("    Record info id: " + recordInfoId);
            LogHelper.info("    Record info:    " + recordInfo);
        }
        if (recordInfo != null && (recordResource = new ResourceLocation(recordInfo.recordUrl)) != null) {
            if (showName && !recordInfo.recordName.isEmpty()) {
                String recordTitle = StatCollector.func_74838_a((String)recordInfo.recordName);
                this.mc.field_71456_v.func_73833_a(recordTitle);
            }
            this.StopAllBackgroundMusic();
            this.customBackgroundMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)recordResource);
            this.mc.func_147118_V().func_147682_a(this.customBackgroundMusic);
        }
    }

    public void StopAllBackgroundMusic() {
        if (ConfigurationHandler.debugMusicHelper) {
            LogHelper.info("MusicHelper.StopAllBackgroundMusic()");
            LogHelper.info("    Custom BGMusic: " + this.IsCustomBackgroundMusicPlaying());
        }
        if (this.vanillaPlayingSounds == null) {
            return;
        }
        for (Map.Entry entry : this.vanillaPlayingSounds.entrySet()) {
            String soundId = (String)entry.getKey();
            ISound soundObj = (ISound)entry.getValue();
            if (!soundObj.func_147650_b().func_110623_a().startsWith("music.") && soundObj.func_147656_j() != ISound.AttenuationType.NONE && (soundObj.func_147649_g() != 0.0f || soundObj.func_147654_h() != 0.0f || soundObj.func_147651_i() != 0.0f)) continue;
            if (ConfigurationHandler.debugMusicHelper) {
                LogHelper.info("    Stopping sound [" + soundId + "] - " + soundObj.func_147650_b());
            }
            this.mc.func_147118_V().func_147683_b(soundObj);
        }
    }

    public void StopAllSounds() {
        this.mc.func_147118_V().func_147690_c();
    }

    public boolean IsCustomBackgroundMusicPlaying() {
        if (this.customBackgroundMusic != null) {
            return this.mc.func_147118_V().func_147692_c(this.customBackgroundMusic);
        }
        return false;
    }

    public boolean AnyJukeboxPlaying() {
        boolean p;
        ISound isound;
        for (Map.Entry<ChunkCoordinates, ISound> entry : this.vanillaSoundPositions.entrySet()) {
            isound = entry.getValue();
            p = this.mc.func_147118_V().func_147692_c(isound);
            if (!p) continue;
            return true;
        }
        for (Map.Entry<ChunkCoordinates, ISound> entry : this.mapJukeboxesPositions.entrySet()) {
            isound = entry.getValue();
            p = this.mc.func_147118_V().func_147692_c(isound);
            if (!p) continue;
            return true;
        }
        return false;
    }
}

