/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.helper;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import sidben.redstonejukebox.handler.ConfigurationHandler;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.helper.RecordInfo;

public class RecordInfoManager {
    private static final String RECORD_CLASS_FROM_MOD_HARDCOREEXNDEREXPANSION = "chylex.hee.item.ItemMusicDisk";
    private static final String RECORD_RESOURCEMETHOD_FROM_MOD_HARDCOREEXNDEREXPANSION = "getRecordData";
    private final Map<Integer, RecordInfo> recordsInfoCollection = Maps.newHashMap();
    private final String[] recordNamesList;
    private final int[] recordsInfoIdRandomCandidates;

    public RecordInfoManager() {
        int idCount = 0;
        int countVanillaRecords = 0;
        boolean countCustomRecords = false;
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.13", 178, "item.record.13.desc", Item.func_150891_b((Item)Items.field_151096_cd), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.cat", 184, "item.record.cat.desc", Item.func_150891_b((Item)Items.field_151093_ce), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.blocks", 345, "item.record.blocks.desc", Item.func_150891_b((Item)Items.field_151094_cf), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.chirp", 185, "item.record.chirp.desc", Item.func_150891_b((Item)Items.field_151091_cg), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.far", 174, "item.record.far.desc", Item.func_150891_b((Item)Items.field_151092_ch), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.mall", 197, "item.record.mall.desc", Item.func_150891_b((Item)Items.field_151089_ci), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.mellohi", 96, "item.record.mellohi.desc", Item.func_150891_b((Item)Items.field_151090_cj), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.stal", 150, "item.record.stal.desc", Item.func_150891_b((Item)Items.field_151087_ck), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.strad", 188, "item.record.strad.desc", Item.func_150891_b((Item)Items.field_151088_cl), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.ward", 251, "item.record.ward.desc", Item.func_150891_b((Item)Items.field_151085_cm), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.11", 71, "item.record.11.desc", Item.func_150891_b((Item)Items.field_151086_cn), 0));
        this.recordsInfoCollection.put(idCount++, new RecordInfo("minecraft:records.wait", 237, "item.record.wait.desc", Item.func_150891_b((Item)Items.field_151084_co), 0));
        LogHelper.info("Found 12 vanilla records");
        countVanillaRecords = idCount;
        if (Loader.isModLoaded((String)"PortalGun")) {
            this.recordsInfoCollection.put(idCount++, new RecordInfo("portalgun:records.radioloop", 21, "Valve - Radio Loop"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("portalgun:records.stillalive", 176, "Valve - Still Alive"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("portalgun:records.wantyougone", 141, "Valve - Want You Gone"));
            LogHelper.info("Found 3 records from the PortalGun mod");
        }
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            this.recordsInfoCollection.put(idCount++, new RecordInfo("biomesoplenty:records.wanderer", 289, "item.record_wanderer.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("biomesoplenty:records.corruption", 183, "item.record_corruption.desc"));
            LogHelper.info("Found 2 records from the Biomes O' Plenty mod");
        }
        if (Loader.isModLoaded((String)"VocaloidMod")) {
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:LoveIsWar", 234, "item.record.LoveIsWar.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:Melt", 257, "item.record.Melt.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:OnlineGameAddictsSprechchor", 287, "item.record.OnlineGameAddictsSprechchor.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:RollingGirl", 188, "item.record.RollingGirl.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:RomeoAndCinderella", 275, "item.record.RomeoAndCinderella.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:SPiCa", 213, "item.record.SPiCa.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:TellYourWorld", 252, "item.record.TellYourWorld.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:TwoFacedLovers", 182, "item.record.TwoFacedLovers.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:WeekenderGirl", 209, "item.record.WeekenderGirl.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:WorldIsMine", 251, "item.record.WorldIsMine.desc"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("vocaloidmod:Yellow", 196, "item.record.Yellow.desc"));
            LogHelper.info("Found 11 records from the Vocaloid mod");
        }
        if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.banjolic", 94, "qwertygiy - Banjolic"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.intheend", 213, "qwertygiy - In The End"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.asteroid", 58, "qwertygiy - Asteroid"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.stewed", 85, "qwertygiy - Stewed"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.beatthedragon", 114, "qwertygiy - Beat The Dragon"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.granite", 130, "qwertygiy - Granite"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.rememberthis", 85, "qwertygiy - Remember This"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.spyder", 133, "qwertygiy - Spyder"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.onion", 307, "qwertygiy - Onion"));
            this.recordsInfoCollection.put(idCount++, new RecordInfo("hardcoreenderexpansion:records.qwertygiy.cryingsoul", 130, "qwertygiy - Crying Soul"));
            LogHelper.info("Found 10 records from the Hardcore Ender Expansion mod");
        }
        LogHelper.info("Total amount of compatible records: " + this.recordsInfoCollection.size());
        String recordNames = "";
        for (Map.Entry<Integer, RecordInfo> entry : this.recordsInfoCollection.entrySet()) {
            recordNames = recordNames + ";" + entry.getValue().recordUrl;
        }
        recordNames = recordNames.substring(1);
        this.recordNamesList = recordNames.split(";");
        this.recordsInfoIdRandomCandidates = new int[countVanillaRecords + 0];
        for (int i = 0; i < countVanillaRecords; ++i) {
            this.recordsInfoIdRandomCandidates[i] = i;
        }
    }

    public boolean isRecord(ItemStack s) {
        return s != null && s.func_77973_b() instanceof ItemRecord;
    }

    public String[] getRecordNames() {
        return this.recordNamesList;
    }

    public String getRecordResourceUrl(ItemRecord record, int damageValue) {
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordResourceUrl(" + record + ", " + damageValue + ")");
        }
        String resourceName = "";
        if (record != null) {
            if (record.getClass().getName().equals(RECORD_CLASS_FROM_MOD_HARDCOREEXNDEREXPANSION)) {
                try {
                    Class<?> modClass = Class.forName(RECORD_CLASS_FROM_MOD_HARDCOREEXNDEREXPANSION);
                    Method modMethod = modClass.getMethod(RECORD_RESOURCEMETHOD_FROM_MOD_HARDCOREEXNDEREXPANSION, Integer.TYPE);
                    String[] modReturnValue = (String[])modMethod.invoke(null, damageValue);
                    resourceName = modReturnValue[1];
                    if (!resourceName.startsWith("hardcoreenderexpansion:")) {
                        resourceName = "hardcoreenderexpansion:" + resourceName;
                    }
                }
                catch (ClassNotFoundException e) {
                    LogHelper.error("Error reading record class from HardcoreEnderExpansion mod.");
                    LogHelper.error("    class name:    chylex.hee.item.ItemMusicDisk");
                    LogHelper.error("    exception:     " + e);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    LogHelper.error("Error reading record resource method from HardcoreEnderExpansion mod.");
                    LogHelper.error("    method name:   getRecordData");
                    LogHelper.error("    exception:     " + e);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LogHelper.error("Error invoking record resource method from HardcoreEnderExpansion mod.");
                    LogHelper.error("    method name:   getRecordData");
                    LogHelper.error("    exception:     " + e);
                }
                catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
                    LogHelper.error("Error coverting the return value of the record resource method HardcoreEnderExpansion mod.");
                    LogHelper.error("    exception:     " + e);
                }
            } else {
                resourceName = record.getRecordResource("records." + record.field_150929_a).toString();
            }
            if (ConfigurationHandler.debugRecordInfoManager) {
                LogHelper.info("RecordInfoManager.getRecordResourceUrl()    <-- [" + resourceName + "]");
            }
        }
        return resourceName;
    }

    public int getRecordInfoIdFromItemStack(ItemStack s) {
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoIdFromItemStack(" + LogHelper.itemStackToString(s) + ")");
        }
        int returnValue = -1;
        if (this.isRecord(s)) {
            ItemRecord record = (ItemRecord)s.func_77973_b();
            String resourceName = this.getRecordResourceUrl(record, s.func_77960_j());
            returnValue = this.getRecordInfoIdFromUrl(resourceName);
        }
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoIdFromItemStack()    <-- [" + returnValue + "]");
        }
        return returnValue;
    }

    public int getRecordInfoIdFromUrl(String resourceName) {
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoIdFromUrl('" + resourceName + "')");
        }
        int returnValue = -1;
        if (resourceName != null && !resourceName.isEmpty()) {
            for (Map.Entry<Integer, RecordInfo> entry : this.recordsInfoCollection.entrySet()) {
                if (entry.getValue().recordUrl == null || !entry.getValue().recordUrl.equalsIgnoreCase(resourceName)) continue;
                returnValue = entry.getKey();
                break;
            }
        }
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoIdFromUrl()    <-- [" + returnValue + "]");
        }
        return returnValue;
    }

    public RecordInfo getRecordInfoFromId(int recordInfoId) {
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoFromId(" + recordInfoId + ")");
        }
        RecordInfo returnValue = null;
        if (this.recordsInfoCollection.containsKey(recordInfoId)) {
            returnValue = this.recordsInfoCollection.get(recordInfoId);
        }
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getRecordInfoFromId()    <-- [" + returnValue + "]");
        }
        return returnValue;
    }

    public int getSongTime(ItemStack s) {
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getSongTime(" + LogHelper.itemStackToString(s) + ")");
        }
        int returnValue = ConfigurationHandler.defaultSongTime;
        int infoId = this.getRecordInfoIdFromItemStack(s);
        RecordInfo recordInfo = this.getRecordInfoFromId(infoId);
        if (recordInfo != null && recordInfo.getRecordDurationSeconds() >= 0) {
            returnValue = recordInfo.getRecordDurationSeconds();
        }
        if (ConfigurationHandler.debugRecordInfoManager) {
            LogHelper.info("RecordInfoManager.getSongTime()    <-- [" + returnValue + "]");
        }
        return returnValue;
    }

    public ItemStack getRandomRecord(Random rand) {
        try {
            int randomPosition = rand.nextInt(this.recordsInfoIdRandomCandidates.length);
            int randomInfoId = this.recordsInfoIdRandomCandidates[randomPosition];
            RecordInfo recordInfo = this.recordsInfoCollection.get(randomInfoId);
            Item recordItem = Item.func_150899_d((int)recordInfo.recordItemId);
            if (ConfigurationHandler.debugRecordInfoManager) {
                LogHelper.info("RecordInfoManager.getRandomRecord()");
                LogHelper.info("    Record info: " + recordInfo);
                LogHelper.info("    Item: " + recordItem);
            }
            return new ItemStack(recordItem, 1, recordInfo.recordItemDamage);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LogHelper.error("Error getting random record: " + e);
            return null;
        }
    }
}

