/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.handler.ConfigurationHandler;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.init.MyItems;

public class RecordStoreHelper {
    private final Random rand = new Random();
    private final LoadingCache<Integer, MerchantRecipeList> storeCache = CacheBuilder.newBuilder().maximumSize((long)ConfigurationHandler.maxStores).expireAfterAccess((long)ConfigurationHandler.expirationTime, TimeUnit.MINUTES).recordStats().build((CacheLoader)new CacheLoader<Integer, MerchantRecipeList>(){

        public MerchantRecipeList load(Integer key) throws Exception {
            int luck = RecordStoreHelper.this.rand.nextInt(100) + 1;
            MerchantRecipeList store = luck <= ConfigurationHandler.shopChance ? RecordStoreHelper.this.createRandomStore() : new MerchantRecipeList();
            return store;
        }
    });
    public MerchantRecipeList clientSideCurrentStore = new MerchantRecipeList();

    public MerchantRecipeList getStore(int villagerId) {
        MerchantRecipeList list;
        if (villagerId < 0) {
            return null;
        }
        if (ConfigurationHandler.debugRecordStoreHelper) {
            LogHelper.info("RecordStoreHelper.getStore(" + villagerId + ")");
        }
        try {
            list = (MerchantRecipeList)this.storeCache.get((Object)villagerId);
        }
        catch (ExecutionException e) {
            LogHelper.error(e);
            list = null;
        }
        if (ConfigurationHandler.debugRecordStoreHelper) {
            LogHelper.info("RecordStoreHelper.getStore() <-- [" + list + "]");
            CacheStats cacheStats = this.storeCache.stats();
            LogHelper.info("* RecordStoreHelper - " + cacheStats.toString());
        }
        return list;
    }

    public void useRecipe(MerchantRecipe recipe, EntityPlayer player) {
        if (ConfigurationHandler.debugRecordStoreHelper) {
            LogHelper.info("RecordStoreHelper.useRecipe(" + LogHelper.recipeToString(recipe) + ", " + player + ")");
        }
        recipe.func_77399_f();
    }

    MerchantRecipeList createRandomStore() {
        if (ConfigurationHandler.debugRecordStoreHelper) {
            LogHelper.info("RecordStoreHelper.createRandomStore()");
        }
        MerchantRecipeList store = new MerchantRecipeList();
        LinkedList<EnumRecipeType> offers = new LinkedList<EnumRecipeType>();
        int offersSize = this.rand.nextInt(ConfigurationHandler.maxOffers);
        if (offersSize < 3) {
            offersSize = 3;
        }
        if (this.rand.nextInt(10) < 5) {
            offers.add(EnumRecipeType.BUYING_RECORDS);
            offers.add(EnumRecipeType.SELLING_RECORDS);
        } else {
            offers.add(EnumRecipeType.SELLING_RECORDS);
            offers.add(EnumRecipeType.BUYING_RECORDS);
        }
        int spareOffers = 5;
        for (int i = 0; i < offersSize + 5; ++i) {
            int luck = this.rand.nextInt(100) + 1;
            EnumRecipeType luckType = luck <= 60 ? EnumRecipeType.BUYING_RECORDS : EnumRecipeType.SELLING_RECORDS;
            offers.add(luckType);
        }
        String recordName = "";
        ArrayList<String> usedRecords = new ArrayList<String>();
        for (EnumRecipeType t : offers) {
            ItemStack record;
            MerchantRecipe recipe = this.getRandomRecipe(t);
            if (ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(recipe.func_77394_a())) {
                record = recipe.func_77394_a();
            } else if (ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(recipe.func_77397_d())) {
                record = recipe.func_77397_d();
            } else if (ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(recipe.func_77396_b())) {
                record = recipe.func_77396_b();
            } else {
                record = null;
                recordName = "";
            }
            if (record != null) {
                recordName = ((ItemRecord)record.func_77973_b()).field_150929_a;
            }
            if (record != null && !usedRecords.contains(recordName)) {
                store.add((Object)recipe);
                usedRecords.add(recordName);
            }
            if (store.size() < offersSize) continue;
            break;
        }
        usedRecords = null;
        return store;
    }

    MerchantRecipe getRandomRecipe(EnumRecipeType type) {
        MerchantRecipe recipe;
        int auxPriceMax;
        int auxPriceMin;
        ItemStack emptyDisc = new ItemStack((Item)MyItems.recordBlank, 1);
        ItemStack musicDisc = null;
        ItemStack emeralds = null;
        musicDisc = ModRedstoneJukebox.instance.getRecordInfoManager().getRandomRecord(this.rand);
        if (type == EnumRecipeType.BUYING_RECORDS) {
            auxPriceMin = ConfigurationHandler.recordPriceBuyMin;
            auxPriceMax = ConfigurationHandler.recordPriceBuyMax;
        } else if (type == EnumRecipeType.SELLING_RECORDS) {
            auxPriceMin = ConfigurationHandler.recordPriceSellMin;
            auxPriceMax = ConfigurationHandler.recordPriceSellMax;
        } else {
            return null;
        }
        emeralds = auxPriceMin == auxPriceMax ? new ItemStack(Items.field_151166_bC, auxPriceMin) : new ItemStack(Items.field_151166_bC, this.rand.nextInt(auxPriceMax - auxPriceMin + 1) + auxPriceMin);
        if (type == EnumRecipeType.BUYING_RECORDS) {
            recipe = new MerchantRecipe(musicDisc, emeralds);
        } else if (type == EnumRecipeType.SELLING_RECORDS) {
            recipe = new MerchantRecipe(emptyDisc, emeralds, musicDisc);
        } else {
            return null;
        }
        int recipeStock = this.rand.nextInt(ConfigurationHandler.tradeUses) + 1;
        recipe.func_82783_a(recipeStock - 7);
        return recipe;
    }

    public static enum EnumRecipeType {
        BUYING_RECORDS,
        SELLING_RECORDS;

    }
}

