/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.tileentity.TileEntityRedstoneJukebox;

public class JukeboxPlayRecordMessage
implements IMessage {
    private int recordInfoId;
    private int x;
    private int y;
    private int z;
    private byte jukeboxSlot;
    private int extraRange;

    public JukeboxPlayRecordMessage() {
    }

    public JukeboxPlayRecordMessage(TileEntityRedstoneJukebox teJukebox, int recordInfoId, byte selectedSlot, int extraRange) {
        this.recordInfoId = recordInfoId;
        this.jukeboxSlot = selectedSlot;
        this.x = teJukebox.field_145851_c;
        this.y = teJukebox.field_145848_d;
        this.z = teJukebox.field_145849_e;
        this.extraRange = extraRange;
    }

    public void fromBytes(ByteBuf buf) {
        this.recordInfoId = buf.readInt();
        this.jukeboxSlot = buf.readByte();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.extraRange = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recordInfoId);
        buf.writeByte((int)this.jukeboxSlot);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.extraRange);
    }

    public void updateJukeboxAndPlayRecord() {
        World world = ModRedstoneJukebox.proxy.getClientWorld();
        if (world != null) {
            TileEntity teCandidate = world.func_147438_o(this.x, this.y, this.z);
            if (teCandidate instanceof TileEntityRedstoneJukebox) {
                TileEntityRedstoneJukebox teJukebox = (TileEntityRedstoneJukebox)teCandidate;
                if (this.recordInfoId < 0) {
                    teJukebox.setCurrentJukeboxPlaySlot((byte)-1);
                } else {
                    teJukebox.setCurrentJukeboxPlaySlot(this.jukeboxSlot);
                }
            } else {
                LogHelper.warn("RedstoneJukebox TileEntity at " + this.x + ", " + this.y + ", " + this.z + " not found, can't sync client. Found this instead: " + teCandidate);
            }
            if (this.recordInfoId < 0) {
                ChunkCoordinates chunkcoordinates = new ChunkCoordinates(this.x, this.y, this.z);
                ModRedstoneJukebox.instance.getMusicHelper().stopPlayingAt(chunkcoordinates);
            } else {
                ModRedstoneJukebox.instance.getMusicHelper().playRecordAt(this.x, this.y, this.z, this.recordInfoId, true, this.extraRange);
            }
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Record info id = ");
        r.append(this.recordInfoId);
        r.append(", Slot = ");
        r.append(this.jukeboxSlot);
        r.append(", Coords = ");
        r.append(this.x);
        r.append(", ");
        r.append(this.y);
        r.append(", ");
        r.append(this.z);
        r.append(", Extra range = ");
        r.append(this.extraRange);
        return r.toString();
    }
}

