/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.handler.ConfigurationHandler;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.network.CommandPlayRecordAtMessage;
import sidben.redstonejukebox.network.CommandPlayRecordMessage;
import sidben.redstonejukebox.network.CommandStopAllRecordsMessage;
import sidben.redstonejukebox.network.JukeboxGUIUpdatedMessage;
import sidben.redstonejukebox.network.JukeboxPlayRecordMessage;
import sidben.redstonejukebox.network.RecordTradingFullListMessage;
import sidben.redstonejukebox.network.RecordTradingGUIUpdatedMessage;
import sidben.redstonejukebox.tileentity.TileEntityRedstoneJukebox;

public class NetworkHelper {
    public static void sendJukeboxGUIUpdatedMessage(TileEntityRedstoneJukebox teJukebox) {
        if (teJukebox == null) {
            return;
        }
        JukeboxGUIUpdatedMessage message = new JukeboxGUIUpdatedMessage(teJukebox);
        if (ConfigurationHandler.debugGuiJukebox) {
            LogHelper.info("Sending JukeboxGUIUpdatedMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendToServer((IMessage)message);
    }

    public static void sendJukeboxPlayRecordMessage(TileEntityRedstoneJukebox teJukebox, int recordInfoId, byte slot, int volumeExtender) {
        int defaultJukeboxRange = 64;
        int extraRangeForNearbyPlayers = 32;
        int targetRange = 96 + volumeExtender;
        JukeboxPlayRecordMessage message = new JukeboxPlayRecordMessage(teJukebox, recordInfoId, slot, volumeExtender);
        NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(teJukebox.func_145831_w().field_73011_w.field_76574_g, (double)teJukebox.field_145851_c, (double)teJukebox.field_145848_d, (double)teJukebox.field_145849_e, (double)targetRange);
        if (ConfigurationHandler.debugNetworkJukebox) {
            LogHelper.info("Sending JukeboxPlayRecordMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendToAllAround((IMessage)message, target);
    }

    public static void sendRecordTradingGUIUpdatedMessage(int recipeIndex) {
        RecordTradingGUIUpdatedMessage message = new RecordTradingGUIUpdatedMessage(recipeIndex);
        if (ConfigurationHandler.debugGuiRecordTrading) {
            LogHelper.info("Sending RecordTradingGUIUpdatedMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendToServer((IMessage)message);
    }

    public static void sendRecordTradingFullListMessage(MerchantRecipeList list, EntityPlayer entityPlayer) {
        RecordTradingFullListMessage message = new RecordTradingFullListMessage(list);
        if (ConfigurationHandler.debugNetworkRecordTrading) {
            LogHelper.info("Sending RecordTradingFullListMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendTo((IMessage)message, (EntityPlayerMP)entityPlayer);
    }

    public static void sendCommandPlayRecordAtMessage(int recordInfoId, boolean showName, double x, double y, double z, int range, EntityPlayerMP entityPlayer) {
        CommandPlayRecordAtMessage message = new CommandPlayRecordAtMessage(recordInfoId, showName, x, y, z, range);
        if (ConfigurationHandler.debugNetworkCommands) {
            LogHelper.info("Sending CommandPlayRecordAtMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendTo((IMessage)message, entityPlayer);
    }

    public static void sendCommandPlayRecordMessage(int recordInfoId, boolean showName) {
        CommandPlayRecordMessage message = new CommandPlayRecordMessage(recordInfoId, showName);
        if (ConfigurationHandler.debugNetworkCommands) {
            LogHelper.info("Sending CommandPlayRecordMessage");
            LogHelper.info("    " + message);
        }
        ModRedstoneJukebox.NetworkWrapper.sendToAll((IMessage)message);
    }

    public static void sendCommandStopAllRecordsMessage(EntityPlayerMP entityPlayer) {
        CommandStopAllRecordsMessage message = new CommandStopAllRecordsMessage();
        if (ConfigurationHandler.debugNetworkCommands) {
            LogHelper.info("Sending CommandStopAllRecordsMessage");
        }
        ModRedstoneJukebox.NetworkWrapper.sendTo((IMessage)message, entityPlayer);
    }

    public static class CommandStopAllRecordsHandler
    implements IMessageHandler<CommandStopAllRecordsMessage, IMessage> {
        public IMessage onMessage(CommandStopAllRecordsMessage message, MessageContext ctx) {
            if (ConfigurationHandler.debugNetworkCommands) {
                LogHelper.info("Handling CommandStopAllRecordsMessage");
            }
            message.stopMusic();
            return null;
        }
    }

    public static class CommandPlayRecordHandler
    implements IMessageHandler<CommandPlayRecordMessage, IMessage> {
        public IMessage onMessage(CommandPlayRecordMessage message, MessageContext ctx) {
            if (ConfigurationHandler.debugNetworkCommands) {
                LogHelper.info("Handling CommandPlayRecordMessage");
                LogHelper.info("    " + message);
            }
            message.playRecord();
            return null;
        }
    }

    public static class CommandPlayRecordAtHandler
    implements IMessageHandler<CommandPlayRecordAtMessage, IMessage> {
        public IMessage onMessage(CommandPlayRecordAtMessage message, MessageContext ctx) {
            if (ConfigurationHandler.debugNetworkCommands) {
                LogHelper.info("Handling CommandPlayRecordAtMessage");
                LogHelper.info("    " + message);
            }
            message.playRecord();
            return null;
        }
    }

    public static class RecordTradingFullListHandler
    implements IMessageHandler<RecordTradingFullListMessage, IMessage> {
        public IMessage onMessage(RecordTradingFullListMessage message, MessageContext ctx) {
            if (ConfigurationHandler.debugNetworkRecordTrading) {
                LogHelper.info("Handling RecordTradingFullListMessage");
                LogHelper.info("    " + message);
            }
            ctx.getClientHandler();
            message.updateClientSideRecordStore();
            return null;
        }
    }

    public static class RecordTradingGUIHandler
    implements IMessageHandler<RecordTradingGUIUpdatedMessage, IMessage> {
        public IMessage onMessage(RecordTradingGUIUpdatedMessage message, MessageContext ctx) {
            EntityPlayerMP player;
            if (ConfigurationHandler.debugGuiRecordTrading) {
                LogHelper.info("Handling RecordTradingGUIUpdatedMessage");
                LogHelper.info("    " + message);
            }
            if ((player = ctx.getServerHandler().field_147369_b) == null) {
                LogHelper.warn("Target player not found for message [" + message + "]");
            } else {
                message.updatePlayer(player);
            }
            return null;
        }
    }

    public static class JukeboxPlayRecordHandler
    implements IMessageHandler<JukeboxPlayRecordMessage, IMessage> {
        public IMessage onMessage(JukeboxPlayRecordMessage message, MessageContext ctx) {
            if (ConfigurationHandler.debugNetworkJukebox) {
                LogHelper.info("Handling JukeboxPlayRecordMessage");
                LogHelper.info("    " + message);
            }
            message.updateJukeboxAndPlayRecord();
            return null;
        }
    }

    public static class JukeboxGUIHandler
    implements IMessageHandler<JukeboxGUIUpdatedMessage, IMessage> {
        public IMessage onMessage(JukeboxGUIUpdatedMessage message, MessageContext ctx) {
            World world;
            if (ConfigurationHandler.debugGuiJukebox) {
                LogHelper.info("Handling JukeboxGUIUpdatedMessage");
                LogHelper.info("    " + message);
            }
            if ((world = ctx.getServerHandler().field_147369_b.field_70170_p) == null) {
                LogHelper.warn("Server world not found for message [" + message + "]");
            } else {
                message.updateJukebox(world);
            }
            return null;
        }
    }
}

