/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.network;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.helper.RecordInfo;
import sidben.redstonejukebox.init.MyItems;

public class RecordTradingFullListMessage
implements IMessage {
    private static final byte TYPE_SELLING = 1;
    private static final byte TYPE_BUYING = 2;
    private MerchantRecipeList tradeList;

    public RecordTradingFullListMessage() {
    }

    public RecordTradingFullListMessage(MerchantRecipeList list) {
        this.tradeList = list;
    }

    public void fromBytes(ByteBuf buf) {
        this.tradeList = new MerchantRecipeList();
        short listSize = buf.readShort();
        for (short i = 0; i < listSize; i = (short)(i + 1)) {
            byte tradeType = buf.readByte();
            int recordInfoId = buf.readInt();
            short emeraldPrice = buf.readShort();
            int recipeUses = buf.readInt();
            int recipeMaxUses = buf.readInt();
            if (recordInfoId <= -1 || emeraldPrice <= 0) continue;
            MerchantRecipe recipe = null;
            RecordInfo recordInfo = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoFromId(recordInfoId);
            Item recordItem = Item.func_150899_d((int)recordInfo.recordItemId);
            ItemStack emptyDisc = new ItemStack((Item)MyItems.recordBlank, 1);
            ItemStack musicDisc = new ItemStack(recordItem, 1, recordInfo.recordItemDamage);
            ItemStack emeralds = new ItemStack(Items.field_151166_bC, (int)emeraldPrice);
            if (tradeType == 2) {
                recipe = new MerchantRecipe(musicDisc, emeralds);
            } else if (tradeType == 1) {
                recipe = new MerchantRecipe(emptyDisc, emeralds, musicDisc);
            }
            if (recipeMaxUses != 7) {
                recipe.func_82783_a(recipeMaxUses - 7);
            }
            if (recipeUses > 0) {
                for (int j = 0; j < recipeUses; ++j) {
                    recipe.func_77399_f();
                }
            }
            this.tradeList.add((Object)recipe);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.tradeList.size());
        for (Object obj : this.tradeList) {
            MerchantRecipe recipe = (MerchantRecipe)obj;
            ItemStack slotBuy1 = recipe.func_77394_a();
            ItemStack slotBuy2 = recipe.func_77396_b();
            ItemStack slotSell = recipe.func_77397_d();
            int recordInfoId = -1;
            if (slotSell.func_77973_b() == Items.field_151166_bC) {
                recordInfoId = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoIdFromItemStack(slotBuy1);
                if (recordInfoId > -1) {
                    buf.writeByte(2);
                    buf.writeInt(recordInfoId);
                    buf.writeShort(slotSell.field_77994_a);
                }
            } else {
                recordInfoId = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoIdFromItemStack(slotSell);
                if (recordInfoId > -1) {
                    buf.writeByte(1);
                    buf.writeInt(recordInfoId);
                    buf.writeShort(slotBuy2.field_77994_a);
                }
            }
            if (recordInfoId <= -1) continue;
            Object hiddenMax = ObfuscationReflectionHelper.getPrivateValue(MerchantRecipe.class, (Object)recipe, (String[])new String[]{"maxTradeUses", "field_82786_e"});
            Object hiddenUses = ObfuscationReflectionHelper.getPrivateValue(MerchantRecipe.class, (Object)recipe, (String[])new String[]{"toolUses", "field_77400_d"});
            int recipeMaxUses = hiddenMax == null ? -1 : (Integer)hiddenMax;
            int recipeUses = hiddenUses == null ? -1 : (Integer)hiddenUses;
            buf.writeInt(recipeUses);
            buf.writeInt(recipeMaxUses);
        }
    }

    public void updateClientSideRecordStore() {
        ModRedstoneJukebox.instance.getRecordStoreHelper().clientSideCurrentStore = this.tradeList;
    }

    public String toString() {
        return LogHelper.recipeListToString(this.tradeList);
    }
}

