/*
 * Decompiled with CFR 0.152.
 */
package sidben.redstonejukebox.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sidben.redstonejukebox.ModRedstoneJukebox;
import sidben.redstonejukebox.block.BlockRedstoneJukebox;
import sidben.redstonejukebox.handler.ConfigurationHandler;
import sidben.redstonejukebox.helper.LogHelper;
import sidben.redstonejukebox.helper.RecordInfo;
import sidben.redstonejukebox.network.NetworkHelper;

public class TileEntityRedstoneJukebox
extends TileEntity
implements IInventory {
    private ItemStack[] jukeboxItems = new ItemStack[8];
    public short paramPlayMode = 0;
    public boolean paramLoop = false;
    private byte[] playOrder = new byte[8];
    private boolean isBlockPowered = false;
    private boolean isPlaylistStarted = false;
    private boolean isPlaylistFinished = false;
    private int currentIndex = -1;
    private byte currentJukeboxPlaySlot = (byte)-1;
    private static int songInterval = 0;
    public int songTimer = 0;
    private boolean schedulePlayNextRecord = false;
    private boolean scheduleStartPlaying = false;
    private boolean scheduleStopPlaying = false;
    private String customName;
    private int _jukeboxExtraVolumeCached = -1;

    public int func_70302_i_() {
        return this.jukeboxItems.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.jukeboxItems[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.jukeboxItems[slot] != null) {
            if (this.jukeboxItems[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.jukeboxItems[slot];
                this.jukeboxItems[slot] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.jukeboxItems[slot].func_77979_a(amount);
            if (this.jukeboxItems[slot].field_77994_a == 0) {
                this.jukeboxItems[slot] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.jukeboxItems[slot] != null) {
            ItemStack itemstack = this.jukeboxItems[slot];
            this.jukeboxItems[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.jukeboxItems[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.redstoneJukebox";
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack s) {
        return ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(s);
    }

    public void resync() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.jukeboxItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.jukeboxItems.length) continue;
            this.jukeboxItems[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.paramPlayMode = par1NBTTagCompound.func_74765_d("PlayMode");
        this.paramLoop = par1NBTTagCompound.func_74767_n("Loop");
        this.isBlockPowered = par1NBTTagCompound.func_74767_n("Powered");
        this.isPlaylistStarted = par1NBTTagCompound.func_74767_n("PlayStarted");
        this.isPlaylistFinished = par1NBTTagCompound.func_74767_n("PlayFinished");
        this.playOrder = par1NBTTagCompound.func_74770_j("PlaylistOrder");
        this.currentIndex = par1NBTTagCompound.func_74762_e("PlaylistIndex");
        if (this.playOrder == null || this.playOrder.length != 8) {
            this.playOrder = new byte[8];
        }
        if (this.currentIndex >= 0) {
            --this.currentIndex;
        }
        if (par1NBTTagCompound.func_150297_b("CustomName", 8)) {
            this.customName = par1NBTTagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("PlayMode", this.paramPlayMode);
        par1NBTTagCompound.func_74757_a("Loop", this.paramLoop);
        par1NBTTagCompound.func_74757_a("Powered", this.isBlockPowered);
        par1NBTTagCompound.func_74757_a("PlayStarted", this.isPlaylistStarted);
        par1NBTTagCompound.func_74757_a("PlayFinished", this.isPlaylistFinished);
        par1NBTTagCompound.func_74773_a("PlaylistOrder", this.playOrder);
        par1NBTTagCompound.func_74768_a("PlaylistIndex", this.currentIndex);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.jukeboxItems.length; ++i) {
            if (this.jukeboxItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.jukeboxItems[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            par1NBTTagCompound.func_74778_a("CustomName", this.customName);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.paramPlayMode = tag.func_74765_d("PlayMode");
        this.paramLoop = tag.func_74767_n("Loop");
        this.currentJukeboxPlaySlot = tag.func_74771_c("InvSlot");
        if (ConfigurationHandler.debugNetworkJukebox) {
            LogHelper.info("TileEntityRedstoneJukebox.onDataPacket()");
            LogHelper.info("    PlayMode: " + this.paramPlayMode);
            LogHelper.info("    Loop:     " + this.paramLoop);
            LogHelper.info("    Slot:     " + this.currentJukeboxPlaySlot);
            LogHelper.info("    Index:    " + this.currentIndex);
            LogHelper.info("    Coords:   " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        if (ConfigurationHandler.debugNetworkJukebox) {
            LogHelper.info("TileEntityRedstoneJukebox.getDescriptionPacket()");
            LogHelper.info("    PlayMode: " + this.paramPlayMode);
            LogHelper.info("    Loop:     " + this.paramLoop);
            LogHelper.info("    Slot:     " + this.currentJukeboxPlaySlot);
            LogHelper.info("    Index:    " + this.currentIndex);
            LogHelper.info("    Coords:   " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("PlayMode", this.paramPlayMode);
        tag.func_74757_a("Loop", this.paramLoop);
        tag.func_74774_a("InvSlot", this.currentJukeboxPlaySlot);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void tickJukebox() {
        if (!this.field_145850_b.field_72995_K) {
            if (ConfigurationHandler.debugJukeboxTick) {
                LogHelper.info("Jukebox.tickJukebox() @ " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " isPlaying: " + this.isPlaying() + " - isBlockPowered: " + this.isBlockPowered + " - schdPlayNext: " + this.schedulePlayNextRecord + " - schdStart: " + this.scheduleStartPlaying + " - schdStop: " + this.scheduleStopPlaying + " - playlistFinish: " + this.isPlaylistFinished + " - songTimer: " + this.songTimer + " - gameTick: " + MinecraftServer.func_71276_C().func_71259_af());
            }
            if (this.schedulePlayNextRecord) {
                this.playNextRecord();
            } else if (this.scheduleStartPlaying) {
                this.startPlaying();
                this.playNextRecord();
            } else if (this.scheduleStopPlaying) {
                this.stopPlaying(true);
            }
            if (!this.isBlockPowered) {
                return;
            }
            if (!this.isPlaylistFinished) {
                if (this.songTimer > 0) {
                    ItemStack record;
                    --this.songTimer;
                    if (this.currentJukeboxPlaySlot > -1 && (record = this.jukeboxItems[this.currentJukeboxPlaySlot]) == null) {
                        this.schedulePlayNextRecord = true;
                    }
                } else {
                    this.schedulePlayNextRecord = true;
                }
            }
        }
    }

    public void startPlaying() {
        if (ConfigurationHandler.debugJukeboxRecordPlay) {
            LogHelper.info("Jukebox.startPlaying() @ (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ") - Empty: " + this.isEmpty());
        }
        if (this.isEmpty()) {
            return;
        }
        this.isPlaylistFinished = false;
        this.isPlaylistStarted = true;
        this.setPlaylistOrder();
        this.scheduleStartPlaying = false;
        this.schedulePlayNextRecord = true;
    }

    public void stopPlaying(boolean updateNeighbors) {
        this.currentIndex = -1;
        this.currentJukeboxPlaySlot = (byte)-1;
        this.songTimer = 0;
        this.scheduleStopPlaying = false;
        if (ConfigurationHandler.debugJukeboxRecordPlay) {
            LogHelper.info("Jukebox.stopPlaying() @ (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ")");
        }
        NetworkHelper.sendJukeboxPlayRecordMessage(this, -1, (byte)-1, 0);
        if (updateNeighbors) {
            BlockRedstoneJukebox.updateJukeboxBlockState(this.isBlockPowered, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void playNextRecord() {
        if (ConfigurationHandler.debugJukeboxRecordPlay) {
            LogHelper.info("Jukebox.playNextRecord() @ (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ") - playlist index: " + this.currentIndex + " - current slot: " + this.currentJukeboxPlaySlot + " - Empty: " + this.isEmpty());
        }
        if (this.isEmpty()) {
            return;
        }
        ++this.currentIndex;
        this.schedulePlayNextRecord = false;
        if (this.currentIndex >= 0 && this.currentIndex < this.func_70302_i_()) {
            ItemStack nextRecordStack = null;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.currentJukeboxPlaySlot = this.playOrder[this.currentIndex];
                nextRecordStack = this.jukeboxItems[this.currentJukeboxPlaySlot];
                if (ConfigurationHandler.debugJukeboxRecordPlay) {
                    LogHelper.info("    checking item #" + this.currentIndex + " on slot " + this.currentJukeboxPlaySlot + ": " + LogHelper.itemStackToString(nextRecordStack));
                }
                if (nextRecordStack != null || this.currentIndex + 1 >= this.func_70302_i_()) break;
                ++this.currentIndex;
            }
            int recordInfoId = -1;
            RecordInfo recordInfo = null;
            if (ConfigurationHandler.debugJukeboxRecordPlay && ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(nextRecordStack)) {
                ItemRecord debugRecord = (ItemRecord)nextRecordStack.func_77973_b();
                LogHelper.info("    * recordName:       " + debugRecord.field_150929_a);
                LogHelper.info("    * record resource:  " + debugRecord.getRecordResource(debugRecord.field_150929_a));
                if (this.field_145850_b.field_72995_K) {
                    LogHelper.info("    * recordName Local: " + debugRecord.func_150927_i());
                }
            }
            if (nextRecordStack != null) {
                recordInfoId = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoIdFromItemStack(nextRecordStack);
                recordInfo = ModRedstoneJukebox.instance.getRecordInfoManager().getRecordInfoFromId(recordInfoId);
            }
            if (recordInfo != null && recordInfo.getRecordDurationSeconds() > 0) {
                if (ConfigurationHandler.debugJukeboxRecordPlay) {
                    LogHelper.info("    Record info id: " + recordInfoId);
                    LogHelper.info("    Song time:      " + recordInfo.getRecordDurationSeconds() + " + " + songInterval + " (jukebox interval)");
                }
                this.songTimer = recordInfo.getRecordDurationSeconds() + songInterval;
                NetworkHelper.sendJukeboxPlayRecordMessage(this, recordInfoId, this.getCurrentJukeboxPlaySlot(), this.getExtraVolume(true));
                BlockRedstoneJukebox.updateJukeboxBlockState(this.isBlockPowered, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                if (ConfigurationHandler.debugJukeboxRecordPlay) {
                    LogHelper.info("    Invalid record, skipping to next slot");
                }
                this.schedulePlayNextRecord = true;
            }
        }
        if (this.currentIndex >= this.func_70302_i_()) {
            this.isPlaylistFinished = true;
            if (this.paramLoop) {
                this.scheduleStartPlaying = true;
            } else {
                this.scheduleStopPlaying = true;
            }
        }
    }

    private void setPlaylistOrder() {
        int i;
        int totalRecords = 0;
        boolean validRecord = false;
        this.currentIndex = -1;
        for (i = 0; i < this.playOrder.length; ++i) {
            this.playOrder[i] = -1;
        }
        for (i = 0; i < this.playOrder.length; i = (int)((byte)(i + 1))) {
            this.playOrder[i] = i;
            ItemStack s = this.func_70301_a(i);
            if (!ModRedstoneJukebox.instance.getRecordInfoManager().isRecord(s) || !(validRecord = true)) continue;
            ++totalRecords;
        }
        if (this.paramPlayMode == 1 && totalRecords > 1) {
            byte temp;
            for (i = 0; i < this.playOrder.length; ++i) {
                int randomPosition = this.field_145850_b.field_73012_v.nextInt(this.playOrder.length);
                temp = this.playOrder[i];
                this.playOrder[i] = this.playOrder[randomPosition];
                this.playOrder[randomPosition] = temp;
            }
            for (i = 0; i < this.playOrder.length; ++i) {
                int randomPosition = this.field_145850_b.field_73012_v.nextInt(this.playOrder.length);
                temp = this.playOrder[i];
                this.playOrder[i] = this.playOrder[randomPosition];
                this.playOrder[randomPosition] = temp;
            }
        }
    }

    public int getExtraVolume(boolean mustRefresh) {
        if (this._jukeboxExtraVolumeCached < 0 || mustRefresh) {
            this._jukeboxExtraVolumeCached = BlockRedstoneJukebox.getAmplifierPower(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this._jukeboxExtraVolumeCached;
    }

    public void updateJukeboxTileState(boolean haveEnergy) {
        this.isBlockPowered = haveEnergy;
        if (!haveEnergy) {
            this.scheduleStartPlaying = false;
            this.schedulePlayNextRecord = false;
            this.scheduleStopPlaying = true;
            this.isPlaylistStarted = false;
            this.isPlaylistFinished = false;
        } else {
            this.scheduleStartPlaying = true;
            this.schedulePlayNextRecord = false;
            this.scheduleStopPlaying = false;
        }
    }

    public boolean isEmpty() {
        for (ItemStack jukeboxItem : this.jukeboxItems) {
            if (jukeboxItem == null) continue;
            return false;
        }
        return true;
    }

    public boolean isPlaying() {
        return this.isPlaylistStarted && !this.isPlaylistFinished();
    }

    public boolean isPlaylistFinished() {
        return this.isPlaylistFinished && !this.paramLoop;
    }

    public int getCurrentPlaySlot() {
        return this.currentIndex;
    }

    public byte getCurrentJukeboxPlaySlot() {
        return this.currentJukeboxPlaySlot;
    }

    public void setCurrentJukeboxPlaySlot(byte slot) {
        this.currentJukeboxPlaySlot = slot;
    }

    public void ejectAll(World world, int x, int y, int z) {
        for (int i1 = 0; i1 < this.func_70302_i_(); ++i1) {
            ItemStack item = this.func_70301_a(i1);
            if (item == null) continue;
            float f1 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f3 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (item.field_77994_a > 0) {
                int j1 = this.field_145850_b.field_73012_v.nextInt(21) + 10;
                if (j1 > item.field_77994_a) {
                    j1 = item.field_77994_a;
                }
                item.field_77994_a -= j1;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f1), (double)((float)y + f2), (double)((float)z + f3), new ItemStack(item.func_77973_b(), j1, item.func_77960_j()));
                if (item.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
                }
                float f4 = 0.05f;
                entityitem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f;
                entityitem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entityitem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }
}

