/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class FertileSoil
extends Block {
    private final BlockState plant;
    private final SeedCategory category;

    protected FertileSoil(String plantName, BlockState plant, SeedCategory category) {
        super(AbstractBlock.Properties.func_200945_a((Material)(category == SeedCategory.HELL_CROP ? Material.field_151595_p : Material.field_151578_c)).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).func_200944_c());
        this.plant = plant;
        this.category = category;
        String name = "fertile_soil_" + plantName;
        this.setRegistryName(name);
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return super.func_220076_a(p_220076_1_, p_220076_2_);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.SHOVEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fertile_soil.desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fertile_soil.benefits"));
        if (this.category == SeedCategory.HELL_CROP) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fertile_soil.quip").func_230530_a_(ESConfig.TT_QUIP));
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction direction, IPlantable plantable) {
        return this.plant.func_177230_c() == plantable;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((Double)ESConfig.fertileSoilRate.get() < 100.0 * Math.random()) {
            return;
        }
        BlockPos upPos = pos.func_177972_a(Direction.UP);
        if (worldIn.func_175623_d(upPos) && (this.category != SeedCategory.CROP || worldIn.func_226659_b_(upPos, 0) > 7)) {
            worldIn.func_175656_a(upPos, this.plant);
        }
    }

    public static enum SeedCategory {
        CROP,
        TREE,
        HELL_CROP,
        BERRY,
        MUSHROOM;

    }
}

