/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.packets;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.packets.Packet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketManager {
    private static final HashMap<Class<?>, BiConsumer<Object, PacketBuffer>> writeMap = new HashMap();
    private static final HashMap<Class<?>, Function<PacketBuffer, Object>> readMap = new HashMap();

    public static void addCodec(Class<?> clazz, BiConsumer<Object, PacketBuffer> writer, Function<PacketBuffer, Object> reader) {
        writeMap.put(clazz, writer);
        readMap.put(clazz, reader);
    }

    public static <T extends Packet> void encode(T packet, PacketBuffer buf) {
        Field[] toEncode;
        for (Field f : toEncode = packet.getFields()) {
            BiConsumer<Object, PacketBuffer> writer = writeMap.get(f.getType());
            if (writer == null) {
                Essentials.logger.error("Failed to get writer for packet class. Report to mod author: " + f.getType().toString());
                continue;
            }
            try {
                writer.accept(f.get(packet), buf);
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to encode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
                throw new IllegalStateException();
            }
        }
    }

    public static <T extends Packet> T decode(PacketBuffer buf, Class<T> clazz) {
        Field[] toDecode;
        Packet packet;
        try {
            packet = (Packet)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Essentials.logger.error("Unable to instantiate packet. Report to mod author: " + clazz.toString(), (Throwable)e);
            throw new IllegalStateException();
        }
        for (Field f : toDecode = packet.getFields()) {
            Function<PacketBuffer, Object> reader = readMap.get(f.getType());
            if (reader == null) {
                Essentials.logger.error("Failed to get reader for packet class. Report to mod author: " + f.getType().toString());
                throw new IllegalStateException();
            }
            try {
                f.set(packet, reader.apply(buf));
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to decode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
                throw new IllegalStateException();
            }
        }
        return (T)packet;
    }

    public static <T extends Packet> void activate(T packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context cont = context.get();
        packet.consume(cont);
        cont.setPacketHandled(true);
    }

    private static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    static {
        PacketManager.addCodec(Boolean.TYPE, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()), PacketBuffer::readBoolean);
        PacketManager.addCodec(Boolean.class, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()), PacketBuffer::readBoolean);
        PacketManager.addCodec(Byte.TYPE, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()), PacketBuffer::readByte);
        PacketManager.addCodec(Byte.class, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()), PacketBuffer::readByte);
        PacketManager.addCodec(Integer.TYPE, (val, buf) -> buf.writeInt(((Integer)val).intValue()), PacketBuffer::readInt);
        PacketManager.addCodec(Integer.class, (val, buf) -> buf.writeInt(((Integer)val).intValue()), PacketBuffer::readInt);
        PacketManager.addCodec(Long.TYPE, (val, buf) -> buf.writeLong(((Long)val).longValue()), PacketBuffer::readLong);
        PacketManager.addCodec(Long.class, (val, buf) -> buf.writeLong(((Long)val).longValue()), PacketBuffer::readLong);
        PacketManager.addCodec(Float.TYPE, (val, buf) -> buf.writeFloat(((Float)val).floatValue()), PacketBuffer::readFloat);
        PacketManager.addCodec(Float.class, (val, buf) -> buf.writeFloat(((Float)val).floatValue()), PacketBuffer::readFloat);
        PacketManager.addCodec(Double.TYPE, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()), PacketBuffer::readDouble);
        PacketManager.addCodec(Double.class, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()), PacketBuffer::readDouble);
        PacketManager.addCodec(String.class, (val, buf) -> buf.func_180714_a((String)val), PacketManager::readString);
        PacketManager.addCodec(BlockPos.class, (val, buf) -> buf.func_179255_a((BlockPos)val), PacketBuffer::func_179259_c);
        PacketManager.addCodec(CompoundNBT.class, (val, buf) -> buf.func_150786_a((CompoundNBT)val), PacketBuffer::func_150793_b);
        PacketManager.addCodec(byte[].class, (val, buf) -> buf.func_179250_a((byte[])val), PacketBuffer::func_179251_a);
    }
}

