/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractSplitterTE
extends TileEntity
implements ITickableTileEntity {
    protected int mode = 6;
    protected final BlockPos[] endPos = new BlockPos[2];

    protected AbstractSplitterTE(TileEntityType<? extends AbstractSplitterTE> type) {
        super(type);
    }

    public SplitDistribution getDistribution() {
        return SplitDistribution.TWELVE;
    }

    protected Direction getFacing() {
        BlockState state = this.func_195044_w();
        if (!state.func_235901_b_((Property)ESProperties.FACING)) {
            return Direction.DOWN;
        }
        return (Direction)state.func_177229_b((Property)ESProperties.FACING);
    }

    public int getMode() {
        return this.mode;
    }

    public int increaseMode() {
        ++this.mode;
        this.mode %= this.getDistribution().maxMode();
        this.func_70296_d();
        return this.mode;
    }

    public void refreshCache() {
        Direction dir = this.getFacing();
        int maxChutes = (Integer)ESConfig.itemChuteRange.get();
        for (int i = 0; i < 2; ++i) {
            BlockState target;
            int extension;
            for (extension = 1; extension <= maxChutes && (target = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(dir, extension))).func_177230_c() == ESBlocks.itemChute && target.func_177229_b(ESProperties.AXIS) == dir.func_176740_k(); ++extension) {
            }
            this.endPos[i] = this.field_174879_c.func_177967_a(dir, extension);
            dir = dir.func_176734_d();
        }
    }

    public static enum SplitDistribution {
        TWELVE(12, new int[]{0, 1, 65, 273, 585, 2633, 1365, 3413, 2925, 1911, 3959, 2047, 4095}),
        FIFTEEN(15, new int[]{0, 1, 129, 1057, 2185, 4681, 5285, 10922, 21845, 22197, 23405, 15291, 15855, 16255, 16383, Short.MAX_VALUE});

        public final int base;
        private final int[] patterns;

        private SplitDistribution(int base, int[] patterns) {
            this.base = base;
            this.patterns = patterns;
        }

        public int maxMode() {
            return this.patterns.length;
        }

        public boolean shouldDispense(int mode, int stage) {
            return (this.patterns[mode % this.patterns.length] >>> (stage %= this.base) & 1) == 1;
        }
    }
}

