/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.AbstractSplitterTE;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BasicFluidSplitterTileEntity
extends AbstractSplitterTE {
    @ObjectHolder(value="basic_fluid_splitter")
    private static TileEntityType<BasicFluidSplitterTileEntity> TYPE = null;
    private final FluidStack[] inventory = new FluidStack[]{FluidStack.EMPTY, FluidStack.EMPTY};
    private static final int CAPACITY = 4000;
    private LazyOptional<IFluidHandler> primaryOpt = LazyOptional.of(() -> new OutFluidHandler(1));
    private LazyOptional<IFluidHandler> secondaryOpt = LazyOptional.of(() -> new OutFluidHandler(0));
    private LazyOptional<IFluidHandler> inOpt = LazyOptional.of(() -> new InHandler());
    private int transferred = 0;

    public BasicFluidSplitterTileEntity(TileEntityType<? extends AbstractSplitterTE> type) {
        super(type);
    }

    public BasicFluidSplitterTileEntity() {
        this(TYPE);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
        this.primaryOpt = LazyOptional.of(() -> new OutFluidHandler(1));
        this.secondaryOpt = LazyOptional.of(() -> new OutFluidHandler(0));
        this.inOpt = LazyOptional.of(() -> new InHandler());
    }

    public void func_73660_a() {
        if (this.endPos[0] == null || this.endPos[1] == null) {
            this.refreshCache();
        }
        Direction dir = this.getFacing();
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = AbstractShifterTileEntity.ejectFluid(this.field_145850_b, this.endPos[i], i == 0 ? dir : dir.func_176734_d(), this.inventory[i]);
        }
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Direction dir = this.getFacing();
            return side == dir ? this.primaryOpt : (side == dir.func_176734_d() ? this.secondaryOpt : this.inOpt);
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)1);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("transferred", this.transferred);
        for (int i = 0; i < 2; ++i) {
            if (this.inventory[i].isEmpty()) continue;
            CompoundNBT inner = new CompoundNBT();
            this.inventory[i].writeToNBT(inner);
            nbt.func_218657_a("inv_" + i, (INBT)inner);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.mode = nbt.func_74771_c("type") == 1 ? nbt.func_74762_e("mode") : 3 + 3 * nbt.func_74762_e("mode");
        this.transferred = nbt.func_74762_e("transferred");
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("inv_" + i));
        }
    }

    protected class OutFluidHandler
    implements IFluidHandler {
        private final int index;

        private OutFluidHandler(int index) {
            this.index = index;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return BasicFluidSplitterTileEntity.this.inventory[this.index];
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int drained;
            if (BlockUtil.sameFluid(resource, BasicFluidSplitterTileEntity.this.inventory[this.index]) && (drained = Math.min(resource.getAmount(), BasicFluidSplitterTileEntity.this.inventory[this.index].getAmount())) > 0) {
                FluidStack out = BasicFluidSplitterTileEntity.this.inventory[this.index].copy();
                out.setAmount(drained);
                if (action.execute()) {
                    BasicFluidSplitterTileEntity.this.inventory[this.index].shrink(drained);
                    BasicFluidSplitterTileEntity.this.func_70296_d();
                }
                return out;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drained = Math.min(maxDrain, BasicFluidSplitterTileEntity.this.inventory[this.index].getAmount());
            if (drained > 0) {
                FluidStack out = BasicFluidSplitterTileEntity.this.inventory[this.index].copy();
                out.setAmount(drained);
                if (action.execute()) {
                    BasicFluidSplitterTileEntity.this.inventory[this.index].shrink(drained);
                    BasicFluidSplitterTileEntity.this.func_70296_d();
                }
                return out;
            }
            return FluidStack.EMPTY;
        }
    }

    private class InHandler
    implements IFluidHandler {
        private InHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            int goDown;
            int accepted;
            if (stack.isEmpty()) {
                return 0;
            }
            if (!BasicFluidSplitterTileEntity.this.inventory[0].isEmpty() && !BlockUtil.sameFluid(stack, BasicFluidSplitterTileEntity.this.inventory[0]) || !BasicFluidSplitterTileEntity.this.inventory[1].isEmpty() && !BlockUtil.sameFluid(stack, BasicFluidSplitterTileEntity.this.inventory[1])) {
                return 0;
            }
            int numerator = BasicFluidSplitterTileEntity.this.getMode();
            AbstractSplitterTE.SplitDistribution distribution = BasicFluidSplitterTileEntity.this.getDistribution();
            int denominator = distribution.base;
            int spaceDown = 4000 - BasicFluidSplitterTileEntity.this.inventory[0].getAmount();
            int spaceUp = 4000 - BasicFluidSplitterTileEntity.this.inventory[1].getAmount();
            if (numerator == 0) {
                accepted = Math.min(spaceUp, stack.getAmount());
                goDown = 0;
            } else if (numerator == denominator) {
                goDown = accepted = Math.min(spaceDown, stack.getAmount());
            } else {
                int baseQty = stack.getAmount() - stack.getAmount() % denominator;
                accepted = denominator * spaceDown / numerator;
                accepted = Math.min(accepted, denominator * spaceUp / (denominator - numerator));
                if ((accepted = Math.max(0, Math.min(baseQty, accepted))) % denominator != 0) {
                    accepted -= accepted % denominator;
                }
                goDown = numerator * accepted / denominator;
                spaceDown -= goDown;
                spaceUp -= accepted - goDown;
                int remainder = stack.getAmount() - accepted;
                for (int i = 0; i < remainder; ++i) {
                    boolean shouldGoDown = distribution.shouldDispense(BasicFluidSplitterTileEntity.this.mode, BasicFluidSplitterTileEntity.this.transferred);
                    if (shouldGoDown) {
                        if (spaceDown <= 0) break;
                        --spaceDown;
                        ++goDown;
                        ++accepted;
                    } else {
                        if (spaceUp <= 0) break;
                        --spaceUp;
                        ++accepted;
                    }
                    BasicFluidSplitterTileEntity.this.transferred += 1;
                }
                BasicFluidSplitterTileEntity.this.transferred %= denominator;
            }
            int goUp = accepted - goDown;
            if (action.execute() && accepted != 0) {
                if (BasicFluidSplitterTileEntity.this.inventory[0].isEmpty()) {
                    ((BasicFluidSplitterTileEntity)BasicFluidSplitterTileEntity.this).inventory[0] = stack.copy();
                    BasicFluidSplitterTileEntity.this.inventory[0].setAmount(goDown);
                } else {
                    BasicFluidSplitterTileEntity.this.inventory[0].grow(goDown);
                }
                if (BasicFluidSplitterTileEntity.this.inventory[1].isEmpty()) {
                    ((BasicFluidSplitterTileEntity)BasicFluidSplitterTileEntity.this).inventory[1] = stack.copy();
                    BasicFluidSplitterTileEntity.this.inventory[1].setAmount(goUp);
                } else {
                    BasicFluidSplitterTileEntity.this.inventory[1].grow(goUp);
                }
                BasicFluidSplitterTileEntity.this.transferred += accepted;
                BasicFluidSplitterTileEntity.this.transferred %= denominator;
            }
            return accepted;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

