/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class HopperFilterTileEntity
extends TileEntity
implements INBTReceiver {
    @ObjectHolder(value="hopper_filter")
    public static TileEntityType<HopperFilterTileEntity> TYPE = null;
    private Direction.Axis axisCache = null;
    private ItemStack filter = ItemStack.field_190927_a;
    private LazyOptional<IItemHandler> passedHandlerPos = null;
    private LazyOptional<IItemHandler> passedHandlerNeg = null;

    public HopperFilterTileEntity() {
        super(TYPE);
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendNBTToClient(filter.func_77955_b(new CompoundNBT()), this.field_174879_c));
        this.func_70296_d();
    }

    private Direction.Axis getAxis() {
        if (this.axisCache == null) {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() == ESBlocks.hopperFilter) {
                this.axisCache = (Direction.Axis)state.func_177229_b(ESProperties.AXIS);
            } else {
                return Direction.Axis.Y;
            }
        }
        return this.axisCache;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.axisCache = null;
        if (this.passedHandlerNeg != null) {
            this.passedHandlerNeg.invalidate();
            this.passedHandlerPos.invalidate();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("filter", (INBT)this.filter.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("filter"));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public static boolean matchFilter(ItemStack query, ItemStack filt) {
        CompoundNBT nbt;
        if (filt.func_190926_b()) {
            return false;
        }
        if (filt.func_77973_b() instanceof BlockItem && ((BlockItem)filt.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock && (nbt = filt.func_77978_p()) != null) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("BlockEntityTag"), (NonNullList)nonnulllist);
            for (ItemStack singleFilt : nonnulllist) {
                if (!HopperFilterTileEntity.matchFilter(query, singleFilt)) continue;
                return true;
            }
            return false;
        }
        return query.func_77973_b() == filt.func_77973_b();
    }

    private void updatePassedOptionals() {
        if (this.passedHandlerPos == null || !this.passedHandlerPos.isPresent() && this.passedHandlerNeg == null || !this.passedHandlerNeg.isPresent()) {
            this.passedHandlerNeg = LazyOptional.of(() -> new ProxyItemHandler(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)this.getAxis())));
            this.passedHandlerPos = LazyOptional.of(() -> new ProxyItemHandler(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getAxis())));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.passedHandlerNeg != null) {
            this.passedHandlerNeg.invalidate();
            this.passedHandlerPos.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side.func_176740_k() == this.getAxis()) {
            this.updatePassedOptionals();
            return side.func_176743_c() == Direction.AxisDirection.POSITIVE ? this.passedHandlerPos : this.passedHandlerNeg;
        }
        return super.getCapability(cap, side);
    }

    private class ProxyItemHandler
    implements IItemHandler {
        private final Direction side;
        private LazyOptional<IItemHandler> src = LazyOptional.empty();

        private ProxyItemHandler(Direction side) {
            this.side = side;
        }

        @Nullable
        private IItemHandler getHandler() {
            BlockState checkState;
            if (this.src.isPresent()) {
                return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
            }
            BlockPos checkPos = HopperFilterTileEntity.this.field_174879_c.func_177972_a(this.side.func_176734_d());
            TileEntity checkTE = HopperFilterTileEntity.this.field_145850_b.func_175625_s(checkPos);
            if (checkTE != null) {
                this.src = checkTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side);
                if (this.src.isPresent()) {
                    return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
                }
            }
            if ((checkState = HopperFilterTileEntity.this.field_145850_b.func_180495_p(checkPos)).func_177230_c() instanceof ISidedInventoryProvider) {
                ISidedInventory inv = ((ISidedInventoryProvider)checkState.func_177230_c()).func_219966_a(checkState, (IWorld)HopperFilterTileEntity.this.field_145850_b, checkPos);
                return new InvWrapper((IInventory)inv);
            }
            return null;
        }

        public int getSlots() {
            IItemHandler handler = this.getHandler();
            return handler == null ? 0 : handler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            IItemHandler handler = this.getHandler();
            return handler == null ? ItemStack.field_190927_a : handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            IItemHandler handler = this.getHandler();
            if (handler != null && HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter)) {
                return handler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            IItemHandler handler = this.getHandler();
            if (handler != null && HopperFilterTileEntity.matchFilter(this.getStackInSlot(slot), HopperFilterTileEntity.this.filter)) {
                return handler.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            IItemHandler handler = this.getHandler();
            return handler == null ? 0 : handler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            IItemHandler handler = this.getHandler();
            return handler != null && HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter) && handler.isItemValid(slot, stack);
        }
    }
}

