/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class LinkHelper {
    public static final ITag<Item> LINKING_TOOLS = ItemTags.func_199901_a((String)new ResourceLocation("essentials", "linking_tool").toString());
    public static final String POS_NBT = "c_link";
    public static final String DIM_NBT = "c_link_dim";
    public static final byte LINK_PACKET_ID = 8;
    @Deprecated
    public static final byte CLEAR_PACKET_ID = 9;
    public static final byte REMOVE_PACKET_ID = 10;
    private final Set<BlockPos> linked = new HashSet<BlockPos>();
    private final ILinkTE te;

    public LinkHelper(ILinkTE te) {
        this.te = te;
    }

    public Set<BlockPos> getLinksRelative() {
        return this.linked;
    }

    public Iterable<BlockPos> getLinksAbsolute() {
        BlockPos selfPos = this.te.getTE().func_174877_v();
        return this.linked.stream().map(relPos -> relPos.func_177971_a((Vector3i)selfPos)).collect(Collectors.toList());
    }

    public void readNBT(CompoundNBT nbt) {
        int i = 0;
        while (nbt.func_74764_b("link_" + i)) {
            this.linked.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link_" + i)));
            ++i;
        }
    }

    public void writeNBT(CompoundNBT nbt) {
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.func_74772_a("link_" + count++, relPos.func_218275_a());
        }
    }

    public boolean addLink(ILinkTE endpoint, @Nullable PlayerEntity player) {
        if (this.linked.size() >= this.te.getMaxLinks()) {
            return false;
        }
        BlockPos tePos = this.te.getTE().func_174877_v();
        BlockPos linkPos = endpoint.getTE().func_174877_v().func_177973_b((Vector3i)tePos);
        this.linked.add(linkPos);
        BlockUtil.sendClientPacketAround(this.te.getTE().func_145831_w(), tePos, new SendLongToClient(8, linkPos.func_218275_a(), tePos));
        this.te.getTE().func_70296_d();
        return true;
    }

    public void removeLink(BlockPos endpoint) {
        BlockPos tePos = this.te.getTE().func_174877_v();
        this.linked.remove(endpoint);
        BlockUtil.sendClientPacketAround(this.te.getTE().func_145831_w(), tePos, new SendLongToClient(10, endpoint.func_218275_a(), tePos));
        this.te.getTE().func_70296_d();
    }

    public void unlinkAllEndpoints() {
        BlockPos selfPos = this.te.getTE().func_174877_v();
        World world = this.te.getTE().func_145831_w();
        for (BlockPos relPos : this.linked) {
            BlockPos endPos = relPos.func_177971_a((Vector3i)selfPos);
            TileEntity endTe = world.func_175625_s(endPos);
            if (!(endTe instanceof ILinkTE)) continue;
            ((ILinkTE)endTe).removeLinkEnd(selfPos);
        }
    }

    public boolean handleIncomingPacket(byte discriminator, long message) {
        if (discriminator == 8) {
            this.linked.add(BlockPos.func_218283_e((long)message));
            return true;
        }
        if (discriminator == 10) {
            this.linked.remove(BlockPos.func_218283_e((long)message));
            return true;
        }
        return false;
    }

    public AxisAlignedBB frustrum() {
        BlockPos pos = this.te.getTE().func_174877_v();
        int[] min = new int[3];
        int[] max = new int[3];
        for (BlockPos link : this.te.getLinks()) {
            min[0] = Math.min(min[0], link.func_177958_n());
            min[1] = Math.min(min[1], link.func_177956_o());
            min[2] = Math.min(min[2], link.func_177952_p());
            max[0] = Math.max(max[0], link.func_177958_n());
            max[1] = Math.max(max[1], link.func_177956_o());
            max[2] = Math.max(max[2], link.func_177952_p());
        }
        return new AxisAlignedBB((double)(min[0] + pos.func_177958_n()), (double)(min[1] + pos.func_177956_o()), (double)(min[2] + pos.func_177952_p()), (double)(max[0] + pos.func_177958_n() + 1), (double)(max[1] + pos.func_177956_o() + 1), (double)(max[2] + pos.func_177952_p() + 1));
    }

    public static boolean isLinkTool(ItemStack stack) {
        return LINKING_TOOLS.func_230235_a_((Object)stack.func_77973_b());
    }

    public static ItemStack wrench(ILinkTE linkTE, ItemStack wrench, PlayerEntity player) {
        if (player.func_213453_ef()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.clear"), player.func_110124_au());
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(linkTE.getLinks());
            World world = linkTE.getTE().func_145831_w();
            BlockPos srcPos = linkTE.getTE().func_174877_v();
            for (BlockPos link : links) {
                linkTE.removeLinkSource(link);
                TileEntity endTE = world.func_175625_s(srcPos.func_177971_a((Vector3i)link));
                if (!(endTE instanceof ILinkTE)) continue;
                ((ILinkTE)endTE).removeLinkEnd(srcPos);
            }
            LinkHelper.clearLinkNBT(wrench);
            return wrench;
        }
        Pair<String, BlockPos> wrenchData = LinkHelper.readLinkNBT(wrench);
        if (wrenchData != null && ((String)wrenchData.getLeft()).equals(LinkHelper.getWorldString(player.field_70170_p))) {
            TileEntity prevTE = player.field_70170_p.func_175625_s((BlockPos)wrenchData.getRight());
            if (prevTE instanceof ILinkTE && ((ILinkTE)prevTE).canLink(linkTE) && prevTE != linkTE) {
                int range = ((ILinkTE)prevTE).getRange();
                if (((BlockPos)wrenchData.getRight()).func_177951_i((Vector3i)linkTE.getTE().func_174877_v()) <= (double)(range * range)) {
                    ILinkTE prevLinkTe = (ILinkTE)prevTE;
                    BlockPos relLinkPos = linkTE.getTE().func_174877_v().func_177973_b((Vector3i)prevTE.func_174877_v());
                    if (prevLinkTe.getLinks().contains(relLinkPos)) {
                        prevLinkTe.removeLinkSource(relLinkPos);
                        linkTE.removeLinkEnd(prevTE.func_174877_v());
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.remove", new Object[]{prevTE.func_174877_v(), linkTE.getTE().func_174877_v()}), player.func_110124_au());
                    } else if (prevLinkTe.getLinks().size() < prevLinkTe.getMaxLinks()) {
                        if (prevLinkTe.createLinkSource(linkTE, player)) {
                            linkTE.createLinkEnd(prevLinkTe);
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.success", new Object[]{prevTE.func_174877_v(), linkTE.getTE().func_174877_v()}), player.func_110124_au());
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.full", new Object[]{prevLinkTe.getMaxLinks()}), player.func_110124_au());
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.range"), player.func_110124_au());
                }
                LinkHelper.clearLinkNBT(wrench);
                return wrench;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.invalid"), player.func_110124_au());
        } else if (linkTE.canBeginLinking()) {
            LinkHelper.setLinkNBT(wrench, linkTE.getTE().func_174877_v(), LinkHelper.getWorldString(linkTE.getTE().func_145831_w()));
            player.func_145747_a((ITextComponent)new TranslationTextComponent("tt.essentials.linking.start"), player.func_110124_au());
            return wrench;
        }
        LinkHelper.clearLinkNBT(wrench);
        return wrench;
    }

    private static String getWorldString(World world) {
        return world.func_234923_W_().func_240901_a_().toString();
    }

    private static void setLinkNBT(ItemStack linkingTool, BlockPos targetPos, String targetWorld) {
        CompoundNBT itemNBT = linkingTool.func_196082_o();
        itemNBT.func_74772_a(POS_NBT, targetPos.func_218275_a());
        itemNBT.func_74778_a(DIM_NBT, targetWorld);
    }

    private static void clearLinkNBT(ItemStack linkingTool) {
        CompoundNBT itemNBT = linkingTool.func_77978_p();
        if (itemNBT != null) {
            itemNBT.func_82580_o(POS_NBT);
            itemNBT.func_82580_o(DIM_NBT);
        }
    }

    @Nullable
    private static Pair<String, BlockPos> readLinkNBT(ItemStack linkingTool) {
        CompoundNBT itemNBT = linkingTool.func_77978_p();
        if (itemNBT == null) {
            return null;
        }
        if (itemNBT.func_74764_b(POS_NBT) && itemNBT.func_74764_b(DIM_NBT)) {
            return Pair.of((Object)itemNBT.func_74779_i(DIM_NBT), (Object)BlockPos.func_218283_e((long)itemNBT.func_74763_f(POS_NBT)));
        }
        return null;
    }
}

