/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.SlottedChestContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class SlottedChestTileEntity
extends TileEntity
implements INBTReceiver,
INamedContainerProvider {
    @ObjectHolder(value="slotted_chest")
    private static TileEntityType<SlottedChestTileEntity> TYPE = null;
    private ItemStack[] inv = new ItemStack[54];
    public ItemStack[] lockedInv = new ItemStack[54];
    public final Inventory iInv = new Inventory(this.inv, this.lockedInv, this);

    public SlottedChestTileEntity() {
        super(TYPE);
        for (int i = 0; i < 54; ++i) {
            this.inv[i] = ItemStack.field_190927_a;
            this.lockedInv[i] = ItemStack.field_190927_a;
        }
    }

    public float calcComparator() {
        float f = 0.0f;
        for (ItemStack itemstack : this.inv) {
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(64, itemstack.func_77976_d());
        }
        return f /= (float)this.inv.length;
    }

    private void filterChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        CompoundNBT slotNBT = new CompoundNBT();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].func_190926_b()) continue;
            slotNBT.func_218657_a("lock" + i, (INBT)this.lockedInv[i].func_77955_b(new CompoundNBT()));
        }
        BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendNBTToClient(slotNBT, this.field_174879_c));
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        for (int i = 0; i < 54; ++i) {
            if (nbt.func_74764_b("slot" + i)) {
                this.inv[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("slot" + i));
                this.lockedInv[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("slot" + i));
            }
            if (!nbt.func_74764_b("lockSlot" + i)) continue;
            this.lockedInv[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("lockSlot" + i));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 54; ++i) {
            if (!this.inv[i].func_190926_b()) {
                nbt.func_218657_a("slot" + i, (INBT)this.inv[i].func_77955_b(new CompoundNBT()));
            }
            if (this.lockedInv[i].func_190926_b()) continue;
            nbt.func_218657_a("lockSlot" + i, (INBT)this.lockedInv[i].func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].func_190926_b()) continue;
            nbt.func_218657_a("lockSlot" + i, (INBT)this.lockedInv[i].func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new InventoryHandler());
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        for (int i = 0; i < 54; ++i) {
            this.lockedInv[i] = nbt.func_74764_b("lock" + i) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("lock" + i)) : ItemStack.field_190927_a;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.slotted_chest");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new SlottedChestContainer(id, playerInventory, this.iInv, this.lockedInv);
    }

    public static class Inventory
    implements IInventory {
        private final ItemStack[] inv;
        private final ItemStack[] lockedInv;
        @Nullable
        private final SlottedChestTileEntity te;

        public Inventory(ItemStack[] inv, ItemStack[] filter, @Nullable SlottedChestTileEntity te) {
            this.inv = inv;
            this.lockedInv = filter;
            this.te = te;
            for (int i = 0; i < inv.length; ++i) {
                if (inv[i] != null) continue;
                inv[i] = ItemStack.field_190927_a;
            }
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.inv.length ? ItemStack.field_190927_a : this.inv[index];
        }

        public ItemStack func_70298_a(int index, int count) {
            if (index >= this.inv.length || this.inv[index].func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            return this.inv[index].func_77979_a(count);
        }

        public ItemStack func_70304_b(int index) {
            if (index >= this.inv.length) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = this.inv[index].func_77946_l();
            this.inv[index].func_190920_e(0);
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (index < this.inv.length) {
                this.inv[index] = stack;
                if (!stack.func_190926_b()) {
                    this.lockedInv[index] = stack.func_77946_l();
                    this.lockedInv[index].func_190920_e(1);
                }
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            if (this.te != null) {
                this.te.func_70296_d();
            }
        }

        public boolean func_70300_a(PlayerEntity playerEntity) {
            return true;
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index < this.inv.length && (this.inv[index].func_190926_b() ? this.lockedInv[index].func_190926_b() || SlottedChestContainer.doStackContentsMatch(stack, this.lockedInv[index]) : SlottedChestContainer.doStackContentsMatch(stack, this.inv[index]));
        }

        public void func_174888_l() {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = ItemStack.field_190927_a;
                this.lockedInv[i] = ItemStack.field_190927_a;
            }
            this.filterChanged();
        }

        public boolean func_191420_l() {
            for (ItemStack itemStack : this.inv) {
                if (itemStack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public void filterChanged() {
            if (this.te != null) {
                this.te.filterChanged();
            }
        }
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 54;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 54 ? SlottedChestTileEntity.this.inv[slot] : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 54 || stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot])) {
                return stack;
            }
            int change = Math.min(stack.func_77976_d() - SlottedChestTileEntity.this.inv[slot].func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                if (SlottedChestTileEntity.this.inv[slot].func_190926_b()) {
                    ((SlottedChestTileEntity)SlottedChestTileEntity.this).inv[slot] = stack.func_77946_l();
                } else {
                    SlottedChestTileEntity.this.inv[slot].func_190917_f(change);
                }
            }
            ItemStack out = stack.func_77946_l();
            out.func_190918_g(change);
            return stack.func_190916_E() == change ? ItemStack.field_190927_a : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 54 || SlottedChestTileEntity.this.inv[slot].func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int change = Math.min(SlottedChestTileEntity.this.inv[slot].func_190916_E(), amount);
            ItemStack out = SlottedChestTileEntity.this.inv[slot].func_77946_l();
            out.func_190920_e(change);
            if (!simulate) {
                SlottedChestTileEntity.this.inv[slot].func_190918_g(change);
            }
            return change == 0 ? ItemStack.field_190927_a : out;
        }

        public int getSlotLimit(int slot) {
            return slot < 54 ? 64 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < 54 && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot]);
        }
    }
}

