/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.LinkHelper;
import com.Da_Technomancer.essentials.tileentities.redstone.RedstoneReceiverTileEntity;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

@ObjectHolder(value="essentials")
public class RedstoneTransmitterTileEntity
extends TileEntity
implements ILinkTE {
    @ObjectHolder(value="redstone_transmitter")
    public static TileEntityType<RedstoneTransmitterTileEntity> TYPE = null;
    public final LinkHelper linkHelper = new LinkHelper(this);
    private boolean builtConnections = false;
    private float output;
    private final LazyOptional<IRedstoneHandler> circOpt = LazyOptional.of(() -> new CircuitHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> circRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.circOpt);
    private final ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> sources = new ArrayList(1);

    public RedstoneTransmitterTileEntity() {
        super(TYPE);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.linkHelper.frustrum();
    }

    @Override
    public boolean canBeginLinking() {
        return true;
    }

    public void dye(DyeColor color) {
        if (this.func_195044_w().func_177229_b(ESProperties.COLOR) != color) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ESProperties.COLOR, (Comparable)color));
            for (BlockPos link : this.linkHelper.getLinksAbsolute()) {
                BlockState linkState = this.field_145850_b.func_180495_p(link);
                if (linkState.func_177230_c() != ESBlocks.redstoneReceiver) continue;
                this.field_145850_b.func_175656_a(link, (BlockState)linkState.func_206870_a(ESProperties.COLOR, (Comparable)color));
            }
        }
    }

    public float getOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        return this.output;
    }

    @Override
    public void removeLinkSource(BlockPos end) {
        this.linkHelper.removeLink(end);
    }

    public void buildConnections() {
        if (!this.field_145850_b.field_72995_K) {
            this.builtConnections = true;
            ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> preSrc = new ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>>(this.sources.size());
            preSrc.addAll(this.sources);
            this.sources.clear();
            for (Direction checkDir : Direction.values()) {
                IRedstoneHandler otherHandler;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(checkDir));
                if (te == null || (otherHandler = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.func_176734_d()))) == null) continue;
                otherHandler.requestSrc(this.circRef, 0, checkDir.func_176734_d(), checkDir);
            }
            if (this.sources.size() != preSrc.size() || !this.sources.containsAll(preSrc)) {
                this.field_145850_b.func_205220_G_().func_205362_a(this.field_174879_c, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.NORMAL);
            }
        }
    }

    public void refreshOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        float input = 0.0f;
        Direction[] sidesToCheck = Direction.values();
        for (int i = 0; i < this.sources.size(); ++i) {
            IRedstoneHandler handl;
            Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction> ref = this.sources.get(i);
            if (ref == null || (handl = (IRedstoneHandler)BlockUtil.get((LazyOptional)((WeakReference)ref.getLeft()).get())) == null) {
                this.sources.remove(i);
                --i;
                continue;
            }
            sidesToCheck[((Direction)ref.getRight()).func_176745_a()] = null;
            input = RedstoneUtil.chooseInput(input, RedstoneUtil.sanitize(handl.getOutput()));
        }
        for (Direction dir : sidesToCheck) {
            if (dir == null) continue;
            input = RedstoneUtil.chooseInput(input, RedstoneUtil.getRedstoneOnSide(this.field_145850_b, this.field_174879_c, dir));
        }
        if (RedstoneUtil.didChange(this.output, input = RedstoneUtil.sanitize(input))) {
            this.output = input;
            for (BlockPos link : this.linkHelper.getLinksAbsolute()) {
                TileEntity te = this.field_145850_b.func_175625_s(link);
                if (!(te instanceof RedstoneReceiverTileEntity)) continue;
                ((RedstoneReceiverTileEntity)te).notifyOutputChange();
            }
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.linkHelper.writeNBT(nbt);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.output = nbt.func_74760_g("out");
        this.linkHelper.readNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("out", this.output);
        this.linkHelper.writeNBT(nbt);
        return nbt;
    }

    @Override
    public TileEntity getTE() {
        return this;
    }

    @Override
    public Color getColor() {
        return new Color(((DyeColor)this.func_195044_w().func_177229_b(ESProperties.COLOR)).getColorValue());
    }

    @Override
    public boolean canLink(ILinkTE otherTE) {
        return otherTE instanceof RedstoneReceiverTileEntity;
    }

    @Override
    public Set<BlockPos> getLinks() {
        return this.linkHelper.getLinksRelative();
    }

    @Override
    public int getRange() {
        return (Integer)ESConfig.wirelessRange.get();
    }

    @Override
    public int getMaxLinks() {
        return 64;
    }

    @Override
    public boolean createLinkSource(ILinkTE endpoint, @Nullable PlayerEntity player) {
        return this.linkHelper.addLink(endpoint, player);
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        this.linkHelper.handleIncomingPacket(identifier, message);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.circOpt.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.circOpt;
        }
        return super.getCapability(cap, side);
    }

    private class CircuitHandler
    implements IRedstoneHandler {
        private CircuitHandler() {
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)src.get();
            if (srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get(srcOption);
                srcHandler.addDependent(RedstoneTransmitterTileEntity.this.circRef, nominalSide);
                Pair srcPair = Pair.of(src, (Object)fromSide);
                if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                    RedstoneTransmitterTileEntity.this.sources.add(srcPair);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
            Pair srcPair = Pair.of(src, (Object)fromSide);
            if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                RedstoneTransmitterTileEntity.this.sources.add(srcPair);
                this.notifyInputChange(src);
            }
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
            RedstoneTransmitterTileEntity.this.field_145850_b.func_205220_G_().func_205362_a(RedstoneTransmitterTileEntity.this.field_174879_c, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.HIGH);
        }
    }
}

