/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.redstone.WireTileEntity;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

public class WireJunctionTileEntity
extends WireTileEntity {
    @ObjectHolder(value="essentials:wire_junction")
    private static TileEntityType<WireJunctionTileEntity> TYPE = null;

    public WireJunctionTileEntity() {
        super(TYPE);
    }

    @Override
    protected WireTileEntity.RedsHandler createRedsHandler() {
        return new JunctionRedsHandler();
    }

    private class JunctionRedsHandler
    extends WireTileEntity.RedsHandler {
        private JunctionRedsHandler() {
            super(WireJunctionTileEntity.this);
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            IRedstoneHandler handler;
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireJunctionTileEntity.this.field_174879_c);
            Direction dir = fromSide.func_176734_d();
            TileEntity neighbor = WireJunctionTileEntity.this.field_145850_b.func_175625_s(WireJunctionTileEntity.this.field_174879_c.func_177972_a(dir));
            if (neighbor != null && (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, fromSide))) != null) {
                if (handler instanceof WireTileEntity.RedsHandler) {
                    ((WireTileEntity.RedsHandler)handler).routeDependents(src, dist, fromSide, nominalSide, visited);
                } else {
                    handler.findDependents(src, dist, fromSide, nominalSide);
                }
            }
        }

        @Override
        protected void routeDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide, HashSet<BlockPos> visited) {
            IRedstoneHandler handler;
            if (!visited.add(WireJunctionTileEntity.this.field_174879_c) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            Direction dir = fromSide.func_176734_d();
            TileEntity neighbor = WireJunctionTileEntity.this.field_145850_b.func_175625_s(WireJunctionTileEntity.this.field_174879_c.func_177972_a(dir));
            if (neighbor != null && (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, fromSide))) != null) {
                if (handler instanceof WireTileEntity.RedsHandler) {
                    ((WireTileEntity.RedsHandler)handler).routeDependents(src, dist, fromSide, nominalSide, visited);
                } else {
                    handler.findDependents(src, dist, fromSide, nominalSide);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            IRedstoneHandler handler;
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireJunctionTileEntity.this.field_174879_c);
            Direction dir = toSide.func_176734_d();
            TileEntity neighbor = WireJunctionTileEntity.this.field_145850_b.func_175625_s(WireJunctionTileEntity.this.field_174879_c.func_177972_a(dir));
            if (neighbor != null && (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, toSide))) != null) {
                if (handler instanceof WireTileEntity.RedsHandler) {
                    ((WireTileEntity.RedsHandler)handler).routeSrc(dependency, dist, toSide, nominalSide, visited);
                } else {
                    handler.requestSrc(dependency, dist, toSide, nominalSide);
                }
            }
        }

        @Override
        protected void routeSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide, HashSet<BlockPos> visited) {
            IRedstoneHandler handler;
            if (!visited.add(WireJunctionTileEntity.this.field_174879_c) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            Direction dir = toSide.func_176734_d();
            TileEntity neighbor = WireJunctionTileEntity.this.field_145850_b.func_175625_s(WireJunctionTileEntity.this.field_174879_c.func_177972_a(dir));
            if (neighbor != null && (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, toSide))) != null) {
                if (handler instanceof WireTileEntity.RedsHandler) {
                    ((WireTileEntity.RedsHandler)handler).routeSrc(dependency, dist, toSide, nominalSide, visited);
                } else {
                    handler.requestSrc(dependency, dist, toSide, nominalSide);
                }
            }
        }
    }
}

