PrefabFiles = {

	"pantao",
	"pantaoyan",
	"pantao_seeds"
}

Assets = {

	Asset( "ANIM", "anim/pantao.zip" ),
	Asset( "ANIM", "anim/pantaoyan.zip" ),

	Asset( "IMAGE", "images/inventoryimages/pantao.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantao.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/pantao_seeds.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantao_seeds.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/pantaoyan.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantaoyan.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/monkeyinv.tex" ),
    Asset( "ATLAS", "images/inventoryimages/monkeyinv.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/splumonkeyinv.tex" ),
    Asset( "ATLAS", "images/inventoryimages/splumonkeyinv.xml" ),
	
}

local require = GLOBAL.require
local GetPlayer = GLOBAL.GetPlayer
local Recipe = GLOBAL.Recipe
local TUNING = GLOBAL.TUNING
local Ingredient = GLOBAL.Ingredient
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS

TUNING.HEALTHVALUE_1 = GetModConfigData("health_1")
TUNING.HUNGERVALUE_1 = GetModConfigData("hunger_1")
TUNING.SANITYVALUE_1 = GetModConfigData("sanity_1")

TUNING.HEALTHVALUE_2 = GetModConfigData("health_2")
TUNING.HUNGERVALUE_2 = GetModConfigData("hunger_2")
TUNING.SANITYVALUE_2 = GetModConfigData("sanity_2")
TUNING.NAUGHTYVALUE_2 = GetModConfigData("naughty_2")

TUNING.HEALTHVALUE_3 = GetModConfigData("health_3")
TUNING.HUNGERVALUE_3 = GetModConfigData("hunger_3")
TUNING.SANITYVALUE_3 = GetModConfigData("sanity_3")
TUNING.NAUGHTYVALUE_3 = GetModConfigData("naughty_3")

AddIngredientValues({"primeape",}, {meat=1})
AddIngredientValues({"monkey",}, {meat=1})

function EdibleMonkeyPostInit(inst)
	if not inst.components.inventoryitem then
    inst:AddComponent("inventoryitem")
	end
	
	local function monkeyinvimagename(inst)
		if inst.prefab == "monkey" then
			inst.components.inventoryitem:ChangeImageName("splumonkeyinv")
			inst.components.inventoryitem.atlasname = "images/inventoryimages/splumonkeyinv.xml"
		elseif inst.prefab == "primeape" then
			inst.components.inventoryitem:ChangeImageName("monkeyinv")
			inst.components.inventoryitem.atlasname = "images/inventoryimages/monkeyinv.xml"
		end
	end
	
	inst.components.inventoryitem.imagename = "monkeyinv"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/monkeyinv.xml"
	inst.components.inventoryitem.canbepickedup = false
	inst.components.inventoryitem.nobounce = true
	
	-----
	inst.components.health.canmurder = false
	-----
	
	local function OnWorked(inst, worker)
	if worker.components.inventory then
		worker.components.inventory:GiveItem(inst, nil, GLOBAL.Vector3(TheSim:GetScreenPos(inst.Transform:GetWorldPosition())))
		worker.SoundEmitter:PlaySound("dontstarve/creatures/monkey/hurt")
	end
	end
	
	if not inst.components.workable then
    inst:AddComponent("workable")
	end
	inst.components.workable:SetWorkAction(ACTIONS.NET)
	inst.components.workable:SetWorkLeft(1)
	inst.components.workable:SetOnFinishCallback(OnWorked)
	
	-----
	
	local function oneatmonkey(inst, eater)
	if not eater:HasTag("player") or not eater:HasTag("character") then
		inst.components.inventory:DropEverything(true)
	end
	
	if eater.components.talker then
		eater.components.talker:Say("Tastes like bananas.") 
	end
	end
	
	if not inst.components.edible then
    inst:AddComponent("edible")
	end
	inst.components.edible.ismeat = true    
	inst.components.edible.foodstate = "RAW"
    inst.components.edible.foodtype = "MEAT"
    inst.components.edible.healthvalue = GetModConfigData("health_1")
    inst.components.edible.hungervalue = GetModConfigData("hunger_1")
    inst.components.edible.sanityvalue = GetModConfigData("sanity_1")
	inst.components.edible:SetOnEatenFn(oneatmonkey)
	--inst:AddTag("monkeyalive")
	
	-----
	
	local function OnCookedFn(inst)
		inst.SoundEmitter:PlaySound("dontstarve/creatures/monkey/death")
	end
	
	if not inst.components.cookable then
    inst:AddComponent("cookable")
	end
    inst.components.cookable.product = "cookedmeat"
    inst.components.cookable:SetOnCookedFn(OnCookedFn)
	
	-----
	if GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then
	
	if not inst.components.appeasement then
    inst:AddComponent("appeasement")
	end
	inst.components.appeasement.appeasementvalue = TUNING.APPEASEMENT_MEDIUM
	
	end
	
	-----
	
	GLOBAL.MakeFeedablePet(inst, TUNING.TOTAL_DAY_TIME*3, monkeyinvimagename)

end
local monkeys = {"monkey", "primeape"}
for k,v in pairs(monkeys) do AddPrefabPostInit(v, EdibleMonkeyPostInit) end


GLOBAL.STRINGS.NAMES.PANTAO = "蟠桃"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAO= "仙界圣果"

GLOBAL.STRINGS.NAMES.PANTAOYAN = "猴儿酒"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAOTAN= "圣果所酿仙露"

GLOBAL.STRINGS.NAMES.PANTAO_SEEDS = "蟠桃种子"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAO_SEEDS= "圣果之种"


local pantaoyan =
	{
	    name = "pantaoyan",
	
		test = function(cooker, names, tags) return names.pantao and names.pantao > 2 and names.primeape and names.primeape > 0 end,
	
		priority = 50,
		weight = 1,
		foodtype = "VEGGIE",

		perishtime = TUNING.PERISH_SUPERSLOW,-- Days: SUPERFAST=3, FAST=6, MED=10, SLOW=15, PRESERVED=20, SUPERSLOW=40
	
		cooktime = GetModConfigData("cook_time"),
	}
AddCookerRecipe("cookpot", pantaoyan)


local function pickproduct(inst)
	
local VEGGIES = 
{	
	cave_banana = {seed_weight = 0,},
	carrot = {seed_weight = 3,},
	corn = {seed_weight = 3,},	
	pumpkin = {seed_weight = 1,},
	eggplant = {seed_weight = 1,},	
	durian = {seed_weight = 0.5,},	
	pomegranate = {seed_weight = 0.5,},	
	dragonfruit = {seed_weight = 0.5,},
	berries = {seed_weight = 0,},
	cactus_meat = {seed_weight = 0,},
	watermelon = {seed_weight = 1,},
	coffeebeans = {seed_weight = 0,},
	sweet_potato = {seed_weight = 3,},	
	pantao = {seed_weight = 1,},
}

	local total_w = 0
	for k,v in pairs(VEGGIES) do
		total_w = total_w + (v.seed_weight or 1)
	end
	
	local rnd = math.random()*total_w
	for k,v in pairs(VEGGIES) do
		rnd = rnd - (v.seed_weight or 1)
		if rnd <= 0 then
			return k
		end
	end
	
	return "carrot"
end

AddPrefabPostInit("seeds",function(inst)

	inst.components.plantable.product = pickproduct

end
)

AddPrefabPostInit("solofish",function(inst)

	inst:AddTag("smallfish")

end
)

--[[local function init_chester(inst)
	if GLOBAL.GetPlayer().prefab == "wukong" then
		inst:AddTag("notarget")
		--table.remove(inst.components.health)
		inst:RemoveComponent("combat")
	end
end
AddPrefabPostInit("chester", init_chester)

local function init_packim(inst)
	if GLOBAL.GetPlayer().prefab == "wukong" then
		inst:AddTag("notarget")
		table.remove(inst.components.health)
		--inst:RemoveComponent("combat")
	end
end
AddPrefabPostInit("packim", init_packim)--]]

AddIngredientValues({"pantao"}, {fruit=1}, false, false)