assets =
{
	Asset("ANIM", "anim/pantao.zip"),
	Asset("IMAGE", "images/inventoryimages/pantao.tex"),
	Asset("ATLAS", "images/inventoryimages/pantao.xml"),
}
prefabs = 
{
"spoiled_food"
}


local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	

	
    inst.AnimState:SetBank("pantao")
    inst.AnimState:SetBuild("pantao")
    inst.AnimState:PlayAnimation("idle")
	MakeInventoryFloatable(inst, "idle_water", "idle")
	
	inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/pantao.xml"
	
	inst:AddComponent("tradable")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = TUNING.HEALTHVALUE_2
	inst.components.edible.hungervalue = TUNING.HUNGERVALUE_2
	inst.components.edible.sanityvalue = TUNING.SANITYVALUE_2
	inst.components.edible.naughtyvalue = TUNING.NAUGHTYVALUE_2
	inst.components.edible.foodtype = "VEGGIE"
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	return inst
end


return Prefab( "common/inventory/pantao", fn, assets, prefabs)