local VigorSkillSlot = require('VigorSkillSlot')
local VigorSkillConfig = require('VigorSkillConfig')

local CurrentIndex = 1
local IsInMagicallyChange = false

local VigorSkillInstance = {}
local CurSkillID = nil

ExecuteWithDelay(10000, function()
    RegisterHook("/Script/b1-Managed.InputActionEventReceiver:InputActionTrigger", function(Context, ActionName, TriggerEvent, InputActionValueType, InputActionValue)

        local actionName = ActionName:get():ToString()
        local triEvent = TriggerEvent:get()

        -- print(IsInMagicallyChange)
        if actionName == "IA_B1UseVigorSkill" and triEvent == 5 then

            if IsNilOrInvalid(BGUFunctionLibraryCS) then
                BGUFunctionLibraryCS = StaticFindObject("/Script/b1-Managed.Default__BGUFunctionLibraryCS")
                if not BGUFunctionLibraryCS:IsValid() then
                    BGUFunctionLibraryCS = nil
                end
            end

            local BPPlayerController = FindFirstOf("BP_B1PlayerController_C")
            local bpPlayer = BPPlayerController.pawn

            if not AttrEnumMap then
                AttrEnumMap={}
                enum=StaticFindObject("/Script/GSE-ProtobufDB.EBGUAttrFloat")
                if not enum:IsValid() then return end
                enum:ForEachName(function(name,value)
                    AttrEnumMap[name:ToString()]=value
                end)
            end

            local curEnergy = BGUFunctionLibraryCS:BGUGetFloatAttr(bpPlayer, AttrEnumMap["EBGUAttrFloat::VigorEnergy"])
            local maxEnergy = BGUFunctionLibraryCS:BGUGetFloatAttr(bpPlayer, AttrEnumMap["EBGUAttrFloat::VigorEnergyMax"])

            -- print(tostring(curEnergy).." :: "..tostring(maxEnergy))

            if math.floor(curEnergy) < math.floor(maxEnergy) then

                local cd = 0
                if VigorSkillSlot.Mode == 1 then

                    if CurrentIndex > #VigorSkillSlot.Slot then
                        CurrentIndex = 1
                    end

                    CurSkillID = VigorSkillSlot.Slot[CurrentIndex].SkillID
                    cd = VigorSkillSlot.Slot[CurrentIndex].CD

                    if VigorSkillInstance[CurSkillID] ~= nil and VigorSkillInstance[CurSkillID].NeedTick then
                        for i = 1, #VigorSkillSlot.Slot do
                            local newID = VigorSkillSlot.Slot[i].SkillID
                            if VigorSkillInstance[newID] == nil or not VigorSkillInstance[newID].NeedTick then
                                CurSkillID = newID
                                cd = VigorSkillSlot.Slot[i].CD
                                CurrentIndex = i
                                break
                            end
                        end
                    end
                elseif VigorSkillSlot.Mode == 2 then

                    local randomTbl = {}
                    for i = 1, #VigorSkillSlot.Slot do
                        local newID = VigorSkillSlot.Slot[i].SkillID
                        if VigorSkillInstance[newID] == nil or not VigorSkillInstance[newID].NeedTick then
                            table.insert(randomTbl, VigorSkillSlot.Slot[i])
                        end
                    end
                    if #randomTbl > 0 then
                        local randomIndex = math.random(#randomTbl)
                        CurSkillID = randomTbl[randomIndex].SkillID
                        cd = randomTbl[randomIndex].CD
                    else
                        return
                    end

                    -- math.random(#VigorSkillSlot)

                end

                -- print(" -------- > "..tostring(cd) )

                -- print(VigorSkillInstance[CurSkillID])

                if VigorSkillInstance[CurSkillID] == nil or not VigorSkillInstance[CurSkillID].NeedTick then

                    if not IsInMagicallyChange then

                        IsInMagicallyChange = true
                        

                        local curSkillConfig = VigorSkillConfig.Config[CurSkillID]

                    
                        -- print(curSkillConfig.Path)
                        local config = LoadAsset(curSkillConfig.Path)
                    
                        local BPPlayerController = FindFirstOf("BP_B1PlayerController_C")
                        local bpPlayer = BPPlayerController.pawn


                    
                        -- print(bpPlayer)
                        -- print(bpPlayer:GetFullName())
                        -- print(config:IsValid())

                        BGUFunctionLibraryCS:CastMagicallyChangeSkill(bpPlayer, config, math.floor(curSkillConfig.SkillID), math.floor(curSkillConfig.RecoverID))
                        if VigorSkillSlot.Mode == 1 then
                            CurrentIndex = CurrentIndex + 1
                        end

                        -- print(" ---- > "..tostring(VigorSkillSlot.Slot[CurrentIndex].CD))
                        VigorSkillInstance[CurSkillID] = {
                            CD = cd,
                            NeedTick = true
                        }
                    end
                end

            else
                IsInMagicallyChange = true
            end

        end
    end)

    RegisterHook("/Script/b1-Managed.BUS_GSEventCollection:Evt_CastSkillWithAnimMontageMultiCast", function(Context, Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason)
    
        local montageName = Montage:get():GetFullName()
        local reson = Reason:get()
        
        -- print(montageName)
        
        if montageName:find("AM_wukong_trans_from_Vigor") and reson == 2 then
    
    
            -- VigorSkillInstance[CurSkillID].NeedTick = true
    
            ExecuteWithDelay(math.floor(Montage:get().SequenceLength * 1000), function()
                -- print(" !!!!!!!! ")
                IsInMagicallyChange = false
            end)
            
        end
    end)
end)

LoopAsync(1000, function()

    for k,v in pairs(VigorSkillInstance) do
        if v.NeedTick then
            v.CD = v.CD - 1
            -- print(tostring("CD ---- > "..v.CD))
            if v.CD <= 0 then
                v.NeedTick = false
            end
        end
    end

end)

function IsNilOrInvalid(obj)
    return obj == nil or not obj:IsValid()
end

-- RegisterHook("/Script/b1-Managed.BPS_GSEventCollection:Evt_SendServantReq_Multicast_Invoke", function(Context, OldActor, NewActorResId)
    
--     print(" --------------- > ")
--     print(Context:get())
--     print(Context:get():GetFullName())
--     -- print(BuffID:get())
--     print(" ---------------------- ")
-- end)
