using RimWorld;
using Verse;
using System.Collections.Generic;
    
namespace RaiseTheRoof
{
    public class CompProperties_RemoveCustomRoof : CompProperties
    {
        public RoofDef roofDef;
    }
    public class CompRemoveCustomRoof : ThingComp
    {
        public CompProperties_RemoveCustomRoof Props
        {
            get
            {
                return (CompProperties_RemoveCustomRoof)props;
            }
        }

        public override void PostSpawnSetup(bool respawningAfterLoad)
        {
            base.PostSpawnSetup(respawningAfterLoad);
            if (!respawningAfterLoad)
            {
                RoofDef roof = parent.Map.roofGrid.RoofAt(parent.Position);
                if (roof == null || (roof != null && roof.defName == Props.roofDef.defName))
                {
                    parent.Map.roofGrid.SetRoof(parent.Position, null);
                    List<IntVec3> roofList = new List<IntVec3>();
                    for (int i = 0; i < 5; i++)
                    {
                        IntVec3 intVec = parent.Position + GenAdj.CardinalDirectionsAndInside[i];
                        roofList.Add(intVec);
                    }
                    RoofCollapseCellsFinder.CheckCollapseFlyingRoofs(roofList, parent.Map, true, false);
                    Thing thing = ThingMaker.MakeThing(RimWorld.ThingDefOf.Steel, null);
                    thing.stackCount = 80;
                    GenPlace.TryPlaceThing(thing, parent.Position, parent.Map, ThingPlaceMode.Near);
                }
            }
        }

        public override void CompTick()
        {
            base.CompTick();
            if (!parent.Destroyed)
            {
                parent.Destroy(DestroyMode.Vanish);
            }
        }
    }
    public class CompProperties_BuildCustomRoof : CompProperties
    {
        public RoofDef roofDef;
    }
    public class CompBuildCustomRoof : ThingComp
    {
        public CompProperties_BuildCustomRoof Props
        {
            get
            {
                return (CompProperties_BuildCustomRoof)props;
            }
        }
        public override void PostSpawnSetup(bool respawningAfterLoad)
		{
			base.PostSpawnSetup(respawningAfterLoad);
			if (!respawningAfterLoad)
			{
                RoofDef roof = parent.Map.roofGrid.RoofAt(parent.Position);
                if (roof == null || (roof != null && roof.defName != Props.roofDef.defName))
                {
                    parent.Map.roofGrid.SetRoof(parent.Position, Props.roofDef);
                    MoteMaker.PlaceTempRoof(parent.Position, parent.Map);
                }
			}
		}

		public override void CompTick()
		{
			base.CompTick();
			if (!parent.Destroyed)
			{
				parent.Destroy(DestroyMode.Vanish);
			}
		}
	}
}
