using RimWorld;
using Verse;

namespace RaiseTheRoof
{
    public class Designator_BuildSteelRoof : Designator_Build
    {
        public override int DraggableDimensions
        {
            get
            {
                return 2;
            }
        }

        public override bool DragDrawMeasurements
        {
            get
            {
                return true;
            }
        }
        public Designator_BuildSteelRoof() : base(ThingDefOf.RTR_SteelRoof) { }
        public override BuildableDef PlacingDef { get => entDef; }

        public override string Label
        {
            get
            {
                return "DesignatorAreaBuildSteelRoofExpand".Translate().CapitalizeFirst();
            }
        }
        public override string Desc
        {
            get
            {
                return "DesignatorAreaBuildSteelRoofExpandDesc".Translate().CapitalizeFirst();
            }
        }
        public override AcceptanceReport CanDesignateCell(IntVec3 c)
        {
            if (!c.InBounds(Map))
            {
                return false;
            }
            if (c.Fogged(Map))
            {
                return false;
            }
            RoofDef roofDef = Map.roofGrid.RoofAt(c);
            if (roofDef != null && roofDef.isThickRoof)
            {
                return false;
            }
            Thing t = Map.thingGrid.ThingAt(c, ThingDefOf.RTR_RemoveSteelRoof);
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, ThingDefOf.RTR_SteelRoof);
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_SteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_SteelRoof"));
            if (t != null)
            {
                return false;
            }
            return true;
        }

        public override void DesignateSingleCell(IntVec3 c)
        {
            if (DebugSettings.godMode)
            {
                Map.areaManager.BuildRoof[c] = false;
                Map.areaManager.NoRoof[c] = false;
                Map.roofGrid.SetRoof(c, RoofDefOf.RTR_RoofSteel);
            }
            else
            {
                Map.areaManager.BuildRoof[c] = false;
                Map.areaManager.NoRoof[c] = false;
                GenConstruct.PlaceBlueprintForBuild(PlacingDef, c, Map, placingRot, Faction.OfPlayer, null);
            }
        }

        public override bool ShowWarningForCell(IntVec3 c)
        {
            foreach (Thing current in Map.thingGrid.ThingsAt(c))
            {
                if (current.def.plant != null && current.def.plant.interferesWithRoof)
                {
                    Messages.Message("MessageRoofIncompatibleWithPlant".Translate(current), MessageTypeDefOf.CautionInput, false);
                    return true;
                }
            }
            return false;
        }
        public override void SelectedUpdate()
        {
            GenUI.RenderMouseoverBracket();
            Map.areaManager.BuildRoof.MarkForDraw();
            Map.areaManager.NoRoof.MarkForDraw();
            Map.roofGrid.Drawer.MarkForDraw();
        }
    }
    public class Designator_RemoveSteelRoof : Designator_Build
    {
		public override int DraggableDimensions
		{
			get
			{
				return 2;
			}
		}

		public override bool DragDrawMeasurements
		{
			get
			{
				return true;
			}
		}
        public Designator_RemoveSteelRoof() : base(ThingDefOf.RTR_RemoveSteelRoof) { }
        public override BuildableDef PlacingDef { get => entDef; }
        public override string Label
        {
            get
            {
                return "DesignatorAreaRemoveSteelRoofExpand".Translate().CapitalizeFirst();
            }
        }
        public override string Desc
        {
            get
            {
                return "DesignatorAreaRemoveSteelRoofExpandDesc".Translate().CapitalizeFirst();
            }
        }
        public override AcceptanceReport CanDesignateCell(IntVec3 c)
		{
			if (!c.InBounds(Map))
			{
				return false;
			}
			if (c.Fogged(Map))
			{
				return false;
			}
			RoofDef roofDef = Map.roofGrid.RoofAt(c);
			if (roofDef != null && roofDef != RoofDefOf.RTR_RoofSteel)
			{
				return false;
			}
            if (roofDef == null)
            {
                return false;
            }
            Thing t = Map.thingGrid.ThingAt(c, ThingDefOf.RTR_RemoveSteelRoof);
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, ThingDefOf.RTR_SteelRoof);
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_SteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                return false;
            }
            t = Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_SteelRoof"));
            if (t != null)
            {
                return false;
            }
            return true;
		}

		public override void DesignateSingleCell(IntVec3 c)
		{
            if (DebugSettings.godMode)
            {
                Map.areaManager.BuildRoof[c] = false;
                Map.areaManager.NoRoof[c] = false;
                Map.roofGrid.SetRoof(c, null);
            }
            else
            {
                Map.areaManager.BuildRoof[c] = false;
                Map.areaManager.NoRoof[c] = false;
                GenConstruct.PlaceBlueprintForBuild(PlacingDef, c, Map, placingRot, Faction.OfPlayer, null);
            }
        }
		public override void SelectedUpdate()
		{
			GenUI.RenderMouseoverBracket();
            Map.areaManager.BuildRoof.MarkForDraw();
            Map.areaManager.NoRoof.MarkForDraw();
            Map.roofGrid.Drawer.MarkForDraw();
        }
    }
}
