﻿using Harmony;
using System;
using System.Collections.Generic;
using System.Reflection;
using Verse;
using RimWorld;
using UnityEngine;

namespace RaiseTheRoof
{
    [StaticConstructorOnStartup]
    public static class HarmonyPatches
    {
        private const BindingFlags allFlags = BindingFlags.Static | BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic | BindingFlags.GetField | BindingFlags.GetProperty | BindingFlags.SetProperty;

        public static FieldInfo fi_drawerInt;
        public static FieldInfo fi_drawer;
        public static FieldInfo fi_wantDraw;
        public static FieldInfo fi_roofGrid;
        public static FieldInfo fi_justAddedCells;
        public static FieldInfo fi_map;
        public static MethodInfo mi_NewBlueprintDef_Thing = typeof(ThingDefGenerator_Buildings).GetMethod("NewBlueprintDef_Thing", allFlags);
        public static MethodInfo mi_NewFrameDef_Thing = typeof(ThingDefGenerator_Buildings).GetMethod("NewFrameDef_Thing", allFlags);
        public static MethodInfo mi_GiveShortHash = typeof(ShortHashGiver).GetMethod("GiveShortHash", allFlags);
        static HarmonyPatches()
        {
            HarmonyInstance harmony = HarmonyInstance.Create("raisetheroof.harmony");
            harmony.Patch(AccessTools.Property(typeof(Area_BuildRoof), "Color").GetGetMethod(), new HarmonyMethod(typeof(HarmonyPatches), nameof(Patch_ColorBuildRoof)), null);
            harmony.Patch(AccessTools.Property(typeof(Area_NoRoof), "Color").GetGetMethod(), new HarmonyMethod(typeof(HarmonyPatches), nameof(Patch_ColorNoRoof)), null);
            {
                Type type = typeof(RoofGrid);
                fi_drawerInt = type.GetField("drawerInt", allFlags);
                fi_roofGrid = type.GetField("roofGrid", allFlags);
                fi_map = type.GetField("map", allFlags);
                harmony.Patch(AccessTools.Property(typeof(RoofGrid), "Color").GetGetMethod(), new HarmonyMethod(typeof(HarmonyPatches), nameof(Patch_ColorRoofGrid)), null);
                harmony.Patch(type.GetMethod("GetCellExtraColor", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_GetCellExtraColor))), null);
                harmony.Patch(type.GetMethod("SetRoof", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_SetRoof))), null);
                harmony.Patch(type.GetMethod("RoofGridUpdate", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_RoofGridUpdate))), null);
            }
            {
                Type type = typeof(Area);
                fi_drawer = type.GetField("drawer", allFlags);
            }
            {
                Type type = typeof(CellBoolDrawer);
                fi_wantDraw = type.GetField("wantDraw", allFlags);
            }
            {
                Type type = typeof(Designator_AreaBuildRoof);
                harmony.Patch(type.GetMethod("CanDesignateCell", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_CanDesignateCellBuildRoof))), null);
                harmony.Patch(type.GetMethod("DesignateSingleCell", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_DesignateSingleCellBuildRoof))), null);
                harmony.Patch(type.GetMethod("SelectedUpdate", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_SelectedUpdateBuildRoof))), null);
            }
            {
                Type type = typeof(Designator_AreaNoRoof);
                fi_justAddedCells = type.GetField("justAddedCells", allFlags);
                harmony.Patch(type.GetMethod("CanDesignateCell", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_CanDesignateCellNoRoof))), null);
                harmony.Patch(type.GetMethod("DesignateSingleCell", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_DesignateSingleCellNoRoof))), null);
                harmony.Patch(type.GetMethod("SelectedUpdate", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_SelectedUpdateNoRoof))), null);
            }
            {
                Type type = typeof(AutoBuildRoofAreaSetter);
                harmony.Patch(type.GetMethod("TryGenerateAreaNow", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_TryGenerateAreaNow))), null);
                harmony.Patch(type.GetMethod("TryGenerateAreaOnImpassable", allFlags), new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_TryGenerateAreaOnImpassable))), null);
            }
            {
                Type type = typeof(InfestationCellFinder);
                harmony.Patch(type.GetMethod("GetScoreAt", allFlags), null, new HarmonyMethod(typeof(HarmonyPatches).GetMethod(nameof(Patch_GetScoreAt))), null);
            }
            SetupBlueprintAndFrameDefs();
            harmony.PatchAll(Assembly.GetExecutingAssembly());
        }
        public static void SetupBlueprintAndFrameDefs()
        {
            CreateBlueprintAndFrameDefs(ThingDefOf.RTR_SteelRoof);
            CreateBlueprintAndFrameDefs(ThingDefOf.RTR_RemoveSteelRoof);
        }
        public static void CreateBlueprintAndFrameDefs(ThingDef thingDef)
        {
            ThingDef def = thingDef;
            ThingDef bpDef = newBlueprintDef_Thing(def, false, null);
            giveShortHash(bpDef, typeof(ThingDef));
            DefDatabase<ThingDef>.Add(bpDef);

            def = thingDef;
            ThingDef fDef = newFrameDef_Thing(def);
            giveShortHash(fDef, typeof(ThingDef));
            DefDatabase<ThingDef>.Add(fDef);
        }
        public static ThingDef newBlueprintDef_Thing(ThingDef def, bool isInstallBlueprint, ThingDef normalBlueprint = null)
        {
            return (ThingDef)mi_NewBlueprintDef_Thing.Invoke(null, new object[] { def, isInstallBlueprint, normalBlueprint });
        }
        public static ThingDef newFrameDef_Thing(ThingDef def)
        {
            return (ThingDef)mi_NewFrameDef_Thing.Invoke(null, new object[] { def });
        }
        public static void giveShortHash(Def def, Type defType)
        {
            mi_GiveShortHash.Invoke(null, new object[] { def, defType });
        }
        public static RoofDef[] roofGrid(RoofGrid instance)
        {
            return (RoofDef[])fi_roofGrid.GetValue(instance);
        }
        public static bool wantDraw(CellBoolDrawer instance)
        {
            return (bool)fi_wantDraw.GetValue(instance);
        }
        public static CellBoolDrawer drawer(Area instance)
        {
            return (CellBoolDrawer)fi_drawer.GetValue(instance);
        }
        public static CellBoolDrawer drawerInt(RoofGrid instance)
        {
            return (CellBoolDrawer)fi_drawerInt.GetValue(instance);
        }
        public static List<IntVec3> justAddedCells(Designator_AreaNoRoof instance)
        {
            return (List<IntVec3>)fi_justAddedCells.GetValue(instance);
        }
        public static Map map(RoofGrid instance)
        {
            return (Map)fi_map.GetValue(instance);
        }
        public static bool Patch_ColorRoofGrid(ref RoofGrid __instance, ref Color __result)
        {
            __result = Color.white;
            return false;
        }
        public static bool Patch_ColorBuildRoof(ref Area_BuildRoof __instance, ref Color __result)
        {
            __result = Color.green;
            return false;
        }
        public static bool Patch_ColorNoRoof(ref Area_NoRoof __instance, ref Color __result)
        {
            __result = Color.red;
            return false;
        }
        public static bool Patch_SelectedUpdateBuildRoof(ref Designator_AreaBuildRoof __instance)
        {
            GenUI.RenderMouseoverBracket();
            __instance.Map.areaManager.BuildRoof.MarkForDraw();
            __instance.Map.areaManager.NoRoof.MarkForDraw();
            __instance.Map.roofGrid.Drawer.MarkForDraw();
            return false;
        }
        public static bool Patch_SelectedUpdateNoRoof(ref Designator_AreaNoRoof __instance)
        {
            GenUI.RenderMouseoverBracket();
            __instance.Map.areaManager.BuildRoof.MarkForDraw();
            __instance.Map.areaManager.NoRoof.MarkForDraw();
            __instance.Map.roofGrid.Drawer.MarkForDraw();
            return false;
        }

        public static bool Patch_GetCellExtraColor(ref RoofGrid __instance, ref Color __result, ref int index)
        {
            CellBoolDrawer drawerBuildRoof = drawer(map(__instance).areaManager.BuildRoof);
            bool drawingBuildRoof = wantDraw(drawerBuildRoof);
            CellBoolDrawer drawerNoRoof = drawer(map(__instance).areaManager.NoRoof);
            bool drawingNoRoof = wantDraw(drawerNoRoof);

            IntVec3 c = map(__instance).cellIndices.IndexToCell(index);
            if (drawingNoRoof && map(__instance).areaManager.NoRoof[c])
            {
                __result = new Color(0f, 0f, 0f, 0f);
            }
            else if (drawingBuildRoof && map(__instance).areaManager.BuildRoof[c])
            {
                __result = new Color(0f, 0f, 0f, 0f);
            }
            else if (RimWorld.RoofDefOf.RoofRockThick != null && roofGrid(__instance)[index] == RimWorld.RoofDefOf.RoofRockThick)
            {
                Color orange = new Color(1.0f, 0.65f, 0f);
                __result = orange;
            }
            else if (RimWorld.RoofDefOf.RoofRockThin != null && roofGrid(__instance)[index] == RimWorld.RoofDefOf.RoofRockThin)
            {
                __result = Color.yellow;
            }
            else if (RimWorld.RoofDefOf.RoofConstructed != null && roofGrid(__instance)[index] == RimWorld.RoofDefOf.RoofConstructed)
            {
                __result = Color.cyan;
            }
            else if (RoofDefOf.RTR_RoofSteel != null && roofGrid(__instance)[index] == RoofDefOf.RTR_RoofSteel)
            {
                __result = Color.blue;
            }
            else
            {
                __result = Color.white;
            }
            return false;
        }
        public static bool Patch_CanDesignateCellBuildRoof(ref Designator_AreaBuildRoof __instance, ref AcceptanceReport __result, ref IntVec3 c)
        {
            bool result = true;
            if (!c.InBounds(__instance.Map))
            {
                result = false;
            }
            if (c.Fogged(__instance.Map))
            {
                result = false;
            }
            RoofDef roofDef = __instance.Map.roofGrid.RoofAt(c);
            if (roofDef != null)
            {
                result = false;
            }
            Thing t = __instance.Map.thingGrid.ThingAt(c, ThingDefOf.RTR_RemoveSteelRoof);
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, ThingDefOf.RTR_SteelRoof);
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_SteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_SteelRoof"));
            if (t != null)
            {
                result = false;
            }
            if (result)
            {
                __result = true;
            }
            else
            {
                __result = false;
            }
            return false;
        }
        public static bool Patch_CanDesignateCellNoRoof(ref Designator_AreaNoRoof __instance, ref AcceptanceReport __result, ref IntVec3 c)
        {
            bool result = true;
            if (!c.InBounds(__instance.Map))
            {
                result = false;
            }
            if (c.Fogged(__instance.Map))
            {
                result = false;
            }
            RoofDef roofDef = __instance.Map.roofGrid.RoofAt(c);
            if (roofDef != null && (roofDef == RimWorld.RoofDefOf.RoofRockThick || roofDef == RoofDefOf.RTR_RoofSteel))
            {
                result = false;
            }
            if (roofDef == null)
            {
                result = false;
            }
            Thing t = __instance.Map.thingGrid.ThingAt(c, ThingDefOf.RTR_RemoveSteelRoof);
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, ThingDefOf.RTR_SteelRoof);
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Blueprint_RTR_SteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_RemoveSteelRoof"));
            if (t != null)
            {
                result = false;
            }
            t = __instance.Map.thingGrid.ThingAt(c, DefDatabase<ThingDef>.GetNamed("Frame_RTR_SteelRoof"));
            if (t != null)
            {
                result = false;
            }
            if (result)
            {
                __result = true;
            }
            else
            {
                __result = false;
            }
            return false;
        }
        public static bool Patch_DesignateSingleCellBuildRoof(ref Designator_AreaBuildRoof __instance, ref IntVec3 c)
        {
            __instance.Map.areaManager.NoRoof[c] = false;
            if (!__instance.Map.areaManager.BuildRoof[c])
            {
                __instance.Map.areaManager.BuildRoof[c] = true;
                CellBoolDrawer drawerIntRoofGrid = drawerInt(__instance.Map.roofGrid);
                drawerIntRoofGrid.SetDirty();
            }
            return false;
        }
        public static bool Patch_DesignateSingleCellNoRoof(ref Designator_AreaNoRoof __instance, ref IntVec3 c)
        {
            __instance.Map.areaManager.BuildRoof[c] = false;
            if (!__instance.Map.areaManager.NoRoof[c])
            {
                __instance.Map.areaManager.NoRoof[c] = true;
                CellBoolDrawer drawerIntRoofGrid = drawerInt(__instance.Map.roofGrid);
                drawerIntRoofGrid.SetDirty();
            }
            justAddedCells(__instance).Add(c);
            return false;
        }
        public static bool Patch_SetRoof(ref RoofGrid __instance, ref IntVec3 c, ref RoofDef def)
        {
            if (Scribe.mode == LoadSaveMode.Inactive)
            {
                if (def != null)
                {
                    if (map(__instance).areaManager.BuildRoof[c])
                    {
                        map(__instance).areaManager.BuildRoof[c] = false;
                    }
                }
                else
                {
                    if (map(__instance).areaManager.NoRoof[c])
                    {
                        map(__instance).areaManager.NoRoof[c] = false;
                    }
                }
            }
            return true;
        }
        public static bool Patch_TryGenerateAreaNow(ref AutoBuildRoofAreaSetter __instance, ref Room room)
        {
            return false;
        }
        public static bool Patch_TryGenerateAreaOnImpassable(ref AutoBuildRoofAreaSetter __instance, ref IntVec3 c)
        {
            return false;
        }
        public static bool Patch_RoofGridUpdate(ref RoofGrid __instance)
        {
            if (Find.PlaySettings.showRoofOverlay)
            {
                map(__instance).areaManager.BuildRoof.MarkForDraw();
                map(__instance).areaManager.NoRoof.MarkForDraw();
                __instance.Drawer.MarkForDraw();
            }
            __instance.Drawer.CellBoolDrawerUpdate();
            return false;
        }
        public static void Patch_GetScoreAt(ref float __result, ref IntVec3 cell, ref Map map)
        {
            if (cell.GetRoof(map) == RoofDefOf.RTR_RoofSteel)
            {
                __result = 0f;
            }
        }
    }
}
