﻿using RimWorld;
using HarmonyLib;
using Verse;
using System;

namespace TameWithKibble
{
	class FoodUtilityPatch
	{
		public static bool WillTrainOrTame(bool willEatValue, Pawn p, Pawn getter)
		{
			return willEatValue && p.AnimalOrWildMan() && getter.IsColonist && !p.Downed && p.Awake();
		}
	}

	[HarmonyPatch(typeof(FoodUtility), "WillEat", new Type[] { typeof(Pawn), typeof(Thing), typeof(Pawn), typeof(bool) })]
	class FoodUtilityPatch1
	{


		[HarmonyPostfix]
		public static void WillEatPatch1(ref bool __result, Pawn p, Thing food, Pawn getter)
		{
			if (getter == null) return;
			if (FoodUtilityPatch.WillTrainOrTame(__result, p, getter))
			{
				foreach (FoodRestriction allFoodRestriction in Current.Game.foodRestrictionDatabase.AllFoodRestrictions)
				{
					if (allFoodRestriction.label == TWKPatch.RestrictionName)
					{
						if (!allFoodRestriction.Allows(food) && (food.def.IsWithinCategory(ThingCategoryDefOf.Foods) || food.def.IsWithinCategory(ThingCategoryDefOf.Corpses)))
						{
							__result = false;
							return;
						}

					}
				}
			}
		}
	}

	[HarmonyPatch(typeof(FoodUtility), "WillEat", new Type[] { typeof(Pawn), typeof(ThingDef), typeof(Pawn), typeof(bool) })]
	class FoodUtilityPatch2
	{
		[HarmonyPostfix]
		public static void WillEatPatch2(ref bool __result, Pawn p, ThingDef food, Pawn getter)
		{
			if (getter == null) return;
			if (FoodUtilityPatch.WillTrainOrTame(__result, p, getter))
			{
				foreach (FoodRestriction allFoodRestriction in Current.Game.foodRestrictionDatabase.AllFoodRestrictions)
				{
					if (allFoodRestriction.label == TWKPatch.RestrictionName)
					{
						if (!allFoodRestriction.Allows(food) && food.IsWithinCategory(allFoodRestriction.filter.DisplayRootCategory.catDef))
						{
							__result = false;
							return;
						}

					}
				}
			}
		}
	}
}
