﻿using RimWorld;
using HarmonyLib;
using Verse;

namespace TameWithKibble
{
	class RestrictionUtility
	{
		public static bool MakeFoodRestriction(FoodRestrictionDatabase foodRestrictionDatabase)
		{
			foreach (FoodRestriction allFoodRestriction in foodRestrictionDatabase.AllFoodRestrictions)
			{
				if (allFoodRestriction.label == TWKPatch.RestrictionName) return false;
			}
			FoodRestriction foodRestrictionA = foodRestrictionDatabase.MakeNewFoodRestriction();
			foodRestrictionA.label = TWKPatch.RestrictionName;
			foreach (ThingDef allDef3 in DefDatabase<ThingDef>.AllDefs)
			{
				if (allDef3.ingestible != null && (int)allDef3.ingestible.preferability >= 7 && allDef3 != ThingDefOf.MealNutrientPaste && allDef3 != ThingDefOf.Pemmican)
				{
					foodRestrictionA.filter.SetAllow(allDef3, allow: false);
				}
			}
			foodRestrictionA.filter.SetAllow(ThingDefOf.Chocolate, allow: false);
			return true;
		}
	}
}
