﻿using RimWorld;
using Verse;
using System;
using UnityEngine;
using System.Collections.Generic;

using System.Linq;


namespace ConveyorBelt
{

    public class Building_ConveyorBelt : Building_Storage
    {
        private int spriteTime = 0; //Which frame the animation is at
        private Matrix4x4 drawMatrix; //Matrix describing the translation,scale and rotation to draw building at
        private List<Material> matList = new List<Material>(); //Preloaded material list for animation
        private int ticksPrev = 0; //Counter for the number of ticks that have occured since moving frames
        private const int maxTickFrames = 20; //Animation playback speed - Ticks until move to next frame
        private int maxcheckTicks = 120 + Rand.RangeInclusive(0, 20); //How often to check frames for next movement
        private int checkticksPrev = 0;
        private int aniFrames = 0; //Number of frames in the animation
        private Map map;
        private IntVec3 targetpos;
        private ConveyorBelt_CS.CB_ItemHandler handler = new ConveyorBelt_CS.CB_ItemHandler();

        public Building_ConveyorBelt()
        {
            
        }

        public override void Draw()
        {
            if (aniFrames == 0)
            {
                //Setup position ,rotation, and size matrix describing items coordinates
                this.drawMatrix = SetupMatrix();
                PreLoadMaterials();
            }
            DrawBelt();
        }

        public override void SpawnSetup(Map map, bool respawnAfterLoad)
        {
            base.SpawnSetup(map, respawnAfterLoad);
            this.map = map;
            this.targetpos = handler.GetTarget(this.Position, this.Rotation);
            //Log.Message("This Position: " + "(" + (int)this.Position.ToVector3().x + "," + (int)this.Position.ToVector3().y + "," + (int)this.Position.ToVector3().z + ")");
            //Log.Message("Target Position: " + "(" + (int)this.targetpos.x + "," + (int)this.targetpos.y + "," + (int)this.targetpos.z + ")");
        }

        public override void Tick()
        {
            base.Tick();
          
            CompPowerTrader comp = base.GetComp<CompPowerTrader>();
            if (comp != null && comp.PowerOn && aniFrames != 0)
            {
                if (ticksPrev >= maxTickFrames){
                    spriteTime = SpriteCounter(spriteTime);
                    
                    ticksPrev = 0;
                }
                else
                {
                    ticksPrev += 1;
                }

                if (checkticksPrev>= maxcheckTicks)
                {
                    handler.TryMoveObjeect(this.Position, targetpos, this.map);
                    checkticksPrev = 0;
                }
                else
                {
                    checkticksPrev += 1;
                }
            
                
                //bool isoccupied = handler.GetLocationIsOccupied(this.cbmap, this.Position);
                //bool isoccupied = CB_ItemHandler.GetLocationIsOccupied(this.cbmap, this.Position.ToVector3());
            }
        }

        public void DrawBelt()
        {
            Graphics.DrawMesh(MeshPool.plane10, drawMatrix, matList[spriteTime], 0);
        }

        private Matrix4x4 SetupMatrix()
        {
            
            float curDrawSize = this.def.graphicData.drawSize.x;
            Matrix4x4 matrix = default(Matrix4x4);
            
            matrix.SetTRS(this.DrawPos + Altitudes.AltIncVect, Quaternion.identity, new Vector3(curDrawSize, 1f, curDrawSize));
            return matrix;
        }

        private int SpriteCounter(int spriteTime)
        { 
            if (spriteTime != null)
            {
                spriteTime += 1;
                spriteTime = spriteTime % aniFrames;
            }
            else
            {
                spriteTime = 0;
            }
            return spriteTime;
        }

        private string GetSubfolderPath(Rot4 facingdirection)
        {
            string outputString;
            string basepath;

            string[] pathslice = this.Graphic.path.Split('/');
            basepath = pathslice[0];
            for (int i = 1; i< pathslice.Length - 1; i++)
            {
                    basepath = basepath +"/" +pathslice[i];
            }
            switch (facingdirection.AsInt)
            {
                case 0:
                    outputString = basepath+ "/North";
                    break;
                case 1:
                    outputString = basepath + "/East";
                    break;
                case 2:
                    outputString = basepath + "/South";
                    break;
                case 3:
                    outputString = basepath + "/West";
                    break;
                default:
                    outputString = basepath + "/North";
                    break;
            }
            outputString = outputString + "/ConveyorBelt";
            return outputString;
        }

        private void PreLoadMaterials()
        {
            //Preload Materials for Rendor- selecting correct direction for animation
            string subfolderpath;
            
            subfolderpath = GetSubfolderPath(this.Rotation);
            //Log.Message("MatFolder: " + subfolderpath);

            //Load Animation texturesTextures from Subfolder
            List<Texture2D> texlist = (from x in ContentFinder<Texture2D>.GetAllInFolder(subfolderpath)
                                       where !x.name.EndsWith(Graphic_Single.MaskSuffix)
                                       orderby x.name
                                       select x).ToList<Texture2D>();

            //Check list and build materials
            if (texlist.NullOrEmpty<Texture2D>())
            {
                Log.Error("Collection cannot init: No textures found at path: " + subfolderpath, false);
                Graphic[] subGraphics = new Graphic[]
                 {
                    BaseContent.BadGraphic
                 };
                this.matList.Add(subGraphics[0].MatSingle);
                aniFrames += 1;
            }
            else
            {
                Graphic[] subGraphics = new Graphic[texlist.Count];
                for (int i = 0; i < texlist.Count; i++)
                {
                    //Make Material from Texture
                    MaterialRequest req2 = default(MaterialRequest);
                    req2.mainTex = texlist[i];
                    req2.shader = this.def.graphic.Shader;
                    req2.color = this.Graphic.color;
                    req2.colorTwo = this.Graphic.colorTwo;
                    req2.maskTex = null;
                    req2.shaderParameters = this.def.graphicData.shaderParameters;
                    this.matList.Add(MaterialPool.MatFrom(req2));
                    aniFrames += 1;
                }
            }
        }
    }

}