﻿using System;
using System.Collections.Generic;
using RimWorld;
using Verse;

namespace ConveyorBelt_CS
{
    public class CB_ItemHandler
    {
        public CB_ItemHandler()
        {
        }
        

        public bool GetLocationIsOccupied(Map map, IntVec3 position)
        {
            bool isoccupied = false;

            IEnumerable<Thing> enumerable = map.thingGrid.ThingsAt(position);
            foreach (Thing thing in enumerable)
            {
                if (thing.def.category != ThingCategory.Building && thing.def.category != ThingCategory.Pawn && thing.def.category != ThingCategory.Ethereal || thing.def.passability.Equals(Traversability.Impassable)) //&& (thing.def.defName.Equals("PowerConduitInvisible") || thing.def.defName.Equals("PowerConduit")))
                {
                    //Log.Message("Thing Occupied: " + thing.thingIDNumber);
                    //Log.Message("Thing Position: " + "(" + (int)thing.Position.ToVector3().x + "," + (int)thing.Position.ToVector3().y + "," + (int)thing.Position.ToVector3().z + ")");
                    isoccupied = true;
                }
            }
            return isoccupied;
        }

        public IntVec3 GetTarget(IntVec3 OriginalPosition, Rot4 facingdirection)
        {
            IntVec3 targetloc = default(IntVec3);
            targetloc.z += (int)(OriginalPosition.z+(float)facingdirection.AsVector2.y);
            targetloc.y += (int)(OriginalPosition.y);
            targetloc.x += (int)(OriginalPosition.x + (float)facingdirection.AsVector2.x);
            return targetloc;
        }

        public bool TryMoveObjeect(IntVec3 OriginalPosition, IntVec3 targetPosition, Map map)
        {
            bool placed = false;
            if (this.GetLocationIsOccupied(map,targetPosition))
            {
               
            }
            else
            {
                //Zone zone = map.zoneManager.ZoneAt(targetPosition);
                IEnumerable<Thing> enumerable = map.thingGrid.ThingsAt(OriginalPosition);
                foreach (Thing thing in enumerable)
                {
                   if (thing.def.category != ThingCategory.Building && thing.def.category != ThingCategory.Pawn && thing.def.category != ThingCategory.Ethereal)
                    {
                        
                        thing.DeSpawn(DestroyMode.Vanish);
                        //thing.SetForbidden(true, false);
                        placed = GenPlace.TryPlaceThing(thing, targetPosition, map, ThingPlaceMode.Direct, null, null);
                        if (!placed)
                        {
                            GenPlace.TryPlaceThing(thing, OriginalPosition, map, ThingPlaceMode.Direct, null, null);
                        }
                    }
                }
            }
            return placed;
        }
    }
}

