name = "New Boat Shapes"
description = [[This mod introduces 5 new boats with unique shapes, some boats also have additional capacities.

The boats can be turned with the steering wheel. Rotate the camera to deploy the boats at different angles.

Adapts the physics of aquatic objects and interactions with creatures to the new shapes.

Version 1.2:
* Reduce the lag appearing when there are many boats.
* New option to disable the effect of water to improve performance.

Version 1.1:
* Fixed the crash involving the Cookie Cutters.
* Improved compatibility with other mods.
* Fixed a crash when leaks on a boat were retrofitted.
* Fixed a glitch with the fire pump projectiles.
* Fixed a crash on the multiplayer.
]]
author = "Cuikui"
version = "1.2"
forumthread = ""
icon_atlas = "modicon.xml"
icon = "modicon.tex"
api_version = 10

dst_compatible = true
forge_compatible = true
gorge_compatible = true

dont_starve_compatible = false
reign_of_giants_compatible = false
shipwrecked_compatible = false

all_clients_require_mod = true 

configuration_options =
{
    {
        name = "raft",
        label = "Raft Boat",
		hover = "Option for Raft Boat",
        options =
        {
            {description = "Yes", data = true},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "bridge",
        label = "Bridge Boat",
		hover = "Option for Bridge Boat",
        options =
        {
            {description = "Yes", data = true},
			{description = "Classic", data = "classic", hover = "Remove build-in anchor."},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "boat",
        label = "Boat",
		hover = "Option for Classic Boat",
        options =
        {
            {description = "Yes", data = true},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "caravel",
        label = "Caravel",
		hover = "Option for Caravel",
        options =
        {
            {description = "Yes", data = true},
			{description = "Classic", data = "classic", hover = "Remove fast steering."},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "rectangle",
        label = "Rectangle Boat",
		hover = "Option for Rectangle Boat",
        options =
        {
            {description = "Yes", data = true},
			{description = "Classic", data = "classic", hover = "Remove slow speed."},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "moon",
        label = "Moon Boat",
		hover = "Option for Moon Boat",
        options =
        {
            {description = "Yes", data = true},
			{description = "Classic", data = "classic", hover = "Remove Wavey Jones protection."},
			{description = "No", data = false},
        },
        default = true,
    },
    {
        name = "lip",
        label = "Wave effects",
		hover = "Disable to improve performance.",
        options =
        {
            {description = "Yes", data = true},
			{description = "No", data = false}
        },
        default = true,
    },
}