/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.handler;

import com.google.common.collect.Ordering;
import com.hosta.Floricraft.config.ConfigChecker;
import com.hosta.Floricraft.helper.DateHelper;
import com.hosta.Floricraft.helper.EntityHelper;
import com.hosta.Floricraft.helper.MineHelper;
import com.hosta.Floricraft.helper.PotionHelper;
import com.hosta.Floricraft.init.FloricraftInit;
import com.hosta.Floricraft.packet.PacketNBTGui;
import com.hosta.Floricraft.world.biome.BiomeBasicWithPath;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandler {
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        String text = null;
        if (DateHelper.isNewYear()) {
            text = "new_year";
        } else if (DateHelper.isChristmas()) {
            text = "christmas";
        }
        if (text != null) {
            EntityPlayer player = event.player;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.event." + text, new Object[0]));
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Text", text);
            nbt.func_74768_a("Tick", 400);
            FloricraftInit.NETWORK_GUI.sendTo((IMessage)new PacketNBTGui(nbt), (EntityPlayerMP)player);
            MineHelper.spawnFireworksAround(player.func_130014_f_(), player.func_180425_c(), 3, 8);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() == FloricraftInit.PURNER) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemStack = event.craftMatrix.func_70301_a(i);
                if (itemStack == null || itemStack.func_77973_b() != FloricraftInit.PURNER) continue;
                event.craftMatrix.func_70304_b(i);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        BlockPos pos;
        BlockPos posDown;
        EntityZombie zombi;
        EntityLivingBase entity;
        if (!event.getEntity().field_70170_p.field_72995_K && (entity = event.getEntityLiving()) instanceof EntityZombie && zombi.field_70170_p.func_180495_p(posDown = (pos = (zombi = (EntityZombie)entity).func_180425_c()).func_177977_b()) == Blocks.field_150346_d.func_176223_P() && zombi.field_70170_p.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P()) {
            zombi.field_70170_p.func_175656_a(pos, FloricraftInit.LYCORIS.func_176223_P());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        AxisAlignedBB aabb;
        int amplifier;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70644_a(FloricraftInit.POTION_FLORIC)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_FLORIC).func_76458_c();
            int healTick = 200 / ++amplifier;
            if (entity.func_110143_aJ() < entity.func_110138_aP() && entity.field_70173_aa % (healTick < 4 ? 4 : healTick) == 0) {
                entity.func_70691_i(1.0f);
            }
            Collection collection = entity.func_70651_bq();
            List list = Ordering.natural().sortedCopy((Iterable)collection);
            list.forEach(potionEffect -> PotionHelper.decreaseBadPotionEffect(entity, potionEffect));
            if (ConfigChecker.isHillStepEnabled().booleanValue()) {
                entity.field_70138_W = 1.0f;
            }
        }
        if (entity.func_70644_a(FloricraftInit.POTION_TEMPTATION)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_TEMPTATION).func_76458_c();
            EntityAnimal nearest = null;
            aabb = entity.func_174813_aQ().func_72314_b((double)(8 + amplifier * 4), (double)(4 + amplifier * 2), (double)(8 + amplifier * 4));
            nearest = (EntityAnimal)entity.field_70170_p.func_72857_a(EntityAnimal.class, aabb, (Entity)entity);
            if (nearest != null) {
                nearest.func_70690_d(new PotionEffect(FloricraftInit.POTION_TEMPTED, 200, amplifier, true, false));
            }
        }
        if (entity.func_70644_a(FloricraftInit.POTION_TEMPTED)) {
            EntityAnimal animal;
            amplifier = entity.func_70660_b(FloricraftInit.POTION_TEMPTED).func_76458_c();
            EntityPlayer temptation = null;
            aabb = entity.func_174813_aQ().func_72314_b((double)(8 + amplifier * 4), (double)(4 + amplifier * 2), (double)(8 + amplifier * 4));
            temptation = (EntityPlayer)entity.field_70170_p.func_72857_a(EntityPlayer.class, aabb, (Entity)entity);
            if (temptation != null && temptation.func_70644_a(FloricraftInit.POTION_TEMPTATION) && entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70661_as().func_75497_a((Entity)temptation, 1.5 + (double)amplifier * 0.1);
                EntityHelper.spawnEntityParticle((Entity)entity, EnumParticleTypes.HEART);
            } else if (entity instanceof EntityAnimal && (animal = (EntityAnimal)entity).func_70874_b() == 0 && !animal.func_70880_s()) {
                animal.func_146082_f(null);
            }
        }
        if (entity.func_70644_a(FloricraftInit.POTION_ANTI_ZOMBIE)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_ANTI_ZOMBIE).func_76458_c();
            EntityHelper.antiEntityFrom((Entity)entity, EntityZombie.class, amplifier);
        }
        if (entity.func_70644_a(FloricraftInit.POTION_ANTI_SKELETON)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_ANTI_SKELETON).func_76458_c();
            EntityHelper.antiEntityFrom((Entity)entity, EntitySkeleton.class, amplifier);
        }
        if (entity.func_70644_a(FloricraftInit.POTION_ANTI_CREEPER)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_ANTI_CREEPER).func_76458_c();
            EntityHelper.antiEntityFrom((Entity)entity, EntityCreeper.class, amplifier);
        }
        if (entity.func_70644_a(FloricraftInit.POTION_ANTI_SPIDER)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_ANTI_SPIDER).func_76458_c();
            EntityHelper.antiEntityFrom((Entity)entity, EntitySpider.class, amplifier);
        }
        if (entity.func_70644_a(FloricraftInit.POTION_ANTI_ENDERMAN)) {
            amplifier = entity.func_70660_b(FloricraftInit.POTION_ANTI_ENDERMAN).func_76458_c();
            EntityHelper.antiEntityFrom((Entity)entity, EntityEnderman.class, amplifier);
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Post event) {
        if (!ConfigChecker.getGenBiomeFast().booleanValue()) {
            BiomeBasicWithPath.genPath(event.getWorld(), event.getChunkX() * 16, event.getChunkZ() * 16);
        }
    }
}

