/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.world.gen.feature;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class WorldGenSimpleRoad {
    private int rare;
    private float slope;
    private float scaleWidth;
    private float scaleHight;
    private float[] path;
    private float[] grass;
    private float[] waterway;
    private float[] fence;

    public WorldGenSimpleRoad(float slope, float scaleWidth, float scaleHight, int rare) {
        this.rare = rare;
        this.slope = slope;
        this.scaleWidth = scaleWidth;
        this.scaleHight = scaleHight;
    }

    private float function(float x) {
        return this.slope * x + MathHelper.func_76134_b((float)(x / this.scaleWidth)) * this.scaleHight;
    }

    public void setSegment(int posX) {
        this.path = this.getSegment(posX, 3);
        this.path[0] = this.getRared(this.path[0]);
        this.path[1] = this.getRared(this.path[1]);
        this.grass = this.getSegmentSide(posX, 3, 1);
        this.waterway = this.getSegmentSide(posX, 3, 2);
        this.fence = this.getSegmentSide(posX, 3, 3);
    }

    private float[] getSegmentSide(int posX, int width, int side) {
        float[] way1 = this.getSegment(posX - side, width);
        float[] way2 = this.getSegment(posX + side, width);
        return new float[]{this.getRared(Math.min(way1[0], way2[0]) - (float)side), this.getRared(Math.max(way1[1], way2[1]) + (float)side)};
    }

    private float[] getSegment(int posX, int width) {
        float z = this.function(posX);
        float[] segment = new float[]{z, z};
        float widthHalf = (float)width / 2.0f;
        float pos = -widthHalf;
        z = this.function((float)posX + pos);
        for (int i = 0; i < width; ++i) {
            float z1 = z;
            z = this.function((float)posX + pos + 1.0f);
            float hight = MathHelper.func_76129_c((float)(widthHalf * widthHalf - (pos += 0.5f) * pos));
            pos += 0.5f;
            segment[0] = Math.min(Math.min(z1, z) - hight, segment[0]);
            segment[1] = Math.max(Math.max(z1, z) + hight, segment[1]);
        }
        return segment;
    }

    public boolean isOnRoad(int posZ) {
        return this.isOnPath(posZ, this.fence[0], this.fence[1]);
    }

    private boolean isOnPath(int posZ, float min, float max) {
        float rareZ = this.getRared(posZ);
        return min < max && min <= rareZ && rareZ < max || max < min && (rareZ < max || min <= rareZ);
    }

    private float getRared(float raw) {
        float rared = raw % (float)this.rare;
        return rared <= 0.0f ? rared + (float)this.rare : rared;
    }

    public boolean genPath(World world, BlockPos pos) {
        if (this.isOnPath(pos.func_177952_p(), this.path[0], this.path[1])) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c) {
                world.func_175656_a(pos, this.isAirNearBy(world, pos) ? Blocks.field_150376_bx.func_176223_P() : Blocks.field_185774_da.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public boolean genGrass(World world, BlockPos pos) {
        if (this.isOnPath(pos.func_177952_p(), this.grass[0], this.path[0]) || this.isOnPath(pos.func_177952_p(), this.path[1], this.grass[1])) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c) {
                world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150329_H.func_176203_a(1));
            }
            return true;
        }
        return false;
    }

    public boolean genWaterway(World world, BlockPos pos) {
        if (this.isOnPath(pos.func_177952_p(), this.waterway[0], this.grass[0]) || this.isOnPath(pos.func_177952_p(), this.grass[1], this.waterway[1])) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c && world.func_175623_d(pos.func_177984_a())) {
                if (this.isAirNearBy(world, pos)) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    pos = pos.func_177977_b();
                }
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public boolean genFence(World world, BlockPos pos) {
        if (this.isOnPath(pos.func_177952_p(), this.fence[0], this.waterway[0]) || this.isOnPath(pos.func_177952_p(), this.waterway[1], this.fence[1])) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c && world.func_175623_d(pos.func_177984_a())) {
                world.func_175656_a(pos.func_177984_a(), Blocks.field_180407_aO.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private boolean isAirNearBy(World world, BlockPos pos) {
        return this.isAirNotOnWater(world, pos.func_177974_f()) || this.isAirNotOnWater(world, pos.func_177976_e()) || this.isAirNotOnWater(world, pos.func_177968_d()) || this.isAirNotOnWater(world, pos.func_177978_c());
    }

    private boolean isAirNotOnWater(World world, BlockPos pos) {
        return this.isAir(world.func_180495_p(pos).func_177230_c()) && world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j;
    }

    private boolean isAir(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_180407_aO || block == Blocks.field_150329_H;
    }
}

