/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.tileentity;

import com.hosta.Floricraft.tileentity.TileEntityBasicWithRender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityInventoryWithRender
extends TileEntityBasicWithRender
implements ISidedInventory {
    protected ItemStack[] items;
    private final int STACKLIMIT;

    public TileEntityInventoryWithRender(int inventorySize, int stackLimit) {
        this.items = new ItemStack[inventorySize];
        this.STACKLIMIT = stackLimit;
    }

    public void onClick(EntityPlayer player, ItemStack stackIn, EnumHand hand) {
        if (stackIn != null && this.isWhiteList(stackIn.func_77973_b())) {
            int index;
            int maxIndex = 0;
            for (index = this.items.length - 1; index >= 0; --index) {
                if (this.items[index] == null) continue;
                maxIndex = index;
                break;
            }
            for (index = maxIndex; index < this.items.length; ++index) {
                if (this.items[index] == null) {
                    this.items[index] = stackIn.func_77979_a(this.func_70297_j_());
                } else if (this.items[index].func_77973_b() == stackIn.func_77973_b() && this.items[index].field_77994_a < this.func_70297_j_() && this.canCombine(index, stackIn)) {
                    int amount = this.items[index].field_77994_a;
                    this.items[index].field_77994_a = Math.min(amount + stackIn.field_77994_a, this.func_70297_j_());
                    stackIn.func_77979_a(this.items[index].field_77994_a - amount);
                }
                if (stackIn.field_77994_a > 0) continue;
                player.func_184611_a(hand, null);
                break;
            }
        } else {
            for (int index = this.func_70302_i_() - 1; index >= 0; --index) {
                if (this.items[index] == null) continue;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.items[index]);
                this.items[index] = null;
                break;
            }
        }
        this.func_70296_d();
    }

    protected void setMoveOverItems(int index) {
        if (this.items[index] == null) {
            for (int i = index; i < this.items.length - 1; ++i) {
                this.items[i] = this.items[i + 1];
            }
            this.items[this.items.length - 1] = null;
        }
    }

    private void sendPacket() {
        if (!this.func_145831_w().field_72995_K) {
            for (EntityPlayer player : this.func_145831_w().field_73010_i) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendPacket();
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagList tags = compound.func_74764_b("Items") ? (NBTTagList)compound.func_74781_a("Items") : new NBTTagList();
        ItemStack[] items = new ItemStack[this.items.length];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            int slot;
            NBTTagCompound tagCompound = tags.func_150305_b(i);
            int n = slot = tagCompound.func_74764_b("Slot") ? (int)tagCompound.func_74771_c("Slot") : -999;
            if (slot < 0 || slot >= items.length) continue;
            items[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.items = items;
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)this.items[i].func_77955_b(tagCompound));
        }
        compound.func_82580_o("Items");
        compound.func_74782_a("Items", (NBTBase)tagList);
        return super.func_189515_b(compound);
    }

    public String func_70005_c_() {
        return "InventoryPotpourri";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.items[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.items, (int)index, (int)count);
        if (itemstack != null) {
            this.setMoveOverItems(index);
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        if ((index < 0 || index >= this.items.length) && this.items[index] != null) {
            ItemStack itemstack = this.items[index];
            this.items[index] = null;
            this.setMoveOverItems(index);
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (this.items[index] != null && stack != null) {
            if (this.canCombine(index, stack) && stack.field_77994_a != 1) {
                this.items[index] = stack;
                this.func_70296_d();
            } else if (this.items[this.items.length - 1] == null) {
                for (int i = this.items.length - 1; i > index; --i) {
                    this.items[i] = this.items[i - 1];
                }
                this.items[index] = stack;
                this.func_70296_d();
            }
        } else if (stack != null) {
            this.items[index] = stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return this.STACKLIMIT;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && this.isWhiteList(stack.func_77973_b());
    }

    protected abstract boolean isWhiteList(Item var1);

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] i = new int[this.items.length];
        for (int j = 0; j < i.length; ++j) {
            i[j] = j;
        }
        return i;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.items[index] == null || this.canCombine(index, itemStackIn) && this.items[index].field_77994_a + itemStackIn.field_77994_a <= this.func_70297_j_();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    private boolean canCombine(int index, ItemStack stack) {
        ItemStack itemStack1 = this.items[index].func_77946_l();
        itemStack1.field_77994_a = 1;
        ItemStack itemStack2 = stack.func_77946_l();
        itemStack2.field_77994_a = 1;
        return itemStack1.func_77969_a(itemStack2);
    }
}

