/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.world.biome;

import com.hosta.Floricraft.config.ConfigChecker;
import com.hosta.Floricraft.world.biome.BiomeBasic;
import com.hosta.Floricraft.world.biome.BiomeFlowerLand;
import com.hosta.Floricraft.world.gen.feature.WorldGenSimpleRoad;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeBasicWithPath
extends BiomeBasic {
    HashMap<BlockPos, int[]> hightMap = new HashMap();

    public BiomeBasicWithPath(Biome.BiomeProperties properties) {
        super(properties.func_185398_c(0.125f).func_185400_d(0.0f));
        this.field_76760_I.field_76808_K = false;
        this.field_76760_I.field_76806_I = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76832_z = -999;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        super.func_180622_a(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
        int x1 = x % 16;
        x1 = x1 < 0 ? x1 + 16 : x1;
        int z1 = z % 16;
        z1 = z1 < 0 ? z1 + 16 : z1;
        int y1 = 255;
        while (y1 > 0 && chunkPrimerIn.func_177856_a(x1, --y1, z1).func_185904_a() == Material.field_151579_a) {
        }
        BlockPos chunkPos = new BlockPos(x - x1, 0, z - z1);
        int[] hight = this.hightMap.containsKey(chunkPos) ? this.hightMap.get(chunkPos) : new int[256];
        hight[x1 + z1 * 16] = y1;
        this.hightMap.put(chunkPos, hight);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        int[] hight = new int[256];
        if (this.hightMap.containsKey(pos)) {
            hight = this.hightMap.get(pos);
            this.hightMap.remove(pos);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int top = hight[x + z * 16];
                    BlockPos fillerPos = new BlockPos(pos.func_177958_n() + x, top, pos.func_177952_p() + z);
                    while (fillerPos.func_177956_o() > 0 && worldIn.func_175623_d(fillerPos)) {
                        worldIn.func_175656_a(fillerPos, fillerPos.func_177956_o() == top ? this.field_76752_A : this.field_76753_B);
                        fillerPos = fillerPos.func_177977_b();
                    }
                }
            }
        }
        if (ConfigChecker.getGenBiomeFast().booleanValue()) {
            BiomeBasicWithPath.genPath(worldIn, pos.func_177958_n(), pos.func_177952_p());
        }
    }

    public static void genPath(World world, int posX, int posZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos topPos = new BlockPos(posX + x, 0, posZ + z);
                Biome biome = world.func_180494_b(topPos);
                if (!(biome instanceof BiomeBasicWithPath)) continue;
                WorldGenSimpleRoad[] simpleRoads = new WorldGenSimpleRoad[]{new WorldGenSimpleRoad(2.0f, 5.0f, 5.0f, 300), new WorldGenSimpleRoad(-0.5f, 50.0f, 50.0f, 200)};
                topPos = world.func_175672_r(topPos);
                boolean pathFlag = false;
                for (WorldGenSimpleRoad simpleRoad : simpleRoads) {
                    simpleRoad.setSegment(topPos.func_177958_n());
                    if (!simpleRoad.isOnRoad(topPos.func_177952_p())) continue;
                    pathFlag = true;
                }
                if (pathFlag) {
                    boolean genFlag = false;
                    topPos = topPos.func_177977_b();
                    if (!genFlag) {
                        for (WorldGenSimpleRoad simpleRoad : simpleRoads) {
                            genFlag = simpleRoad.genPath(world, topPos);
                        }
                    }
                    if (!genFlag) {
                        for (WorldGenSimpleRoad simpleRoad : simpleRoads) {
                            genFlag = simpleRoad.genGrass(world, topPos);
                        }
                    }
                    if (!genFlag) {
                        for (WorldGenSimpleRoad simpleRoad : simpleRoads) {
                            genFlag = simpleRoad.genWaterway(world, topPos);
                        }
                    }
                    if (genFlag || z % 16 == 0) continue;
                    for (WorldGenSimpleRoad simpleRoad : simpleRoads) {
                        genFlag = simpleRoad.genFence(world, topPos);
                    }
                    continue;
                }
                if (!(biome instanceof BiomeFlowerLand) || x % 4 == 0 || z % 16 == 0) continue;
                BiomeFlowerLand biomeFarmer = (BiomeFlowerLand)biome;
                if (world.func_180495_p(topPos.func_177977_b()).func_177230_c() != biomeFarmer.farmLand.func_177230_c() || !world.func_175623_d(topPos)) continue;
                int i = topPos.func_177958_n() / 4 % biomeFarmer.crops.length;
                i = i < 0 ? i + biomeFarmer.crops.length : i;
                world.func_175656_a(topPos, biomeFarmer.crops[i]);
                if (!(biomeFarmer.crops[i].func_177230_c() instanceof BlockDoublePlant)) continue;
                world.func_175656_a(topPos.func_177984_a(), biomeFarmer.crops[i].func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER));
            }
        }
    }
}

