/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.world.gen.feature;

import com.hosta.Floricraft.helper.DateHelper;
import com.hosta.Floricraft.init.FloricraftInit;
import com.hosta.Floricraft.world.gen.feature.WorldGenTreeBasic;
import java.util.Random;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenTreeChristmas
extends WorldGenTreeBasic {
    private final IBlockState LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
    private IBlockState leaves;
    private IBlockState leaves2;
    private int hight;
    private int range = 0;

    public WorldGenTreeChristmas(boolean notify, Random rand, IBlockState leaves, IBlockState leaves2, int hight) {
        this(notify, rand, leaves, leaves2);
        this.hight = hight;
    }

    public WorldGenTreeChristmas(boolean notify, Random rand, IBlockState leaves, IBlockState leaves2) {
        this(notify, rand);
        this.leaves = leaves;
        this.leaves2 = leaves2;
    }

    private WorldGenTreeChristmas(boolean notify, Random rand) {
        super(notify);
        if (!DateHelper.isChristmas()) {
            if (rand.nextBoolean()) {
                this.hight = 7;
            } else if (rand.nextBoolean()) {
                this.hight = rand.nextBoolean() ? 8 : 6;
            } else if (rand.nextBoolean()) {
                this.hight = 4;
            } else if (rand.nextBoolean()) {
                this.hight = 11;
                this.range = 1;
            } else {
                this.hight = 12;
                this.range = 1;
            }
        } else if (rand.nextBoolean()) {
            this.hight = 12;
            this.range = 1;
        } else if (rand.nextBoolean()) {
            if (rand.nextBoolean()) {
                this.hight = 7;
            } else {
                this.hight = 11;
                this.range = 1;
            }
        } else {
            this.hight = rand.nextBoolean() ? 8 : (rand.nextBoolean() ? 6 : 4);
        }
    }

    @Override
    public boolean canGrow(World worldIn, Random rand, BlockPos position) {
        BlockPos posMax;
        BlockPos posMin = position.func_177982_a(-this.range, 1, -this.range);
        return this.areReplaceable(worldIn, posMin, posMax = position.func_177982_a(this.range, this.hight, this.range)) && position.func_177956_o() + this.hight < 255;
    }

    @Override
    public void generateTree(World worldIn, Random rand, BlockPos position) {
        int i;
        for (i = 0; i < this.hight; ++i) {
            this.func_175903_a(worldIn, position.func_177981_b(i), this.LOG);
        }
        switch (this.hight) {
            case 4: {
                this.setLeaves(worldIn, position.func_177981_b(1), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight), this.leaves);
                break;
            }
            case 6: {
                this.setLeaves(worldIn, position.func_177981_b(1), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(4), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(5), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(6), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight + 1), this.leaves);
                break;
            }
            case 7: {
                this.setLeaves(worldIn, position.func_177981_b(1), this.leaves2, 3, true);
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(4), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(5), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(6), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight), this.leaves);
                break;
            }
            case 8: {
                this.setLeaves(worldIn, position.func_177981_b(1), this.leaves2, 3, true);
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(4), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(5), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(6), this.leaves2, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(7), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight), this.leaves);
                break;
            }
            case 11: {
                for (i = 0; i < 10; ++i) {
                    this.setLeaves(worldIn, position.func_177981_b(i), this.LOG, 1);
                }
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves2, 4, true);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves2, 3, false);
                this.setLeaves(worldIn, position.func_177981_b(4), this.leaves, 2);
                this.setLeaves(worldIn, position.func_177981_b(5), this.leaves2, 4, true);
                this.setLeaves(worldIn, position.func_177981_b(6), this.leaves2, 3, false);
                this.setLeaves(worldIn, position.func_177981_b(7), this.leaves, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(8), this.leaves2, 3, true);
                this.setLeaves(worldIn, position.func_177981_b(9), this.leaves, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(10), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(11), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight + 1), this.leaves);
                break;
            }
            case 12: {
                for (i = 0; i < 10; ++i) {
                    this.setLeaves(worldIn, position.func_177981_b(i), this.LOG, 1);
                }
                this.setLeaves(worldIn, position.func_177981_b(2), this.leaves2, 4, true);
                this.setLeaves(worldIn, position.func_177981_b(3), this.leaves2, 3, false);
                this.setLeaves(worldIn, position.func_177981_b(4), this.leaves, 3, true);
                this.setLeaves(worldIn, position.func_177981_b(5), this.leaves, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(6), this.leaves2, 3, false);
                this.setLeaves(worldIn, position.func_177981_b(7), this.leaves, 2);
                this.setLeaves(worldIn, position.func_177981_b(8), this.leaves2, 3, true);
                this.setLeaves(worldIn, position.func_177981_b(9), this.leaves, 2, false);
                this.setLeaves(worldIn, position.func_177981_b(10), this.leaves2, 2, true);
                this.setLeaves(worldIn, position.func_177981_b(11), this.leaves, 1);
                this.setLeaves(worldIn, position.func_177981_b(12), this.leaves, 1, false);
                this.setLeaves(worldIn, position.func_177981_b(this.hight + 1), this.leaves);
            }
        }
        if (DateHelper.isChristmas()) {
            switch (this.hight) {
                case 11: 
                case 12: {
                    for (i = 0; i < 4; ++i) {
                        int z;
                        int x = rand.nextInt(5) - 2;
                        if (x == (z = rand.nextInt(5) - 2) || x == -z) continue;
                        BlockPos pos = position.func_177964_d(x).func_177965_g(z);
                        this.setChest(worldIn, pos, rand);
                    }
                    break;
                }
            }
        }
    }

    public void setLeaves(World worldIn, BlockPos posIn, IBlockState state, int range, boolean nonCorner) {
        int[] min = new int[]{posIn.func_177958_n() - range, posIn.func_177952_p() - range};
        int[] max = new int[]{posIn.func_177958_n() + range, posIn.func_177952_p() + range};
        for (int i = min[0]; i <= max[0]; ++i) {
            for (int k = min[1]; k <= max[1]; ++k) {
                boolean flag = true;
                if (nonCorner) {
                    if (i == min[0] || i == max[0]) {
                        if (k == min[1] || k == max[1]) {
                            flag = false;
                        } else if (k == min[1] + 1 || k == max[1] - 1) {
                            flag = false;
                        }
                    }
                    if (!(i != min[0] + 1 && i != max[0] - 1 || k != min[1] && k != max[1])) {
                        flag = false;
                    }
                } else if (!(i != min[0] && i != max[0] || k != min[1] && k != max[1])) {
                    flag = false;
                }
                if (!flag) continue;
                BlockPos pos = new BlockPos(i, posIn.func_177956_o(), k);
                this.setLeaves(worldIn, pos, state);
            }
        }
    }

    public void setLeaves(World worldIn, BlockPos posIn, IBlockState state, int range) {
        int[] min = new int[]{posIn.func_177958_n() - range, posIn.func_177952_p() - range};
        int[] max = new int[]{posIn.func_177958_n() + range, posIn.func_177952_p() + range};
        for (int i = min[0]; i <= max[0]; ++i) {
            for (int k = min[1]; k <= max[1]; ++k) {
                BlockPos pos = new BlockPos(i, posIn.func_177956_o(), k);
                this.setLeaves(worldIn, pos, state);
            }
        }
    }

    public boolean setLeaves(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isReplaceable(worldIn, pos) && worldIn.func_180495_p(pos) != this.LOG) {
            this.func_175903_a(worldIn, pos, state);
            return true;
        }
        return false;
    }

    public void setChest(World worldIn, BlockPos pos, Random rand) {
        TileEntity tileEntity;
        if (this.checkChest(worldIn, pos) && this.setLeaves(worldIn, pos, Blocks.field_150486_ae.func_176458_f(worldIn, pos, Blocks.field_150486_ae.func_176223_P())) && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tileEntity;
            chest.func_145976_a("Christmas Present");
            int i = rand.nextInt(5);
            switch (i) {
                case 0: {
                    chest.func_189404_a(LootTableList.field_186422_d, rand.nextLong());
                    break;
                }
                case 1: {
                    chest.func_189404_a(LootTableList.field_186431_m, rand.nextLong());
                    break;
                }
                case 2: {
                    chest.func_189404_a(LootTableList.field_186425_g, rand.nextLong());
                    break;
                }
                case 3: {
                    chest.func_189404_a(LootTableList.field_186421_c, rand.nextLong());
                    break;
                }
                case 4: {
                    chest.func_189404_a(LootTableList.field_186423_e, rand.nextLong());
                }
            }
            for (int j = 0; j < chest.func_70302_i_(); ++j) {
                if (!rand.nextBoolean() || !rand.nextBoolean()) continue;
                int k = rand.nextInt(11);
                ItemStack stack = null;
                switch (k) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        stack = new ItemStack(FloricraftInit.ORNAMENT_CHRISTMAS, rand.nextInt(2) + 1, k);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        if (rand.nextBoolean() && rand.nextBoolean()) {
                            stack = new ItemStack(FloricraftInit.SAPLING_CHRISTMAS, 1, k - 4);
                            break;
                        }
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        stack = new ItemStack(FloricraftInit.CONFECTION_EVENT, rand.nextInt(2) + 1, k - 7);
                        break;
                    }
                    case 10: {
                        stack = new ItemStack(Items.field_151105_aU, 1);
                    }
                }
                if (stack == null) continue;
                chest.func_70299_a(j, stack);
            }
        }
    }

    public boolean checkChest(World worldIn, BlockPos posIn) {
        for (int i = 0; i < 4; ++i) {
            BlockPos pos = null;
            switch (i) {
                case 0: {
                    pos = posIn.func_177978_c();
                    break;
                }
                case 1: {
                    pos = posIn.func_177968_d();
                    break;
                }
                case 2: {
                    pos = posIn.func_177974_f();
                    break;
                }
                case 3: {
                    pos = posIn.func_177976_e();
                }
            }
            if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150486_ae) continue;
            return false;
        }
        return true;
    }
}

