/*
 * Decompiled with CFR 0.152.
 */
package com.hosta.Floricraft.helper;

import com.hosta.Floricraft.config.ConfigChecker;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class WindHelper {
    static final int FUNC_NORTH = 8168;
    static final int FUNC_WEST = 10681;
    static final int FUNC_TICK = 87242408;
    static int worldTick;
    static double windNorth;
    static double windWest;
    static double windDown;

    public static double[] getWind(World worldIn) {
        double[] dArray;
        if (ConfigChecker.isWindEnabled().booleanValue()) {
            dArray = WindHelper.getWind(WindHelper.getWorldTick(worldIn));
        } else {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        }
        return dArray;
    }

    public static double getWindNorth(World worldIn) {
        return ConfigChecker.isWindEnabled() != false ? WindHelper.getWindNorth(WindHelper.getWorldTick(worldIn)) : 0.0;
    }

    public static double getWindWest(World worldIn) {
        return ConfigChecker.isWindEnabled() != false ? WindHelper.getWindWest(WindHelper.getWorldTick(worldIn)) : 0.0;
    }

    public static double getAngle(World worldIn) {
        return ConfigChecker.isWindEnabled() != false ? WindHelper.getAngle(WindHelper.getWorldTick(worldIn)) : 0.0;
    }

    private static double[] getWind(int worldTick) {
        WindHelper.setWind(worldTick);
        return new double[]{windWest, windDown, windNorth};
    }

    private static double getWindNorth(int worldTick) {
        WindHelper.setWind(worldTick);
        return windNorth;
    }

    private static double getWindWest(int worldTick) {
        WindHelper.setWind(worldTick);
        return windWest;
    }

    private static double getAngle(int worldTick) {
        WindHelper.setWind(worldTick);
        return WindHelper.getAngle();
    }

    private static double getAngle() {
        return windWest <= 0.0 ? Math.acos(WindHelper.getCos()) : 6.2831853 - Math.acos(WindHelper.getCos());
    }

    private static double getCos() {
        return windNorth / WindHelper.getRadius();
    }

    private static double getRadius() {
        return Math.sqrt(windNorth * windNorth + windWest * windWest);
    }

    private static int getWorldTick(World worldIn) {
        return (int)(worldIn.func_82737_E() % 87242408L);
    }

    private static void setWind(int worldTick) {
        if (worldTick != WindHelper.worldTick) {
            WindHelper.worldTick = worldTick;
            WindHelper.setWindNorth(worldTick);
            WindHelper.setWindWest(worldTick);
        }
    }

    private static void setWindNorth(int worldTick) {
        windNorth = WindHelper.functionWindNorth(worldTick);
    }

    private static void setWindWest(int worldTick) {
        windWest = WindHelper.functionWindWest(worldTick);
    }

    private static double functionWindNorth(int x) {
        float rareX = (float)(x % 8168) / 1300.0f;
        double funcX = MathHelper.func_76134_b((float)rareX) + MathHelper.func_76134_b((float)(rareX * 2.0f)) + MathHelper.func_76134_b((float)(rareX * 5.0f));
        return funcX / 20.0;
    }

    private static double functionWindWest(int x) {
        float rareX = (float)(x % 10681) / 1700.0f;
        double funcX = MathHelper.func_76134_b((float)rareX) + MathHelper.func_76134_b((float)(rareX * 2.0f)) + MathHelper.func_76134_b((float)(rareX * 5.0f));
        return funcX / 20.0;
    }

    static {
        windDown = 0.0;
    }
}

