--CIVILIZATION_AZTEC
--------------------------------------------------------------
-- LeaderTraits
--------------------------------------------------------------
INSERT OR REPLACE INTO LeaderTraits(LeaderType, TraitType) 	   
SELECT 'LEADER_MONTEZUMA', 'TRAIT_LEADER_AGGRESSIVE_MILITARY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_AZTEC_EAGLE_WARRIOR');
--------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_LEGEND_FIVE_SUNS', 'GOLDEN_TRAIT_KILL_SCIENCE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_AZTEC_EAGLE_WARRIOR');
INSERT OR REPLACE INTO TraitModifiers (TraitType,						ModifierId)
SELECT	'TRAIT_LEADER_GIFTS_FOR_TLATOANI',		'GOLDEN_TRAIT_LUXURY' ||ResourceType
FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
--------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_KILL_SCIENCE', 'MODIFIER_PLAYER_UNITS_ADJUST_POST_COMBAT_YIELD', NULL WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_AZTEC_EAGLE_WARRIOR');
INSERT OR REPLACE INTO Modifiers (ModifierId,										ModifierType,												SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_LUXURY' ||ResourceType,	'MODIFIER_PLAYER_ADJUST_PLOT_YIELD',						'GOLDEN_AZTEC_PLOT_HAS_' ||ResourceType
FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
--------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_KILL_SCIENCE', 'YieldType', 'YIELD_SCIENCE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_AZTEC_EAGLE_WARRIOR');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_KILL_SCIENCE', 'PercentDefeatedStrength', 50 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_AZTEC_EAGLE_WARRIOR');
INSERT OR REPLACE INTO ModifierArguments (ModifierId,												Name,			Value)
SELECT	'GOLDEN_TRAIT_LUXURY' ||ResourceType,	'YieldType',	'YIELD_GOLD'
FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
INSERT OR REPLACE INTO ModifierArguments (ModifierId,												Name,			Value)
SELECT	'GOLDEN_TRAIT_LUXURY' ||ResourceType,	'Amount',		2
FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
---------------------------------------------------------------------------------------------------------------
-- RequirementSets
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_AZTEC_PLOT_HAS_' ||ResourceType,	'REQUIREMENTSET_TEST_ALL' FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
---------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'GOLDEN_AZTEC_PLOT_HAS_' ||ResourceType,	'GOLDEN_REQUIRES_AZTEC_PLOT_HAS_' ||ResourceType FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
---------------------------------------------------------------------------------------------------------------
-- Requirements
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO Requirements (RequirementId,									RequirementType)
SELECT	'GOLDEN_REQUIRES_AZTEC_PLOT_HAS_' ||ResourceType,	'REQUIREMENT_PLOT_RESOURCE_TYPE_MATCHES' FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');
---------------------------------------------------------------------------------------------------------------
-- RequirementArguments
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementArguments (RequirementId,									Name,			Value)
SELECT	'GOLDEN_REQUIRES_AZTEC_PLOT_HAS_' ||ResourceType,	'ResourceType',	ResourceType FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_AZTEC_EAGLE_WARRIOR');