--------------------------------------------------------------
-- LeaderTraits
--------------------------------------------------------------
INSERT OR REPLACE INTO LeaderTraits(LeaderType, TraitType) 	   
SELECT 'LEADER_JAYAVARMAN', 'TRAIT_LEADER_RELIGIOUS_MAJOR_CIV' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO LeaderTraits(LeaderType, TraitType) 	   
SELECT 'LEADER_GITARJA', 'TRAIT_LEADER_RELIGIOUS_MAJOR_CIV' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');	
--------------------------------------------------------------
-- StartBiasTerrains
--------------------------------------------------------------
UPDATE StartBiasTerrains SET Tier = 3
WHERE CivilizationType = 'CIVILIZATION_KHMER' AND TerrainType = 'TERRAIN_COAST' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
--------------------------------------------------------------
-- ExcludedAdjacencies
--------------------------------------------------------------
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Science', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Faith', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Gold', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Culture', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Production', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'District_Food', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Culture', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Faith', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Gold', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Production', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Science', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ExcludedAdjacencies(YieldChangeId, TraitType) 	   
SELECT 'CITY_CENTER_Food', 'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
--------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA', 'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA', 'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
-- SELECT	'TRAIT_CIVILIZATION_INDONESIA_NUSANTARA', 'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
DELETE FROM TraitModifiers WHERE ModifierId = 'TRAIT_AQUEDUCT_AMENITY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
DELETE FROM TraitModifiers WHERE ModifierId = 'TRAIT_AQUEDUCT_FAITH' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_HOLYSITE_AMENITY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_LAKE_FAITH_MODIFIER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_LAKE_GOLD_MODIFIER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_LAKE_PRODUCTION_MODIFIER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_FARM_AQUEDUCT_ADJECENCY_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_KHMER_BARAYS', 'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_LEADER_EXALTED_GODDESS', 'GOLDEN_TRAIT_INDONESIA_PURCHASE_CIVILIAN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_LEADER_EXALTED_GODDESS', 'GOLDEN_TRAIT_INDONESIA_GOLD_CITY_CENTER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO TraitModifiers		(TraitType, ModifierId)
SELECT	'TRAIT_LEADER_EXALTED_GODDESS', 'GOLDEN_TRAIT_INDONESIA_FISHERY_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
--------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'MODIFIER_PLAYER_CITIES_TERRAIN_ADJACENCY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'MODIFIER_PLAYER_CITIES_TERRAIN_ADJACENCY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'MODIFIER_PLAYER_CITIES_TERRAIN_ADJACENCY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_HOLYSITE_AMENITY', 'MODIFIER_PLAYER_DISTRICTS_ADJUST_EXTRA_ENTERTAINMENT', 'PLOT_IS_HOLY_SITE_RIVER_FOOD_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_LAKE_FAITH_MODIFIER', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'GOLDEN_PLOT_IS_LAKE_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_LAKE_GOLD_MODIFIER', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'GOLDEN_PLOT_IS_LAKE_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_LAKE_PRODUCTION_MODIFIER', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'GOLDEN_PLOT_IS_LAKE_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_FARM_AQUEDUCT_ADJECENCY_PRODUCTION', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'PLOT_IS_FARM_AQUEDUCT_ADJACENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_FOOD', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'PLOT_IS_FARM_CANAL_ADJACENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_PRODUCTION', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'PLOT_IS_FARM_CANAL_ADJACENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers	(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_FOOD', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'PLOT_IS_FARM_DAM_ADJACENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_PRODUCTION', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'PLOT_IS_FARM_DAM_ADJACENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_INDONESIA_PURCHASE_CIVILIAN', 'MODIFIER_PLAYER_CITIES_ENABLE_UNIT_FAITH_PURCHASE', NULL WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_INDONESIA_GOLD_CITY_CENTER', 'MODIFIER_PLAYER_DISTRICTS_ADJUST_YIELD_CHANGE', 'PLOT_IS_ADJACENT_COAST_CITY_CENTER_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO Modifiers		(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_INDONESIA_FISHERY_PRODUCTION', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD', 'GOLDEN_PLOT_HAS_IMPROVEMENT_FISHERY_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');

--------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'DistrictType', 'DISTRICT_COMMERCIAL_HUB' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'TerrainType', 'TERRAIN_COAST' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_COMMERCIAL_HUB_ADJACENCYGOLD', 'Description', 'LOC_DISTRICT_NUSANTARA_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'DistrictType', 'DISTRICT_HARBOR' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'TerrainType', 'TERRAIN_COAST' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_HARBOR_ADJACENCYGOLD', 'Description', 'LOC_DISTRICT_NUSANTARA_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'DistrictType', 'DISTRICT_ENCAMPMENT' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'TerrainType', 'TERRAIN_COAST' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'YieldType', 'YIELD_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
-- INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
-- SELECT	'GOLDEN_TRAIT_INDONESIA_NUSANTARA_ENCAMPMENT_ADJACENCYFOOD', 'Description', 'LOC_DISTRICT_NUSANTARA_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'TRAIT_NUSANTARA_COAST_HOLY_SITE' AND Name = 'TilesRequired' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'TRAIT_NUSANTARA_COAST_CAMPUS' AND Name = 'TilesRequired' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'TRAIT_NUSANTARA_COAST_INDUSTRIAL_ZONE' AND Name = 'TilesRequired' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'TRAIT_NUSANTARA_COAST_THEATER' AND Name = 'TilesRequired' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 5
WHERE ModifierId = 'TRAIT_HOLY_SITE_RIVER_FOOD' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 3
WHERE ModifierId = 'TRAIT_HOLY_SITE_RIVER_HOUSING' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 1
WHERE ModifierId = 'TRAIT_FARM_AQUEDUCT_ADJECENCY_FOOD' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_HOLYSITE_AMENITY', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_FAITH_MODIFIER', 'Amount', 2 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_FAITH_MODIFIER', 'YieldType', 'YIELD_FAITH' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_GOLD_MODIFIER', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_GOLD_MODIFIER', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_PRODUCTION_MODIFIER', 'Amount', 2 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_LAKE_PRODUCTION_MODIFIER', 'YieldType', 'YIELD_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_AQUEDUCT_ADJECENCY_PRODUCTION', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_AQUEDUCT_ADJECENCY_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_FOOD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_FOOD', 'YieldType', 'YIELD_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_PRODUCTION', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_CANAL_ADJECENCY_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_FOOD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_FOOD', 'YieldType', 'YIELD_FOOD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_PRODUCTION', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_FARM_DAM_ADJECENCY_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_PURCHASE_CIVILIAN', 'Tag', 'CLASS_LANDCIVILIAN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_GOLD_CITY_CENTER', 'Amount', 5 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_GOLD_CITY_CENTER', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
UPDATE ModifierArguments SET Value = 5
WHERE ModifierId = 'TRAIT_FAITH_CITY_CENTER' AND Name = 'Amount' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_FISHERY_PRODUCTION', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO ModifierArguments		(ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_INDONESIA_FISHERY_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
---------------------------------------------------------------------------------------------------------------
-- RequirementSets
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'PLOT_IS_FARM_CANAL_ADJACENT_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'PLOT_IS_FARM_DAM_ADJACENT_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
---------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'PLOT_IS_FARM_CANAL_ADJACENT_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_DISTRICT_CANAL' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'PLOT_IS_FARM_CANAL_ADJACENT_REQUIREMENTS',	'REQUIRES_PLOT_HAS_FARM' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'PLOT_IS_FARM_DAM_ADJACENT_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_DISTRICT_DAM' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'PLOT_IS_FARM_DAM_ADJACENT_REQUIREMENTS',	'REQUIRES_PLOT_HAS_FARM' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_INDONESIAN_JONG');