--------------------------------------------------------------
-- Buildings
--------------------------------------------------------------
UPDATE Buildings SET Description = 'DLC_LOC_BUILDING_WATER_MILL_DESCRIPTION'
WHERE BuildingType = 'BUILDING_WATER_MILL' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- Resource_YieldChanges
--------------------------------------------------------------
UPDATE Resource_YieldChanges SET YieldType = 'YIELD_FOOD', YieldChange = 1
WHERE ResourceType = 'RESOURCE_MAIZE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
UPDATE Resource_YieldChanges SET YieldType = 'YIELD_SCIENCE', YieldChange = 1
WHERE ResourceType = 'RESOURCE_HONEY' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- Resource_Harvests
--------------------------------------------------------------
UPDATE Resource_Harvests SET YieldType = 'YIELD_FOOD', Amount = 20
WHERE ResourceType = 'RESOURCE_MAIZE' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- BuildingModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO BuildingModifiers(BuildingType, ModifierId)
SELECT	'BUILDING_FOOD_MARKET', 'WATERMILL_ADDMAIZEYIELD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');

--------------------------------------------------------------
-- ImprovementModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO ImprovementModifiers (ImprovementType, ModifierId)
SELECT	'IMPROVEMENT_PLANTATION', 'FARM_HOUSING_WITH_MAYAB_TRAIT' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_MAYAB', 'GOLDEN_TRAIT_MAYAB_MONUMENT_BUILDER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_MAYAB', 'GOLDEN_TRAIT_MAYA_PLANTATION_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
-- DELETE FROM TraitModifiers WHERE ModifierId = 'TRAIT_LEADER_NEARBY_CITIES_GAIN_YIELDS' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
DELETE FROM TraitModifiers WHERE ModifierId = 'TRAIT_LEADER_NEARBY_CITIES_LOSE_YIELDS' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_LEADER_MUTAL', 'GOLDEN_TRAIT_MUTAL_DEBUFF' || YieldType FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_EJERCITO_PATRIOTA', 'GOLDEN_TRAIT_PATRIOTA_GOLDEN_IDENTITY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_EJERCITO_PATRIOTA', 'GOLDEN_TRAIT_PATRIOTA_DARK_IDENTITY' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_EJERCITO_PATRIOTA', 'GOLDEN_TRAIT_PATRIOTA_LIBERATION'|| YieldType FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO TraitModifiers (TraitType, ModifierId)
SELECT	'TRAIT_CIVILIZATION_EJERCITO_PATRIOTA', 'GOLDEN_TRAIT_PATRIOTA_KILL_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_MAYAB_MONUMENT_BUILDER', 'MODIFIER_PLAYER_BUILT_CITIES_GRANT_FREE_UNIT', 0, 0, 'GOLDEN_CITY_HAS_BUILDING_MONUMENT_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_MAYA_PLANTATION_GOLD', 'MODIFIER_PLAYER_ADJUST_PLOT_YIELD_GRANCOLOMBIA_MAYA', 0, 0, 'GOLDEN_PLOT_HAS_IMPROVEMENT_PLANTATION_REQUIREMENTS' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_MUTAL_DEBUFF' || YieldType,	'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER', 'OBJECT_IS_7_OR_MORE_TILES_FROM_CAPITAL_REQUIREMENTS' FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');	
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_PATRIOTA_GOLDEN_IDENTITY', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN', 0, 0, 'PLAYER_HAS_GOLDEN_AGE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_PATRIOTA_DARK_IDENTITY', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN', 0, 0, 'PLAYER_HAS_DARK_AGE' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_PATRIOTA_LIBERATION' || YieldType,	'MODIFIER_PLAYER_ADD_DIPLOMATIC_YIELD_MODIFIER', NULL FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');	
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_PATRIOTA_KILL_GOLD', 'MODIFIER_PLAYER_UNITS_ADJUST_POST_COMBAT_YIELD', 0, 0, NULL WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MAYAB_MONUMENT_BUILDER', 'UnitType', 'UNIT_BUILDER' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MAYAB_MONUMENT_BUILDER', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MAYA_PLANTATION_GOLD', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MAYA_PLANTATION_GOLD', 'Amount', 1 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MUTAL_DEBUFF' || YieldType,	'YieldType', YieldType FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');			
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_MUTAL_DEBUFF' || YieldType,	'Amount', -10 FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');	
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_GOLDEN_IDENTITY', 'Amount', -0.25 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_DARK_IDENTITY', 'Amount', 0.25 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_LIBERATION' || YieldType,	'YieldType', YieldType FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');			
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_LIBERATION' || YieldType,	'Amount', 50 FROM Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');	
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_LIBERATION' || YieldType,	'DiplomaticYieldSource', 'LIBERATION' FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');			
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_LIBERATION' || YieldType,	'TurnsActive', 10 FROM	Yields WHERE YieldType IN ('YIELD_FOOD', 'YIELD_PRODUCTION', 'YIELD_GOLD', 'YIELD_SCIENCE', 'YIELD_CULTURE', 'YIELD_FAITH') AND EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');			
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_KILL_GOLD', 'YieldType', 'YIELD_GOLD' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_TRAIT_PATRIOTA_KILL_GOLD', 'PercentDefeatedStrength', 50 WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_MAYAN_HULCHE');
--------------------------------------------------------------
-- RequirementArguments
--------------------------------------------------------------
UPDATE RequirementArguments SET Value = 9
WHERE RequirementId = 'REQUIRES_OBJECT_7_OR_MORE_TILES_FROM_CAPITAL' AND Name = 'MinDistance' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
UPDATE RequirementArguments SET Value = 8
WHERE RequirementId = 'REQUIRES_OBJECT_6_TILES_FROM_CAPITAL_NOT_CAPITAL' AND Name = 'MaxDistance' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
UPDATE RequirementArguments SET Value = 8
WHERE RequirementId = 'REQUIRES_OBJECT_6_TILES_FROM_CAPITAL' AND Name = 'MaxDistance' AND EXISTS (SELECT UnitType FROM Units WHERE UnitType='UNIT_MAYAN_HULCHE');
