--------------------------------------------------------------
--允许在森林与雨林上建造奇观
--------------------------------------------------------------
-- INSERT OR REPLACE INTO Building_ValidFeatures(BuildingType, FeatureType)
-- SELECT BuildingType, 'FEATURE_JUNGLE' FROM Buildings
-- WHERE IsWonder = 1 AND BuildingType NOT IN (SELECT BuildingType FROM Building_RequiredFeatures WHERE FeatureType = 'FEATURE_JUNGLE');
-- INSERT OR REPLACE INTO Building_ValidFeatures(BuildingType, FeatureType)
-- SELECT BuildingType, 'FEATURE_FOREST' FROM Buildings 
-- WHERE IsWonder = 1 AND BuildingType NOT IN (SELECT BuildingType FROM Building_RequiredFeatures WHERE FeatureType = 'FEATURE_FOREST');		
--------------------------------------------------------------
--允许在森林与雨林上建造区域
--------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT 'MODIFIER_DISTRICT_JUNGLE_ALLOW_' || DistrictType, 'MODIFIER_PLAYER_CITIES_ADJUST_VALID_FEATURES_DISTRICTS', 'GOLDEN_PLAYER_HAS_CIVIC_NATURAL_HISTORY_REQUIREMENTS' FROM Districts;
INSERT OR REPLACE INTO ModifierArguments(ModifierId, Name, Value)
SELECT 'MODIFIER_DISTRICT_JUNGLE_ALLOW_' || DistrictType, 'DistrictType', DistrictType FROM Districts;
INSERT OR REPLACE INTO ModifierArguments(ModifierId, Name, Value)
SELECT 'MODIFIER_DISTRICT_JUNGLE_ALLOW_' || DistrictType, 'FeatureType', 'FEATURE_JUNGLE' FROM Districts;
INSERT OR REPLACE INTO Traits(TraitType) 
VALUES('TRAIT_DISTRICT_JUNGLE');
INSERT OR REPLACE INTO Types(Type, Kind) 
VALUES('TRAIT_DISTRICT_JUNGLE', 'KIND_TRAIT');
INSERT OR REPLACE INTO TraitModifiers(TraitType, ModifierId)
SELECT 'TRAIT_DISTRICT_JUNGLE', 'MODIFIER_DISTRICT_JUNGLE_ALLOW_' || DistrictType FROM Districts;
INSERT OR REPLACE INTO CivilizationTraits(CivilizationType, TraitType)
SELECT CivilizationType, 'TRAIT_DISTRICT_JUNGLE' FROM Civilizations;
INSERT OR REPLACE INTO Modifiers(ModifierId, ModifierType, SubjectRequirementSetId)
SELECT 'MODIFIER_DISTRICT_FOREST_ALLOW_' || DistrictType, 'MODIFIER_PLAYER_CITIES_ADJUST_VALID_FEATURES_DISTRICTS', 'GOLDEN_PLAYER_HAS_CIVIC_NATURAL_HISTORY_REQUIREMENTS' FROM Districts;
INSERT OR REPLACE INTO ModifierArguments(ModifierId, Name, Value)
SELECT 'MODIFIER_DISTRICT_FOREST_ALLOW_' || DistrictType, 'DistrictType', DistrictType FROM Districts;
INSERT OR REPLACE INTO ModifierArguments(ModifierId, Name, Value)
SELECT 'MODIFIER_DISTRICT_FOREST_ALLOW_' || DistrictType, 'FeatureType', 'FEATURE_FOREST' FROM Districts;
INSERT OR REPLACE INTO Traits(TraitType) 
VALUES('TRAIT_DISTRICT_FOREST');
INSERT OR REPLACE INTO Types(Type, Kind) 
VALUES('TRAIT_DISTRICT_FOREST', 'KIND_TRAIT');
INSERT OR REPLACE INTO TraitModifiers(TraitType, ModifierId)
SELECT 'TRAIT_DISTRICT_FOREST', 'MODIFIER_DISTRICT_FOREST_ALLOW_' || DistrictType FROM Districts;
INSERT OR REPLACE INTO CivilizationTraits(CivilizationType, TraitType)
SELECT CivilizationType, 'TRAIT_DISTRICT_FOREST' FROM Civilizations;
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_INDUSTRIAL_ZONE';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_INDUSTRIAL_ZONE';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_HANSA';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_HANSA';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_ENCAMPMENT';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_ENCAMPMENT';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_IKANDA';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_IKANDA';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_SPACEPORT';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_SPACEPORT';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_FOREST_ALLOW_DISTRICT_AERODROME';
DELETE FROM TraitModifiers WHERE ModifierId='MODIFIER_DISTRICT_JUNGLE_ALLOW_DISTRICT_AERODROME';
--------------------------------------------------------------
-- 魅力值调整
--------------------------------------------------------------
-- UPDATE Features		SET Appeal = 1	WHERE FeatureType = 'FEATURE_FOREST';
-- UPDATE Features		SET Appeal = -1	WHERE FeatureType = 'FEATURE_JUNGLE';
UPDATE Features		SET Appeal = 1	WHERE FeatureType = 'FEATURE_REEF';
-- UPDATE Features		SET Appeal = -1	WHERE FeatureType = 'FEATURE_FLOODPLAINS';
-- UPDATE Features		SET Appeal = -1	WHERE FeatureType = 'FEATURE_FLOODPLAINS_GRASSLAND';
-- UPDATE Features		SET Appeal = -1	WHERE FeatureType = 'FEATURE_FLOODPLAINS_PLAINS';
UPDATE Features		SET Appeal = 1	WHERE FeatureType = 'FEATURE_GEOTHERMAL_FISSURE';
-- UPDATE Features		SET Appeal = -1	WHERE FeatureType = 'FEATURE_MARSH';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_INDUSTRIAL_ZONE';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_HANSA';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_ENCAMPMENT';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_IKANDA';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_SPACEPORT';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_AERODROME';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_HARBOR';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_ROYAL_NAVY_DOCKYARD';
UPDATE Districts	SET Appeal = -2	WHERE DistrictType = 'DISTRICT_COTHON';
UPDATE Districts	SET Appeal = 1	WHERE DistrictType = 'DISTRICT_AQUEDUCT';
UPDATE Districts	SET Appeal = 1	WHERE DistrictType = 'DISTRICT_BATH';
UPDATE Districts	SET Appeal = 1	WHERE DistrictType = 'DISTRICT_CANAL';
UPDATE Districts	SET Appeal = 1	WHERE DistrictType = 'DISTRICT_DAM';
UPDATE Improvements	SET Appeal = -2	WHERE ImprovementType = 'IMPROVEMENT_MISSILE_SILO';
UPDATE Improvements	SET Appeal = -2	WHERE ImprovementType = 'IMPROVEMENT_AIRSTRIP';
UPDATE Improvements	SET Appeal = -1	WHERE ImprovementType = 'IMPROVEMENT_LUMBER_MILL';
UPDATE Improvements	SET Appeal = -1	WHERE ImprovementType = 'IMPROVEMENT_FORT';
UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_CITY_PARK';
UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_SKI_RESORT';
UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_BEACH_RESORT';
-- UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_PASTURE';
-- UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_PLANTATION';
-- UPDATE Improvements	SET Appeal = 1	WHERE ImprovementType = 'IMPROVEMENT_CAMP';
UPDATE Improvements	SET Appeal = 0	WHERE ImprovementType = 'IMPROVEMENT_GEOTHERMAL_PLANT';
-- UPDATE Improvements	SET Appeal = -2	WHERE ImprovementType = 'IMPROVEMENT_MINE';
-- UPDATE Improvements	SET Appeal = -2	WHERE ImprovementType = 'IMPROVEMENT_QUARRY';
UPDATE Improvements	SET Appeal = -1	WHERE ImprovementType = 'IMPROVEMENT_OIL_WELL';
UPDATE Improvements	SET Appeal = -1	WHERE ImprovementType = 'IMPROVEMENT_OFFSHORE_OIL_RIG';
UPDATE Improvements	SET Appeal = -2	WHERE ImprovementType = 'IMPROVEMENT_MOUNTAIN_TUNNEL';
--------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType,					ModifierId) VALUES	
('TRAIT_LEADER_MAJOR_CIV',	'DISTRICT_BREATHTAKING_APPEAL_TO_AMENITIES'),
('TRAIT_LEADER_MAJOR_CIV',	'DISTRICT_CHARMING_APPEAL_TO_HOUSING'),
('TRAIT_LEADER_MAJOR_CIV',	'DISTRICT_UNINVITING_APPEAL_TO_HOUSING'),
('TRAIT_LEADER_MAJOR_CIV',	'DISTRICT_DISGUSTING_APPEAL_TO_AMENITIES'),
('TRAIT_LEADER_MAJOR_CIV',	'GOLDEN_MARSH_APPEAL'),
('TRAIT_LEADER_MAJOR_CIV',	'GOLDEN_JUNGLE_APPEAL');
--------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,										ModifierType,											SubjectRequirementSetId) VALUES
('DISTRICT_BREATHTAKING_APPEAL_TO_AMENITIES',	'MODIFIER_PLAYER_DISTRICTS_ADJUST_EXTRA_ENTERTAINMENT',	'DISTRICT_BREATHTAKING_APPEAL'),
('DISTRICT_CHARMING_APPEAL_TO_HOUSING',	        'MODIFIER_PLAYER_DISTRICTS_ADJUST_HOUSING',	            'DISTRICT_CHARMING_APPEAL'),
('DISTRICT_UNINVITING_APPEAL_TO_HOUSING',		'MODIFIER_PLAYER_DISTRICTS_ADJUST_HOUSING',            	'DISTRICT_UNINVITING_APPEAL'),
('DISTRICT_DISGUSTING_APPEAL_TO_AMENITIES',		'MODIFIER_PLAYER_DISTRICTS_ADJUST_EXTRA_ENTERTAINMENT',	'DISTRICT_DISGUSTING_APPEAL');
INSERT OR REPLACE INTO Modifiers (ModifierId,										ModifierType,						SubjectRequirementSetId) VALUES
('GOLDEN_MARSH_APPEAL',		            'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',            	    'GOLDEN_PLAYER_HAS_CIVIC_CONSERVATION_REQUIREMENTS'),
('GOLDEN_JUNGLE_APPEAL',		        'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',            	    'GOLDEN_PLAYER_HAS_CIVIC_CONSERVATION_REQUIREMENTS');	
--------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,										Name,		Value) VALUES
('DISTRICT_BREATHTAKING_APPEAL_TO_AMENITIES',	'Amount',	   1),
('DISTRICT_CHARMING_APPEAL_TO_HOUSING',	        'Amount',	   1),
('DISTRICT_UNINVITING_APPEAL_TO_HOUSING',		'Amount',	   -1),
('DISTRICT_DISGUSTING_APPEAL_TO_AMENITIES',	 	'Amount',	   -1),
('GOLDEN_MARSH_APPEAL',                         'FeatureType', 'FEATURE_MARSH'),
('GOLDEN_MARSH_APPEAL',                         'Amount',      2),
('GOLDEN_JUNGLE_APPEAL',                        'FeatureType', 'FEATURE_JUNGLE'),
('GOLDEN_JUNGLE_APPEAL',                        'Amount',      1);
--------------------------------------------------------------
-- RequirementSets
--------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets
		(RequirementSetId,										RequirementSetType)
VALUES	('DISTRICT_BREATHTAKING_APPEAL',					'REQUIREMENTSET_TEST_ALL'),
        ('DISTRICT_CHARMING_APPEAL',				     	'REQUIREMENTSET_TEST_ALL'),
		('DISTRICT_UNINVITING_APPEAL',						'REQUIREMENTSET_TEST_ALL'),
		('DISTRICT_DISGUSTING_APPEAL',						'REQUIREMENTSET_TEST_ALL');
--------------------------------------------------------------
-- RequirementSetRequirements
--------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements
		(RequirementSetId,										RequirementId)
VALUES	('DISTRICT_BREATHTAKING_APPEAL',					'GOLDEN_REQUIRES_PLOT_HAS_ANY_DISTRICT'),
        ('DISTRICT_CHARMING_APPEAL',					    'GOLDEN_REQUIRES_PLOT_HAS_ANY_DISTRICT'),
		('DISTRICT_UNINVITING_APPEAL',						'GOLDEN_REQUIRES_PLOT_HAS_ANY_DISTRICT'),
		('DISTRICT_DISGUSTING_APPEAL',						'GOLDEN_REQUIRES_PLOT_HAS_ANY_DISTRICT'),
		('DISTRICT_BREATHTAKING_APPEAL',					'GOLDEN_REQUIRES_BREATHTAKING_APPEAL'),
		('DISTRICT_CHARMING_APPEAL',					    'GOLDEN_REQUIRES_CHARMING_APPEAL'),
		('DISTRICT_UNINVITING_APPEAL',						'GOLDEN_REQUIRES_UNINVITING_APPEAL'),
		('DISTRICT_DISGUSTING_APPEAL',						'GOLDEN_REQUIRES_DISGUSTING_APPEAL');
--------------------------------------------------------------
-- Requirements
--------------------------------------------------------------
INSERT OR REPLACE INTO Requirements
		(RequirementId,									RequirementType)
VALUES	('GOLDEN_REQUIRES_PLOT_HAS_ANY_DISTRICT',			'REQUIREMENT_PLOT_HAS_ANY_DISTRICT'),
		('GOLDEN_REQUIRES_BREATHTAKING_APPEAL',			    'REQUIREMENT_PLOT_IS_APPEAL_BETWEEN'),
		('GOLDEN_REQUIRES_CHARMING_APPEAL',		    	    'REQUIREMENT_PLOT_IS_APPEAL_BETWEEN'),
		('GOLDEN_REQUIRES_UNINVITING_APPEAL',				'REQUIREMENT_PLOT_IS_APPEAL_BETWEEN'),
		('GOLDEN_REQUIRES_DISGUSTING_APPEAL',				'REQUIREMENT_PLOT_IS_APPEAL_BETWEEN');
--------------------------------------------------------------
-- RequirementArguments
--------------------------------------------------------------
INSERT OR REPLACE INTO RequirementArguments
		(RequirementId,									Name,				Value)
VALUES	('GOLDEN_REQUIRES_BREATHTAKING_APPEAL',			'MinimumAppeal',	4),
        ('GOLDEN_REQUIRES_CHARMING_APPEAL',			    'MinimumAppeal',	2),
		('GOLDEN_REQUIRES_UNINVITING_APPEAL',			'MaximumAppeal',	-2),
		('GOLDEN_REQUIRES_DISGUSTING_APPEAL',			'MaximumAppeal',	-4);