--市政厅建筑
INSERT OR REPLACE INTO Types 
(Type,					                Kind) VALUES
('BUILDING_CITYHALL_VILLAGE',	        'KIND_BUILDING'),
('BUILDING_CITYHALL_TOWN',	            'KIND_BUILDING'),
('BUILDING_CITYHALL_COUNTY',	        'KIND_BUILDING'),
('BUILDING_CITYHALL_CITY',	            'KIND_BUILDING'),
('BUILDING_CITYHALL_METROPOLIS',	    'KIND_BUILDING');
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	    'KIND_BUILDING');

INSERT OR REPLACE INTO Buildings 
(BuildingType,					        Name,                                       Description,                                      Cost, Maintenance, PrereqDistrict,         AdvisorType,       InternalOnly, Entertainment) VALUES
('BUILDING_CITYHALL_VILLAGE',	        'LOC_BUILDING_CITYHALL_VILLAGE_NAME',       'LOC_BUILDING_CITYHALL_VILLAGE_DESCRIPTION',      100,  1,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 0,       0),
('BUILDING_CITYHALL_TOWN',	            'LOC_BUILDING_CITYHALL_TOWN_NAME',          'LOC_BUILDING_CITYHALL_TOWN_DESCRIPTION',         200,  2,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 1,       0),
('BUILDING_CITYHALL_COUNTY',	        'LOC_BUILDING_CITYHALL_COUNTY_NAME',        'LOC_BUILDING_CITYHALL_COUNTY_DESCRIPTION',       300,  3,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 1,       0),
('BUILDING_CITYHALL_CITY',	            'LOC_BUILDING_CITYHALL_CITY_NAME',          'LOC_BUILDING_CITYHALL_CITY_DESCRIPTION',         400,  4,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 1,       0),
('BUILDING_CITYHALL_METROPOLIS',	    'LOC_BUILDING_CITYHALL_METROPOLIS_NAME',    'LOC_BUILDING_CITYHALL_METROPOLIS_DESCRIPTION',   500,  5,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 1,       0);
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	    'LOC_BUILDING_CITYHALL_MEGALOPOLIS_NAME',   'LOC_BUILDING_CITYHALL_MEGALOPOLIS_DESCRIPTION',  600,  6,           'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC', 1,       0);

INSERT OR REPLACE INTO MutuallyExclusiveBuildings 
(Building,					                MutuallyExclusiveBuilding) VALUES	
('BUILDING_CITYHALL_VILLAGE',	            'BUILDING_CITYHALL_TOWN'),
('BUILDING_CITYHALL_VILLAGE',	            'BUILDING_CITYHALL_COUNTY'),
('BUILDING_CITYHALL_VILLAGE',	            'BUILDING_CITYHALL_CITY'),
('BUILDING_CITYHALL_VILLAGE',	            'BUILDING_CITYHALL_METROPOLIS'),
-- ('BUILDING_CITYHALL_VILLAGE',	            'BUILDING_CITYHALL_MEGALOPOLIS'),
('BUILDING_CITYHALL_TOWN',	                'BUILDING_CITYHALL_VILLAGE'),
('BUILDING_CITYHALL_TOWN',	                'BUILDING_CITYHALL_COUNTY'),
('BUILDING_CITYHALL_TOWN',	                'BUILDING_CITYHALL_CITY'),
('BUILDING_CITYHALL_TOWN',	                'BUILDING_CITYHALL_METROPOLIS'),
-- ('BUILDING_CITYHALL_TOWN',	                'BUILDING_CITYHALL_MEGALOPOLIS'),
('BUILDING_CITYHALL_COUNTY',	            'BUILDING_CITYHALL_VILLAGE'),
('BUILDING_CITYHALL_COUNTY',	            'BUILDING_CITYHALL_TOWN'),
('BUILDING_CITYHALL_COUNTY',	            'BUILDING_CITYHALL_CITY'),
('BUILDING_CITYHALL_COUNTY',	            'BUILDING_CITYHALL_METROPOLIS'),
-- ('BUILDING_CITYHALL_COUNTY',	            'BUILDING_CITYHALL_MEGALOPOLIS'),
('BUILDING_CITYHALL_CITY',	                'BUILDING_CITYHALL_VILLAGE'),
('BUILDING_CITYHALL_CITY',	                'BUILDING_CITYHALL_TOWN'),
('BUILDING_CITYHALL_CITY',	                'BUILDING_CITYHALL_COUNTY'),
('BUILDING_CITYHALL_CITY',	                'BUILDING_CITYHALL_METROPOLIS'),
-- ('BUILDING_CITYHALL_CITY',	                'BUILDING_CITYHALL_MEGALOPOLIS'),
('BUILDING_CITYHALL_METROPOLIS',	        'BUILDING_CITYHALL_VILLAGE'),
('BUILDING_CITYHALL_METROPOLIS',	        'BUILDING_CITYHALL_TOWN'),
('BUILDING_CITYHALL_METROPOLIS',	        'BUILDING_CITYHALL_COUNTY'),
('BUILDING_CITYHALL_METROPOLIS',	        'BUILDING_CITYHALL_CITY');
-- ('BUILDING_CITYHALL_METROPOLIS',	        'BUILDING_CITYHALL_MEGALOPOLIS'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	        'BUILDING_CITYHALL_VILLAGE'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	        'BUILDING_CITYHALL_TOWN'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	        'BUILDING_CITYHALL_COUNTY'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	        'BUILDING_CITYHALL_CITY'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	        'BUILDING_CITYHALL_METROPOLIS');

INSERT OR REPLACE INTO DistrictModifiers 
(DistrictType,					ModifierId) VALUES	
('DISTRICT_CITY_CENTER',	    'GOLDEN_FREE_BUILDING_CITYHALL_VILLAGE');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								                ModifierType,										        SubjectRequirementSetId, RunOnce, Permanent) VALUES
('GOLDEN_FREE_BUILDING_CITYHALL_VILLAGE',	                'MODIFIER_SINGLE_CITY_GRANT_BUILDING_IN_CITY_IGNORE',	    NULL,                    1,       1);

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,						Name,		    Value) VALUES
('GOLDEN_FREE_BUILDING_CITYHALL_VILLAGE',	        'BuildingType',	    'BUILDING_CITYHALL_VILLAGE');

--城市扩建项目
INSERT OR REPLACE INTO Types 
(Type,					                Kind) VALUES	
('PROJECT_VILLAGE_TOWN',	            'KIND_PROJECT'),
('PROJECT_TOWN_COUNTY',	                'KIND_PROJECT'),
('PROJECT_COUNTY_CITY',	                'KIND_PROJECT'),
('PROJECT_CITY_METROPOLIS',	            'KIND_PROJECT');
-- ('PROJECT_METROPOLIS_MEGALOPOLIS',	    'KIND_PROJECT');

INSERT OR REPLACE INTO Projects 
(ProjectType,					        Name,                                      ShortName,                                  Description,                                      Cost, PrereqCivic,                 PrereqDistrict,         AdvisorType) VALUES
('PROJECT_VILLAGE_TOWN',	            'LOC_PROJECT_VILLAGE_TOWN_NAME',           'LOC_PROJECT_VILLAGE_TOWN_NAME',            'LOC_PROJECT_VILLAGE_TOWN_DESCRIPTION',           100, 'CIVIC_POLITICAL_PHILOSOPHY', 'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC'),
('PROJECT_TOWN_COUNTY',	                'LOC_PROJECT_TOWN_COUNTY_NAME',            'LOC_PROJECT_TOWN_COUNTY_NAME',             'LOC_PROJECT_TOWN_COUNTY_DESCRIPTION',            200, 'CIVIC_GUILDS',               'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC'),
('PROJECT_COUNTY_CITY',	                'LOC_PROJECT_COUNTY_CITY_NAME',            'LOC_PROJECT_COUNTY_CITY_NAME',             'LOC_PROJECT_COUNTY_CITY_DESCRIPTION',            300, 'CIVIC_CIVIL_ENGINEERING',    'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC'),
('PROJECT_CITY_METROPOLIS',	            'LOC_PROJECT_CITY_METROPOLIS_NAME',        'LOC_PROJECT_CITY_METROPOLIS_NAME',         'LOC_PROJECT_CITY_METROPOLIS_DESCRIPTION',        400, 'CIVIC_CAPITALISM',         'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC');
-- ('PROJECT_METROPOLIS_MEGALOPOLIS',	    'LOC_PROJECT_METROPOLIS_MEGALOPOLIS_NAME', 'LOC_PROJECT_METROPOLIS_MEGALOPOLIS_NAME',  'LOC_PROJECT_METROPOLIS_MEGALOPOLIS_DESCRIPTION', 500, 'CIVIC_PROFESSIONAL_SPORTS',  'DISTRICT_CITY_CENTER', 'ADVISOR_GENERIC');

INSERT OR REPLACE INTO Projects_XP2 
(ProjectType,					        CreateBuilding) VALUES	
('PROJECT_VILLAGE_TOWN',	            'BUILDING_CITYHALL_TOWN'),
('PROJECT_TOWN_COUNTY',	                'BUILDING_CITYHALL_COUNTY'),
('PROJECT_COUNTY_CITY',	                'BUILDING_CITYHALL_CITY'),
('PROJECT_CITY_METROPOLIS',	            'BUILDING_CITYHALL_METROPOLIS');
-- ('PROJECT_METROPOLIS_MEGALOPOLIS',	    'BUILDING_CITYHALL_MEGALOPOLIS');

INSERT OR REPLACE INTO Project_BuildingCosts 
(ProjectType,					        ConsumedBuildingType) VALUES	
('PROJECT_VILLAGE_TOWN',	            'BUILDING_CITYHALL_VILLAGE'),
('PROJECT_TOWN_COUNTY',	                'BUILDING_CITYHALL_TOWN'),
('PROJECT_COUNTY_CITY',	                'BUILDING_CITYHALL_COUNTY'),
('PROJECT_CITY_METROPOLIS',	            'BUILDING_CITYHALL_CITY');
-- ('PROJECT_METROPOLIS_MEGALOPOLIS',	    'BUILDING_CITYHALL_METROPOLIS');

INSERT OR REPLACE INTO ProjectCompletionModifiers 
(ProjectType,					        ModifierId) VALUES	
('PROJECT_VILLAGE_TOWN',	            'GOLDEN_VILLAGE_TOWN_HOUSING'),
('PROJECT_TOWN_COUNTY',	                'GOLDEN_TOWN_COUNTY_HOUSING'),
('PROJECT_COUNTY_CITY',	                'GOLDEN_COUNTY_CITY_HOUSING'),
('PROJECT_CITY_METROPOLIS',	            'GOLDEN_CITY_METROPOLIS_HOUSING');
-- ('PROJECT_METROPOLIS_MEGALOPOLIS',	    'GOLDEN_METROPOLIS_MEGALOPOLIS_HOUSING');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								ModifierType,										SubjectRequirementSetId) VALUES
('GOLDEN_VILLAGE_TOWN_HOUSING',	           'MODIFIER_SINGLE_CITY_ADJUST_BUILDING_HOUSING',	    NULL),
('GOLDEN_TOWN_COUNTY_HOUSING',	           'MODIFIER_SINGLE_CITY_ADJUST_BUILDING_HOUSING',	    NULL),
('GOLDEN_COUNTY_CITY_HOUSING',	           'MODIFIER_SINGLE_CITY_ADJUST_BUILDING_HOUSING',	    NULL),
('GOLDEN_CITY_METROPOLIS_HOUSING',	       'MODIFIER_SINGLE_CITY_ADJUST_BUILDING_HOUSING',	    NULL);
-- ('GOLDEN_METROPOLIS_MEGALOPOLIS_HOUSING',  'MODIFIER_SINGLE_CITY_ADJUST_BUILDING_HOUSING',	    NULL);

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,						        Name,		    Value) VALUES
('GOLDEN_VILLAGE_TOWN_HOUSING',	            'Amount',	    1),
('GOLDEN_TOWN_COUNTY_HOUSING',	            'Amount',	    2),
('GOLDEN_COUNTY_CITY_HOUSING',	            'Amount',	    3),
('GOLDEN_CITY_METROPOLIS_HOUSING',	        'Amount',	    4);
-- ('GOLDEN_METROPOLIS_MEGALOPOLIS_HOUSING',   'Amount',	    5);

--爆铺惩罚
INSERT OR REPLACE INTO DistrictModifiers 
(DistrictType,					ModifierId) VALUES	
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_SCIENCE_DEBUFF_TEN'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_CULTURE_DEBUFF_TEN'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_GOLD_DEBUFF_TEN'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_FAITH_DEBUFF_TEN'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_SCIENCE_DEBUFF_TWENTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_CULTURE_DEBUFF_TWENTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_GOLD_DEBUFF_TWENTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_FAITH_DEBUFF_TWENTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_SCIENCE_DEBUFF_THIRTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_CULTURE_DEBUFF_THIRTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_GOLD_DEBUFF_THIRTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_FAITH_DEBUFF_THIRTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_SCIENCE_DEBUFF_FOURTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_CULTURE_DEBUFF_FOURTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_GOLD_DEBUFF_FOURTY'),
('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_FAITH_DEBUFF_FOURTY');
-- ('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_SCIENCE_DEBUFF_FIFTY'),
-- ('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_CULTURE_DEBUFF_FIFTY'),
-- ('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_GOLD_DEBUFF_FIFTY'),
-- ('DISTRICT_CITY_CENTER',	    'GOLDEN_CITY_FAITH_DEBUFF_FIFTY');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								ModifierType,											SubjectRequirementSetId) VALUES
('GOLDEN_CITY_SCIENCE_DEBUFF_TEN',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS'),
('GOLDEN_CITY_CULTURE_DEBUFF_TEN',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS'),
('GOLDEN_CITY_GOLD_DEBUFF_TEN',	            'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS'),
('GOLDEN_CITY_FAITH_DEBUFF_TEN',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS'),
('GOLDEN_CITY_SCIENCE_DEBUFF_TWENTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS'),
('GOLDEN_CITY_CULTURE_DEBUFF_TWENTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS'),
('GOLDEN_CITY_GOLD_DEBUFF_TWENTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS'),
('GOLDEN_CITY_FAITH_DEBUFF_TWENTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS'),
('GOLDEN_CITY_SCIENCE_DEBUFF_THIRTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS'),
('GOLDEN_CITY_CULTURE_DEBUFF_THIRTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS'),
('GOLDEN_CITY_GOLD_DEBUFF_THIRTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS'),
('GOLDEN_CITY_FAITH_DEBUFF_THIRTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS'),
('GOLDEN_CITY_SCIENCE_DEBUFF_FOURTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS'),
('GOLDEN_CITY_CULTURE_DEBUFF_FOURTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS'),
('GOLDEN_CITY_GOLD_DEBUFF_FOURTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS'),
('GOLDEN_CITY_FAITH_DEBUFF_FOURTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS');
-- ('GOLDEN_CITY_SCIENCE_DEBUFF_FIFTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS'),
-- ('GOLDEN_CITY_CULTURE_DEBUFF_FIFTY',	    'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS'),
-- ('GOLDEN_CITY_GOLD_DEBUFF_FIFTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS'),
-- ('GOLDEN_CITY_FAITH_DEBUFF_FIFTY',	        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',	'GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS');


INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,							    Name,		    Value) VALUES
('GOLDEN_CITY_SCIENCE_DEBUFF_TEN',	        'YieldType',    'YIELD_SCIENCE'),
('GOLDEN_CITY_SCIENCE_DEBUFF_TEN',	        'Amount',	    -1),
('GOLDEN_CITY_CULTURE_DEBUFF_TEN',	        'YieldType',    'YIELD_CULTURE'),
('GOLDEN_CITY_CULTURE_DEBUFF_TEN',	        'Amount',	    -1),
('GOLDEN_CITY_GOLD_DEBUFF_TEN',	            'YieldType',    'YIELD_GOLD'),
('GOLDEN_CITY_GOLD_DEBUFF_TEN',	            'Amount',	    -1),
('GOLDEN_CITY_FAITH_DEBUFF_TEN',	        'YieldType',    'YIELD_FAITH'),
('GOLDEN_CITY_FAITH_DEBUFF_TEN',	        'Amount',	    -1),
('GOLDEN_CITY_SCIENCE_DEBUFF_TWENTY',	    'YieldType',    'YIELD_SCIENCE'),
('GOLDEN_CITY_SCIENCE_DEBUFF_TWENTY',	    'Amount',	    -1),
('GOLDEN_CITY_CULTURE_DEBUFF_TWENTY',	    'YieldType',    'YIELD_CULTURE'),
('GOLDEN_CITY_CULTURE_DEBUFF_TWENTY',	    'Amount',	    -1),
('GOLDEN_CITY_GOLD_DEBUFF_TWENTY',	        'YieldType',    'YIELD_GOLD'),
('GOLDEN_CITY_GOLD_DEBUFF_TWENTY',	        'Amount',	    -1),
('GOLDEN_CITY_FAITH_DEBUFF_TWENTY',	        'YieldType',    'YIELD_FAITH'),
('GOLDEN_CITY_FAITH_DEBUFF_TWENTY',	        'Amount',	    -1),
('GOLDEN_CITY_SCIENCE_DEBUFF_THIRTY',	    'YieldType',    'YIELD_SCIENCE'),
('GOLDEN_CITY_SCIENCE_DEBUFF_THIRTY',	    'Amount',	    -1),
('GOLDEN_CITY_CULTURE_DEBUFF_THIRTY',	    'YieldType',    'YIELD_CULTURE'),
('GOLDEN_CITY_CULTURE_DEBUFF_THIRTY',	    'Amount',	    -1),
('GOLDEN_CITY_GOLD_DEBUFF_THIRTY',	        'YieldType',    'YIELD_GOLD'),
('GOLDEN_CITY_GOLD_DEBUFF_THIRTY',	        'Amount',	    -1),
('GOLDEN_CITY_FAITH_DEBUFF_THIRTY',	        'YieldType',    'YIELD_FAITH'),
('GOLDEN_CITY_FAITH_DEBUFF_THIRTY',	        'Amount',	    -1),
('GOLDEN_CITY_SCIENCE_DEBUFF_FOURTY',	    'YieldType',    'YIELD_SCIENCE'),
('GOLDEN_CITY_SCIENCE_DEBUFF_FOURTY',	    'Amount',	    -1),
('GOLDEN_CITY_CULTURE_DEBUFF_FOURTY',	    'YieldType',    'YIELD_CULTURE'),
('GOLDEN_CITY_CULTURE_DEBUFF_FOURTY',	    'Amount',	    -1),
('GOLDEN_CITY_GOLD_DEBUFF_FOURTY',	        'YieldType',    'YIELD_GOLD'),
('GOLDEN_CITY_GOLD_DEBUFF_FOURTY',	        'Amount',	    -1),
('GOLDEN_CITY_FAITH_DEBUFF_FOURTY',	        'YieldType',    'YIELD_FAITH'),
('GOLDEN_CITY_FAITH_DEBUFF_FOURTY',	        'Amount',	    -1);
-- ('GOLDEN_CITY_SCIENCE_DEBUFF_FIFTY',	    'YieldType',    'YIELD_SCIENCE'),
-- ('GOLDEN_CITY_SCIENCE_DEBUFF_FIFTY',	    'Amount',	    -1),
-- ('GOLDEN_CITY_CULTURE_DEBUFF_FIFTY',	    'YieldType',    'YIELD_CULTURE'),
-- ('GOLDEN_CITY_CULTURE_DEBUFF_FIFTY',	    'Amount',	    -1),
-- ('GOLDEN_CITY_GOLD_DEBUFF_FIFTY',	        'YieldType',    'YIELD_GOLD'),
-- ('GOLDEN_CITY_GOLD_DEBUFF_FIFTY',	        'Amount',	    -1),
-- ('GOLDEN_CITY_FAITH_DEBUFF_FIFTY',	        'YieldType',    'YIELD_FAITH'),
-- ('GOLDEN_CITY_FAITH_DEBUFF_FIFTY',	        'Amount',	    -1);

INSERT OR REPLACE INTO RequirementSets 				
(RequirementSetId ,                                                             RequirementSetType) 	VALUES 		
('GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ANY'),
('GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ANY'),
('GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ANY'),
('GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ANY');
-- ('GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ANY');

INSERT OR REPLACE INTO RequirementSetRequirements 	
(RequirementSetId ,                                                             RequirementId) 			VALUES 		
('GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_TEN_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_AND_NOT_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_TOWN'),
('GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_DONT_HAVE_TWENTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_AND_NOT_COUNTY_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_COUNTY'),
('GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_THIRTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_AND_NOT_CITY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_CITY'),
('GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_FOURTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_AND_NOT_METROPOLIS_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS');
-- ('GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_FIFTY_POPULATION'),
-- ('GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_AND_NOT_MEGALOPOLIS_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS');

INSERT OR REPLACE INTO 		Requirements 
(RequirementId,				                RequirementType) VALUES					    
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_TOWN',	        'REQUIREMENT_REQUIREMENTSET_IS_MET'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_COUNTY',	        'REQUIREMENT_REQUIREMENTSET_IS_MET'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_CITY',	        'REQUIREMENT_REQUIREMENTSET_IS_MET'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS',	    'REQUIREMENT_REQUIREMENTSET_IS_MET');
-- ('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS',	'REQUIREMENT_REQUIREMENTSET_IS_MET');

INSERT OR REPLACE INTO 		RequirementArguments 
(RequirementId,		                                        Name,			        Value) VALUES					    
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_TOWN',		    'RequirementSetId',		'GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_COUNTY',		    'RequirementSetId',		'GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_CITY',		    'RequirementSetId',		'GOLDEN_CITY_LEVEL_IS_LOWER_THAN_CITY_REQUIREMENTS'),
('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS',   	'RequirementSetId',		'GOLDEN_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS_REQUIREMENTS');
-- ('GOLDEN_REQUIRES_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS',	'RequirementSetId',		'GOLDEN_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS_REQUIREMENTS');

INSERT OR REPLACE INTO RequirementSets 				
(RequirementSetId ,                                             RequirementSetType) 	VALUES 		
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_CITY_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL');
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL');

INSERT OR REPLACE INTO RequirementSetRequirements 	
(RequirementSetId ,                                                 RequirementId) 			VALUES 		
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_TOWN'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_COUNTY'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_CITY'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS'),
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_TOWN_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_COUNTY'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_CITY'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS'),
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_COUNTY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_CITY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_CITY'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_CITY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS'),
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_CITY_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS'),
('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS');
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_METROPOLIS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS');
-- ('GOLDEN_CITY_LEVEL_IS_LOWER_THAN_MEGALOPOLIS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS');

INSERT OR REPLACE INTO 		Requirements 
(RequirementId,				                                        RequirementType,                 Inverse) VALUES					    
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_TOWN',	        'REQUIREMENT_CITY_HAS_BUILDING', 1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_COUNTY',	        'REQUIREMENT_CITY_HAS_BUILDING', 1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_CITY',	        'REQUIREMENT_CITY_HAS_BUILDING', 1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS',	    'REQUIREMENT_CITY_HAS_BUILDING', 1);
-- ('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS',	'REQUIREMENT_CITY_HAS_BUILDING', 1);

INSERT OR REPLACE INTO 		RequirementArguments 
(RequirementId,		                                        Name,			        Value) VALUES					    
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_TOWN',		    'BuildingType',		'BUILDING_CITYHALL_TOWN'),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_COUNTY',		    'BuildingType',		'BUILDING_CITYHALL_COUNTY'),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_CITY',		    'BuildingType',		'BUILDING_CITYHALL_CITY'),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_METROPOLIS',		'BuildingType',		'BUILDING_CITYHALL_METROPOLIS');
-- ('GOLDEN_REQUIRES_CITY_DONT_HAVE_BUILDING_CITYHALL_MEGALOPOLIS',	'BuildingType',		'BUILDING_CITYHALL_MEGALOPOLIS');

--额外的宜居度需求
INSERT OR REPLACE INTO DistrictModifiers (DistrictType,					ModifierId) VALUES	
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_TEN'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								        ModifierType,											SubjectRequirementSetId) VALUES
('GOLDEN_CITY_AMENITIES_DEBUFF_TEN',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_TEN_MODIFIER',	    'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY_MODIFIER',	'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY_MODIFIER',	'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY_MODIFIER',	'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                'GOLDEN_CITY_HAS_FIFTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY_MODIFIER',	    'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS');

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,							            Name,		    Value) VALUES
('GOLDEN_CITY_AMENITIES_DEBUFF_TEN',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_TEN_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_TEN_MODIFIER',	    'Amount',	    -1),
('GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_TWENTY_MODIFIER',	'Amount',	    -1),
('GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_THIRTY_MODIFIER',	'Amount',	    -1),
('GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FOURTY_MODIFIER',	'Amount',	    -1),
('GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_FIFTY_MODIFIER',	    'Amount',	    -1);

--消耗额外的电力
INSERT OR REPLACE INTO DistrictModifiers (DistrictType,					ModifierId) VALUES	
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_POWER_TEN'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_POWER_TWENTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_POWER_THIRTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_POWER_FOURTY'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_POWER_FIFTY');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								ModifierType,										SubjectRequirementSetId) VALUES
('GOLDEN_CITY_POWER_TEN',	                'MODIFIER_SINGLE_CITY_ADJUST_REQUIRED_POWER',	    'GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_POWER_TWENTY',	            'MODIFIER_SINGLE_CITY_ADJUST_REQUIRED_POWER',	    'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_POWER_THIRTY',	            'MODIFIER_SINGLE_CITY_ADJUST_REQUIRED_POWER',	    'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_POWER_FOURTY',	            'MODIFIER_SINGLE_CITY_ADJUST_REQUIRED_POWER',	    'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
('GOLDEN_CITY_POWER_FIFTY',	                'MODIFIER_SINGLE_CITY_ADJUST_REQUIRED_POWER',	    'GOLDEN_CITY_HAS_FIFTY_POPULATION_REQUIREMENTS');

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,						Name,		    Value) VALUES
('GOLDEN_CITY_POWER_TEN',	        'Amount',	    1),
('GOLDEN_CITY_POWER_TWENTY',	    'Amount',	    1),
('GOLDEN_CITY_POWER_THIRTY',	    'Amount',	    1),
('GOLDEN_CITY_POWER_FOURTY',	    'Amount',	    1),
('GOLDEN_CITY_POWER_FIFTY',	        'Amount',	    1);

--忠诚度压力
INSERT OR REPLACE INTO BuildingModifiers (BuildingType,					ModifierId) VALUES	
('BUILDING_CITYHALL_TOWN',	        'GOLDEN_CITY_IDENTITY_TOWN'),
('BUILDING_CITYHALL_COUNTY',	    'GOLDEN_CITY_IDENTITY_COUNTY'),
('BUILDING_CITYHALL_CITY',	        'GOLDEN_CITY_IDENTITY_CITY'),
('BUILDING_CITYHALL_METROPOLIS',	'GOLDEN_CITY_IDENTITY_METROPOLIS');
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	'GOLDEN_CITY_IDENTITY_MEGALOPOLIS');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								ModifierType,											SubjectRequirementSetId) VALUES
('GOLDEN_CITY_IDENTITY_TOWN',	            'MODIFIER_SINGLE_CITY_ADJUST_IDENTITY_PRESSURE',	    NULL),
('GOLDEN_CITY_IDENTITY_COUNTY',	            'MODIFIER_SINGLE_CITY_ADJUST_IDENTITY_PRESSURE',	    NULL),
('GOLDEN_CITY_IDENTITY_CITY',	            'MODIFIER_SINGLE_CITY_ADJUST_IDENTITY_PRESSURE',	    NULL),
('GOLDEN_CITY_IDENTITY_METROPOLIS',	        'MODIFIER_SINGLE_CITY_ADJUST_IDENTITY_PRESSURE',	    NULL);
-- ('GOLDEN_CITY_IDENTITY_MEGALOPOLIS',	    'MODIFIER_SINGLE_CITY_ADJUST_IDENTITY_PRESSURE',	    NULL);

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,						    Name,		    Value) VALUES
('GOLDEN_CITY_IDENTITY_TOWN',	        'Amount',	    4),
('GOLDEN_CITY_IDENTITY_COUNTY',	        'Amount',	    8),
('GOLDEN_CITY_IDENTITY_CITY',	        'Amount',	    12),
('GOLDEN_CITY_IDENTITY_METROPOLIS',	    'Amount',	    16);
-- ('GOLDEN_CITY_IDENTITY_MEGALOPOLIS',	'Amount',	    20);

--单位人口产出
INSERT OR REPLACE INTO BuildingModifiers (BuildingType,					ModifierId) VALUES	
('BUILDING_CITYHALL_TOWN',	        'GOLDEN_CITY_TOWN_POP_SCIENCE'),
('BUILDING_CITYHALL_TOWN',	        'GOLDEN_CITY_TOWN_POP_CULTURE'),
('BUILDING_CITYHALL_TOWN',	        'GOLDEN_CITY_TOWN_POP_PRODUCTION'),
('BUILDING_CITYHALL_COUNTY',	    'GOLDEN_CITY_COUNTY_POP_SCIENCE'),
('BUILDING_CITYHALL_COUNTY',	    'GOLDEN_CITY_COUNTY_POP_CULTURE'),
('BUILDING_CITYHALL_COUNTY',	    'GOLDEN_CITY_COUNTY_POP_PRODUCTION'),
('BUILDING_CITYHALL_CITY',	        'GOLDEN_CITY_CITY_POP_SCIENCE'),
('BUILDING_CITYHALL_CITY',	        'GOLDEN_CITY_CITY_POP_CULTURE'),
('BUILDING_CITYHALL_CITY',	        'GOLDEN_CITY_CITY_POP_PRODUCTION'),
('BUILDING_CITYHALL_METROPOLIS',	'GOLDEN_CITY_METROPOLIS_POP_SCIENCE'),
('BUILDING_CITYHALL_METROPOLIS',	'GOLDEN_CITY_METROPOLIS_POP_CULTURE'),
('BUILDING_CITYHALL_METROPOLIS',	'GOLDEN_CITY_METROPOLIS_POP_PRODUCTION');
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	'GOLDEN_CITY_MEGALOPOLIS_POP_SCIENCE'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	'GOLDEN_CITY_MEGALOPOLIS_POP_CULTURE'),
-- ('BUILDING_CITYHALL_MEGALOPOLIS',	'GOLDEN_CITY_MEGALOPOLIS_POP_PRODUCTION');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								ModifierType,											SubjectRequirementSetId) VALUES
('GOLDEN_CITY_TOWN_POP_SCIENCE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_TOWN_POP_CULTURE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_TOWN_POP_PRODUCTION',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_COUNTY_POP_SCIENCE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_COUNTY_POP_CULTURE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_COUNTY_POP_PRODUCTION',	    'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_CITY_POP_SCIENCE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_CITY_POP_CULTURE',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_CITY_POP_PRODUCTION',	        'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_METROPOLIS_POP_SCIENCE',	    'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_METROPOLIS_POP_CULTURE',	    'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
('GOLDEN_CITY_METROPOLIS_POP_PRODUCTION',	'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL);
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_SCIENCE',	    'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_CULTURE',	    'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_PRODUCTION',	'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_PER_POPULATION',	    NULL);

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,						        Name,		    Value) VALUES
('GOLDEN_CITY_TOWN_POP_SCIENCE',	        'YieldType',	'YIELD_SCIENCE'),
('GOLDEN_CITY_TOWN_POP_SCIENCE',	        'Amount',	    0.1),
('GOLDEN_CITY_TOWN_POP_CULTURE',	        'YieldType',	'YIELD_CULTURE'),
('GOLDEN_CITY_TOWN_POP_CULTURE',	        'Amount',	    0.1),
('GOLDEN_CITY_TOWN_POP_PRODUCTION',	        'YieldType',	'YIELD_PRODUCTION'),
('GOLDEN_CITY_TOWN_POP_PRODUCTION',	        'Amount',	    0.1),
('GOLDEN_CITY_COUNTY_POP_SCIENCE',	        'YieldType',	'YIELD_SCIENCE'),
('GOLDEN_CITY_COUNTY_POP_SCIENCE',	        'Amount',	    0.1),
('GOLDEN_CITY_COUNTY_POP_CULTURE',	        'YieldType',	'YIELD_CULTURE'),
('GOLDEN_CITY_COUNTY_POP_CULTURE',	        'Amount',	    0.1),
('GOLDEN_CITY_COUNTY_POP_PRODUCTION',	    'YieldType',	'YIELD_PRODUCTION'),
('GOLDEN_CITY_COUNTY_POP_PRODUCTION',	    'Amount',	    0.1),
('GOLDEN_CITY_CITY_POP_SCIENCE',	        'YieldType',	'YIELD_SCIENCE'),
('GOLDEN_CITY_CITY_POP_SCIENCE',	        'Amount',	    0.1),
('GOLDEN_CITY_CITY_POP_CULTURE',	        'YieldType',	'YIELD_CULTURE'),
('GOLDEN_CITY_CITY_POP_CULTURE',	        'Amount',	    0.1),
('GOLDEN_CITY_CITY_POP_PRODUCTION',	        'YieldType',	'YIELD_PRODUCTION'),
('GOLDEN_CITY_CITY_POP_PRODUCTION',	        'Amount',	    0.1),
('GOLDEN_CITY_METROPOLIS_POP_SCIENCE',	    'YieldType',	'YIELD_SCIENCE'),
('GOLDEN_CITY_METROPOLIS_POP_SCIENCE',	    'Amount',	    0.1),
('GOLDEN_CITY_METROPOLIS_POP_CULTURE',	    'YieldType',	'YIELD_CULTURE'),
('GOLDEN_CITY_METROPOLIS_POP_CULTURE',	    'Amount',	    0.1),
('GOLDEN_CITY_METROPOLIS_POP_PRODUCTION',	'YieldType',	'YIELD_PRODUCTION'),
('GOLDEN_CITY_METROPOLIS_POP_PRODUCTION',	'Amount',	    0.1);
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_SCIENCE',	    'YieldType',	'YIELD_SCIENCE'),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_SCIENCE',	    'Amount',	    0.1),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_CULTURE',	    'YieldType',	'YIELD_CULTURE'),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_CULTURE',	    'Amount',	    0.1),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_PRODUCTION',	'YieldType',	'YIELD_PRODUCTION'),
-- ('GOLDEN_CITY_MEGALOPOLIS_POP_PRODUCTION',	'Amount',	    0.1);


--后期电力不足减宜居度
INSERT OR REPLACE INTO DistrictModifiers (DistrictType,					ModifierId) VALUES	
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION'),
('DISTRICT_CITY_CENTER',	'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE');

INSERT OR REPLACE INTO Modifiers 
(ModifierId,								                    ModifierType,											        SubjectRequirementSetId) VALUES
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                        'GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN_MODIFIER',	    'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_GAME_ERA_IS_MODERN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                        'GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC_MODIFIER',	    'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_GAME_ERA_IS_ATOMIC_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION',	        'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                        'GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION_MODIFIER',	'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_GAME_ERA_IS_INFORMATION_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE',	            'MODIFIER_SINGLE_CITY_ATTACH_MODIFIER',	                        'GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE_MODIFIER',	    'GOLDEN_MODIFIER_PLAYER_DISTRICT_ADJUST_EXTRA_ENTERTAINMENT',	'GOLDEN_GAME_ERA_IS_FUTURE_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS');

INSERT OR REPLACE INTO ModifierArguments 
(ModifierId,							                        Name,		    Value) VALUES
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_MODERN_MODIFIER',	    'Amount',	    -1),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_ATOMIC_MODIFIER',	    'Amount',	    -2),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION',	        'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_INFORMATION_MODIFIER',	'Amount',	    -3),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE',	            'ModifierId',   'GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE_MODIFIER'),
('GOLDEN_CITY_AMENITIES_DEBUFF_NO_POWER_FUTURE_MODIFIER',	    'Amount',	    -4);

INSERT OR REPLACE INTO RequirementSets 				
(RequirementSetId ,                                             RequirementSetType) 	VALUES 		
('GOLDEN_GAME_ERA_IS_MODERN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_GAME_ERA_IS_ATOMIC_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_GAME_ERA_IS_INFORMATION_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_GAME_ERA_IS_FUTURE_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	    'REQUIREMENTSET_TEST_ALL');

INSERT OR REPLACE INTO RequirementSetRequirements 	
(RequirementSetId ,                                                             RequirementId) 			VALUES 		
('GOLDEN_GAME_ERA_IS_MODERN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'GOLDEN_REQUIRES_GAME_ERA_IS_ERA_MODERN'),
('GOLDEN_GAME_ERA_IS_MODERN_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLOT_HAS_DISTRICT_CITY_CENTER'),
('GOLDEN_GAME_ERA_IS_ATOMIC_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'GOLDEN_REQUIRES_GAME_ERA_IS_ERA_ATOMIC'),
('GOLDEN_GAME_ERA_IS_ATOMIC_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLOT_HAS_DISTRICT_CITY_CENTER'),
('GOLDEN_GAME_ERA_IS_INFORMATION_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	'GOLDEN_REQUIRES_GAME_ERA_IS_ERA_INFORMATION'),
('GOLDEN_GAME_ERA_IS_INFORMATION_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	'GOLDEN_REQUIRES_PLOT_HAS_DISTRICT_CITY_CENTER'),
('GOLDEN_GAME_ERA_IS_FUTURE_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	    'GOLDEN_REQUIRES_GAME_ERA_IS_ERA_FUTURE'),
('GOLDEN_GAME_ERA_IS_FUTURE_PLOT_HAS_DISTRICT_CITY_CENTER_REQUIREMENTS' , 	    'GOLDEN_REQUIRES_PLOT_HAS_DISTRICT_CITY_CENTER');