--------------------------------------------------------------
-- Modifiers/ModifierArguments
--------------------------------------------------------------
--东亚
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER',			                'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY',			            'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_IS_OWNER_CAPITAL_CONTINENT_REQUIREMENTS'),
('GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY',			        'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER',                             'DistrictType',      'DISTRICT_THEATER'),
('GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY',                         'Amount',            0.2),
('GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY',                     'Amount',            -0.2);
--（东）南亚、大洋洲
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_ASIA_PACIFIC_FAITH_PURCHASE_HARBOR',			'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_ASIA_PACIFIC_NON_WAR_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS_REQUIREMENTS'),
('GOLDEN_TRAIT_ASIA_PACIFIC_WAR_IDENTITY',			        'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_IS_AT_WAR_WITH_MAJOR_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_ASIA_PACIFIC_FAITH_PURCHASE_HARBOR',            'DistrictType',      'DISTRICT_HARBOR'),
('GOLDEN_TRAIT_ASIA_PACIFIC_NON_WAR_IDENTITY',                 'Amount',            0.2),
('GOLDEN_TRAIT_ASIA_PACIFIC_WAR_IDENTITY',                     'Amount',            -0.2);
--西亚
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT',		'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),	
('GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY',			            'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_IS_AT_WAR_WITH_MAJOR_REQUIREMENTS'),
('GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY',			        'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT',            'DistrictType',      'DISTRICT_ENCAMPMENT'),
('GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY',                         'Amount',      0.2),
('GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY',                     'Amount',      -0.2);
--西欧北欧
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE',		        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),		
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS'),
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY',			        'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_IS_OWNER_CAPITAL_CONTINENT_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE',                 'DistrictType',      'DISTRICT_INDUSTRIAL_ZONE'),
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY',                 'Amount',      0.2),
('GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY',                     'Amount',      -0.2);
--中欧东欧
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_NEIGHBORHOOD',		        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),	
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_DAM',		                'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_GOVERNMENT',		        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_AERODROME',		        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE',		        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_FOUNDED_RELIGION_REQUIREMENTS'),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY',			'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_PLAYER_NO_FOUNDED_RELIGION_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_NEIGHBORHOOD',               'DistrictType',      'DISTRICT_NEIGHBORHOOD'),
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_DAM',                        'DistrictType',      'DISTRICT_DAM'),
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_GOVERNMENT',                 'DistrictType',      'DISTRICT_GOVERNMENT'),
-- ('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_AERODROME',                  'DistrictType',      'DISTRICT_AERODROME'),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE',                  'DistrictType',      'DISTRICT_HOLY_SITE'),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY',                 'Amount',      0.2),
('GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY',             'Amount',      -0.2);
--地中海
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB',	'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'CITY_HAS_GOVERNOR_REQUIREMENTS'),
('GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'CITY_HAS_NO_GOVERNOR_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB',     'DistrictType',      'DISTRICT_COMMERCIAL_HUB'),
('GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY',                 'Amount',      0.2),
('GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY',              'Amount',      -0.2);
--非洲
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER',	    'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'PLAYER_HAS_GOLDEN_AGE'),
('GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'PLAYER_HAS_DARK_AGE');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER',    'DistrictType',      'DISTRICT_CITY_CENTER'),
('GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY',            'Amount',      0.2),
('GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY',              'Amount',      -0.2);
--北美洲
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_NORTH_AMERICA_FAITH_PURCHASE_CAMPUS',	        'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_NORTH_AMERICA_GARRISON_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_HAS_GARRISON_UNIT_REQUIREMENTS'),
('GOLDEN_TRAIT_NORTH_AMERICA_NO_GARRISON_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_HAS_NO_GARRISON_UNIT_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_NORTH_AMERICA_FAITH_PURCHASE_CAMPUS',             'DistrictType',    'DISTRICT_CAMPUS'),
('GOLDEN_TRAIT_NORTH_AMERICA_GARRISON_IDENTITY',                 'Amount',          0.2),
('GOLDEN_TRAIT_NORTH_AMERICA_NO_GARRISON_IDENTITY',              'Amount',          -0.2);
--拉丁美洲
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_ENTERTAINMENT_COMPLEX',	'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',		    NULL),
('GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_WATER_ENTERTAINMENT_COMPLEX',	'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE',	NULL),
('GOLDEN_TRAIT_LATIN_AMERICA_TEN_POPULATION_IDENTITY',			    'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_HAS_NO_GARRISON_UNIT_REQUIREMENTS'),
('GOLDEN_TRAIT_LATIN_AMERICA_NO_TEN_POPULATION_IDENTITY',			'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_CITIZEN',				'GOLDEN_CITY_HAS_GARRISON_UNIT_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_ENTERTAINMENT_COMPLEX',    'DistrictType',    'DISTRICT_ENTERTAINMENT_COMPLEX'),
('GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_WATER_ENTERTAINMENT_COMPLEX',    'DistrictType',    'DISTRICT_WATER_ENTERTAINMENT_COMPLEX'),
('GOLDEN_TRAIT_LATIN_AMERICA_TEN_POPULATION_IDENTITY',                 'Amount',           0.2),
('GOLDEN_TRAIT_LATIN_AMERICA_NO_TEN_POPULATION_IDENTITY',              'Amount',           -0.2);

--农耕
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES		
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL',			            'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',				NULL),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL',			'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',				NULL),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS',			            'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',				NULL),
('GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB',			        'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB',			            'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB',		                'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL);
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL',                         'FeatureType',      'FEATURE_FLOODPLAINS'),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL',                         'Amount',           1),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL',               'FeatureType',      'FEATURE_FLOODPLAINS_GRASSLAND'),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL',               'Amount',           1),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS',                         'FeatureType',      'FEATURE_FLOODPLAINS_PLAINS'),
('GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS',                         'Amount',           1),
('GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB',                      'DistrictType',     'DISTRICT_AQUEDUCT'),
('GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB',                         'DistrictType',     'DISTRICT_CANAL'),
('GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB',                           'DistrictType',     'DISTRICT_DAM');
--种植
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_PLANTATION_PLANTATION_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_PLANTATION_LUXURY_HOUSING',			            'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_HOUSING',				            'GOLDEN_PLOT_HAS_ANY_LUXURY_RESOURCE_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_PLANTATION_PLANTATION_CULTURE_BOMB',                    'ImprovementType',   'IMPROVEMENT_PLANTATION'),
('GOLDEN_TRAIT_PLANTATION_LUXURY_HOUSING',                             'Amount',            2);
--雨林
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_JUNGLE_FORT_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL',			        'MODIFIER_PLAYER_CITIES_ADJUST_FEATURE_APPEAL_MODIFIER',				NULL);
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_JUNGLE_FORT_CULTURE_BOMB',                    'ImprovementType',   'IMPROVEMENT_FORT'),
('GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL',                         'FeatureType',      'FEATURE_JUNGLE'),
('GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL',                         'Amount',           1);
--森林
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_FORESTRY_CITY_HOUSING',			        'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_HOUSING',				            'GOLDEN_PLOT_IS_FOREST_ADJACENT_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB',                    'ImprovementType',   'IMPROVEMENT_CAMP'),
('GOLDEN_TRAIT_FORESTRY_CITY_HOUSING',                         'Amount',            2);
--畜牧
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING',			    'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_HOUSING',				            'GOLDEN_CITY_NO_WATER_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB',         'ImprovementType',   'IMPROVEMENT_PASTURE'),
('GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING',        'Amount',            3);
--渔业、造船业
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING',			        'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_HOUSING',				            'GOLDEN_PLOT_ADJACENT_TO_COAST_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB',                    'ImprovementType',   'IMPROVEMENT_FISHING_BOATS'),
('GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING',                          'Amount',            3);
--高地
INSERT OR REPLACE INTO Modifiers 	(ModifierId,	ModifierType,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB',			    'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',				                NULL),
('GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING',			    'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_HOUSING',				        'GOLDEN_PLOT_IS_ADJACENT_TO_ANY_MOUNTAINS_REQUIREMENTS');
INSERT OR REPLACE INTO ModifierArguments  (ModifierId,	Name,	Value) VALUES
('GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB',                    'ImprovementType',   'IMPROVEMENT_QUARRY'),
('GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING',                 'Amount',            2);
--------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierId) VALUES
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_NO_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_FAITH_PURCHASE_CAMPUS'),

('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT'),

('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_FORT_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL'),

('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_NO_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_ENTERTAINMENT_COMPLEX'),
('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_WATER_ENTERTAINMENT_COMPLEX'),

('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER'),

('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER'),

('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE'),

('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_PLANTATION_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_LUXURY_HOUSING'),

('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE'),

('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_PLANTATION_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_LUXURY_HOUSING'),

('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE'),

('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB'),

('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_FAITH_PURCHASE_HARBOR'),

('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER'),

('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_FORT_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL'),

('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER'),

('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE'),

('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_PLANTATION_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',	'GOLDEN_TRAIT_PLANTATION_LUXURY_HOUSING'),

('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB'),

('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE'),

('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT'),

('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB'),

('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT');

INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierId) VALUES
('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_NO_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_FAITH_PURCHASE_CAMPUS'),

('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_APPEAL'),
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_GRASSLAND_APPEAL'),	
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_FLOODPLAINS_PLAINS'),
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_AQUEDUCT_CULTURE_BOMB'),	
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_CANAL_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AGRICULTURE_DAM_CULTURE_BOMB'),

('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER'),

('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE'),

('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_NO_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_ENTERTAINMENT_COMPLEX'),
('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_WATER_ENTERTAINMENT_COMPLEX'),

('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_EAST_ASIA_FAITH_PURCHASE_THEATER'),

('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE'),

('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE'),

('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER');

INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierId) VALUES
('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_NO_GARRISON_IDENTITY'),
('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_AMERICA_FAITH_PURCHASE_CAMPUS'),

('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_PASTURE_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ANIMAL_HUSBANDRY_NO_WATER_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_NON_RELIGION_FOUNDER_IDENTITY'),
('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',	'GOLDEN_TRAIT_CENTRAL_EASTERN_EUROPE_FAITH_PURCHASE_HOLY_SITE'),

('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_NO_TEN_POPULATION_IDENTITY'),
('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_ENTERTAINMENT_COMPLEX'),
('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_LATIN_AMERICA_FAITH_PURCHASE_WATER_ENTERTAINMENT_COMPLEX'),

('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_GOLDENAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_DARKAGE_IDENTITY'),
('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_AFRICA_FAITH_PURCHASE_CITY_CENTER'),

('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_FORT_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_JUNGLE_JUNGLE_APPEAL'),

('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',	'GOLDEN_TRAIT_ASIA_PACIFIC_FAITH_PURCHASE_HARBOR'),

('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_QUARRY_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MANUFACTURE_MOUNTAINS_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_NON_WAR_IDENTITY'),
('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_WEST_ASIA_FAITH_PURCHASE_ENCAMPMENT'),

('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_FISHING_BOATS_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FISHERY_COASTAL_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_NO_GOVERNOR_IDENTITY'),
('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',	'GOLDEN_TRAIT_MEDITERRANEAN_FAITH_PURCHASE_COMMERCIAL_HUB'),

('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CAMP_CULTURE_BOMB'),
('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_FORESTRY_CITY_HOUSING'),

('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_NON_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_CAPITAL_CONTINENT_IDENTITY'),
('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',	'GOLDEN_TRAIT_NORTH_WESTERN_EUROPE_FAITH_PURCHASE_INDUSTRIAL_ZONE');
--------------------------------------------------------------
-- Types
--------------------------------------------------------------
INSERT OR REPLACE INTO Types (Type,                                       Kind)  VALUES
							('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',            'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',         'KIND_TRAIT');
INSERT OR REPLACE INTO Types (Type,                                       Kind)  VALUES
							('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',            'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',        'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',     'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',        'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',            'KIND_TRAIT');
INSERT OR REPLACE INTO Types (Type,                                       Kind)  VALUES
							('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',          'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',            'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',            'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',           'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',         'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',       'KIND_TRAIT'),
							('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',          'KIND_TRAIT');
--------------------------------------------------------------
-- Traits
--------------------------------------------------------------
INSERT OR REPLACE INTO Traits (TraitType,                                  Name,                         Description) VALUES                       
                             ('GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES_DESCRIPTION'),							 
                             ('GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES',           'LOC_GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES_DESCRIPTION'),							 
                             ('GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES_DESCRIPTION');
INSERT OR REPLACE INTO Traits (TraitType,                                  Name,                         Description) VALUES
                             ('GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES',           'LOC_GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES',       'LOC_GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES',    'LOC_GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES',       'LOC_GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES_DESCRIPTION'),							 
                             ('GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES',           'LOC_GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES_DESCRIPTION');
INSERT OR REPLACE INTO Traits (TraitType,                                  Name,                         Description) VALUES
                             ('GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES',           'LOC_GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES',           'LOC_GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES',          'LOC_GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES',        'LOC_GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES_DESCRIPTION'),
                             ('GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES',      'LOC_GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES_DESCRIPTION'),							 
                             ('GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES',         'LOC_GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES_NAME',      'LOC_GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES_DESCRIPTION');	
--------------------------------------------------------------
-- CivilizationTraits
--------------------------------------------------------------
INSERT OR REPLACE INTO CivilizationTraits (CivilizationType,              TraitType) VALUES
                                         ('CIVILIZATION_AMERICA',        'GOLDEN_CIVILIZATION_AMERICA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_ARABIA',         'GOLDEN_CIVILIZATION_ARABIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_BRAZIL',         'GOLDEN_CIVILIZATION_BRAZIL_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_CHINA',          'GOLDEN_CIVILIZATION_CHINA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_EGYPT',          'GOLDEN_CIVILIZATION_EGYPT_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_ENGLAND',        'GOLDEN_CIVILIZATION_ENGLAND_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_FRANCE',         'GOLDEN_CIVILIZATION_FRANCE_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_GERMANY',        'GOLDEN_CIVILIZATION_GERMANY_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_GREECE',         'GOLDEN_CIVILIZATION_GREECE_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_INDIA',          'GOLDEN_CIVILIZATION_INDIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_JAPAN',          'GOLDEN_CIVILIZATION_JAPAN_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_KONGO',          'GOLDEN_CIVILIZATION_KONGO_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_NORWAY',         'GOLDEN_CIVILIZATION_NORWAY_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_ROME',           'GOLDEN_CIVILIZATION_ROME_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_RUSSIA',         'GOLDEN_CIVILIZATION_RUSSIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_SCYTHIA',        'GOLDEN_CIVILIZATION_SCYTHIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_SPAIN',          'GOLDEN_CIVILIZATION_SPAIN_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_SUMERIA',        'GOLDEN_CIVILIZATION_SUMERIA_CUSTOM_FEATURES');
INSERT OR REPLACE INTO CivilizationTraits (CivilizationType,              TraitType) VALUES
                                         ('CIVILIZATION_CREE',           'GOLDEN_CIVILIZATION_CREE_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_KOREA',          'GOLDEN_CIVILIZATION_KOREA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_GEORGIA',        'GOLDEN_CIVILIZATION_GEORGIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_MAPUCHE',        'GOLDEN_CIVILIZATION_MAPUCHE_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_MONGOLIA',       'GOLDEN_CIVILIZATION_MONGOLIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_NETHERLANDS',    'GOLDEN_CIVILIZATION_NETHERLANDS_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_SCOTLAND',       'GOLDEN_CIVILIZATION_SCOTLAND_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_ZULU',           'GOLDEN_CIVILIZATION_ZULU_CUSTOM_FEATURES');
INSERT OR REPLACE INTO CivilizationTraits (CivilizationType,              TraitType) VALUES
                                         ('CIVILIZATION_CANADA',         'GOLDEN_CIVILIZATION_CANADA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_HUNGARY',        'GOLDEN_CIVILIZATION_HUNGARY_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_INCA',           'GOLDEN_CIVILIZATION_INCA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_MALI',           'GOLDEN_CIVILIZATION_MALI_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_MAORI',          'GOLDEN_CIVILIZATION_MAORI_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_OTTOMAN',        'GOLDEN_CIVILIZATION_OTTOMAN_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_PHOENICIA',      'GOLDEN_CIVILIZATION_PHOENICIA_CUSTOM_FEATURES'),
                                         ('CIVILIZATION_SWEDEN',         'GOLDEN_CIVILIZATION_SWEDEN_CUSTOM_FEATURES');





-- INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,         RequirementSetType) 	VALUES 		
-- ('GOLDEN_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL');

-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,         RequirementId) 			VALUES 		
-- ('GOLDEN_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE');

-- INSERT OR REPLACE INTO 		Requirements (RequirementId,				            RequirementType) VALUES					    
-- ('GOLDEN_REQUIRES_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE',	       'REQUIREMENT_COLLECTION_COUNT_ATLEAST');

-- INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		                Name,			        Value) VALUES					    
-- ('GOLDEN_REQUIRES_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE',		                    'RequirementSetId',		    'GOLDEN_PLOT_HAS_ANY_LUXURY_RESOURCE_REQUIREMENTS'),
-- ('GOLDEN_REQUIRES_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE',				            'CollectionType',			'COLLECTION_CITY_PLOT_YIELDS'),
-- ('GOLDEN_REQUIRES_PLANTATION_CITY_HAS_NO_LESS_THAN_3_LUXURY_RESOURCE',				            'Count',					3);