
INSERT OR REPLACE INTO Types (Type,	Kind)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_UNIVERSITY', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'KIND_BUILDING'),
	
	('BUILDING_NATIONAL_MARKET', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_BANK', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'KIND_BUILDING'),
	
	('BUILDING_NATIONAL_WORKSHOP', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_FACTORY', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_POWER_STATION', 'KIND_BUILDING'),
	
	('BUILDING_NATIONAL_SHRINE', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_TEMPLE', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_CATHEDRAL', 'KIND_BUILDING'),
		
	('BUILDING_NATIONAL_AMPHITHEATER', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_MUSEUM', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'KIND_BUILDING'),
	
	('BUILDING_NATIONAL_BARRACKS', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_ARMORY', 'KIND_BUILDING'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'KIND_BUILDING');

	
INSERT OR REPLACE INTO Buildings (BuildingType, Name, Description, PrereqCivic, PrereqDistrict, Cost, AdvisorType, Maintenance, CitizenSlots, MaxPlayerInstances, RegionalRange, Entertainment, Housing)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'LOC_BUILDING_NATIONAL_LIBRARY_NAME', 'LOC_BUILDING_NATIONAL_LIBRARY_DESCRIPTION', 'CIVIC_RECORDED_HISTORY', 'DISTRICT_CAMPUS', '200', 'ADVISOR_TECHNOLOGY', '2', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_UNIVERSITY', 'LOC_BUILDING_NATIONAL_UNIVERSITY_NAME', 'LOC_BUILDING_NATIONAL_UNIVERSITY_DESCRIPTION', 'CIVIC_THE_ENLIGHTENMENT', 'DISTRICT_CAMPUS', '500', 'ADVISOR_TECHNOLOGY', '3', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_RESEARCH_LAB', 'LOC_BUILDING_NATIONAL_RESEARCH_LAB_NAME', 'LOC_BUILDING_NATIONAL_RESEARCH_LAB_DESCRIPTION', 'CIVIC_NUCLEAR_PROGRAM', 'DISTRICT_CAMPUS', '1200', 'ADVISOR_TECHNOLOGY', '4', '1', '1', '0', '0', '0'),	
	
	('BUILDING_NATIONAL_MARKET', 'LOC_BUILDING_NATIONAL_MARKET_NAME', 'LOC_BUILDING_NATIONAL_MARKET_DESCRIPTION', 'CIVIC_MEDIEVAL_FAIRES', 'DISTRICT_COMMERCIAL_HUB', '250', 'ADVISOR_GENERIC', '0', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_BANK', 'LOC_BUILDING_NATIONAL_BANK_NAME', 'LOC_BUILDING_NATIONAL_BANK_DESCRIPTION', 'CIVIC_MERCANTILISM', 'DISTRICT_COMMERCIAL_HUB', '600', 'ADVISOR_GENERIC', '0', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'LOC_BUILDING_NATIONAL_STOCK_EXCHANGE_NAME', 'LOC_BUILDING_NATIONAL_STOCK_EXCHANGE_DESCRIPTION', 'CIVIC_CAPITALISM', 'DISTRICT_COMMERCIAL_HUB', '800', 'ADVISOR_GENERIC', '0', '1', '1', '0', '0', '0'),	
	
	('BUILDING_NATIONAL_WORKSHOP', 'LOC_BUILDING_NATIONAL_WORKSHOP_NAME', 'LOC_BUILDING_NATIONAL_WORKSHOP_DESCRIPTION', 'CIVIC_MERCANTILISM', 'DISTRICT_INDUSTRIAL_ZONE', '400', 'ADVISOR_GENERIC', '2', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_FACTORY', 'LOC_BUILDING_NATIONAL_FACTORY_NAME', 'LOC_BUILDING_NATIONAL_FACTORY_DESCRIPTION', 'CIVIC_NUCLEAR_PROGRAM', 'DISTRICT_INDUSTRIAL_ZONE', '800', 'ADVISOR_GENERIC', '3', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_POWER_STATION', 'LOC_BUILDING_NATIONAL_POWER_STATION_NAME', 'LOC_BUILDING_NATIONAL_POWER_STATION_DESCRIPTION', 'CIVIC_ENVIRONMENTALISM', 'DISTRICT_INDUSTRIAL_ZONE', '1200', 'ADVISOR_GENERIC', '4', '1', '1', '0', '0', '0'),	
	
	('BUILDING_NATIONAL_SHRINE', 'LOC_BUILDING_NATIONAL_SHRINE_NAME', 'LOC_BUILDING_NATIONAL_SHRINE_DESCRIPTION', 'CIVIC_MYSTICISM', 'DISTRICT_HOLY_SITE', '150', 'ADVISOR_RELIGIOUS', '2', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_TEMPLE', 'LOC_BUILDING_NATIONAL_TEMPLE_NAME', 'LOC_BUILDING_NATIONAL_TEMPLE_DESCRIPTION', 'CIVIC_THEOLOGY', 'DISTRICT_HOLY_SITE', '300', 'ADVISOR_RELIGIOUS', '3', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_CATHEDRAL', 'LOC_BUILDING_NATIONAL_CATHEDRAL_NAME', 'LOC_BUILDING_NATIONAL_CATHEDRAL_DESCRIPTION', 'CIVIC_OPERA_BALLET', 'DISTRICT_HOLY_SITE', '600', 'ADVISOR_RELIGIOUS', '4', '1', '1', '0', '0', '0'),
	
	('BUILDING_NATIONAL_AMPHITHEATER', 'LOC_BUILDING_NATIONAL_AMPHITHEATER_NAME', 'LOC_BUILDING_NATIONAL_AMPHITHEATER_DESCRIPTION', 'CIVIC_GUILDS', 'DISTRICT_THEATER', '300', 'ADVISOR_CULTURE', '2', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_MUSEUM', 'LOC_BUILDING_NATIONAL_MUSEUM_NAME', 'LOC_BUILDING_NATIONAL_MUSEUM_DESCRIPTION', 'CIVIC_OPERA_BALLET', 'DISTRICT_THEATER', '600', 'ADVISOR_CULTURE', '3', '1', '1', '0', '0', '0'),	
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'LOC_BUILDING_NATIONAL_BROADCAST_CENTER_NAME', 'LOC_BUILDING_NATIONAL_BROADCAST_CENTER_DESCRIPTION', 'CIVIC_CULTURAL_HERITAGE', 'DISTRICT_THEATER', '1200', 'ADVISOR_CULTURE', '4', '1', '1', '0', '0', '0'),	
	
	('BUILDING_NATIONAL_BARRACKS', 'LOC_BUILDING_NATIONAL_BARRACKS_NAME', 'LOC_BUILDING_NATIONAL_BARRACKS_DESCRIPTION', 'CIVIC_MILITARY_TRAINING', 'DISTRICT_ENCAMPMENT', '200', 'ADVISOR_CONQUEST', '2', '1', '1', '0', '0', '4'),	
	('BUILDING_NATIONAL_ARMORY', 'LOC_BUILDING_NATIONAL_ARMORY_NAME', 'LOC_BUILDING_NATIONAL_ARMORY_DESCRIPTION', 'CIVIC_NATIONALISM', 'DISTRICT_ENCAMPMENT', '400', 'ADVISOR_CONQUEST', '3', '1', '1', '0', '0', '6'),	
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'LOC_BUILDING_NATIONAL_MILITARY_ACADEMY_NAME', 'LOC_BUILDING_NATIONAL_MILITARY_ACADEMY_DESCRIPTION', 'CIVIC_MOBILIZATION', 'DISTRICT_ENCAMPMENT', '800', 'ADVISOR_CONQUEST', '4', '1', '1', '0', '0', '8');


INSERT OR REPLACE INTO BuildingPrereqs (Building, PrereqBuilding)
VALUES
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_UNIVERSITY'),
	
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_BANK'),
	
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_FACTORY'),
	
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_TEMPLE'),
	
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_MUSEUM'),
	
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_ARMORY');	
	
	
INSERT OR REPLACE INTO Building_YieldChanges (BuildingType, YieldType, YieldChange)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'YIELD_SCIENCE', '4'),
	('BUILDING_NATIONAL_UNIVERSITY', 'YIELD_SCIENCE', '6'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'YIELD_SCIENCE', '8'),
		
	('BUILDING_NATIONAL_MARKET', 'YIELD_GOLD', '4'),
	('BUILDING_NATIONAL_BANK', 'YIELD_GOLD', '8'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'YIELD_GOLD', '12'),
		
	('BUILDING_NATIONAL_WORKSHOP', 'YIELD_PRODUCTION', '4'),
	('BUILDING_NATIONAL_FACTORY', 'YIELD_PRODUCTION', '6'),
	('BUILDING_NATIONAL_POWER_STATION', 'YIELD_PRODUCTION', '8'),
	
	('BUILDING_NATIONAL_SHRINE', 'YIELD_FAITH', '4'),
	('BUILDING_NATIONAL_TEMPLE', 'YIELD_FAITH', '6'),
	('BUILDING_NATIONAL_CATHEDRAL', 'YIELD_FAITH', '8'),
	
	-- ('BUILDING_NATIONAL_BARRACKS', 'YIELD_FOOD', '0'),
	-- ('BUILDING_NATIONAL_ARMORY', 'YIELD_FOOD', '0'),
	-- ('BUILDING_NATIONAL_MILITARY_ACADEMY', 'YIELD_FOOD', '0'),
	
	('BUILDING_NATIONAL_AMPHITHEATER', 'YIELD_CULTURE', '4'),
	('BUILDING_NATIONAL_MUSEUM', 'YIELD_CULTURE', '6'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'YIELD_CULTURE', '8');	
	
	
INSERT OR REPLACE INTO Building_GreatPersonPoints (BuildingType, GreatPersonClassType, PointsPerTurn)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'GREAT_PERSON_CLASS_SCIENTIST', '2'),
	('BUILDING_NATIONAL_UNIVERSITY', 'GREAT_PERSON_CLASS_SCIENTIST', '2'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'GREAT_PERSON_CLASS_SCIENTIST', '2'),
	
	('BUILDING_NATIONAL_MARKET', 'GREAT_PERSON_CLASS_MERCHANT', '2'),
	('BUILDING_NATIONAL_BANK', 'GREAT_PERSON_CLASS_MERCHANT', '2'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'GREAT_PERSON_CLASS_MERCHANT', '2'),
	
	('BUILDING_NATIONAL_WORKSHOP', 'GREAT_PERSON_CLASS_ENGINEER', '2'),
	('BUILDING_NATIONAL_FACTORY', 'GREAT_PERSON_CLASS_ENGINEER', '2'),
	('BUILDING_NATIONAL_POWER_STATION', 'GREAT_PERSON_CLASS_ENGINEER', '2'),
	
	('BUILDING_NATIONAL_SHRINE', 'GREAT_PERSON_CLASS_PROPHET', '2'),
	('BUILDING_NATIONAL_TEMPLE', 'GREAT_PERSON_CLASS_PROPHET', '2'),
	('BUILDING_NATIONAL_CATHEDRAL', 'GREAT_PERSON_CLASS_PROPHET', '2'),
	
	('BUILDING_NATIONAL_AMPHITHEATER', 'GREAT_PERSON_CLASS_WRITER', '2'),
	('BUILDING_NATIONAL_MUSEUM', 'GREAT_PERSON_CLASS_WRITER', '2'),
	('BUILDING_NATIONAL_MUSEUM', 'GREAT_PERSON_CLASS_ARTIST', '4'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'GREAT_PERSON_CLASS_ARTIST', '2'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'GREAT_PERSON_CLASS_MUSICIAN', '4'),
	
	('BUILDING_NATIONAL_BARRACKS', 'GREAT_PERSON_CLASS_GENERAL', '1'),
    ('BUILDING_NATIONAL_ARMORY', 'GREAT_PERSON_CLASS_GENERAL', '1'),		
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'GREAT_PERSON_CLASS_GENERAL', '1'),
	('BUILDING_NATIONAL_BARRACKS', 'GREAT_PERSON_CLASS_ADMIRAL', '1'),
    ('BUILDING_NATIONAL_ARMORY', 'GREAT_PERSON_CLASS_ADMIRAL', '1'),		
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'GREAT_PERSON_CLASS_ADMIRAL', '1');
	
	
INSERT OR REPLACE INTO Building_GreatWorks (BuildingType, GreatWorkSlotType, NumSlots)
VALUES	
	('BUILDING_NATIONAL_AMPHITHEATER','GREATWORKSLOT_WRITING','4'),
	('BUILDING_NATIONAL_MUSEUM','GREATWORKSLOT_ART','3'),
	('BUILDING_NATIONAL_MUSEUM','GREATWORKSLOT_ARTIFACT','3'),
	('BUILDING_NATIONAL_BROADCAST_CENTER','GREATWORKSLOT_MUSIC','2'),
	('BUILDING_NATIONAL_SHRINE','GREATWORKSLOT_RELIC','2'),
	('BUILDING_NATIONAL_TEMPLE','GREATWORKSLOT_RELIC','2'),
	('BUILDING_NATIONAL_CATHEDRAL','GREATWORKSLOT_RELIC','2');	


INSERT OR REPLACE INTO Buildings_XP2 (BuildingType, RequiredPower)
VALUES	
	('BUILDING_NATIONAL_LIBRARY','1'),
	('BUILDING_NATIONAL_UNIVERSITY','2'),
	('BUILDING_NATIONAL_RESEARCH_LAB','3'),
	('BUILDING_NATIONAL_MARKET','1'),
	('BUILDING_NATIONAL_BANK','2'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE','3'),
	('BUILDING_NATIONAL_WORKSHOP','1'),
	('BUILDING_NATIONAL_FACTORY','2'),
	('BUILDING_NATIONAL_POWER_STATION','3'),
	('BUILDING_NATIONAL_SHRINE','1'),
	('BUILDING_NATIONAL_TEMPLE','2'),
	('BUILDING_NATIONAL_CATHEDRAL','3'),
	('BUILDING_NATIONAL_AMPHITHEATER','1'),
	('BUILDING_NATIONAL_MUSEUM','2'),
	('BUILDING_NATIONAL_BROADCAST_CENTER','3');
INSERT OR REPLACE INTO Buildings_XP2 (BuildingType, RequiredPower, EntertainmentBonusWithPower)
VALUES		
	('BUILDING_NATIONAL_BARRACKS','1','1' ),
	('BUILDING_NATIONAL_ARMORY','2','2'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY','3','3');


INSERT OR REPLACE INTO Building_YieldChangesBonusWithPower (BuildingType, YieldType, YieldChange)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'YIELD_SCIENCE', '2'),
    ('BUILDING_NATIONAL_UNIVERSITY', 'YIELD_SCIENCE', '4'),	
    ('BUILDING_NATIONAL_RESEARCH_LAB', 'YIELD_SCIENCE', '6'),	
    ('BUILDING_NATIONAL_MARKET', 'YIELD_GOLD', '2'),
    ('BUILDING_NATIONAL_BANK', 'YIELD_GOLD', '4'),	
    ('BUILDING_NATIONAL_STOCK_EXCHANGE', 'YIELD_GOLD', '6'),
    ('BUILDING_NATIONAL_WORKSHOP', 'YIELD_PRODUCTION', '2'),
    ('BUILDING_NATIONAL_FACTORY', 'YIELD_PRODUCTION', '4'),	
    ('BUILDING_NATIONAL_POWER_STATION', 'YIELD_PRODUCTION', '6'),	
	('BUILDING_NATIONAL_SHRINE', 'YIELD_FAITH', '2'),
    ('BUILDING_NATIONAL_TEMPLE', 'YIELD_FAITH', '4'),	
    ('BUILDING_NATIONAL_CATHEDRAL', 'YIELD_FAITH', '6'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'YIELD_CULTURE', '2'),
    ('BUILDING_NATIONAL_MUSEUM', 'YIELD_CULTURE', '4'),	
    ('BUILDING_NATIONAL_BROADCAST_CENTER', 'YIELD_CULTURE', '6');	
	
	
INSERT OR REPLACE INTO MutuallyExclusiveBuildings (Building, MutuallyExclusiveBuilding)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_FACTORY'),
    ('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_LIBRARY', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_UNIVERSITY', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_RESEARCH_LAB', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),
	
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_MARKET', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),		
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_BANK', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),		
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_STOCK_EXCHANGE', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_WORKSHOP', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),		
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_FACTORY', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),		
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_POWER_STATION', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),
	
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_SHRINE', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_TEMPLE', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_LIBRARY'),	
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_MARKET'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_BROADCAST_CENTER'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_CATHEDRAL', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),
	
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_AMPHITHEATER', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_MUSEUM', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),	
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_BARRACKS'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_ARMORY'),
	('BUILDING_NATIONAL_BROADCAST_CENTER', 'BUILDING_NATIONAL_MILITARY_ACADEMY'),
	
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_BARRACKS', 'BUILDING_NATIONAL_BROADCAST_CENTER'),	
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_ARMORY', 'BUILDING_NATIONAL_BROADCAST_CENTER'),	
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_MARKET'),	
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_BANK'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_STOCK_EXCHANGE'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_WORKSHOP'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_FACTORY'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_POWER_STATION'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_SHRINE'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_TEMPLE'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_CATHEDRAL'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_LIBRARY'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_UNIVERSITY'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_RESEARCH_LAB'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_AMPHITHEATER'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_MUSEUM'),
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'BUILDING_NATIONAL_BROADCAST_CENTER');
	

INSERT OR REPLACE INTO BuildingModifiers (BuildingType, ModifierId)
VALUES	
	('BUILDING_NATIONAL_LIBRARY', 'GOLDEN_NATIONAL_LIBRARY_SCIENCE'),
    ('BUILDING_NATIONAL_LIBRARY', 'GOLDEN_NATIONAL_LIBRARY_SCIENCE_PLUS'),	
    ('BUILDING_NATIONAL_UNIVERSITY', 'GOLDEN_NATIONAL_UNIVERSITY_SCIENCE'),
    ('BUILDING_NATIONAL_UNIVERSITY', 'GOLDEN_NATIONAL_UNIVERSITY_SCIENCE_PLUS'),	
    ('BUILDING_NATIONAL_RESEARCH_LAB', 'GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE'),
    ('BUILDING_NATIONAL_RESEARCH_LAB', 'GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE_PLUS'),	
    
    ('BUILDING_NATIONAL_AMPHITHEATER', 'GOLDEN_NATIONAL_AMPHITHEATER_CULTURE'),
    ('BUILDING_NATIONAL_AMPHITHEATER', 'GOLDEN_NATIONAL_AMPHITHEATER_CULTURE_PLUS'),	
    ('BUILDING_NATIONAL_MUSEUM', 'GOLDEN_NATIONAL_MUSEUM_CULTURE'),
    ('BUILDING_NATIONAL_MUSEUM', 'GOLDEN_NATIONAL_MUSEUM_CULTURE_PLUS'),	
    ('BUILDING_NATIONAL_BROADCAST_CENTER', 'GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE'),
    ('BUILDING_NATIONAL_BROADCAST_CENTER', 'GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE_PLUS'),	

    ('BUILDING_NATIONAL_MARKET', 'GOLDEN_NATIONAL_MARKET_GOLD'),
    ('BUILDING_NATIONAL_MARKET', 'GOLDEN_NATIONAL_MARKET_GOLD_PLUS'),	
    ('BUILDING_NATIONAL_BANK', 'GOLDEN_NATIONAL_BANK_GOLD'),
    ('BUILDING_NATIONAL_BANK', 'GOLDEN_NATIONAL_BANK_GOLD_PLUS'),	
    ('BUILDING_NATIONAL_STOCK_EXCHANGE', 'GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD'),
    ('BUILDING_NATIONAL_STOCK_EXCHANGE', 'GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD_PLUS'),	
	
	('BUILDING_NATIONAL_SHRINE', 'GOLDEN_NATIONAL_SHRINE_FAITH'),
    ('BUILDING_NATIONAL_SHRINE', 'GOLDEN_NATIONAL_SHRINE_FAITH_PLUS'),	
    ('BUILDING_NATIONAL_TEMPLE', 'GOLDEN_NATIONAL_TEMPLE_FAITH'),
    ('BUILDING_NATIONAL_TEMPLE', 'GOLDEN_NATIONAL_TEMPLE_FAITH_PLUS'),	
	('BUILDING_NATIONAL_CATHEDRAL', 'GOLDEN_NATIONAL_CATHEDRAL_FAITH'),
    ('BUILDING_NATIONAL_CATHEDRAL', 'GOLDEN_NATIONAL_CATHEDRAL_FAITH_PLUS'),
	
	('BUILDING_NATIONAL_WORKSHOP', 'GOLDEN_NATIONAL_WORKSHOP_PRODUCTION'),
    ('BUILDING_NATIONAL_WORKSHOP', 'GOLDEN_NATIONAL_WORKSHOP_PRODUCTION_PLUS'),	
    ('BUILDING_NATIONAL_FACTORY', 'GOLDEN_NATIONAL_FACTORY_PRODUCTION'),
    ('BUILDING_NATIONAL_FACTORY', 'GOLDEN_NATIONAL_FACTORY_PRODUCTION_PLUS'),
	('BUILDING_NATIONAL_POWER_STATION', 'GOLDEN_NATIONAL_POWER_STATION_PRODUCTION'),
    ('BUILDING_NATIONAL_POWER_STATION', 'GOLDEN_NATIONAL_POWER_STATION_PRODUCTION_PLUS'),
	
	('BUILDING_NATIONAL_BARRACKS', 'BARRACKS_ADJUST_RESOURCE_STOCKPILE_CAP'),
    ('BUILDING_NATIONAL_ARMORY', 'ARMORY_ADJUST_RESOURCE_STOCKPILE_CAP'),		
	('BUILDING_NATIONAL_MILITARY_ACADEMY', 'MILITARY_ACADEMY_ADJUST_RESOURCE_STOCKPILE_CAP'),	
	-- ('BUILDING_NATIONAL_BARRACKS', 'GOLDEN_NATIONAL_BARRACKS_GROWTH'),
    ('BUILDING_NATIONAL_BARRACKS', 'GOLDEN_NATIONAL_BARRACKS_GROWTH_PLUS'),		
	-- ('BUILDING_NATIONAL_ARMORY', 'GOLDEN_NATIONAL_ARMORY_GROWTH'),
    ('BUILDING_NATIONAL_ARMORY', 'GOLDEN_NATIONAL_ARMORY_GROWTH_PLUS'),	
	-- ('BUILDING_NATIONAL_MILITARY_ACADEMY', 'GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH'),
    ('BUILDING_NATIONAL_MILITARY_ACADEMY', 'GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH_PLUS');
	
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
VALUES
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CAMPUS_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CAMPUS_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CAMPUS_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
	
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_THEATER_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_MUSEUM_CULTURE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_THEATER_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_MUSEUM_CULTURE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_THEATER_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
	
	('GOLDEN_NATIONAL_MARKET_GOLD', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_COMMERCIAL_HUB_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_MARKET_GOLD_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_BANK_GOLD', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_BANK_GOLD_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_COMMERCIAL_HUB_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
	
	('GOLDEN_NATIONAL_SHRINE_FAITH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_HOLY_SITE_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_SHRINE_FAITH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_TEMPLE_FAITH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_HOLY_SITE_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_TEMPLE_FAITH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_HOLY_SITE_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
	
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_YIELD_MODIFIER', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS'),
	
	-- ('GOLDEN_NATIONAL_BARRACKS_GROWTH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_ENCAMPMENT_HAS_TWO_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_BARRACKS_GROWTH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS'),
	-- ('GOLDEN_NATIONAL_ARMORY_GROWTH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_ENCAMPMENT_HAS_FOUR_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_ARMORY_GROWTH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS'),
	-- ('GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_ENCAMPMENT_HAS_SIX_ADJACENCY_REQUIREMENTS'),	
	('GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH_PLUS', 'MODIFIER_SINGLE_CITY_ADJUST_CITY_GROWTH', 'GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS');
	
	
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE', 'Amount', '5'),
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE_PLUS', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_LIBRARY_SCIENCE_PLUS', 'Amount', '5'),
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE', 'Amount', '10'),
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE_PLUS', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_UNIVERSITY_SCIENCE_PLUS', 'Amount', '10'),
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE', 'Amount', '15'),
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE_PLUS', 'YieldType', 'YIELD_SCIENCE'),
	('GOLDEN_NATIONAL_RESEARCH_LAB_SCIENCE_PLUS', 'Amount', '15'),
	
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE', 'Amount', '5'),
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE_PLUS', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_AMPHITHEATER_CULTURE_PLUS', 'Amount', '5'),
	('GOLDEN_NATIONAL_MUSEUM_CULTURE', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_MUSEUM_CULTURE', 'Amount', '10'),
	('GOLDEN_NATIONAL_MUSEUM_CULTURE_PLUS', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_MUSEUM_CULTURE_PLUS', 'Amount', '10'),
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE', 'Amount', '15'),
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE_PLUS', 'YieldType', 'YIELD_CULTURE'),
	('GOLDEN_NATIONAL_BROADCAST_CENTER_CULTURE_PLUS', 'Amount', '15'),
	
	('GOLDEN_NATIONAL_MARKET_GOLD', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_MARKET_GOLD', 'Amount', '5'),
	('GOLDEN_NATIONAL_MARKET_GOLD_PLUS', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_MARKET_GOLD_PLUS', 'Amount', '5'),
	('GOLDEN_NATIONAL_BANK_GOLD', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_BANK_GOLD', 'Amount', '10'),
	('GOLDEN_NATIONAL_BANK_GOLD_PLUS', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_BANK_GOLD_PLUS', 'Amount', '10'),
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD', 'Amount', '15'),
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD_PLUS', 'YieldType', 'YIELD_GOLD'),
	('GOLDEN_NATIONAL_STOCK_EXCHANGE_GOLD_PLUS', 'Amount', '15'),
	
	('GOLDEN_NATIONAL_SHRINE_FAITH', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_SHRINE_FAITH', 'Amount', '5'),
	('GOLDEN_NATIONAL_SHRINE_FAITH_PLUS', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_SHRINE_FAITH_PLUS', 'Amount', '5'),
	('GOLDEN_NATIONAL_TEMPLE_FAITH', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_TEMPLE_FAITH', 'Amount', '10'),
	('GOLDEN_NATIONAL_TEMPLE_FAITH_PLUS', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_TEMPLE_FAITH_PLUS', 'Amount', '10'),
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH', 'Amount', '15'),
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH_PLUS', 'YieldType', 'YIELD_FAITH'),
	('GOLDEN_NATIONAL_CATHEDRAL_FAITH_PLUS', 'Amount', '15'),
	
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION', 'Amount', '5'),
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION_PLUS', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_WORKSHOP_PRODUCTION_PLUS', 'Amount', '5'),
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION', 'Amount', '10'),
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION_PLUS', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_FACTORY_PRODUCTION_PLUS', 'Amount', '10'),
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION', 'Amount', '15'),
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION_PLUS', 'YieldType', 'YIELD_PRODUCTION'),
	('GOLDEN_NATIONAL_POWER_STATION_PRODUCTION_PLUS', 'Amount', '15'),
	
	-- ('GOLDEN_NATIONAL_BARRACKS_GROWTH', 'Amount', '5'),
	('GOLDEN_NATIONAL_BARRACKS_GROWTH_PLUS', 'Amount', '10'),
	-- ('GOLDEN_NATIONAL_ARMORY_GROWTH', 'Amount', '10'),
	('GOLDEN_NATIONAL_ARMORY_GROWTH_PLUS', 'Amount', '20'),
	-- ('GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH', 'Amount', '15'),
	('GOLDEN_NATIONAL_MILITARY_ACADEMY_GROWTH_PLUS', 'Amount', '30');
	