-- delete national wonders on city transfer, from Serp/LeeS
local nationaltypes = {"BUILDING_NATIONAL_LIBRARY","BUILDING_NATIONAL_COLLEGE","BUILDING_NATIONAL_RESEARCH_LAB",
"BUILDING_NATIONAL_MARKET","BUILDING_NATIONAL_BANK","BUILDING_NATIONAL_STOCK_EXCHANGE",
"BUILDING_NATIONAL_WORKSHOP","BUILDING_NATIONAL_FACTORY",
"BUILDING_NATIONAL_SHRINE","BUILDING_NATIONAL_TEMPLE",
"BUILDING_NATIONAL_AMPHITHEATER","BUILDING_NATIONAL_MUSEUM","BUILDING_NATIONAL_BROADCAST_CENTER",
"BUILDING_NATIONAL_BARRACKS","BUILDING_NATIONAL_ARMORY","BUILDING_NATIONAL_MILITARY_ACADEMY"}
local function OnCityTransfered(playerID,cityID) -- playerID is the new owner
    local pPlayer = Players[playerID];
    if pPlayer~=nil then
        local playercities = pPlayer:GetCities();
        local pCity = playercities:FindID( cityID );
        if pCity~=nil then
            local citybuildings = pCity:GetBuildings();
            for _,nationaltype in ipairs(nationaltypes) do
				local tNationalRowData = GameInfo.Buildings[nationaltype]
				if tNationalRowData ~= nil then
					local natioanlID = tNationalRowData.Index
					local nationalName = Locale.Lookup(tNationalRowData.Name)
					if citybuildings:HasBuilding(natioanlID) then
						print("DeleteNational: City transfered, delete found national wonder " .. nationalName)
						citybuildings:RemoveBuilding(natioanlID);
						if pPlayer:IsHuman() then
							local sText = nationalName .. " [COLOR_Civ6Red]destroyed![ENDCOLOR]"
							Game.AddWorldViewText(EventSubTypes.DAMAGE, sText, pCity:GetX(), pCity:GetY(), 0)
						end
					end
				end
			end
        end
    end
end

Events.CityTransfered.Add(OnCityTransfered);