--------------------------------------------------------------
-- 战略资源-GS
--------------------------------------------------------------
-- Types
INSERT OR REPLACE INTO Types (Type, Kind)
SELECT	'POLICY_RESOURCE_RECYCLE', 'KIND_POLICY' FROM Leaders WHERE LeaderType='LEADER_DIDO';
-- Policies
INSERT OR REPLACE INTO Policies (PolicyType, Name, Description, PrereqCivic, GovernmentSlotType)
SELECT	'POLICY_RESOURCE_RECYCLE', 'LOC_POLICY_RESOURCE_RECYCLE_NAME', 'LOC_POLICY_RESOURCE_RECYCLE_DESCRIPTION', 'CIVIC_ENVIRONMENTALISM', 'SLOT_MILITARY' FROM Leaders WHERE LeaderType='LEADER_DIDO';
-- ObsoletePolicies
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
SELECT	'POLICY_EQUESTRIAN_ORDERS', 'POLICY_DRILL_MANUALS' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
SELECT	'POLICY_DRILL_MANUALS', 'POLICY_RESOURCE_MANAGEMENT' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
SELECT	'POLICY_RESOURCE_MANAGEMENT', 'POLICY_RESOURCE_RECYCLE' FROM Leaders WHERE LeaderType='LEADER_DIDO';
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_DRILL_MANUALS', 'EQUESTRIAN_ORDERS_ADDITIONAL_HORSES_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_DRILL_MANUALS', 'EQUESTRIAN_ORDERS_ADDITIONAL_IRON_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_MANAGEMENT', 'EQUESTRIAN_ORDERS_ADDITIONAL_HORSES_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_MANAGEMENT', 'EQUESTRIAN_ORDERS_ADDITIONAL_IRON_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_MANAGEMENT', 'DRILL_MANUALS_ADDITIONAL_NITER_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_MANAGEMENT', 'DRILL_MANUALS_ADDITIONAL_COAL_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'EQUESTRIAN_ORDERS_ADDITIONAL_HORSES_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'EQUESTRIAN_ORDERS_ADDITIONAL_IRON_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'DRILL_MANUALS_ADDITIONAL_NITER_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'DRILL_MANUALS_ADDITIONAL_COAL_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'RESOURCE_MANAGEMENT_ADDITIONAL_ALUMINUM_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'RESOURCE_MANAGEMENT_ADDITIONAL_OIL_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
SELECT	'POLICY_RESOURCE_RECYCLE', 'GOLDEN_RESOURCE_RECYCLE_ADDITIONAL_URANIUM_EXTRACTION' FROM Leaders WHERE LeaderType='LEADER_DIDO';
-- Modifiers
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType)
SELECT	'GOLDEN_RESOURCE_RECYCLE_ADDITIONAL_URANIUM_EXTRACTION', 'MODIFIER_PLAYER_ADJUST_RESOURCE_ACCUMULATION_MODIFIER' FROM Leaders WHERE LeaderType='LEADER_DIDO';
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_RESOURCE_RECYCLE_ADDITIONAL_URANIUM_EXTRACTION', 'Amount', 2 FROM Leaders WHERE LeaderType='LEADER_DIDO';
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
SELECT	'GOLDEN_RESOURCE_RECYCLE_ADDITIONAL_URANIUM_EXTRACTION', 'ResourceType', 'RESOURCE_URANIUM' FROM Leaders WHERE LeaderType='LEADER_DIDO';
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'EQUESTRIAN_ORDERS_ADDITIONAL_HORSES_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'EQUESTRIAN_ORDERS_ADDITIONAL_IRON_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'DRILL_MANUALS_ADDITIONAL_NITER_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'DRILL_MANUALS_ADDITIONAL_COAL_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'RESOURCE_MANAGEMENT_ADDITIONAL_ALUMINUM_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
UPDATE ModifierArguments SET Value = 2
WHERE ModifierId = 'RESOURCE_MANAGEMENT_ADDITIONAL_OIL_EXTRACTION' AND Name='Amount' AND EXISTS (SELECT LeaderType FROM Leaders WHERE LeaderType='LEADER_DIDO');
--------------------------------------------------------------
-- 驻军-RF
--------------------------------------------------------------
-- Types
INSERT OR REPLACE INTO Types(Type, Kind)
VALUES	('POLICY_LIVELIHOOD_ARMY', 'KIND_POLICY');
-- Policies
INSERT OR REPLACE INTO Policies (PolicyType, Name, Description, PrereqCivic, GovernmentSlotType)
VALUES	('POLICY_LIVELIHOOD_ARMY', 'LOC_POLICY_LIVELIHOOD_ARMY_NAME', 'LOC_POLICY_LIVELIHOOD_ARMY_DESCRIPTION', 'CIVIC_MOBILIZATION', 'SLOT_MILITARY');
UPDATE Policies SET PrereqCivic = 'CIVIC_SOCIAL_MEDIA' WHERE PolicyType = 'POLICY_PROPAGANDA' ;
-- ObsoletePolicies
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
VALUES	('POLICY_LIMITANEI', 'POLICY_RETAINERS'), 
        ('POLICY_LIVELIHOOD_ARMY', 'POLICY_PROPAGANDA');
UPDATE ObsoletePolicies SET ObsoletePolicy = 'POLICY_LIVELIHOOD_ARMY' WHERE PolicyType = 'POLICY_RETAINERS';
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_LIMITANEI', 'GOLDEN_LIMITANEI_AMENITYBONUS') ,
        ('POLICY_RETAINERS', 'GOLDEN_RETAINERS_GARRISONIDENTITY') ,
	    ('POLICY_LIVELIHOOD_ARMY', 'GOLDEN_LIVELIHOOD_ARMY_AMENITYBONUS') ,
        ('POLICY_LIVELIHOOD_ARMY', 'GOLDEN_LIVELIHOOD_ARMY_GARRISONIDENTITY') ,
        ('POLICY_PROPAGANDA', 'GOLDEN_PROPAGANDA_AMENITYBONUS'),
        ('POLICY_PROPAGANDA', 'GOLDEN_PROPAGANDA_GARRISONIDENTITY') ;
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_PROPAGANDA' AND ModifierId = 'PROPAGANDA_OVERALLWARWEARINESS';
-- Modifiers
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, SubjectRequirementSetId)
VALUES	('GOLDEN_LIMITANEI_AMENITYBONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_AMENITY', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
        ('GOLDEN_RETAINERS_GARRISONIDENTITY', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
     	('GOLDEN_LIVELIHOOD_ARMY_AMENITYBONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_AMENITY', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
	    ('GOLDEN_LIVELIHOOD_ARMY_GARRISONIDENTITY', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
	    ('GOLDEN_PROPAGANDA_AMENITYBONUS', 'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_AMENITY', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT'),
        ('GOLDEN_PROPAGANDA_GARRISONIDENTITY', 'MODIFIER_PLAYER_CITIES_ADJUST_IDENTITY_PER_TURN', 'CITY_HAS_GARRISON_UNIT_REQUIERMENT');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	('GOLDEN_LIMITANEI_AMENITYBONUS', 'Amount', 1),
	    ('GOLDEN_RETAINERS_GARRISONIDENTITY', 'Amount', 4),
	    ('GOLDEN_LIVELIHOOD_ARMY_AMENITYBONUS', 'Amount', 3),
	    ('GOLDEN_LIVELIHOOD_ARMY_GARRISONIDENTITY', 'Amount', 6),
        ('GOLDEN_PROPAGANDA_AMENITYBONUS', 'Amount', 4),
	    ('GOLDEN_PROPAGANDA_GARRISONIDENTITY', 'Amount', 8);
UPDATE ModifierArguments SET Value = 2 WHERE ModifierId = 'RETAINERS_AMENITYBONUS' AND Name = 'Amount';
--------------------------------------------------------------
-- 单位经验值
--------------------------------------------------------------
-- Types
INSERT OR REPLACE INTO Types(Type, Kind)
VALUES	('POLICY_TRAINING', 'KIND_POLICY'),
        ('POLICY_SPECIAL_FORCES', 'KIND_POLICY');
-- Policies
INSERT OR REPLACE INTO Policies (PolicyType, Name, Description, PrereqCivic, GovernmentSlotType)
VALUES	('POLICY_TRAINING', 'LOC_POLICY_TRAINING_NAME', 'LOC_POLICY_TRAINING_DESCRIPTION', 'CIVIC_MILITARY_TRADITION', 'SLOT_MILITARY'),
        ('POLICY_SPECIAL_FORCES', 'LOC_POLICY_SPECIAL_FORCES_NAME', 'LOC_POLICY_SPECIAL_FORCES_DESCRIPTION', 'CIVIC_MERCENARIES', 'SLOT_MILITARY');
UPDATE Policies SET PrereqCivic = 'CIVIC_MOBILIZATION' WHERE PolicyType = 'POLICY_AFTER_ACTION_REPORTS' ;		
-- ObsoletePolicies
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
VALUES	('POLICY_TRAINING', 'POLICY_SPECIAL_FORCES'), 
        ('POLICY_SPECIAL_FORCES', 'POLICY_AFTER_ACTION_REPORTS');
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_TRAINING', 'GOLDEN_TRAINING_EXPERIENCE') ,
        ('POLICY_SPECIAL_FORCES', 'GOLDEN_SPECIAL_FORCES_EXPERIENCE');	
-- Modifiers
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType)
VALUES	('GOLDEN_TRAINING_EXPERIENCE', 'MODIFIER_PLAYER_UNITS_ADJUST_UNIT_EXPERIENCE_MODIFIER'),
        ('GOLDEN_SPECIAL_FORCES_EXPERIENCE', 'MODIFIER_PLAYER_UNITS_ADJUST_UNIT_EXPERIENCE_MODIFIER');		
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	('GOLDEN_TRAINING_EXPERIENCE', 'Amount', 25),
	    ('GOLDEN_SPECIAL_FORCES_EXPERIENCE', 'Amount', 50);		
UPDATE ModifierArguments SET Value = 100 WHERE ModifierId = 'AFTERACTIONREPORTS_EXPERIENCE' AND Name = 'Amount';	
--------------------------------------------------------------
-- 生产单位加速
--------------------------------------------------------------
-- Policies
UPDATE Policies SET PrereqCivic = 'CIVIC_FEUDALISM'       WHERE PolicyType = 'POLICY_CHIVALRY' ;		
UPDATE Policies SET PrereqCivic = 'CIVIC_NAVAL_TRADITION' WHERE PolicyType = 'POLICY_PRESS_GANGS' ;		
UPDATE Policies SET PrereqCivic = 'CIVIC_MOBILIZATION'    WHERE PolicyType = 'POLICY_LIGHTNING_WARFARE' ;		
UPDATE Policies SET PrereqCivic = 'CIVIC_SPACE_RACE'      WHERE PolicyType = 'POLICY_STRATEGIC_AIR_FORCE' ;	
-- ObsoletePolicies
DELETE FROM ObsoletePolicies WHERE PolicyType = 'POLICY_MANEUVER' AND ObsoletePolicy = 'POLICY_LIGHTNING_WARFARE';	
DELETE FROM ObsoletePolicies WHERE PolicyType = 'POLICY_MARITIME_INDUSTRIES' AND ObsoletePolicy = 'POLICY_INTERNATIONAL_WATERS';	
-- PolicyModifiers
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_AGOGE' AND ModifierId = 'AGOGE_ANCIENT_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_AGOGE' AND ModifierId = 'AGOGE_CLASSICAL_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_FEUDAL_CONTRACT' AND ModifierId = 'FEUDALCONTRACT_MEDIEVAL_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_FEUDAL_CONTRACT' AND ModifierId = 'FEUDALCONTRACT_RENAISSANCE_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_GRANDE_ARMEE' AND ModifierId = 'GRANDEARMEE_INDUSTRIAL_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_GRANDE_ARMEE' AND ModifierId = 'GRANDEARMEE_MODERN_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_MILITARY_FIRST' AND ModifierId = 'MILITARYFIRST_ATOMIC_ANTI_CAVALRY_PRODUCTION';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_MILITARY_FIRST' AND ModifierId = 'MILITARYFIRST_INFORMATION_ANTI_CAVALRY_PRODUCTION';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_AGOGE', 'GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION'),
        ('POLICY_AGOGE', 'GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION'),
		('POLICY_FEUDAL_CONTRACT', 'GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION'),
		('POLICY_FEUDAL_CONTRACT', 'GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION'),
		('POLICY_FEUDAL_CONTRACT', 'GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION'),
		('POLICY_FEUDAL_CONTRACT', 'GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION'),		
		('POLICY_GRANDE_ARMEE', 'GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION'),
		('POLICY_GRANDE_ARMEE', 'GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION'),
		('POLICY_GRANDE_ARMEE', 'GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION'),
		('POLICY_GRANDE_ARMEE', 'GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION'),
		('POLICY_GRANDE_ARMEE', 'GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION'),
		('POLICY_GRANDE_ARMEE', 'GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION'),		
		('POLICY_MILITARY_FIRST', 'GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_MILITARYFIRST_ATOMIC_SIEGE_PRODUCTION'),
		('POLICY_MILITARY_FIRST', 'GOLDEN_MILITARYFIRST_INFORMATION_SIEGE_PRODUCTION'),		
		('POLICY_MANEUVER', 'AGOGE_ANCIENT_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_MANEUVER', 'AGOGE_CLASSICAL_ANTI_CAVALRY_PRODUCTION'),		
		('POLICY_CHIVALRY', 'AGOGE_ANCIENT_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_CHIVALRY', 'AGOGE_CLASSICAL_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_CHIVALRY', 'FEUDALCONTRACT_MEDIEVAL_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_CHIVALRY', 'FEUDALCONTRACT_RENAISSANCE_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_CHIVALRY', 'GRANDEARMEE_INDUSTRIAL_ANTI_CAVALRY_PRODUCTION'),		
		('POLICY_LIGHTNING_WARFARE', 'AGOGE_ANCIENT_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'AGOGE_CLASSICAL_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'FEUDALCONTRACT_MEDIEVAL_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'FEUDALCONTRACT_RENAISSANCE_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'GRANDEARMEE_INDUSTRIAL_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'GRANDEARMEE_MODERN_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'MILITARYFIRST_ATOMIC_ANTI_CAVALRY_PRODUCTION'),
		('POLICY_LIGHTNING_WARFARE', 'MILITARYFIRST_INFORMATION_ANTI_CAVALRY_PRODUCTION');	
-- Modifiers	
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType) VALUES	
('GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),	
('GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_MILITARYFIRST_ATOMIC_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION'),
('GOLDEN_MILITARYFIRST_INFORMATION_SIEGE_PRODUCTION', 'MODIFIER_PLAYER_CITIES_ADJUST_UNIT_TAG_ERA_PRODUCTION');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value, Extra) VALUES	
('GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION', 'EraType', 'ERA_ANCIENT', -1),
('GOLDEN_AGOGE_ANCIENT_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION', 'EraType', 'ERA_CLASSICAL', -1),
('GOLDEN_AGOGE_CLASSICAL_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION', 'EraType', 'ERA_MEDIEVAL', -1),
('GOLDEN_FEUDALCONTRACT_MEDIEVAL_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION', 'EraType', 'ERA_RENAISSANCE', -1),
('GOLDEN_FEUDALCONTRACT_RENAISSANCE_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION', 'EraType', 'ERA_INDUSTRIAL', -1),
('GOLDEN_GRANDEARMEE_INDUSTRIAL_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION', 'EraType', 'ERA_MODERN', -1),
('GOLDEN_GRANDEARMEE_MODERN_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_MILITARYFIRST_ATOMIC_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_MILITARYFIRST_ATOMIC_SIEGE_PRODUCTION', 'EraType', 'ERA_ATOMIC', -1),
('GOLDEN_MILITARYFIRST_ATOMIC_SIEGE_PRODUCTION', 'Amount', 50, -1),
('GOLDEN_MILITARYFIRST_INFORMATION_SIEGE_PRODUCTION', 'UnitPromotionClass', 'PROMOTION_CLASS_SIEGE', -1),
('GOLDEN_MILITARYFIRST_INFORMATION_SIEGE_PRODUCTION', 'EraType', 'ERA_INFORMATION', -1),
('GOLDEN_MILITARYFIRST_INFORMATION_SIEGE_PRODUCTION', 'Amount', 50, -1);
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_ANCIENT_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_CLASSICAL_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_ANCIENT_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_CLASSICAL_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_ANCIENT_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'MARITIMIEINDUSTRIES_CLASSICAL_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_RENAISSANCE_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_INDUSTRIAL_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_RENAISSANCE_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_INDUSTRIAL_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_RENAISSANCE_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'PRESSGANGS_INDUSTRIAL_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_MODERN_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_ATOMIC_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_INFORMATION_NAVAL_MELEE_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_MODERN_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_ATOMIC_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_INFORMATION_NAVAL_RANGED_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_MODERN_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_ATOMIC_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
UPDATE ModifierArguments SET Value = 50 WHERE ModifierId = 'INTERNATIONALWATERS_INFORMATION_NAVAL_RAIDER_PRODUCTION' AND Name = 'Amount';	
--------------------------------------------------------------
-- 单位维护费
--------------------------------------------------------------
-- Types
INSERT OR REPLACE INTO Types(Type, Kind)
VALUES	('POLICY_OPTIMAL_MANAGEMENT', 'KIND_POLICY');
-- Policies
INSERT OR REPLACE INTO Policies (PolicyType, Name, Description, PrereqCivic, GovernmentSlotType)
VALUES	('POLICY_OPTIMAL_MANAGEMENT', 'LOC_POLICY_OPTIMAL_MANAGEMENT_NAME', 'LOC_POLICY_OPTIMAL_MANAGEMENT_DESCRIPTION', 'CIVIC_ENVIRONMENTALISM', 'SLOT_MILITARY');
-- ObsoletePolicies
INSERT OR REPLACE INTO ObsoletePolicies (PolicyType, ObsoletePolicy)
VALUES	('POLICY_LEVEE_EN_MASSE', 'POLICY_OPTIMAL_MANAGEMENT');
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_OPTIMAL_MANAGEMENT', 'GOLDEN_OPTIMAL_MANAGEMENT_UNITMAINTENANCEDISCOUNT') ;
-- Modifiers
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType)
VALUES	('GOLDEN_OPTIMAL_MANAGEMENT_UNITMAINTENANCEDISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_MAINTENANCE_DISCOUNT');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	('GOLDEN_OPTIMAL_MANAGEMENT_UNITMAINTENANCEDISCOUNT', 'Amount', 3);
UPDATE ModifierArguments SET Value = 2 WHERE ModifierId = 'LEVEEENMASSE_UNITMAINTENANCEDISCOUNT' AND Name = 'Amount';
--------------------------------------------------------------
-- 掠夺
--------------------------------------------------------------
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_RAID', 'GOLDEN_RAID_PLUNDER_BONUS') ;
-- Modifiers
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType)
VALUES	('GOLDEN_RAID_PLUNDER_BONUS', 'MODIFIER_PLAYER_UNITS_ADJUST_PLUNDER_YIELDS');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	('GOLDEN_RAID_PLUNDER_BONUS', 'Amount', 50);
UPDATE ModifierArguments SET Value = 100 WHERE ModifierId = 'TOTAL_WAR_PLUNDER_BONUS' AND Name = 'Amount';
UPDATE ModifierArguments SET Value = 100 WHERE ModifierId = 'TOTALWAR_DOUBLEPILLAGEDISTRICT' AND Name = 'Amount';
UPDATE ModifierArguments SET Value = 100 WHERE ModifierId = 'TOTALWAR_DOUBLEPILLAGEIMPROVE' AND Name = 'Amount';
--------------------------------------------------------------
-- 城市防御
--------------------------------------------------------------
-- Policies
UPDATE Policies SET PrereqCivic = 'CIVIC_CIVIL_ENGINEERING' WHERE PolicyType = 'POLICY_BASTIONS' ;
-- ObsoletePolicies
UPDATE ObsoletePolicies SET ObsoletePolicy = 'POLICY_BASTIONS' WHERE PolicyType = 'POLICY_LIMES';
UPDATE ObsoletePolicies SET ObsoletePolicy = 'POLICY_SECOND_STRIKE_CAPABILITY' WHERE PolicyType = 'POLICY_BASTIONS';
-- PolicyModifiers
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)
VALUES	('POLICY_BASTIONS', 'LIMES_CASTLEPRODUCTION'),
        ('POLICY_BASTIONS', 'LIMES_WALLSPRODUCTION'),
		('POLICY_BASTIONS', 'LIMES_STARFORTPRODUCTION'),
		('POLICY_LIMES', 'GOLDEN_LIMES_OUTERDEFENSE'),
		('POLICY_LIMES', 'GOLDEN_LIMES_RANGEDSTRIKE'),
		('POLICY_SECOND_STRIKE_CAPABILITY', 'GOLDEN_SECOND_STRIKE_CAPABILITY_OUTERDEFENSE'),		
		('POLICY_SECOND_STRIKE_CAPABILITY', 'GOLDEN_SECOND_STRIKE_CAPABILITY_RANGEDSTRIKE');
-- ModifierArguments		
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType) VALUES	
('GOLDEN_LIMES_OUTERDEFENSE', 'MODIFIER_PLAYER_CITIES_ADJUST_OUTER_DEFENSE'),	
('GOLDEN_LIMES_RANGEDSTRIKE', 'MODIFIER_PLAYER_CITIES_ADJUST_RANGED_STRIKE'),
('GOLDEN_SECOND_STRIKE_CAPABILITY_OUTERDEFENSE', 'MODIFIER_PLAYER_CITIES_ADJUST_OUTER_DEFENSE'),
('GOLDEN_SECOND_STRIKE_CAPABILITY_RANGEDSTRIKE', 'MODIFIER_PLAYER_CITIES_ADJUST_RANGED_STRIKE');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value)
VALUES	('GOLDEN_LIMES_OUTERDEFENSE', 'Amount', 4),
        ('GOLDEN_LIMES_RANGEDSTRIKE', 'Amount', 4),
		('GOLDEN_SECOND_STRIKE_CAPABILITY_OUTERDEFENSE', 'Amount', 10),
		('GOLDEN_SECOND_STRIKE_CAPABILITY_RANGEDSTRIKE', 'Amount', 10);
UPDATE ModifierArguments SET Value = 7 WHERE ModifierId = 'BASTIONS_OUTERDEFENSE' AND Name = 'Amount';
UPDATE ModifierArguments SET Value = 7 WHERE ModifierId = 'BASTIONS_RANGEDSTRIKE' AND Name = 'Amount';	
--------------------------------------------------------------
-- 单位升级
--------------------------------------------------------------
-- PolicyModifiers
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_RETINUES';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_PROFESSIONAL_ARMY';
DELETE FROM PolicyModifiers WHERE PolicyType = 'POLICY_FORCE_MODERNIZATION';
INSERT OR REPLACE INTO PolicyModifiers (PolicyType, ModifierId)VALUES	
('POLICY_RETINUES', 'GOLDEN_RETINUES_UNITUPGRADEDISCOUNT'),
('POLICY_RETINUES', 'GOLDEN_RETINUES_UPGRADE_RESOURCE_DISCOUNT'),
('POLICY_PROFESSIONAL_ARMY', 'GOLDEN_PROFESSIONAL_ARMY_UNITUPGRADEDISCOUNT'),
('POLICY_PROFESSIONAL_ARMY', 'GOLDEN_PROFESSIONAL_ARMY_UPGRADE_RESOURCE_DISCOUNT'),
('POLICY_FORCE_MODERNIZATION', 'GOLDEN_FORCE_MODERNIZATION_UNITUPGRADEDISCOUNT'),
('POLICY_FORCE_MODERNIZATION', 'GOLDEN_FORCE_MODERNIZATION_UPGRADE_RESOURCE_DISCOUNT');
-- ModifierArguments		
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType) VALUES	
('GOLDEN_RETINUES_UNITUPGRADEDISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_DISCOUNT_PERCENT'),	
('GOLDEN_RETINUES_UPGRADE_RESOURCE_DISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_RESOURCE_COST_MODIFIER'),
('GOLDEN_PROFESSIONAL_ARMY_UNITUPGRADEDISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_DISCOUNT_PERCENT'),	
('GOLDEN_PROFESSIONAL_ARMY_UPGRADE_RESOURCE_DISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_RESOURCE_COST_MODIFIER'),
('GOLDEN_FORCE_MODERNIZATION_UNITUPGRADEDISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_DISCOUNT_PERCENT'),	
('GOLDEN_FORCE_MODERNIZATION_UPGRADE_RESOURCE_DISCOUNT', 'MODIFIER_PLAYER_ADJUST_UNIT_UPGRADE_RESOURCE_COST_MODIFIER');
-- ModifierArguments
INSERT OR REPLACE INTO ModifierArguments (ModifierId, Name, Value) VALUES	
('GOLDEN_RETINUES_UNITUPGRADEDISCOUNT', 'Amount', 25),
('GOLDEN_RETINUES_UPGRADE_RESOURCE_DISCOUNT', 'Amount', 25),
('GOLDEN_PROFESSIONAL_ARMY_UNITUPGRADEDISCOUNT', 'Amount', 50),
('GOLDEN_PROFESSIONAL_ARMY_UPGRADE_RESOURCE_DISCOUNT', 'Amount', 50),
('GOLDEN_FORCE_MODERNIZATION_UNITUPGRADEDISCOUNT', 'Amount', 75),
('GOLDEN_FORCE_MODERNIZATION_UPGRADE_RESOURCE_DISCOUNT', 'Amount', 75);
	