---------------------------------------------------------
--Populations
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId , RequirementSetType) 	
VALUES 		('GOLDEN_CITY_HAS_SIX_POPULATION_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_CITY_HAS_SEVEN_POPULATION_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_CITY_HAS_EIGHT_POPULATION_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TWELVE_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_FOURTEEN_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_CITY_HAS_SIXTEEN_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),					
			('GOLDEN_CITY_HAS_EIGHTEEN_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TWENTYONE_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TWENTYFOUR_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_TWENTYEIGHT_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_THIRTYTWO_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),						
			('GOLDEN_CITY_HAS_THIRTYSIX_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_CITY_HAS_FIFTY_POPULATION_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL');						
INSERT OR REPLACE INTO RequirementSets 				
(RequirementSetId ,                                         RequirementSetType) 	VALUES 		
('GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			
VALUES 		('GOLDEN_CITY_HAS_SIX_POPULATION_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_HAS_SIX_POPULATION'),
            ('GOLDEN_CITY_HAS_SEVEN_POPULATION_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_HAS_SEVEN_POPULATION'),
            ('GOLDEN_CITY_HAS_EIGHT_POPULATION_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_HAS_EIGHT_POPULATION'),
			('GOLDEN_CITY_HAS_TEN_POPULATION_REQUIREMENTS' , 			'GOLDEN_REQUIRES_CITY_HAS_TEN_POPULATION'),
			('GOLDEN_CITY_HAS_TWELVE_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_TWELVE_POPULATION'),
			('GOLDEN_CITY_HAS_FOURTEEN_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_FOURTEEN_POPULATION'),
            ('GOLDEN_CITY_HAS_SIXTEEN_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_SIXTEEN_POPULATION'),					
			('GOLDEN_CITY_HAS_EIGHTEEN_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_EIGHTEEN_POPULATION'),
			('GOLDEN_CITY_HAS_TWENTY_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_TWENTY_POPULATION'),
			('GOLDEN_CITY_HAS_TWENTYONE_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_TWENTYONE_POPULATION'),
			('GOLDEN_CITY_HAS_TWENTYFOUR_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_HAS_TWENTYFOUR_POPULATION'),
			('GOLDEN_CITY_HAS_TWENTYEIGHT_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_HAS_TWENTYEIGHT_POPULATION'),
			('GOLDEN_CITY_HAS_THIRTY_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_THIRTY_POPULATION'),
			('GOLDEN_CITY_HAS_THIRTYTWO_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_THIRTYTWO_POPULATION'),						
			('GOLDEN_CITY_HAS_THIRTYSIX_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_THIRTYSIX_POPULATION'),
			('GOLDEN_CITY_HAS_FOURTY_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_FOURTY_POPULATION'),
			('GOLDEN_CITY_HAS_FIFTY_POPULATION_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_CITY_HAS_FIFTY_POPULATION');				
INSERT OR REPLACE INTO RequirementSetRequirements 	
(RequirementSetId ,                                         RequirementId) 	VALUES 		
('GOLDEN_CITY_DONT_HAVE_TEN_POPULATION_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_DONT_HAVE_TEN_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_TWENTY_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_TWENTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_THIRTY_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_THIRTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_FOURTY_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_FOURTY_POPULATION'),
('GOLDEN_CITY_DONT_HAVE_FIFTY_POPULATION_REQUIREMENTS' , 	'GOLDEN_REQUIRES_CITY_DONT_HAVE_FIFTY_POPULATION');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,							RequirementType)
VALUES						('GOLDEN_REQUIRES_CITY_HAS_SIX_POPULATION',				'REQUIREMENT_CITY_HAS_X_POPULATION'),
                            ('GOLDEN_REQUIRES_CITY_HAS_SEVEN_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_EIGHT_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TEN_POPULATION',				'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TWELVE_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_FOURTEEN_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_SIXTEEN_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_EIGHTEEN_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTY_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYONE_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYFOUR_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYEIGHT_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_THIRTY_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_THIRTYTWO_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),										
							('GOLDEN_REQUIRES_CITY_HAS_THIRTYSIX_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_FOURTY_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION'),
							('GOLDEN_REQUIRES_CITY_HAS_FIFTY_POPULATION',			'REQUIREMENT_CITY_HAS_X_POPULATION');							
INSERT OR REPLACE INTO 		Requirements 
(RequirementId,							                RequirementType,			             Inverse) VALUES						
('GOLDEN_REQUIRES_CITY_DONT_HAVE_TEN_POPULATION',		'REQUIREMENT_CITY_HAS_X_POPULATION',     1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_TWENTY_POPULATION',	'REQUIREMENT_CITY_HAS_X_POPULATION',     1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_THIRTY_POPULATION',	'REQUIREMENT_CITY_HAS_X_POPULATION',     1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_FOURTY_POPULATION',	'REQUIREMENT_CITY_HAS_X_POPULATION',     1),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_FIFTY_POPULATION',	    'REQUIREMENT_CITY_HAS_X_POPULATION',     1);
--RequirementArguments		
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,				Name,			Value)
VALUES						('GOLDEN_REQUIRES_CITY_HAS_SIX_POPULATION',			'Amount',		6),
                            ('GOLDEN_REQUIRES_CITY_HAS_SEVEN_POPULATION',		'Amount',		7),
							('GOLDEN_REQUIRES_CITY_HAS_EIGHT_POPULATION',		'Amount',		8),
							('GOLDEN_REQUIRES_CITY_HAS_TEN_POPULATION',			'Amount',		10),
							('GOLDEN_REQUIRES_CITY_HAS_TWELVE_POPULATION',		'Amount',		12),
							('GOLDEN_REQUIRES_CITY_HAS_FOURTEEN_POPULATION',	'Amount',		14),
							('GOLDEN_REQUIRES_CITY_HAS_SIXTEEN_POPULATION',		'Amount',		16),
							('GOLDEN_REQUIRES_CITY_HAS_EIGHTEEN_POPULATION',	'Amount',		18),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTY_POPULATION',		'Amount',		20),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYONE_POPULATION',	'Amount',		21),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYFOUR_POPULATION',	'Amount',		24),
							('GOLDEN_REQUIRES_CITY_HAS_TWENTYEIGHT_POPULATION',	'Amount',		28),
							('GOLDEN_REQUIRES_CITY_HAS_THIRTY_POPULATION',		'Amount',		30),
							('GOLDEN_REQUIRES_CITY_HAS_THIRTYTWO_POPULATION',	'Amount',		32),
							('GOLDEN_REQUIRES_CITY_HAS_THIRTYSIX_POPULATION',	'Amount',		36),
							('GOLDEN_REQUIRES_CITY_HAS_FOURTY_POPULATION',		'Amount',		40),
							('GOLDEN_REQUIRES_CITY_HAS_FIFTY_POPULATION',		'Amount',		50);
INSERT OR REPLACE INTO 		RequirementArguments 
(RequirementId,				                         Name,			Value) VALUES						
('GOLDEN_REQUIRES_CITY_DONT_HAVE_TEN_POPULATION',    'Amount',		10),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_TWENTY_POPULATION', 'Amount',		20),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_THIRTY_POPULATION', 'Amount',		30),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_FOURTY_POPULATION', 'Amount',		40),
('GOLDEN_REQUIRES_CITY_DONT_HAVE_FIFTY_POPULATION',  'Amount',		50);		
---------------------------------------------------------
--Districts
---------------------------------------------------------			
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES 		
('GOLDEN_DISTRICT_IS_WONDER_REQUIREMENT' , 		                'REQUIREMENTSET_TEST_ALL');
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES 		
('GOLDEN_DISTRICT_IS_NOT_AQUEDUCT_REQUIREMENTS' , 			    'REQUIREMENTSET_TEST_ALL');		
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			VALUES 		
('GOLDEN_DISTRICT_IS_WONDER_REQUIREMENT' , 		                'REQUIRES_DISTRICT_IS_WORLD_WONDER');	
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			VALUES 		
('GOLDEN_DISTRICT_IS_NOT_AQUEDUCT_REQUIREMENTS' , 			    'GOLDEN_REQUIRES_DISTRICT_IS_NOT_AQUEDUCT');				
--Requirements	
INSERT OR REPLACE INTO 		Requirements (RequirementId,				                    RequirementType,			            Inverse) VALUES						
('GOLDEN_REQUIRES_DISTRICT_IS_NOT_AQUEDUCT',			        'REQUIREMENT_CITY_HAS_DISTRICT',        1);													
--RequirementArguments		
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		                    Name,			    Value) VALUES						
('GOLDEN_REQUIRES_DISTRICT_IS_NOT_AQUEDUCT',			        'DistrictType',		'DISTRICT_AQUEDUCT');		
-- 新写法
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_CITY_HAS_'|| DistrictType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Districts WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_CITY_HAS_'|| DistrictType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_CITY_HAS_' || DistrictType FROM Districts WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_CITY_HAS_' || DistrictType,	   'REQUIREMENT_CITY_HAS_DISTRICT' FROM Districts WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_CITY_HAS_' || DistrictType,		'DistrictType',	    DistrictType FROM Districts WHERE Cost<>0;	
---------------------------------------------------------
--District type match (plot)
---------------------------------------------------------
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLOT_HAS_'|| DistrictType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Districts WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_HAS_'|| DistrictType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_HAS_' || DistrictType FROM Districts WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || DistrictType,	   'REQUIREMENT_DISTRICT_TYPE_MATCHES' FROM Districts WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || DistrictType,		'DistrictType',	    DistrictType FROM Districts WHERE Cost<>0;					
---------------------------------------------------------
--DISTRICT Number
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				
(RequirementSetId ,     RequirementSetType) 	VALUES 		
('GOLDEN_CITY_HAS_1_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_HAS_2_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_HAS_4_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_HAS_6_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements	
INSERT OR REPLACE INTO RequirementSetRequirements 	
(RequirementSetId ,     RequirementId) 			VALUES 		
('GOLDEN_CITY_HAS_1_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_1_SPECIALTY_DISTRICTS'),
('GOLDEN_CITY_HAS_2_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS'),
('GOLDEN_CITY_HAS_4_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_4_SPECIALTY_DISTRICTS'),	
('GOLDEN_CITY_HAS_6_SPECIALTY_DISTRICTS_REQUIREMENTS' , 		'GOLDEN_REQUIRES_CITY_HAS_6_SPECIALTY_DISTRICTS');	
--Requirements
INSERT OR REPLACE INTO 		Requirements 
(RequirementId,				                    RequirementType) VALUES						
('GOLDEN_REQUIRES_CITY_HAS_1_SPECIALTY_DISTRICTS',			    'REQUIREMENT_CITY_HAS_X_SPECIALTY_DISTRICTS'),
('GOLDEN_REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS',			    'REQUIREMENT_CITY_HAS_X_SPECIALTY_DISTRICTS'),
('GOLDEN_REQUIRES_CITY_HAS_4_SPECIALTY_DISTRICTS',			    'REQUIREMENT_CITY_HAS_X_SPECIALTY_DISTRICTS'),		
('GOLDEN_REQUIRES_CITY_HAS_6_SPECIALTY_DISTRICTS',			    'REQUIREMENT_CITY_HAS_X_SPECIALTY_DISTRICTS');				
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments 
(RequirementId,		                    Name,			Value) VALUES						
('GOLDEN_REQUIRES_CITY_HAS_1_SPECIALTY_DISTRICTS',			    'Amount',		1),	
('GOLDEN_REQUIRES_CITY_HAS_2_SPECIALTY_DISTRICTS',		        'Amount',		2),
('GOLDEN_REQUIRES_CITY_HAS_4_SPECIALTY_DISTRICTS',		        'Amount',		4),
('GOLDEN_REQUIRES_CITY_HAS_6_SPECIALTY_DISTRICTS',		        'Amount',		6);	
---------------------------------------------------------
--DISTRICT ADJACENT
---------------------------------------------------------
--Requirements	
INSERT OR REPLACE INTO 		Requirements (RequirementId,				            RequirementType,			                              Inverse)
VALUES						('GOLDEN_REQUIRES_PLOT_NOT_ADJACENT_TO_DAM',			'REQUIREMENT_PLOT_ADJACENT_DISTRICT_TYPE_MATCHES',        1);							
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			    Value)
VALUES						('GOLDEN_REQUIRES_PLOT_NOT_ADJACENT_TO_DAM',			'DistrictType',		'DISTRICT_DAM');	
--新写法
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLOT_IS_ADJACENT_TO_'|| DistrictType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Districts WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_IS_ADJACENT_TO_'|| DistrictType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || DistrictType FROM Districts WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || DistrictType,	'REQUIREMENT_PLOT_ADJACENT_DISTRICT_TYPE_MATCHES' FROM Districts WHERE Cost<>0;
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_WITHIN_TWO_TILES_TO_' || DistrictType,	'REQUIREMENT_PLOT_ADJACENT_DISTRICT_TYPE_MATCHES' FROM Districts WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || DistrictType,		'DistrictType',	    DistrictType FROM Districts WHERE Cost<>0;	
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_WITHIN_TWO_TILES_TO_' || DistrictType,		'DistrictType',	    DistrictType FROM Districts WHERE Cost<>0;	
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_WITHIN_TWO_TILES_TO_' || DistrictType,		'MaxRange',	    2 FROM Districts WHERE Cost<>0;	
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_WITHIN_TWO_TILES_TO_' || DistrictType,		'MinRange',	    1 FROM Districts WHERE Cost<>0;	
---------------------------------------------------------
--DISTRICT ADJACENCY value
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_CAMPUS_HAS_TWO_ADJACENCY_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_TWO_ADJACENCY_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_HOLY_SITE_HAS_TWO_ADJACENCY_REQUIREMENTS' ,   		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_THEATER_HAS_TWO_ADJACENCY_REQUIREMENTS' ,     		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY_REQUIREMENTS' ,  'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_ENCAMPMENT_HAS_TWO_ADJACENCY_REQUIREMENTS' , 	    'REQUIREMENTSET_TEST_ALL');	
--RequirementSetRequirements	
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			
VALUES 		('GOLDEN_CAMPUS_HAS_TWO_ADJACENCY_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_CAMPUS_HAS_TWO_ADJACENCY'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_TWO_ADJACENCY_REQUIREMENTS' , 	'GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_TWO_ADJACENCY'),
			('GOLDEN_HOLY_SITE_HAS_TWO_ADJACENCY_REQUIREMENTS' ,   		'GOLDEN_REQUIRES_HOLY_SITE_HAS_TWO_ADJACENCY'),
			('GOLDEN_THEATER_HAS_TWO_ADJACENCY_REQUIREMENTS' , 	    	'GOLDEN_REQUIRES_THEATER_HAS_TWO_ADJACENCY'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY_REQUIREMENTS' , 	'GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY'),
			('GOLDEN_ENCAMPMENT_HAS_TWO_ADJACENCY_REQUIREMENTS' , 		'GOLDEN_REQUIRES_ENCAMPMENT_HAS_TWO_ADJACENCY');	
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				                    RequirementType)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_TWO_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_TWO_ADJACENCY',			'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_TWO_ADJACENCY', 			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_THEATER_HAS_TWO_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY',		    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_TWO_ADJACENCY',			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT');		
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		                Name,			    Value)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_TWO_ADJACENCY',			    'DistrictType',		'DISTRICT_CAMPUS'),	
                            ('GOLDEN_REQUIRES_CAMPUS_HAS_TWO_ADJACENCY',		        'YieldType',		'YIELD_SCIENCE'),
							('GOLDEN_REQUIRES_CAMPUS_HAS_TWO_ADJACENCY',			    'Amount',		    2),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_TWO_ADJACENCY',		'DistrictType',		'DISTRICT_COMMERCIAL_HUB'),	
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_TWO_ADJACENCY',		'YieldType',		'YIELD_GOLD'),
							('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_TWO_ADJACENCY',	    'Amount',		    2),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_TWO_ADJACENCY', 			'DistrictType',		'DISTRICT_HOLY_SITE'),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_TWO_ADJACENCY', 		    'YieldType',		'YIELD_FAITH'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_TWO_ADJACENCY', 			'Amount',		    2),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_TWO_ADJACENCY',			    'DistrictType',		'DISTRICT_THEATER'),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_TWO_ADJACENCY',		        'YieldType',		'YIELD_CULTURE'),
							('GOLDEN_REQUIRES_THEATER_HAS_TWO_ADJACENCY',			    'Amount',		    2),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY',		'DistrictType',		'DISTRICT_INDUSTRIAL_ZONE'),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY',		'YieldType',		'YIELD_PRODUCTION'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_TWO_ADJACENCY',		'Amount',		    2),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_TWO_ADJACENCY',			'DistrictType',		'DISTRICT_ENCAMPMENT'),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_TWO_ADJACENCY',		    'YieldType',		'YIELD_FOOD'),
							('GOLDEN_REQUIRES_ENCAMPMENT_HAS_TWO_ADJACENCY',			'Amount',		    2);
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_CAMPUS_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  		    'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  	'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_HOLY_SITE_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,   		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_THEATER_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,     		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,     'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_ENCAMPMENT_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  	    'REQUIREMENTSET_TEST_ALL');	
--RequirementSetRequirements	
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			
VALUES 		('GOLDEN_CAMPUS_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  		    'GOLDEN_REQUIRES_CAMPUS_HAS_FOUR_ADJACENCY'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  	'GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY'),
			('GOLDEN_HOLY_SITE_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,   		'GOLDEN_REQUIRES_HOLY_SITE_HAS_FOUR_ADJACENCY'),
			('GOLDEN_THEATER_HAS_FOUR_ADJACENCY_REQUIREMENTS' , 	    	'GOLDEN_REQUIRES_THEATER_HAS_FOUR_ADJACENCY'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY_REQUIREMENTS' , 	'GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY'),
			('GOLDEN_ENCAMPMENT_HAS_FOUR_ADJACENCY_REQUIREMENTS' ,  		'GOLDEN_REQUIRES_ENCAMPMENT_HAS_FOUR_ADJACENCY');	
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				                    RequirementType)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_FOUR_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY',			'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_FOUR_ADJACENCY',			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_THEATER_HAS_FOUR_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY',		    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_FOUR_ADJACENCY',			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT');		
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		                Name,			    Value)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_FOUR_ADJACENCY',			    'DistrictType',		'DISTRICT_CAMPUS'),	
                            ('GOLDEN_REQUIRES_CAMPUS_HAS_FOUR_ADJACENCY',		        'YieldType',		'YIELD_SCIENCE'),
							('GOLDEN_REQUIRES_CAMPUS_HAS_FOUR_ADJACENCY',			    'Amount',		    4),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY',		'DistrictType',		'DISTRICT_COMMERCIAL_HUB'),	
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY',		'YieldType',		'YIELD_GOLD'),
							('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_FOUR_ADJACENCY',	    'Amount',		    4),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_FOUR_ADJACENCY',			'DistrictType',		'DISTRICT_HOLY_SITE'),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_FOUR_ADJACENCY',		    'YieldType',		'YIELD_FAITH'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_FOUR_ADJACENCY',			'Amount',		    4),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_FOUR_ADJACENCY',			    'DistrictType',		'DISTRICT_THEATER'),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_FOUR_ADJACENCY',		        'YieldType',		'YIELD_CULTURE'),
							('GOLDEN_REQUIRES_THEATER_HAS_FOUR_ADJACENCY',			    'Amount',		    4),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY',		'DistrictType',		'DISTRICT_INDUSTRIAL_ZONE'),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY',		'YieldType',		'YIELD_PRODUCTION'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_FOUR_ADJACENCY',		'Amount',		    4),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_FOUR_ADJACENCY',			'DistrictType',		'DISTRICT_ENCAMPMENT'),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_FOUR_ADJACENCY',		    'YieldType',		'YIELD_FOOD'),
							('GOLDEN_REQUIRES_ENCAMPMENT_HAS_FOUR_ADJACENCY',			'Amount',		    4);
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_CAMPUS_HAS_SIX_ADJACENCY_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_SIX_ADJACENCY_REQUIREMENTS' , 	    'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_HOLY_SITE_HAS_SIX_ADJACENCY_REQUIREMENTS' ,    		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_THEATER_HAS_SIX_ADJACENCY_REQUIREMENTS' ,      		'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY_REQUIREMENTS' ,      'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_ENCAMPMENT_HAS_SIX_ADJACENCY_REQUIREMENTS' ,   	    'REQUIREMENTSET_TEST_ALL');	
--RequirementSetRequirements	
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			
VALUES 		('GOLDEN_CAMPUS_HAS_SIX_ADJACENCY_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_CAMPUS_HAS_SIX_ADJACENCY'),
            ('GOLDEN_COMMERCIAL_HUB_HAS_SIX_ADJACENCY_REQUIREMENTS' , 	'GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_SIX_ADJACENCY'),
			('GOLDEN_HOLY_SITE_HAS_SIX_ADJACENCY_REQUIREMENTS' ,   		'GOLDEN_REQUIRES_HOLY_SITE_HAS_SIX_ADJACENCY'),
			('GOLDEN_THEATER_HAS_SIX_ADJACENCY_REQUIREMENTS' , 	    	'GOLDEN_REQUIRES_THEATER_HAS_SIX_ADJACENCY'),
			('GOLDEN_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY_REQUIREMENTS' , 	'GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY'),
			('GOLDEN_ENCAMPMENT_HAS_SIX_ADJACENCY_REQUIREMENTS' , 		'GOLDEN_REQUIRES_ENCAMPMENT_HAS_SIX_ADJACENCY');	
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				                    RequirementType)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_SIX_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_SIX_ADJACENCY',			'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_SIX_ADJACENCY', 			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_THEATER_HAS_SIX_ADJACENCY',			        'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY',		    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT'),
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_SIX_ADJACENCY',			    'REQUIREMENT_CITY_HAS_HIGH_ADJACENCY_DISTRICT');		
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		                Name,			    Value)
VALUES						('GOLDEN_REQUIRES_CAMPUS_HAS_SIX_ADJACENCY',			    'DistrictType',		'DISTRICT_CAMPUS'),	
                            ('GOLDEN_REQUIRES_CAMPUS_HAS_SIX_ADJACENCY',		        'YieldType',		'YIELD_SCIENCE'),
							('GOLDEN_REQUIRES_CAMPUS_HAS_SIX_ADJACENCY',			    'Amount',		    6),
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_SIX_ADJACENCY',		'DistrictType',		'DISTRICT_COMMERCIAL_HUB'),	
                            ('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_SIX_ADJACENCY',		'YieldType',		'YIELD_GOLD'),
							('GOLDEN_REQUIRES_COMMERCIAL_HUB_HAS_SIX_ADJACENCY',	    'Amount',		    6),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_SIX_ADJACENCY',			    'DistrictType',		'DISTRICT_HOLY_SITE'),	
                            ('GOLDEN_REQUIRES_HOLY_SITE_HAS_SIX_ADJACENCY',		        'YieldType',		'YIELD_FAITH'),
							('GOLDEN_REQUIRES_HOLY_SITE_HAS_SIX_ADJACENCY',			    'Amount',		    6),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_SIX_ADJACENCY',			    'DistrictType',		'DISTRICT_THEATER'),	
                            ('GOLDEN_REQUIRES_THEATER_HAS_SIX_ADJACENCY',		        'YieldType',		'YIELD_CULTURE'),
							('GOLDEN_REQUIRES_THEATER_HAS_SIX_ADJACENCY',			    'Amount',		    6),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY',		'DistrictType',		'DISTRICT_INDUSTRIAL_ZONE'),	
                            ('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY',		'YieldType',		'YIELD_PRODUCTION'),
							('GOLDEN_REQUIRES_INDUSTRIAL_ZONE_HAS_SIX_ADJACENCY',		'Amount',		    6),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_SIX_ADJACENCY',			'DistrictType',		'DISTRICT_ENCAMPMENT'),	
                            ('GOLDEN_REQUIRES_ENCAMPMENT_HAS_SIX_ADJACENCY',		    'YieldType',		'YIELD_FOOD'),
							('GOLDEN_REQUIRES_ENCAMPMENT_HAS_SIX_ADJACENCY',			'Amount',		    6);																										
---------------------------------------------------------
--Buildings
---------------------------------------------------------								
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,						RequirementSetType)
VALUES	('GOLDEN_BUILDING_IS_WORSHIP_BUILDING_REQUIREMENTS',	'REQUIREMENTSET_TEST_ANY');
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'GOLDEN_BUILDING_IS_WORSHIP_BUILDING_REQUIREMENTS',		'GOLDEN_REQUIRES_BUILDING_IS_WORSHIP_BUILDING' ||BuildingType FROM Buildings WHERE EnabledByReligion = 1;
INSERT OR REPLACE INTO Requirements (RequirementId,									RequirementType)
SELECT	'GOLDEN_REQUIRES_BUILDING_IS_WORSHIP_BUILDING' ||BuildingType,	'REQUIREMENT_CITY_HAS_BUILDING' FROM Buildings WHERE EnabledByReligion = 1;
INSERT OR REPLACE INTO RequirementArguments (RequirementId,									Name,			Value)
SELECT	'GOLDEN_REQUIRES_BUILDING_IS_WORSHIP_BUILDING' ||BuildingType,	'BuildingType',	BuildingType FROM Buildings WHERE EnabledByReligion = 1;
--有
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_CITY_HAS_'|| BuildingType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Buildings WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_CITY_HAS_'|| BuildingType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_CITY_HAS_' || BuildingType FROM Buildings WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_CITY_HAS_' || BuildingType,	   'REQUIREMENT_CITY_HAS_BUILDING' FROM Buildings WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_CITY_HAS_' || BuildingType,		'BuildingType',	    BuildingType FROM Buildings WHERE Cost<>0;	
--没有
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_CITY_DONT_HAVE'|| BuildingType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Buildings WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_CITY_DONT_HAVE'|| BuildingType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_CITY_DONT_HAVE' || BuildingType FROM Buildings WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			   RequirementType,			        Inverse)
SELECT	 'GOLDEN_REQUIRES_CITY_DONT_HAVE' || BuildingType,	   'REQUIREMENT_CITY_HAS_BUILDING', 1 FROM Buildings WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_CITY_DONT_HAVE' || BuildingType,		'BuildingType',	    BuildingType FROM Buildings WHERE Cost<>0;	
---------------------------------------------------------
--Recources
---------------------------------------------------------		
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId , RequirementSetType) 	VALUES 		
('GOLDEN_PLOT_HAS_ANY_LUXURY_RESOURCE_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ANY');							
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'GOLDEN_PLOT_HAS_ANY_LUXURY_RESOURCE_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_HAS_LUXURY_' ||ResourceType FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY';
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,									RequirementType)
SELECT	'GOLDEN_REQUIRES_PLOT_HAS_LUXURY_' ||ResourceType,	'REQUIREMENT_PLOT_RESOURCE_TYPE_MATCHES' FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY';
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,									Name,			Value)
SELECT	'GOLDEN_REQUIRES_PLOT_HAS_LUXURY_' ||ResourceType,	'ResourceType',	ResourceType FROM Resources WHERE ResourceClassType='RESOURCECLASS_LUXURY';							
-- 新写法
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLOT_HAS_'|| ResourceType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Resources WHERE Frequency<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_HAS_'|| ResourceType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_HAS_' || ResourceType FROM Resources WHERE Frequency<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || ResourceType,	   'REQUIREMENT_PLOT_RESOURCE_TYPE_MATCHES' FROM Resources WHERE Frequency<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || ResourceType,		'ResourceType',	    ResourceType FROM Resources WHERE Frequency<>0;									
---------------------------------------------------------
--Improvements
---------------------------------------------------------
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLOT_HAS_'|| ImprovementType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Improvements WHERE Buildable = 1;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_HAS_'|| ImprovementType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_HAS_' || ImprovementType FROM Improvements WHERE Buildable = 1;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || ImprovementType,	   'REQUIREMENT_PLOT_IMPROVEMENT_TYPE_MATCHES' FROM Improvements WHERE Buildable = 1;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_' || ImprovementType,		'ImprovementType',	    ImprovementType FROM Improvements WHERE Buildable = 1;	
---------------------------------------------------------
--Improvements ADJACENT
---------------------------------------------------------	
-- 新写法
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLOT_IS_ADJACENT_TO_'|| ImprovementType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Improvements WHERE Buildable = 1;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_IS_ADJACENT_TO_'|| ImprovementType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || ImprovementType FROM Improvements WHERE Buildable = 1;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || ImprovementType,	   'REQUIREMENT_PLOT_ADJACENT_IMPROVEMENT_TYPE_MATCHES' FROM Improvements WHERE Buildable = 1;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_' || ImprovementType,		'ImprovementType',	    ImprovementType FROM Improvements WHERE Buildable = 1;		
---------------------------------------------------------
--Water
---------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES 		
('GOLDEN_CITY_NO_WATER_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL');		
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES 		
('GOLDEN_CITY_NO_WATER_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_PLOT_IS_NOT_FRESH_WATER'),
('GOLDEN_CITY_NO_WATER_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_PLOT_NOT_ADJACENT_TO_COAST');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				        RequirementType,			             Inverse) VALUES
('GOLDEN_REQUIRES_PLOT_IS_NOT_FRESH_WATER',			    'REQUIREMENT_PLOT_IS_FRESH_WATER',       1);
---------------------------------------------------------
--Features & Tarrains
---------------------------------------------------------		
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_PLOT_HAS_COAST_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_PLOT_HAS_OCEAN_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_PLOT_HAS_ANY_DESERT_REQUIREMENTS' , 			        'REQUIREMENTSET_TEST_ANY'),
			('GOLDEN_PLOT_HAS_FOREST_REQUIREMENTS' , 		                'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_PLOT_HAS_JUNGLE_REQUIREMENTS' , 		                'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_PLOT_HAS_GEOTHERMAL_FISSURE_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_PLOT_HAS_MARSH_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_PLOT_HAS_ANY_FLOODPLAINS_REQUIREMENTS' , 			    'REQUIREMENTSET_TEST_ANY'),
			('GOLDEN_PLOT_HAS_ANY_MOUNTAINS_REQUIREMENTS' , 			    'REQUIREMENTSET_TEST_ANY'),
			('GOLDEN_PLOT_IS_FRESH_WATER_REQUIREMENTS' , 		            'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_PLOT_IS_LAKE_REQUIREMENTS' , 		                    'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			
VALUES 		('GOLDEN_PLOT_HAS_COAST_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_PLOT_HAS_COAST'),
            ('GOLDEN_PLOT_HAS_OCEAN_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_PLOT_HAS_OCEAN'),
			('GOLDEN_PLOT_HAS_ANY_DESERT_REQUIREMENTS' , 			      'GOLDEN_REQUIRES_PLOT_HAS_DESERT'),
			('GOLDEN_PLOT_HAS_ANY_DESERT_REQUIREMENTS' , 			      'GOLDEN_REQUIRES_PLOT_HAS_DESERT_HILLS'),
			('GOLDEN_PLOT_HAS_ANY_DESERT_REQUIREMENTS' , 			      'GOLDEN_REQUIRES_PLOT_HAS_MOUNTAINS_TERRAIN_DESERT_MOUNTAIN'),
			('GOLDEN_PLOT_HAS_ANY_DESERT_REQUIREMENTS' , 			      'GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS'),
		    ('GOLDEN_PLOT_HAS_FOREST_REQUIREMENTS' , 		              'GOLDEN_REQUIRES_PLOT_HAS_FOREST'),
			('GOLDEN_PLOT_HAS_JUNGLE_REQUIREMENTS' , 		              'GOLDEN_REQUIRES_PLOT_HAS_JUNGLE'),
			('GOLDEN_PLOT_HAS_GEOTHERMAL_FISSURE_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_PLOT_HAS_GEOTHERMAL_FISSURE'),
			('GOLDEN_PLOT_HAS_MARSH_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_PLOT_HAS_MARSH'),
			('GOLDEN_PLOT_HAS_ANY_FLOODPLAINS_REQUIREMENTS' , 			  'GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_GRASSLAND'),
			('GOLDEN_PLOT_HAS_ANY_FLOODPLAINS_REQUIREMENTS' , 			  'GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_PLAINS'),
			('GOLDEN_PLOT_HAS_ANY_FLOODPLAINS_REQUIREMENTS' , 			  'GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS'),
			('GOLDEN_PLOT_IS_FRESH_WATER_REQUIREMENTS' , 		          'REQUIRES_PLOT_IS_FRESH_WATER'),
            ('GOLDEN_PLOT_IS_LAKE_REQUIREMENTS' , 		                  'REQUIRES_PLOT_IS_LAKE');
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_HAS_ANY_MOUNTAINS_REQUIREMENTS',		              'GOLDEN_REQUIRES_PLOT_HAS_MOUNTAINS_' || TerrainType FROM Terrains WHERE Mountain = 1;			
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				            RequirementType)
VALUES						('GOLDEN_REQUIRES_PLOT_HAS_COAST',			            'REQUIREMENT_PLOT_TERRAIN_TYPE_MATCHES'),
                            ('GOLDEN_REQUIRES_PLOT_HAS_OCEAN',			            'REQUIREMENT_PLOT_TERRAIN_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_DESERT_HILLS',			    'REQUIREMENT_PLOT_TERRAIN_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_DESERT',			            'REQUIREMENT_PLOT_TERRAIN_TYPE_MATCHES');
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_MOUNTAINS_' || TerrainType,	'REQUIREMENT_PLOT_TERRAIN_TYPE_MATCHES' FROM Terrains WHERE Mountain = 1;							
INSERT OR REPLACE INTO 		Requirements (RequirementId,				            RequirementType)
VALUES						('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_GRASSLAND',		'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
                            ('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_PLAINS',			'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS',			    'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_FOREST',			            'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_JUNGLE',			            'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_GEOTHERMAL_FISSURE',			'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_PLOT_HAS_MARSH',			            'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES');								
--RequirementArguments		
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			    Value)
VALUES						('GOLDEN_REQUIRES_PLOT_HAS_COAST',			            'TerrainType',		'TERRAIN_COAST'),	
                            ('GOLDEN_REQUIRES_PLOT_HAS_OCEAN',			            'TerrainType',		'TERRAIN_OCEAN'),
							('GOLDEN_REQUIRES_PLOT_HAS_DESERT_HILLS',			    'TerrainType',		'TERRAIN_DESERT_HILLS'),
							('GOLDEN_REQUIRES_PLOT_HAS_DESERT',			            'TerrainType',		'TERRAIN_DESERT');
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_HAS_MOUNTAINS_' || TerrainType,			'TerrainType',	    TerrainType FROM Terrains WHERE Mountain = 1;							
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			    Value)
VALUES						('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_GRASSLAND',		'FeatureType',		'FEATURE_FLOODPLAINS_GRASSLAND'),	
                            ('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS_PLAINS',		    'FeatureType',		'FEATURE_FLOODPLAINS_PLAINS'),
							('GOLDEN_REQUIRES_PLOT_HAS_FLOODPLAINS',    		    'FeatureType',		'FEATURE_FLOODPLAINS'),
							('GOLDEN_REQUIRES_PLOT_HAS_FOREST',		                'FeatureType',		'FEATURE_FOREST'),
							('GOLDEN_REQUIRES_PLOT_HAS_JUNGLE',		                'FeatureType',		'FEATURE_JUNGLE'),
							('GOLDEN_REQUIRES_PLOT_HAS_GEOTHERMAL_FISSURE',		    'FeatureType',		'FEATURE_GEOTHERMAL_FISSURE'),
							('GOLDEN_REQUIRES_PLOT_HAS_MARSH',		                'FeatureType',		'FEATURE_MARSH');
---------------------------------------------------------
--Features & Tarrains ADJACENT
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId , RequirementSetType) 	VALUES 		
('GOLDEN_PLOT_ADJACENT_TO_COAST_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_FOREST_ADJACENT_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_JUNGLE_ADJACENT_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_FLOODPLAINS_GRASSLAND_ADJACENT_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_FLOODPLAINS_PLAINS_ADJACENT_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_FLOODPLAINS_ADJACENT_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLOT_IS_ADJACENT_TO_ANY_MOUNTAINS_REQUIREMENTS' , 		    'REQUIREMENTSET_TEST_ANY');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		
('GOLDEN_PLOT_ADJACENT_TO_COAST_REQUIREMENTS' , 	'GOLDEN_REQUIRES_PLOT_ADJACENT_TO_COAST'),
('GOLDEN_PLOT_IS_FOREST_ADJACENT_REQUIREMENTS' , 	'GOLDEN_REQUIRES_PLOT_IS_FOREST_ADJACENT'),
('GOLDEN_PLOT_IS_JUNGLE_ADJACENT_REQUIREMENTS' , 	'GOLDEN_REQUIRES_PLOT_IS_JUNGLE_ADJACENT'),
('GOLDEN_PLOT_IS_FLOODPLAINS_GRASSLAND_ADJACENT_REQUIREMENTS' , 	'GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_GRASSLAND_ADJACENT'),
('GOLDEN_PLOT_IS_FLOODPLAINS_PLAINS_ADJACENT_REQUIREMENTS' , 	    'GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_PLAINS_ADJACENT'),
('GOLDEN_PLOT_IS_FLOODPLAINS_ADJACENT_REQUIREMENTS' ,            	'GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_ADJACENT');	
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLOT_IS_ADJACENT_TO_ANY_MOUNTAINS_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_MOUNTAINS_' || TerrainType FROM Terrains WHERE Mountain = 1;
--Requirements	
INSERT OR REPLACE INTO 		Requirements (RequirementId,				        RequirementType,			             Inverse) VALUES
('GOLDEN_REQUIRES_PLOT_ADJACENT_TO_COAST',		        'REQUIREMENT_PLOT_ADJACENT_TO_COAST',    0),
('GOLDEN_REQUIRES_PLOT_NOT_ADJACENT_TO_COAST',		    'REQUIREMENT_PLOT_ADJACENT_TO_COAST',    1),
('GOLDEN_REQUIRES_PLOT_IS_FOREST_ADJACENT',		        'REQUIREMENT_PLOT_ADJACENT_FEATURE_TYPE_MATCHES',    0),
('GOLDEN_REQUIRES_PLOT_IS_JUNGLE_ADJACENT',		        'REQUIREMENT_PLOT_ADJACENT_FEATURE_TYPE_MATCHES',    0),
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_GRASSLAND_ADJACENT',		    'REQUIREMENT_PLOT_ADJACENT_FEATURE_TYPE_MATCHES',    0),
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_PLAINS_ADJACENT',		        'REQUIREMENT_PLOT_ADJACENT_FEATURE_TYPE_MATCHES',    0),
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_ADJACENT',		            'REQUIREMENT_PLOT_ADJACENT_FEATURE_TYPE_MATCHES',    0);
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_MOUNTAINS_' || TerrainType,	'REQUIREMENT_PLOT_ADJACENT_TERRAIN_TYPE_MATCHES' FROM Terrains WHERE Mountain = 1;
--RequirementArguments	
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			    Value) VALUES		
('GOLDEN_REQUIRES_PLOT_IS_FOREST_ADJACENT',		            'FeatureType',		'FEATURE_FOREST'),
('GOLDEN_REQUIRES_PLOT_IS_JUNGLE_ADJACENT',		            'FeatureType',		'FEATURE_JUNGLE'),	
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_GRASSLAND_ADJACENT',	'FeatureType',		'FEATURE_FLOODPLAINS_GRASSLAND'),	
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_PLAINS_ADJACENT',		'FeatureType',		'FEATURE_FLOODPLAINS_PLAINS'),	
('GOLDEN_REQUIRES_PLOT_IS_FLOODPLAINS_ADJACENT',		    'FeatureType',		'FEATURE_FLOODPLAINS');	
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLOT_IS_ADJACENT_TO_MOUNTAINS_' || TerrainType,				'TerrainType',	TerrainType FROM Terrains WHERE Mountain = 1;
---------------------------------------------------------
--Techs & Civics
---------------------------------------------------------
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLAYER_HAS_'|| TechnologyType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Technologies WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_'|| TechnologyType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType,	   'REQUIREMENT_PLAYER_HAS_TECHNOLOGY' FROM Technologies WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType,		'TechnologyType',	    TechnologyType FROM Technologies WHERE Cost<>0;		

-- RequirementSets
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_PLAYER_HAS_'|| CivicType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Civics WHERE Cost<>0;
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_'|| CivicType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE Cost<>0;
-- Requirements
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType,	   'REQUIREMENT_PLAYER_HAS_CIVIC' FROM Civics WHERE Cost<>0;
-- RequirementArguments
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType,		'CivicType',	    CivicType FROM Civics WHERE Cost<>0;			
---------------------------------------------------------
--Era(Techs & Civics)
---------------------------------------------------------		
-- RequirementSets
INSERT OR REPLACE INTO RequirementSets
		(RequirementSetId,						                RequirementSetType)
VALUES  ('GOLDEN_PLAYER_HAS_ANCIENT_TECH_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_CLASSICAL_TECH_REQUIREMENTS',	    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_MEDIEVAL_TECH_REQUIREMENTS',		'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_RENAISSANCE_TECH_REQUIREMENTS',    	'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_INDUSTRIAL_TECH_REQUIREMENTS',	    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_MODERN_TECH_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_ATOMIC_TECH_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_INFORMATION_TECH_REQUIREMENTS',	    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_FUTURE_TECH_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_ANCIENT_CIVIC_REQUIREMENTS',		'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_CLASSICAL_CIVIC_REQUIREMENTS',	    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_MEDIEVAL_CIVIC_REQUIREMENTS',		'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_RENAISSANCE_CIVIC_REQUIREMENTS',    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_INDUSTRIAL_CIVIC_REQUIREMENTS',	    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_MODERN_CIVIC_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_ATOMIC_CIVIC_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_INFORMATION_CIVIC_REQUIREMENTS',	'REQUIREMENTSET_TEST_ANY'),
		('GOLDEN_PLAYER_HAS_FUTURE_CIVIC_REQUIREMENTS',		    'REQUIREMENTSET_TEST_ANY');			
-- RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_ANCIENT_TECH_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_ANCIENT';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_CLASSICAL_TECH_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_CLASSICAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_MEDIEVAL_TECH_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_MEDIEVAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_RENAISSANCE_TECH_REQUIREMENTS',	    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_RENAISSANCE';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_INDUSTRIAL_TECH_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_INDUSTRIAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_MODERN_TECH_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_MODERN';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_ATOMIC_TECH_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_ATOMIC';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_INFORMATION_TECH_REQUIREMENTS',	    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_INFORMATION';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_FUTURE_TECH_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || TechnologyType FROM Technologies WHERE EraType='ERA_FUTURE';	
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_ANCIENT_CIVIC_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_ANCIENT';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_CLASSICAL_CIVIC_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_CLASSICAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_MEDIEVAL_CIVIC_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_MEDIEVAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_RENAISSANCE_CIVIC_REQUIREMENTS',	    'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_RENAISSANCE';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_INDUSTRIAL_CIVIC_REQUIREMENTS',		'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_INDUSTRIAL';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_MODERN_CIVIC_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_MODERN';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_ATOMIC_CIVIC_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_ATOMIC';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_INFORMATION_CIVIC_REQUIREMENTS',	'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_INFORMATION';
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_PLAYER_HAS_FUTURE_CIVIC_REQUIREMENTS',		    'GOLDEN_REQUIRES_PLAYER_HAS_' || CivicType FROM Civics WHERE EraType='ERA_FUTURE';
---------------------------------------------------------
--GAME ERA: IS OR AT LEAST
---------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_GAME_ERA_IS_'|| EraType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Eras;
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_GAME_ERA_IS_'|| EraType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_GAME_ERA_IS_' || EraType FROM Eras;
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_GAME_ERA_IS_' || EraType,	   'REQUIREMENT_GAME_ERA_IS' FROM Eras;
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_GAME_ERA_IS_' || EraType,		'EraType',	    EraType FROM Eras;	

INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							RequirementSetType)
SELECT	'GOLDEN_GAME_ERA_ATLEAST_'|| EraType ||'_REQUIREMENTS',	'REQUIREMENTSET_TEST_ALL' FROM Eras;
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,		RequirementId)
SELECT	 'GOLDEN_GAME_ERA_ATLEAST_'|| EraType ||'_REQUIREMENTS',	'GOLDEN_REQUIRES_GAME_ERA_ATLEAST_' || EraType FROM Eras;
INSERT OR REPLACE INTO Requirements (RequirementId,			RequirementType)
SELECT	 'GOLDEN_REQUIRES_GAME_ERA_ATLEAST_' || EraType,	   'REQUIREMENT_GAME_ERA_ATLEAST_EXPANSION' FROM Eras;
INSERT OR REPLACE INTO RequirementArguments (RequirementId,				Name,				Value)
SELECT	 'GOLDEN_REQUIRES_GAME_ERA_ATLEAST_' || EraType,		'EraType',	    EraType FROM Eras;	
---------------------------------------------------------
--Units
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_UNIT_IS_BUILDER_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_UNIT_IS_SETTLER_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_UNIT_IS_MILITARY_ENGINEER_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
			('GOLDEN_UNIT_IS_APOSTLE_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			
VALUES 		('GOLDEN_UNIT_IS_BUILDER_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_UNIT_IS_BUILDER'),
            ('GOLDEN_UNIT_IS_SETTLER_REQUIREMENTS' , 			          'GOLDEN_REQUIRES_UNIT_IS_SETTLER'),
		    ('GOLDEN_UNIT_IS_MILITARY_ENGINEER_REQUIREMENTS' , 		      'GOLDEN_REQUIRES_UNIT_IS_MILITARY_ENGINEER'),
			('GOLDEN_UNIT_IS_APOSTLE_REQUIREMENTS' , 		              'GOLDEN_REQUIRES_UNIT_IS_APOSTLE');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType)
VALUES						('GOLDEN_REQUIRES_UNIT_IS_BUILDER',		       'REQUIREMENT_UNIT_TYPE_MATCHES'),
                            ('GOLDEN_REQUIRES_UNIT_IS_SETTLER',			   'REQUIREMENT_UNIT_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_UNIT_IS_MILITARY_ENGINEER',  'REQUIREMENT_UNIT_TYPE_MATCHES'),
							('GOLDEN_REQUIRES_UNIT_IS_APOSTLE',            'REQUIREMENT_UNIT_TYPE_MATCHES');
--RequirementArguments		
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			Value)
VALUES						('GOLDEN_REQUIRES_UNIT_IS_BUILDER',		                'UnitType',		'UNIT_BUILDER'),	
                            ('GOLDEN_REQUIRES_UNIT_IS_SETTLER',		                'UnitType',		'UNIT_SETTLER'),
							('GOLDEN_REQUIRES_UNIT_IS_MILITARY_ENGINEER',		    'UnitType',		'UNIT_MILITARY_ENGINEER'),
							('GOLDEN_REQUIRES_UNIT_IS_APOSTLE',		                'UnitType',		'UNIT_APOSTLE');
---------------------------------------------------------
--Great person
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_UNIT_IS_MERCHANT_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_UNIT_IS_MERCHANT_REQUIREMENTS' , 		              'GOLDEN_REQUIRES_UNIT_IS_MERCHANT');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_UNIT_IS_MERCHANT',            'REQUIREMENT_GREAT_PERSON_TYPE_MATCHES');
--RequirementArguments		
INSERT OR REPLACE INTO 		RequirementArguments (RequirementId,		            Name,			Value) VALUES		
('GOLDEN_REQUIRES_UNIT_IS_MERCHANT',		                'GreatPersonClassType',		'GREAT_PERSON_CLASS_MERCHANT');
---------------------------------------------------------
--CONTINENT
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_CITY_IS_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 			            'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 			        'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_CITY_IS_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		              'GOLDEN_REQUIRES_CITY_IS_OWNER_CAPITAL_CONTINENT'),
('GOLDEN_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		          'GOLDEN_REQUIRES_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_CITY_IS_OWNER_CAPITAL_CONTINENT',            'REQUIREMENT_CITY_IS_OWNER_CAPITAL_CONTINENT');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType,			             Inverse) VALUES		
('GOLDEN_REQUIRES_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT',        'REQUIREMENT_CITY_IS_OWNER_CAPITAL_CONTINENT', 1);
---------------------------------------------------------
--WAR
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLAYER_IS_AT_WAR_WITH_MAJOR_REQUIREMENTS' , 			        'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS'),
('GOLDEN_PLAYER_IS_AT_WAR_WITH_MAJOR_REQUIREMENTS' , 		          'GOLDEN_REQUIRES_PLAYER_IS_AT_WAR_WITH_MAJOR');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS',            'REQUIREMENT_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType,			             Inverse) VALUES		
('GOLDEN_REQUIRES_PLAYER_IS_AT_WAR_WITH_MAJOR',                   'REQUIREMENT_PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS', 1);
---------------------------------------------------------
--GARRISON
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_CITY_HAS_GARRISON_UNIT_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_HAS_NO_GARRISON_UNIT_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_CITY_HAS_GARRISON_UNIT_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_CITY_HAS_GARRISON_UNIT'),
('GOLDEN_CITY_HAS_NO_GARRISON_UNIT_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_CITY_HAS_NO_GARRISON_UNIT');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_CITY_HAS_GARRISON_UNIT',                      'REQUIREMENT_CITY_HAS_GARRISON_UNIT');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType,			             Inverse) VALUES		
('GOLDEN_REQUIRES_CITY_HAS_NO_GARRISON_UNIT',                   'REQUIREMENT_CITY_HAS_GARRISON_UNIT', 1);
---------------------------------------------------------
--RELIGION FOUNDER
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_PLAYER_FOUNDED_RELIGION_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLAYER_NO_FOUNDED_RELIGION_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_PLAYER_FOUNDED_RELIGION_REQUIREMENTS' , 		      'GOLDEN_REQUIRES_PLAYER_FOUNDED_RELIGION'),
('GOLDEN_PLAYER_NO_FOUNDED_RELIGION_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_PLAYER_NO_FOUNDED_RELIGION');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_PLAYER_FOUNDED_RELIGION',                      'REQUIREMENT_PLAYER_IS_RELIGION_FOUNDER');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType,			             Inverse) VALUES		
('GOLDEN_REQUIRES_PLAYER_NO_FOUNDED_RELIGION',                   'REQUIREMENT_PLAYER_IS_RELIGION_FOUNDER', 1);
---------------------------------------------------------
--Power
---------------------------------------------------------
--RequirementSets
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	VALUES
('GOLDEN_CITY_IS_POWERED_REQUIREMENTS' , 			'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL');
--RequirementSetRequirements
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,   RequirementId) 			VALUES
('GOLDEN_CITY_IS_POWERED_REQUIREMENTS' , 		      'GOLDEN_REQUIRES_CITY_IS_POWERED'),
('GOLDEN_CITY_IS_NOT_POWERED_REQUIREMENTS' , 		  'GOLDEN_REQUIRES_CITY_IS_NOT_POWERED');
--Requirements
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType) VALUES		
('GOLDEN_REQUIRES_CITY_IS_POWERED',                       'REQUIREMENT_CITY_IS_POWERED');
INSERT OR REPLACE INTO 		Requirements (RequirementId,				   RequirementType,			             Inverse) VALUES		
('GOLDEN_REQUIRES_CITY_IS_NOT_POWERED',                   'REQUIREMENT_CITY_IS_POWERED', 1);
---------------------------------------------------------
--Difficulty
---------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets (RequirementSetId,							    RequirementSetType)
SELECT	'GOLDEN_PLAYER_IS_' ||DifficultyType|| '_AI',	'REQUIREMENTSET_TEST_ALL' FROM Difficulties;

INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'GOLDEN_PLAYER_IS_' ||DifficultyType|| '_AI',	        'REQUIRES_PLAYER_IS_AI' FROM Difficulties;
INSERT OR REPLACE INTO RequirementSetRequirements (RequirementSetId,							RequirementId)
SELECT	'GOLDEN_PLAYER_IS_' ||DifficultyType|| '_AI',	        'GOLDEN_REQUIRES_' ||DifficultyType FROM Difficulties;

INSERT OR REPLACE INTO Requirements (RequirementId,					RequirementType)
SELECT	'GOLDEN_REQUIRES_' ||DifficultyType,	            'REQUIREMENT_PLAYER_HANDICAP_AT_OR_ABOVE' FROM Difficulties;

INSERT OR REPLACE INTO RequirementArguments (RequirementId,			Name,			Value)
SELECT	'GOLDEN_REQUIRES_' ||DifficultyType,	'Handicap',	DifficultyType FROM Difficulties;
---------------------------------------------------------
--Nobel Prize
---------------------------------------------------------	
DELETE FROM RequirementSetRequirements WHERE RequirementSetId = 'NOBEL_PRIZE_TARGET_REQUIREMENTS' AND RequirementId = 'REQUIRES_GAME_HAS_NOBEL_PRIZE_TRAIT'; 		
				