-----------------------------------------------
-- Types
-----------------------------------------------
INSERT OR REPLACE INTO Types (Type,						Kind)
VALUES
('ABILITY_CAVALRY_SIEGE',						'KIND_ABILITY'),
('ABILITY_HEAVYCAVALRY_RANGE',					'KIND_ABILITY');
-----------------------------------------------
-- TypeTags
-----------------------------------------------		
INSERT OR REPLACE INTO TypeTags (Type,									Tag)
VALUES	
('ABILITY_CAVALRY_SIEGE',				'CLASS_LIGHT_CAVALRY'),
('ABILITY_HEAVYCAVALRY_RANGE',			'CLASS_HEAVY_CAVALRY');

DELETE FROM TypeTags WHERE Type = 'ABILITY_OBSERVATION_STRENGTH_BONUS' AND Tag = 'CLASS_OBSERVATION' ;
DELETE FROM TypeTags WHERE Type = 'ABILITY_DRONE_GRANT_SIEGE_BONUS' AND Tag = 'CLASS_DRONE' ;
-----------------------------------------------
-- UnitAbilities
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilities (UnitAbilityType,						Name,									Description) VALUES	
('ABILITY_CAVALRY_SIEGE',				'LOC_ABILITY_CAVALRY_SIEGE_NAME',		'LOC_ABILITY_CAVALRY_SIEGE_DESCRIPTION'),
('ABILITY_HEAVYCAVALRY_RANGE',			'LOC_ABILITY_HEAVYCAVALRY_RANGE_NAME',	'LOC_ABILITY_HEAVYCAVALRY_RANGE_DESCRIPTION');
-----------------------------------------------
-- UnitAbilityModifiers
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilityModifiers (UnitAbilityType,						ModifierId) VALUES	
('ABILITY_CAVALRY_SIEGE',				'GOLDEN_ADJUST_CAVALRY_SIEGE'),
('ABILITY_HEAVYCAVALRY_RANGE',			'GOLDEN_ADJUST_HEAVYCAVALRY_RANGE');

DELETE FROM UnitAbilityModifiers WHERE UnitAbilityType = 'ABILITY_RECEIVE_RANGE_BONUS' AND ModifierId = 'RECEIVE_RANGE_BONUS' ; --气球和无人机给攻城单位+1射程
-----------------------------------------------
-- Modifiers
-----------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,						ModifierType,								SubjectRequirementSetId)
VALUES	
('GOLDEN_ADJUST_CAVALRY_SIEGE',							'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		'GOLDEN_OPPONENT_SIEGE_REQUIREMENTS'),
('GOLDEN_ADJUST_HEAVYCAVALRY_RANGE',					'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		'GOLDEN_OPPONENT_RANGE_REQUIREMENTS');
-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,				Name,		Value)
VALUES
('GOLDEN_ADJUST_CAVALRY_SIEGE',							'Amount',	20),
('GOLDEN_ADJUST_HEAVYCAVALRY_RANGE',					'Amount',	20);
UPDATE ModifierArguments SET  Value = 20
WHERE ModifierId = 'ANTI_SPEAR' AND Name = 'Amount';
UPDATE ModifierArguments SET  Value = 20
WHERE ModifierId = 'ANTI_CAVALRY_COMBAT_BONUS' AND Name = 'Amount';

-----------------------------------------------
-- ModifierStrings
-----------------------------------------------
INSERT OR REPLACE INTO ModifierStrings (ModifierId,				Context,	Text)
VALUES	
('GOLDEN_ADJUST_CAVALRY_SIEGE',							'Preview',	'LOC_ABILITY_CAVALRY_SIEGE_MODIFIER_DESCRIPTION'),
('GOLDEN_ADJUST_HEAVYCAVALRY_RANGE',					'Preview',	'LOC_ABILITY_HEAVYCAVALRY_RANGE_MODIFIER_DESCRIPTION');
-----------------------------------------------
--RequirementSets
-----------------------------------------------
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_OPPONENT_SIEGE_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL'),
            ('GOLDEN_OPPONENT_RANGE_REQUIREMENTS' , 		'REQUIREMENTSET_TEST_ALL');	
-----------------------------------------------
--RequirementSetRequirements
-----------------------------------------------	
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			
VALUES 		('GOLDEN_OPPONENT_SIEGE_REQUIREMENTS' , 		'OPPONENT_SIEGE_REQUIREMENT'),
            ('GOLDEN_OPPONENT_RANGE_REQUIREMENTS' , 		'OPPONENT_RANGED_REQUIREMENT');	
-----------------------------------------------
--Requirements
-----------------------------------------------	
-----------------------------------------------
--RequirementArguments	
-----------------------------------------------

-----------------------------------------------
--补给系统
-----------------------------------------------
-- INSERT OR REPLACE INTO Types 					(Type,Kind) 			VALUES 		('ABILITY_ATTRITION',					'KIND_ABILITY');

-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_RECON');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_MELEE');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_ANTI_CAVALRY');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_RANGED');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_SIEGE');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_LIGHT_CAVALRY');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_HEAVY_CAVALRY');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_NAVAL_RANGED');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_NAVAL_MELEE');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_NAVAL_CARRIER');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_AIRCRAFT');
-- INSERT OR REPLACE INTO TypeTags 				(Type , Tag) 			VALUES 		('ABILITY_ATTRITION' , 					'CLASS_RELIGIOUS_ALL');
-- INSERT OR REPLACE INTO TypeTags                 (Type, Tag)             SELECT	    'ABILITY_ATTRITION',                    'CLASS_NAVAL_BOMBARD' FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN';	
-- INSERT OR REPLACE INTO TypeTags                 (Type, Tag)             SELECT	    'ABILITY_ATTRITION',                    'CLASS_AUTOMATIC_GUN' FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN';	
				
-- INSERT OR REPLACE INTO UnitAbilities (UnitAbilityType,Name,Description) 								VALUES 		('ABILITY_ATTRITION',	'LOC_ABILITY_ATTRITION_NAME','LOC_ABILITY_ATTRITION_DESCRIPTION');

-- INSERT OR REPLACE INTO UnitAbilityModifiers (UnitAbilityType,ModifierId) 								VALUES 		('ABILITY_ATTRITION',		            'GOLDEN_ENEMY_ATTRITION_NO_DISTRICT');				
-- INSERT OR REPLACE INTO Modifiers (ModifierId,ModifierType,SubjectRequirementSetId) 						VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT',	'MODIFIER_PLAYER_UNIT_ADJUST_DAMAGE','GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT'); 
-- INSERT OR REPLACE INTO ModifierArguments (ModifierId,Name,Value) 										VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT',	'Amount',2); 

-- INSERT OR REPLACE INTO UnitAbilityModifiers (UnitAbilityType,ModifierId) 								VALUES 		('ABILITY_ATTRITION',		            'GOLDEN_ENEMY_ATTRITION');				
-- INSERT OR REPLACE INTO Modifiers (ModifierId,ModifierType,SubjectRequirementSetId) 						VALUES 		('GOLDEN_ENEMY_ATTRITION',				'MODIFIER_PLAYER_UNIT_ADJUST_DAMAGE','GOLDEN_ENEMY_ATTRITION_REQUIREMENT'); 
-- INSERT OR REPLACE INTO ModifierArguments (ModifierId,Name,Value) 										VALUES 		('GOLDEN_ENEMY_ATTRITION',				'Amount',3); 

-- INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId , RequirementSetType) 	VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'REQUIREMENTSET_TEST_ALL');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'REQUIRES_TURN_STARTED');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'UNIT_IN_ENEMY_TERRITORY_REQUIREMENT');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'GOLDEN_REQUIRES_UNIT_IS_NOT_ADJACENT_TO_OWNER_TERRITORY');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'REQUIRES_UNIT_NOT_BARBARIAN');	
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MILITARY_ENGINEER');	
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MEDIC');	
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_SUPPLY_CONVOY');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_NO_DISTRICT_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_WITHOUT_DISTRICT');		

-- INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId , RequirementSetType) 	VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'REQUIREMENTSET_TEST_ALL');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'REQUIRES_TURN_STARTED');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'UNIT_IN_ENEMY_TERRITORY_REQUIREMENT');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'GOLDEN_REQUIRES_UNIT_IS_NOT_ADJACENT_TO_OWNER_TERRITORY');
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'REQUIRES_UNIT_NOT_BARBARIAN');		
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MILITARY_ENGINEER');	
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MEDIC');	
-- INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId , RequirementId) 			VALUES 		('GOLDEN_ENEMY_ATTRITION_REQUIREMENT' , 			'GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_SUPPLY_CONVOY');	

-- INSERT OR REPLACE INTO Requirements				(RequirementId , RequirementType, Inverse) 	VALUES		('GOLDEN_REQUIRES_UNIT_IS_NOT_ADJACENT_TO_OWNER_TERRITORY', 	'REQUIREMENT_UNIT_ADJACENT_TO_OWNER_TERRITORY',	1 );	
-- INSERT OR REPLACE INTO Requirements				(RequirementId , RequirementType, Inverse) 	VALUES		('GOLDEN_REQUIRES_PLOT_WITHOUT_DISTRICT', 	                    'REQUIREMENT_PLOT_HAS_ANY_DISTRICT',	        1 );	
-- INSERT OR REPLACE INTO Requirements				(RequirementId , RequirementType, Inverse) 	VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MILITARY_ENGINEER',   	'REQUIREMENT_PLOT_UNIT_TYPE_MATCHES',	        1 );
-- INSERT OR REPLACE INTO Requirements				(RequirementId , RequirementType, Inverse) 	VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MEDIC',               	'REQUIREMENT_PLOT_UNIT_TYPE_MATCHES',	        1 );
-- INSERT OR REPLACE INTO Requirements				(RequirementId , RequirementType, Inverse) 	VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_SUPPLY_CONVOY',        	'REQUIREMENT_PLOT_UNIT_TYPE_MATCHES',	        1 );

-- INSERT OR REPLACE INTO RequirementArguments		(RequirementId,Name,Value)				VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MILITARY_ENGINEER',	'UnitType',	'UNIT_MILITARY_ENGINEER'	);
-- INSERT OR REPLACE INTO RequirementArguments		(RequirementId,Name,Value)				VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_MEDIC',	            'UnitType',	'UNIT_MEDIC'	);
-- INSERT OR REPLACE INTO RequirementArguments		(RequirementId,Name,Value)				VALUES		('GOLDEN_REQUIRES_PLOT_DONT_HAVE_UNIT_SUPPLY_CONVOY',	    'UnitType',	'UNIT_SUPPLY_CONVOY'	);

-----------------------------------------------
--视野系统
-----------------------------------------------										
INSERT OR REPLACE INTO Types						
(Type,									Kind) VALUES						
('ABILITY_ENHANCED_SIGHT',				'KIND_ABILITY');

INSERT OR REPLACE INTO UnitAbilityModifiers		
 (UnitAbilityType,				ModifierId) VALUES
('ABILITY_ENHANCED_SIGHT',		'GOLDEN_ENHANCED_SIGHT_ON_HILLS');
										
INSERT OR REPLACE INTO UnitAbilities				
(UnitAbilityType,				Name,								Description,										Inactive) VALUES
('ABILITY_ENHANCED_SIGHT',		'LOC_ABILITY_ENHANCED_SIGHT_NAME',	'LOC_ABILITY_ENHANCED_SIGHT_MODIFIER_DESCRIPTION',	0);
									
INSERT OR REPLACE INTO Modifiers					
(ModifierId,							ModifierType,						    Permanent,		SubjectRequirementSetId,	SubjectStackLimit) VALUES						
('GOLDEN_ENHANCED_SIGHT_ON_HILLS',		'MODIFIER_PLAYER_UNIT_ADJUST_SIGHT',	0,				'GOLDEN_TERRAIN_IS_A_HILL_REQUIREMENTS',	1);									
INSERT OR REPLACE INTO Modifiers				
(ModifierId,								        ModifierType,						Permanent) VALUES						
('GOLDEN_ENHANCED_SIGHT_ON_HILLS_MODIFIER',			'MODIFIER_ALL_PLAYERS_ATTACH_MODIFIER',			1);		
								
 INSERT OR REPLACE INTO ModifierArguments			
 (ModifierId,								Name,			Value) VALUES						
('GOLDEN_ENHANCED_SIGHT_ON_HILLS',		'ModifierId',	'GOLDEN_ENHANCED_SIGHT_ON_HILLS_MODIFIER'),
('GOLDEN_ENHANCED_SIGHT_ON_HILLS',		'Amount',		1);
										
INSERT OR REPLACE INTO ModifierStrings				
(ModifierId,							    Context,	Text)	VALUES								
('GOLDEN_ENHANCED_SIGHT_ON_HILLS',	'Preview',	'LOC_ABILITY_ENHANCED_SIGHT_MODIFIER_DESCRIPTION');

INSERT OR REPLACE INTO	RequirementSets				
(RequirementSetId,                                  RequirementSetType)		VALUES		
('GOLDEN_TERRAIN_IS_A_HILL_REQUIREMENTS',			'REQUIREMENTSET_TEST_ALL');

INSERT OR REPLACE INTO RequirementSetRequirements	
(RequirementSetId,                                  RequirementId)			VALUES		
('GOLDEN_TERRAIN_IS_A_HILL_REQUIREMENTS',			'GOLDEN_REQUIRES_TERRAIN_ON_HILL');

INSERT OR REPLACE INTO Requirements				
(RequirementId,										 RequirementType)VALUES						
('GOLDEN_REQUIRES_TERRAIN_ON_HILL',					'REQUIREMENT_PLOT_IS_HILLS');	
										
INSERT OR REPLACE INTO TypeTags 	
([Type] , Tag) 	VALUES 	
('ABILITY_ENHANCED_SIGHT',	'CLASS_MELEE'),
('ABILITY_ENHANCED_SIGHT',	'CLASS_ANTI_CAVALRY'),
('ABILITY_ENHANCED_SIGHT',	'CLASS_TRUE_RANGED'),
('ABILITY_ENHANCED_SIGHT',	'CLASS_SIEGE');		
INSERT OR REPLACE INTO TypeTags                 (Type, Tag)             SELECT	    'ABILITY_ENHANCED_SIGHT',                    'CLASS_AUTOMATIC_GUN' FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN';	
