-- Author: Flactine
--------------------------------------------------------------
-- Melee
--------------------------------------------------------------
--===
--左线1：PROMOTION_BATTLECRY 战嚎
--原：攻击近战和远程单位时+7战斗力。
--改：攻击时+10力，防御时-5力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_BATTLECRY' AND ModifierId = 'BATTLECRY_BONUS_VS_MELEE_RANGED';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_BATTLECRY',	'MODIFIER_GA_PROMOTION_BATTLECRY_ATTACK'),
('PROMOTION_BATTLECRY',	'MODIFIER_GA_PROMOTION_BATTLECRY_DEFEND');

INSERT INTO Modifiers
(ModifierId,								ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_BATTLECRY_ATTACK',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENTS'),
('MODIFIER_GA_PROMOTION_BATTLECRY_DEFEND',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_WEAK_WHEN_DEFENDING_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,									Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_BATTLECRY_ATTACK',		'Amount',		10),
('MODIFIER_GA_PROMOTION_BATTLECRY_DEFEND',		'Amount',		-5);

INSERT INTO ModifierStrings	
(ModifierId,									Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_BATTLECRY_ATTACK',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_BATTLECRY_ATTACK_TEXT'),
('MODIFIER_GA_PROMOTION_BATTLECRY_DEFEND',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_BATTLECRY_DEFEND_TEXT');
--===
--左线2：PROMOTION_COMMANDO	突击队
--原：+1移动力。可攀登悬崖。
--改：+1移动力。+1视野。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_COMMANDO' AND ModifierId = 'COMMANDO_BONUS_IGNORE_CLIFF_WALLS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_COMMANDO',	'MODIFIER_GA_PROMOTION_COMMANDO_SIGHT_BONUS');

INSERT INTO Modifiers
(ModifierId,									ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_COMMANDO_SIGHT_BONUS',	'MODIFIER_PLAYER_UNIT_ADJUST_SIGHT');

INSERT INTO ModifierArguments
(ModifierId,										Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_COMMANDO_SIGHT_BONUS',		'Amount',		1);
--===
--左线3：PROMOTION_ZWEIHANDER	双手剑
--原：与抗骑兵单位战斗时+7战斗力。
--改：为相邻的其他近战单位+5力。
--再改：每回合结束时（甚至是在移动或攻击后）恢复10点生命。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ZWEIHANDER' AND ModifierId = 'ZWEIHANDER_BONUS_VS_ANTI_CAVALRY';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_ZWEIHANDER',	'MAMLUK_HEAL_EVERY_MOVE');

-- INSERT INTO UnitPromotionModifiers			
-- (UnitPromotionType,			ModifierId)
-- VALUES
-- ('PROMOTION_ZWEIHANDER',	'MODIFIER_GA_PROMOTION_ZWEIHANDER_COMBAT_BONUS_TO_MELEE');

-- INSERT INTO Modifiers
-- (ModifierId,												ModifierType,								SubjectRequirementSetId)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_ZWEIHANDER_COMBAT_BONUS_TO_MELEE',	'MODIFIER_PLAYER_UNITS_ATTACH_MODIFIER',	'REQSET_GA_PROMOTION_ZWEIHANDER_WITH_MELEE'),
-- ('MODIFIER_GA_PROMOTION_ZWEIHANDER_MELEE_BUFF',				'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		Null);

-- INSERT INTO ModifierArguments
-- (ModifierId,													Name,			Value)
-- VALUES			
-- ('MODIFIER_GA_PROMOTION_ZWEIHANDER_COMBAT_BONUS_TO_MELEE',		'ModifierId',	'MODIFIER_GA_PROMOTION_ZWEIHANDER_MELEE_BUFF'),
-- ('MODIFIER_GA_PROMOTION_ZWEIHANDER_MELEE_BUFF',					'Amount',		5);

-- INSERT INTO ModifierStrings	
-- (ModifierId,										Context,	Text)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_ZWEIHANDER_MELEE_BUFF',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_ZWEIHANDER_MELEE_BUFF_TEXT');

-- INSERT INTO RequirementSets	
-- (RequirementSetId,								RequirementSetType)
-- VALUES
-- ('REQSET_GA_PROMOTION_ZWEIHANDER_WITH_MELEE',	'REQUIREMENTSET_TEST_ALL');

-- INSERT INTO RequirementSetRequirements	
-- (RequirementSetId,								RequirementId)
-- VALUES
-- ('REQSET_GA_PROMOTION_ZWEIHANDER_WITH_MELEE',	'REQUIREMENT_UNIT_IS_MELEE'),
-- ('REQSET_GA_PROMOTION_ZWEIHANDER_WITH_MELEE',	'REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE');

INSERT INTO Requirements	
(RequirementId,								RequirementType)
VALUES	
('REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE',		'REQUIREMENT_PLOT_ADJACENT_TO_OWNER');

INSERT INTO RequirementArguments	
(RequirementId,							Name,			Value)
VALUES
('REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE',	'MinDistance',	1),
('REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE',	'MaxDistance',	1);
--===
--右线1：PROMOTION_TORTOISE 龟形盾
--原：防御远程攻击时+10战斗力。
--改：受伤时不减战斗力。
--===
-- DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_TORTOISE' AND ModifierId = 'TORTOISE_DEFENSE_BONUS_VS_RANGED_COMBAT';
--===
--右线2：PROMOTION_AMPHIBIOUS 水陆两栖
--原：从海洋或河流进行攻击时，免除战斗力和移动力减益。
--改：从海洋或河流进行攻击时，免除战斗力和移动力减益。可攀登悬崖。
--===
INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_AMPHIBIOUS',	'COMMANDO_BONUS_IGNORE_CLIFF_WALLS');
--===
--右线3：PROMOTION_URBAN_WARFARE 城镇战
--原：当在区域内攻击时+10战斗力。
--改：组成编队时+10战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_URBAN_WARFARE' AND ModifierId = 'URBAN_WARFARE_BONUS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_URBAN_WARFARE',	'MODIFIER_GA_PROMOTION_URBAN_WARFARE_IN_FORMATION_BUFF');

INSERT INTO Modifiers
(ModifierId,												ModifierType,								SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_URBAN_WARFARE_IN_FORMATION_BUFF',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		'CONVOY_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,													Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_URBAN_WARFARE_IN_FORMATION_BUFF',		'Amount',		10);

INSERT INTO ModifierStrings	
(ModifierId,													Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_URBAN_WARFARE_IN_FORMATION_BUFF',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_URBAN_WARFARE_IN_FORMATION_BUFF_TEXT');
--===
--中线4：PROMOTION_ELITE_GUARD	精英卫队
--原：如果移动力允许，每回合+1额外攻击。可在攻击后移动。
--无更改
--===
--------------------------------------------------------------
-- Ranged
--------------------------------------------------------------
--===
--左线1：PROMOTION_VOLLEY 齐射
--原：与陆地单位战斗时+5远程攻击力。
--无更改
--===
--===
--左线2：PROMOTION_ARROW_STORM 风暴之箭
--原：与陆地和海军单位战斗时+7远程攻击力。
--改：与海军单位和水运单位战斗时+10远程攻击力。（实际上判定条件是攻击水中的单位）
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ARROW_STORM' AND ModifierId = 'ARROW_STORM_BONUS_VS_LAND_AND_SEA_UNITS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_ARROW_STORM',	'MODIFIER_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER');

INSERT INTO Modifiers
(ModifierId,												ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'REQSET_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER');

INSERT INTO ModifierArguments
(ModifierId,													Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',		'Amount',	10);

INSERT INTO ModifierStrings	
(ModifierId,													Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,											RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,											RequirementId)
VALUES
('REQSET_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENT'),
('REQSET_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',	'OPPONENT_IS_NOT_AIR_UNIT_REQUIREMENTS'),
('REQSET_GA_PROMOTION_ARROW_STORM_COMBAT_BONUS_IN_WATER',	'REQ_GA_PLOT_IN_WATER');

INSERT INTO Requirements	
(RequirementId,				RequirementType)
VALUES	
('REQ_GA_PLOT_IN_WATER',	'REQUIREMENT_PLOT_TERRAIN_CLASS_MATCHES');

INSERT INTO RequirementArguments	
(RequirementId,				Name,		Value)
VALUES
('REQ_GA_PLOT_IN_WATER',	'Tag',		'TERRAIN_CLASS_WATER');
--===
--左线3：PROMOTION_SUPPRESSION 压制
--原：学会区域控制。
--改：获得区域控制，+5远程攻击力。
--===
INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_SUPPRESSION',	'MODIFIER_GA_PROMOTION_SUPPRESSION_ATTACK_BONUS');

INSERT INTO Modifiers
(ModifierId,										ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_SUPPRESSION_ATTACK_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,											Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_SUPPRESSION_ATTACK_BONUS',		'Amount',	5);

INSERT INTO ModifierStrings	
(ModifierId,											Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_SUPPRESSION_ATTACK_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_SUPPRESSION_ATTACK_BONUS_TEXT');
--===
--右线1：PROMOTION_GARRISON 驻军
--原：占领一个区域或提供防御力的改良设施时+10战斗力。
--无改动
--===
--===
--右线2：PROMOTION_INCENDIARIES 燃烧弹
--原：攻击区域防御时+7远程攻击力。
--改：在友方领土内+5战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_INCENDIARIES' AND ModifierId = 'INCENDIARIES_BONUS_VS_DISTRICT_DEFENSES';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_INCENDIARIES',	'MODIFIER_GA_PROMOTION_INCENDIARIES_HOME_BONUS');

INSERT INTO Modifiers
(ModifierId,										ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_INCENDIARIES_HOME_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'COSSACK_PLOT_IS_OWNER_OR_ADJACENT_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,											Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_INCENDIARIES_HOME_BONUS',		'Amount',	5);

INSERT INTO ModifierStrings	
(ModifierId,											Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_INCENDIARIES_HOME_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_INCENDIARIES_HOME_BONUS_TEXT');
--===
--右线3：PROMOTION_EMPLACEMENT 炮台
--原：防御城市攻击时+10战斗力。
--改：-1移动力。+1视野。+10远程攻击力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_EMPLACEMENT' AND ModifierId = 'EMPLACEMENT_DEFENSE_BONUS_VS_CITIES';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_EMPLACEMENT',	'MODIFIER_GA_PROMOTION_EMPLACEMENT_LOSE_MOVEMENT'),
('PROMOTION_EMPLACEMENT',	'MODIFIER_GA_PROMOTION_EMPLACEMENT_SIGHT_BONUS'),
('PROMOTION_EMPLACEMENT',	'MODIFIER_GA_PROMOTION_EMPLACEMENT_ATTACK_BONUS');

INSERT INTO Modifiers
(ModifierId,										ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_EMPLACEMENT_LOSE_MOVEMENT',	'MODIFIER_PLAYER_UNIT_ADJUST_MOVEMENT',	Null),
('MODIFIER_GA_PROMOTION_EMPLACEMENT_SIGHT_BONUS',	'MODIFIER_PLAYER_UNIT_ADJUST_SIGHT',	Null),
('MODIFIER_GA_PROMOTION_EMPLACEMENT_ATTACK_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,											Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_EMPLACEMENT_LOSE_MOVEMENT',		'Amount',		-1),
('MODIFIER_GA_PROMOTION_EMPLACEMENT_SIGHT_BONUS',		'Amount',		1),
('MODIFIER_GA_PROMOTION_EMPLACEMENT_ATTACK_BONUS',		'Amount',		10);

INSERT INTO ModifierStrings	
(ModifierId,											Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_EMPLACEMENT_ATTACK_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_EMPLACEMENT_ATTACK_BONUS_TEXT');
--===
--中线4：PROMOTION_EXPERT_MARKSMAN	神枪手
--原：如果单位没有移动，每回合+1额外攻击。
--无更改
--===
--------------------------------------------------------------
-- Anti_Cavalry
--------------------------------------------------------------
--===
--左线1：PROMOTION_ECHELON 梯队
--原：与骑兵单位战斗时+5战斗力。
--改：攻击时-5力，防御时+10力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ECHELON' AND ModifierId = 'ECHELON_ADDITIONAL_CAVALRY_BONUS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_ECHELON',	'MODIFIER_GA_PROMOTION_ECHELON_ATTACK'),
('PROMOTION_ECHELON',	'MODIFIER_GA_PROMOTION_ECHELON_DEFEND');

INSERT INTO Modifiers
(ModifierId,								ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_ECHELON_ATTACK',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENTS'),
('MODIFIER_GA_PROMOTION_ECHELON_DEFEND',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_WEAK_WHEN_DEFENDING_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,									Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_ECHELON_ATTACK',		'Amount',		-5),
('MODIFIER_GA_PROMOTION_ECHELON_DEFEND',		'Amount',		10);

INSERT INTO ModifierStrings	
(ModifierId,									Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_ECHELON_ATTACK',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_ECHELON_ATTACK_TEXT'),
('MODIFIER_GA_PROMOTION_ECHELON_DEFEND',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_ECHELON_DEFEND_TEXT');
--===
--左线2：PROMOTION_SQUARE	方阵
--原：双倍支援加成。
--无更改
--===
--===
--左线3：PROMOTION_REDEPLOY	重新部署
--原：+1移动力。
--改：为相邻的抗骑兵单位+5力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_REDEPLOY' AND ModifierId = 'REDEPLOY_BONUS_MOVEMENT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_REDEPLOY',	'MODIFIER_GA_PROMOTION_REDEPLOY_COMBAT_BONUS_TO_ANTI_CAVALRY');

INSERT INTO Modifiers
(ModifierId,													ModifierType,								SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_REDEPLOY_COMBAT_BONUS_TO_ANTI_CAVALRY',	'MODIFIER_PLAYER_UNITS_ATTACH_MODIFIER',	'REQSET_GA_PROMOTION_REDEPLOY_WITH_ANTI_CAVALRY'),
('MODIFIER_GA_PROMOTION_REDEPLOY_ANTI_CAVALRY_BUFF',			'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		Null);

INSERT INTO ModifierArguments
(ModifierId,														Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_REDEPLOY_COMBAT_BONUS_TO_ANTI_CAVALRY',		'ModifierId',	'MODIFIER_GA_PROMOTION_REDEPLOY_ANTI_CAVALRY_BUFF'),
('MODIFIER_GA_PROMOTION_REDEPLOY_ANTI_CAVALRY_BUFF',				'Amount',		5);

INSERT INTO ModifierStrings	
(ModifierId,											Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_REDEPLOY_ANTI_CAVALRY_BUFF',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_REDEPLOY_ANTI_CAVALRY_BUFF_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,									RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_REDEPLOY_WITH_ANTI_CAVALRY',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,									RequirementId)
VALUES
('REQSET_GA_PROMOTION_REDEPLOY_WITH_ANTI_CAVALRY',	'REQUIREMENT_UNIT_IS_ANTI_CAV'),
('REQSET_GA_PROMOTION_REDEPLOY_WITH_ANTI_CAVALRY',	'REQ_GA_PROMOTION_FRIENDLY_IN_1_TILE');
--===
--右线1：PROMOTION_THRUST 突袭
--原：与近战单位战斗时+10战斗力。
--改：与未受伤单位战斗时+10力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_THRUST' AND ModifierId = 'THRUST_BONUS_VS_MELEE';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
SELECT
'PROMOTION_THRUST',	'MODIFIER_GA_PROMOTION_THRUST_COMBAT_UNWOUNDED_BONUS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_AUTOMATIC_GUN');

INSERT INTO Modifiers
(ModifierId,													ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_THRUST_COMBAT_UNWOUNDED_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'REQSET_GA_PROMOTION_OPPONENT_NOT_WOUNDED');

INSERT INTO ModifierArguments
(ModifierId,														Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_THRUST_COMBAT_UNWOUNDED_BONUS',		'Amount',	10);

INSERT INTO ModifierStrings	
(ModifierId,														Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_THRUST_COMBAT_UNWOUNDED_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_THRUST_COMBAT_UNWOUNDED_BONUS_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,								RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_OPPONENT_NOT_WOUNDED',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,								RequirementId)
VALUES
('REQSET_GA_PROMOTION_OPPONENT_NOT_WOUNDED',	'REQ_GA_PROMOTION_OPPONENT_NOT_WOUNDED');

INSERT INTO Requirements	
(RequirementId,								RequirementType,					Inverse)
VALUES	
('REQ_GA_PROMOTION_OPPONENT_NOT_WOUNDED',	'REQUIREMENT_OPPONENT_IS_WOUNDED',	1);
--===
--右线2：PROMOTION_SCHILTRON 长矛阵
--原：防御近战系单位攻击时+10战斗力。
--改：占领一个区域或提供防御力的改良设施时+10战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_SCHILTRON' AND ModifierId = 'SCHILTRON_DEFENSE_BONUS_VS_MELEE';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_SCHILTRON',	'SAMURAI_NO_REDUCTION_DAMAGE');

-- INSERT INTO UnitPromotionModifiers			
-- (UnitPromotionType,		ModifierId)
-- VALUES
-- ('PROMOTION_SCHILTRON',	'MODIFIER_GA_PROMOTION_SCHILTRON_DEFEND_BONUS_IN_DISTRICT');

-- INSERT INTO Modifiers
-- (ModifierId,														ModifierType,							SubjectRequirementSetId)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_SCHILTRON_DEFEND_BONUS_IN_DISTRICT',		'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'GARRISON_REQUIREMENTS');

-- INSERT INTO ModifierArguments
-- (ModifierId,													Name,			Value)
-- VALUES			
-- ('MODIFIER_GA_PROMOTION_SCHILTRON_DEFEND_BONUS_IN_DISTRICT',	'Amount',		10);

-- INSERT INTO ModifierStrings	
-- (ModifierId,													Context,	Text)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_SCHILTRON_DEFEND_BONUS_IN_DISTRICT',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_SCHILTRON_DEFEND_BONUS_IN_DISTRICT_TEXT');
--===
--右线3：PROMOTION_CHOKE_POINTS 咽喉要道
--原：在树林、丛林、丘陵或沼泽防御时+7战斗力。
--改：在树林、丛林、丘陵或沼泽防御时+10战斗力。
--===
UPDATE	ModifierArguments
SET		Value = 10
WHERE	ModifierId = 'CHOKE_POINTS_BONUS';
--===
--中线4：PROMOTION_HOLD_THE_LINE	压阵
--原：与骑兵战斗时，若与不同类型战斗单位相邻+10战斗力。
--改：若与不同类型战斗单位相邻+10战斗力。
--===
UPDATE	Modifiers
SET		SubjectRequirementSetId = Null
WHERE	ModifierId = 'HOLD_THE_LINE_COMBAT_BONUS';
--------------------------------------------------------------
-- Heavy_Cavalry
--------------------------------------------------------------
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_MARAUDING' AND PrereqUnitPromotion = 'PROMOTION_ROUT';
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_ROUT' AND PrereqUnitPromotion = 'PROMOTION_MARAUDING';
DELETE FROM TypeTags WHERE Type = 'ABILITY_IGNORE_ZOC' AND Tag = 'CLASS_HEAVY_CAVALRY';
--===
--左线1：PROMOTION_CHARGE 冲锋
--原：与驻扎单位战斗时+10战斗力。
--改：无视区域控制。与驻扎单位战斗时+10战斗力。
--===
INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_CHARGE',	'IGNOREZOC_IGNORE_ZOC');
--===
--左线2：PROMOTION_MARAUDING 抢劫
--原：在区域内战斗时，+7战斗力。
--改：伤害点数高于敌方的状况下，会将防守的敌方单位推至后方的单元格。无法后退的防守单位会遭受额外伤害。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_MARAUDING' AND ModifierId = 'URBAN_RAIDER_BONUS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_MARAUDING',	'HUSSAR_FORCE_RETREAT');
--===
--左线3：PROMOTION_ARMOR_PIERCING 穿透护甲
--原：与其他重骑兵单位战斗时+7战斗力。
--改：-1移动力，任何时候+5力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ARMOR_PIERCING' AND ModifierId = 'ARMOR_PIERCING_BONUS_VS_HEAVY_CAVALRY';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_ARMOR_PIERCING',	'MODIFIER_GA_PROMOTION_ARMOR_PIERCING_LOSE_MOVEMENT'),
('PROMOTION_ARMOR_PIERCING',	'MODIFIER_GA_PROMOTION_ARMOR_PIERCING_COMBAT_BONUS');

INSERT INTO Modifiers
(ModifierId,											ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_ARMOR_PIERCING_LOSE_MOVEMENT',	'MODIFIER_PLAYER_UNIT_ADJUST_MOVEMENT'),
('MODIFIER_GA_PROMOTION_ARMOR_PIERCING_COMBAT_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH');

INSERT INTO ModifierArguments
(ModifierId,											Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_ARMOR_PIERCING_LOSE_MOVEMENT',		'Amount',		-1),
('MODIFIER_GA_PROMOTION_ARMOR_PIERCING_COMBAT_BONUS',		'Amount',		5);

INSERT INTO ModifierStrings	
(ModifierId,											Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_ARMOR_PIERCING_COMBAT_BONUS',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_ARMOR_PIERCING_COMBAT_BONUS_TEXT');
--===
--右线1：PROMOTION_BARDING 战马铠甲
--原：防御远程攻击时+7战斗力。
--改：与抗骑兵单位战斗时+10战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_BARDING' AND ModifierId = 'TOP_COVER_DEFENSE_BONUS_VS_RANGED';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_BARDING',			'MODIFIER_GA_PROMOTION_BARDING_COMBAT_BONUS_VS_ANTI_CAVALRY');

INSERT INTO Modifiers
(ModifierId,													ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_BARDING_COMBAT_BONUS_VS_ANTI_CAVALRY',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'ANTI_SPEAR_OPPONENT_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,														Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_BARDING_COMBAT_BONUS_VS_ANTI_CAVALRY',		'Amount',		10);

INSERT INTO ModifierStrings	
(ModifierId,													Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_BARDING_COMBAT_BONUS_VS_ANTI_CAVALRY',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_BARDING_COMBAT_BONUS_VS_ANTI_CAVALRY_TEXT');
--===
--右线2：PROMOTION_ROUT 击溃
--原：与受损单位战斗时+5战斗力。
--无更改
--===
--===
--右线3：PROMOTION_REACTIVE_ARMOR 反应装甲
--原：防御重骑兵和抗骑兵单位攻击时+7战斗力。
--改：相邻敌方单位-5力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_REACTIVE_ARMOR' AND ModifierId = 'REACTIVE_ARMOR_BONUS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_REACTIVE_ARMOR',	'MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY');

INSERT INTO Modifiers
(ModifierId,												ModifierType,								SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY',	'MODIFIER_ALL_UNITS_ATTACH_MODIFIER',		'REQSET_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY');

INSERT INTO Modifiers
(ModifierId,												ModifierType,								SubjectStackLimit)
VALUES
('MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_ENEMY_DEBUFF',		'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',		1);

INSERT INTO ModifierArguments
(ModifierId,												Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY',	'ModifierId',	'MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_ENEMY_DEBUFF'),
('MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_ENEMY_DEBUFF',		'Amount',		-5);

INSERT INTO ModifierStrings	
(ModifierId,										Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_ENEMY_DEBUFF',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_REACTIVE_ARMOR_ENEMY_DEBUFF_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,									RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,									RequirementId)
VALUES
('REQSET_GA_PROMOTION_REACTIVE_ARMOR_DEBUFF_TO_ENEMY',	'REQ_GA_PROMOTION_ENEMY_IN_1_TILE');

INSERT INTO Requirements	
(RequirementId,								RequirementType)
VALUES	
('REQ_GA_PROMOTION_ENEMY_IN_1_TILE',		'REQUIREMENT_PLOT_ADJACENT_TO_OWNER_AT_WAR');

INSERT INTO RequirementArguments	
(RequirementId,							Name,			Value)
VALUES
('REQ_GA_PROMOTION_ENEMY_IN_1_TILE',	'MinDistance',	1),
('REQ_GA_PROMOTION_ENEMY_IN_1_TILE',	'MaxDistance',	1);
--===
--中线4：PROMOTION_BREAKTHROUGH	突破
--原：如果移动力允许，每回合+1额外攻击。
--改：攻击区域防御时+10力。
--===
-- DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_BREAKTHROUGH' AND ModifierId = 'REACTIVE_ARMOR_BONUS';

-- INSERT INTO UnitPromotionModifiers			
-- (UnitPromotionType,				ModifierId)
-- VALUES
-- ('PROMOTION_BREAKTHROUGH',		'MODIFIER_GA_PROMOTION_BREAKTHROUGH_COMBAT_VS_DISTRICT');

-- INSERT INTO Modifiers
-- (ModifierId,												ModifierType,							SubjectRequirementSetId)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_BREAKTHROUGH_COMBAT_VS_DISTRICT',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'URBAN_WARFARE_REQUIREMENTS');

-- INSERT INTO ModifierArguments
-- (ModifierId,													Name,			Value)
-- VALUES			
-- ('MODIFIER_GA_PROMOTION_BREAKTHROUGH_COMBAT_VS_DISTRICT',		'Amount',		10);

-- INSERT INTO ModifierStrings	
-- (ModifierId,													Context,	Text)
-- VALUES
-- ('MODIFIER_GA_PROMOTION_BREAKTHROUGH_COMBAT_VS_DISTRICT',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_BREAKTHROUGH_COMBAT_VS_DISTRICT_TEXT');
--------------------------------------------------------------
-- Light_Cavalry
--------------------------------------------------------------
DELETE FROM TypeTags WHERE Type = 'ABILITY_IGNORE_ZOC' AND Tag = 'CLASS_LIGHT_CAVALRY';
--===
--左线1：PROMOTION_CAPARISON 马衣
--原：与抗骑兵单位战斗时+5战斗力。
--改：+1移动力。无视区域控制。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_CAPARISON' AND ModifierId = 'CAPARISON_BONUS_VS_ANTI_CAVALRY';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_CAPARISON',	'IGNOREZOC_IGNORE_ZOC'),
('PROMOTION_CAPARISON',	'MODIFIER_GA_PROMOTION_CAPARISON_GAIN_MOVEMENT');

INSERT INTO Modifiers
(ModifierId,										ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_CAPARISON_GAIN_MOVEMENT',	'MODIFIER_PLAYER_UNIT_ADJUST_MOVEMENT');

INSERT INTO ModifierArguments
(ModifierId,											Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_CAPARISON_GAIN_MOVEMENT',		'Amount',		1);
--===
--左线2：PROMOTION_DEPREDATION 掠夺
--原：掠夺只消耗1个移动力。
--无更改
--===
--===
--左线3：PROMOTION_SPIKING_THE_GUNS 火药失效
--原：与攻城单位战斗时+7战斗力。
--改：在无地貌的平坦地形攻击时+10战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_SPIKING_THE_GUNS' AND ModifierId = 'SPIKING_THE_GUNS_BONUS_VS_SIEGE';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_SPIKING_THE_GUNS',	'MODIFIER_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA');

INSERT INTO Types			
(Type,							Kind)
VALUES
('TERRAIN_CLASS_GA_FLATLAND',	'KIND_TERRAIN_CLASS');

INSERT INTO TerrainClasses			
(TerrainClassType,				Name)
VALUES
('TERRAIN_CLASS_GA_FLATLAND',	'LOC_TERRAIN_CLASS_GA_FLATLAND_NAME');

INSERT INTO TerrainClass_Terrains			
(TerrainClassType,				TerrainType)
VALUES
('TERRAIN_CLASS_GA_FLATLAND',	'TERRAIN_GRASS'),
('TERRAIN_CLASS_GA_FLATLAND',	'TERRAIN_PLAINS'),
('TERRAIN_CLASS_GA_FLATLAND',	'TERRAIN_DESERT'),
('TERRAIN_CLASS_GA_FLATLAND',	'TERRAIN_TUNDRA'),
('TERRAIN_CLASS_GA_FLATLAND',	'TERRAIN_SNOW');

INSERT INTO Modifiers
(ModifierId,															ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA');

INSERT INTO ModifierArguments
(ModifierId,																Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',		'Amount',		10);

INSERT INTO ModifierStrings			
(ModifierId,															Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA_TEXT');

INSERT INTO RequirementSets	
(RequirementSetId,													RequirementSetType)
VALUES
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQUIREMENTSET_TEST_ALL');

INSERT INTO RequirementSetRequirements	
(RequirementSetId,													RequirementId)
VALUES
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'UNIT_STRONG_WHEN_ATTACKING_REQUIREMENT'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQ_GA_PROMOTION_ON_FLAT_TERRAIN'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQ_GA_PROMOTION_NO_FOREST'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQ_GA_PROMOTION_NO_JUNGLE'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQ_GA_PROMOTION_NO_MARSH'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQ_GA_PROMOTION_NO_OASIS'),
('REQSET_GA_PROMOTION_SPIKING_THE_GUNS_ATTACK_BONUS_ON_CLEAR_AREA',	'REQUIRES_PLOT_HAS_NO_FLOODPLAINS');

INSERT INTO Requirements	
(RequirementId,								RequirementType,							Inverse)
VALUES	
('REQ_GA_PROMOTION_ON_FLAT_TERRAIN',		'REQUIREMENT_PLOT_TERRAIN_CLASS_MATCHES',	0),
('REQ_GA_PROMOTION_NO_FOREST',				'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES',	1),
('REQ_GA_PROMOTION_NO_JUNGLE',				'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES',	1),
('REQ_GA_PROMOTION_NO_MARSH',				'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES',	1),
('REQ_GA_PROMOTION_NO_OASIS',				'REQUIREMENT_PLOT_FEATURE_TYPE_MATCHES',	1);

INSERT INTO RequirementArguments	
(RequirementId,							Name,			Value)
VALUES
('REQ_GA_PROMOTION_ON_FLAT_TERRAIN',	'TerrainClass',	'TERRAIN_CLASS_GA_FLATLAND'),
('REQ_GA_PROMOTION_NO_FOREST',			'FeatureType',	'FEATURE_FOREST'),
('REQ_GA_PROMOTION_NO_JUNGLE',			'FeatureType',	'FEATURE_JUNGLE'),
('REQ_GA_PROMOTION_NO_MARSH',			'FeatureType',	'FEATURE_MARSH'),
('REQ_GA_PROMOTION_NO_OASIS',			'FeatureType',	'FEATURE_OASIS');
--===
--右线1：PROMOTION_COURSERS 追猎者
--原：攻击远程和攻城单位时+5战斗力。
--改：（季票）遭到夹击时+10战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE (UnitPromotionType = 'PROMOTION_COURSERS' AND ModifierId = 'COURSERS_BONUS_VS_RANGED_SIEGE') AND EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_NIHANG');

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
SELECT
'PROMOTION_COURSERS',	'MODIFIER_GA_PROMOTION_COURSERS_FLANKED_BONUS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_NIHANG');

INSERT INTO Modifiers
(ModifierId,									ModifierType,							SubjectRequirementSetId)
SELECT
'MODIFIER_GA_PROMOTION_COURSERS_FLANKED_BONUS',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'UNIT_IS_FLANKED_REQUIREMENTS'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_NIHANG');

INSERT INTO ModifierArguments
(ModifierId,									Name,			Value)
SELECT		
'MODIFIER_GA_PROMOTION_COURSERS_FLANKED_BONUS',	'Amount',		10
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_NIHANG');

INSERT INTO ModifierStrings	
(ModifierId,									Context,	Text)
SELECT	
'MODIFIER_GA_PROMOTION_COURSERS_FLANKED_BONUS',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_COURSERS_FLANKED_BONUS_TEXT'
WHERE EXISTS (SELECT * FROM UnitPromotionClasses WHERE PromotionClassType = 'PROMOTION_CLASS_NIHANG');
--===
--右线2：PROMOTION_DOUBLE_ENVELOPMENT 两翼包围
--原：两倍夹击加成。
--无更改
--===
--===
--右线3：PROMOTION_PURSUIT 追击
--原：+1移动力。
--改：编队单位全部获得陪护单位移动力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_PURSUIT' AND ModifierId = 'PURSUIT_BONUS_MOVEMENT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_PURSUIT',	'ESCORT_MOBILITY_SHARED_MOVEMENT');
--===
--中线4：PROMOTION_ESCORT_MOBILITY 护卫队机动性
--原：编队单位全部获得陪护单位移动力。
--改：每点未使用的移动力提供+3战斗力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ESCORT_MOBILITY' AND ModifierId = 'ESCORT_MOBILITY_SHARED_MOVEMENT';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_ESCORT_MOBILITY',	'MODIFIER_GA_PROMOTION_ESCORT_MOBILITY_COMBAT_BONUS_FROM_UNUSE_MOVEMENT');

INSERT INTO Modifiers
(ModifierId,																ModifierType)
VALUES
('MODIFIER_GA_PROMOTION_ESCORT_MOBILITY_COMBAT_BONUS_FROM_UNUSE_MOVEMENT',	'MODIFIER_SINGLE_UNIT_ADJUST_COMBAT_FOR_UNUSED_MOVEMENT');

INSERT INTO ModifierArguments
(ModifierId,																Name,			Value)
VALUES			
('MODIFIER_GA_PROMOTION_ESCORT_MOBILITY_COMBAT_BONUS_FROM_UNUSE_MOVEMENT',	'Amount',		3);

INSERT INTO ModifierStrings			
(ModifierId,															Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_ESCORT_MOBILITY_COMBAT_BONUS_FROM_UNUSE_MOVEMENT',	'Preview',	'LOC_MODIFIER_GA_PROMOTION_ESCORT_MOBILITY_COMBAT_BONUS_FROM_UNUSE_MOVEMENT_TEXT');
--------------------------------------------------------------
-- Siege
--------------------------------------------------------------
--===
--左线1：PROMOTION_GRAPE_SHOT 霰弹
--原：与陆地单位战斗时+7战斗力。
--改：防御时+10战斗力
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_GRAPE_SHOT' AND ModifierId = 'GRAPE_SHOT_BONUS_VS_UNITS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_GRAPE_SHOT',	'MODIFIER_GA_PROMOTION_GRAPE_SHOT_DEFEND_BONUS');

INSERT INTO Modifiers
(ModifierId,										ModifierType,							SubjectRequirementSetId)
VALUES
('MODIFIER_GA_PROMOTION_GRAPE_SHOT_DEFEND_BONUS',		'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',	'CREW_WEAPONS_REQUIREMENTS');

INSERT INTO ModifierArguments
(ModifierId,										Name,		Value)
VALUES			
('MODIFIER_GA_PROMOTION_GRAPE_SHOT_DEFEND_BONUS',		'Amount',	10);

INSERT INTO ModifierStrings	
(ModifierId,										Context,	Text)
VALUES
('MODIFIER_GA_PROMOTION_GRAPE_SHOT_DEFEND_BONUS',		'Preview',	'LOC_MODIFIER_GA_PROMOTION_GRAPE_SHOT_DEFEND_BONUS_TEXT');
--===
--左线2：PROMOTION_SHRAPNEL 榴霰弹
--原：与陆地单位战斗时+10战斗力。
--改：对陆地单位攻击效率为100%。（与陆地单位战斗时+20战斗力。）
--===
UPDATE ModifierArguments SET  Value = 20
WHERE ModifierId = 'SHRAPNEL_BONUS_VS_UNITS' AND Name = 'Amount';

--===
--左线3：PROMOTION_ADVANCED_RANGEFINDING 先进测距
--原：与海军单位战斗时+10战斗力。
--改：+1射程
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_ADVANCED_RANGEFINDING' AND ModifierId = 'ADVANCED_RANGEFINDING_BONUS_VS_NAVAL';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_ADVANCED_RANGEFINDING',	'FORWARD_OBSERVERS_BONUS_RANGE');
--===
--右线1：PROMOTION_CREW_WEAPONS 重武器
--原：防御时+7战斗力。
--改：+1移动力。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_CREW_WEAPONS' AND ModifierId = 'CREW_WEAPONS_DEFENSE_BONUS';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,		ModifierId)
VALUES
('PROMOTION_CREW_WEAPONS',	'COMMANDO_BONUS_MOVEMENT');
--===
--右线2：PROMOTION_SHELLS 炮弹
--原：防御时+7战斗力。
--无更改
--===
--===
--右线3：PROMOTION_EXPERT_CREW 专家组
--原：移动后可攻击。
--改：移动后可攻击，攻击后可移动。
--===
INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,			ModifierId)
VALUES
('PROMOTION_EXPERT_CREW',	'MOD_MOVE_AFTER_ATTACKING');
--===
--中线4：PROMOTION_FORWARD_OBSERVERS 前方观察员
--原：+1射程。
--改：如果单位没有移动，每回合+1额外攻击。
--===
DELETE FROM UnitPromotionModifiers WHERE UnitPromotionType = 'PROMOTION_FORWARD_OBSERVERS' AND ModifierId = 'FORWARD_OBSERVERS_BONUS_RANGE';

INSERT INTO UnitPromotionModifiers			
(UnitPromotionType,				ModifierId)
VALUES
('PROMOTION_FORWARD_OBSERVERS',	'EXPERT_MARKSMAN_ADDITIONAL_ATTACK');

--------------------------------------------------------------
--航母晋升
--------------------------------------------------------------
--UnitPromotions
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_FLIGHT_DECK';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_SCOUT_PLANES';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_HANGAR_DECK';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_ADVANCED_ENGINES';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_FOLDING_WINGS';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_DECK_CREWS';
UPDATE UnitPromotions SET  Level = 1
WHERE UnitPromotionType = 'PROMOTION_SUPER_CARRIER';
--UnitPromotionPrereqs
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_HANGAR_DECK';
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_ADVANCED_ENGINES';
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_FOLDING_WINGS';
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_DECK_CREWS';
DELETE FROM UnitPromotionPrereqs WHERE UnitPromotion = 'PROMOTION_SUPER_CARRIER';
--TechnologyModifiers
INSERT OR REPLACE INTO TechnologyModifiers	(TechnologyType,				ModifierId) VALUES
('TECH_GUIDANCE_SYSTEMS',	    'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FLIGHT_DECK'),
('TECH_ADVANCED_AI',		    'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SCOUT_PLANES'),
('TECH_ADVANCED_POWER_CELLS',	'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_HANGAR_DECK'),
('TECH_CYBERNETICS',		    'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_ADVANCED_ENGINES'),
('TECH_SMART_MATERIALS',		'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FOLDING_WINGS'),
('TECH_PREDICTIVE_SYSTEMS',		'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_DECK_CREWS'),
('TECH_SEASTEADS',				'GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SUPER_CARRIER');
--Modifiers
INSERT OR REPLACE INTO Modifiers	(ModifierId,											ModifierType,								SubjectRequirementSetId) VALUES
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FLIGHT_DECK',			'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SCOUT_PLANES',			'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_HANGAR_DECK',			'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_ADVANCED_ENGINES',		'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FOLDING_WINGS',		'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_DECK_CREWS',			'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SUPER_CARRIER',		'MODIFIER_PLAYER_UNITS_GRANT_PROMOTION',	'GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS');
--ModifierArguments
INSERT OR REPLACE INTO ModifierArguments	(ModifierId,											Name,						Value) VALUES
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FLIGHT_DECK',			'PromotionType',			'PROMOTION_FLIGHT_DECK'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SCOUT_PLANES',			'PromotionType',			'PROMOTION_SCOUT_PLANES'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_HANGAR_DECK',			'PromotionType',			'PROMOTION_HANGAR_DECK'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_ADVANCED_ENGINES',		'PromotionType',			'PROMOTION_ADVANCED_ENGINES'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_FOLDING_WINGS',		'PromotionType',			'PROMOTION_FOLDING_WINGS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_DECK_CREWS',			'PromotionType',			'PROMOTION_DECK_CREWS'),
('GOLDEN_MODIFIER_AIRCRAFT_CARRIER_UPGRADE_PROMOTION_SUPER_CARRIER',		'PromotionType',			'PROMOTION_SUPER_CARRIER');
--RequirementSets
INSERT OR REPLACE INTO RequirementSets	(RequirementSetId,								RequirementSetType) VALUES
('GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS',			'REQUIREMENTSET_TEST_ALL');
--RequirementSets
INSERT OR REPLACE INTO RequirementSetRequirements	(RequirementSetId,								RequirementId) VALUES
('GOLDEN_UNIT_IS_CARRIER_REQUIREMENTS',			'GOLDEN_REQUIRES_UNIT_IS_NAVAL_CARRIER');
--Requirements
INSERT OR REPLACE INTO Requirements	(RequirementId,								RequirementType) VALUES
('GOLDEN_REQUIRES_UNIT_IS_NAVAL_CARRIER',		'REQUIREMENT_UNIT_TAG_MATCHES');
--RequirementArguments
INSERT OR REPLACE INTO RequirementArguments	(RequirementId,								Name,		Value) VALUES
('GOLDEN_REQUIRES_UNIT_IS_NAVAL_CARRIER',		'Tag',		'CLASS_NAVAL_CARRIER');