---------------------------------------------------------------------------------------------------------------
-- TraitModifiers
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType,						ModifierId) VALUES	
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY'),
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY'),
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY'),
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY'),
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY'),
('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY'),
-- ('TRAIT_CIVILIZATION_CREE_TRADE_GAIN_TILES',	'GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY'),
('TRAIT_LEADER_ALLIANCE_AND_TRADE',	            'GOLDEN_TRAIT_UNITS_IGNORE_WOOD'),
('TRAIT_LEADER_ALLIANCE_AND_TRADE',	            'GOLDEN_ALLIANCE_AND_TRADE_ALLIANCEPOINTS');
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_ALLIANCE_AND_TRADE' AND ModifierId = 'TRAIT_TRADE_FOOD_FROM_CAMPS';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_ALLIANCE_AND_TRADE' AND ModifierId = 'TRAIT_TRADE_GOLD_FROM_CAMPS';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_ALLIANCE_AND_TRADE' AND ModifierId = 'TRAIT_TRADE_FOOD_FROM_PASTURES';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_ALLIANCE_AND_TRADE' AND ModifierId = 'TRAIT_TRADE_GOLD_FROM_PASTURES';
---------------------------------------------------------------------------------------------------------------
-- Modifiers
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,											ModifierType,								RunOnce,	Permanent,	SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				    'MODIFIER_PLAYER_CITIES_FEATURE_ADJACENCY',	0,			0,			NULL),
('GOLDEN_TRAIT_UNITS_IGNORE_WOOD',	                        'MODIFIER_PLAYER_UNITS_GRANT_ABILITY',	    0,			0,			NULL),
('GOLDEN_ALLIANCE_AND_TRADE_ALLIANCEPOINTS',	            'MODIFIER_PLAYER_ADJUST_ALLIANCE_POINTS',	0,			0,			NULL);
---------------------------------------------------------------------------------------------------------------
-- ModifierArguments
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,											Name,			Value) VALUES	
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					'DistrictType',	'DISTRICT_CAMPUS'),
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					'YieldType',	'YIELD_SCIENCE'),
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					'Amount',		1),
('GOLDEN_TRAIT_CAMPUS_WOODS_ADJACENCY',					'Description',	'LOC_GOLDEN_DISTRICT_FOREST_SCIENCE'),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				'DistrictType',	'DISTRICT_THEATER'),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				'YieldType',	'YIELD_CULTURE'),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				'Amount',		1),
('GOLDEN_TRAIT_THEATER_WOODS_ADJACENCY',				'Description',	'LOC_GOLDEN_DISTRICT_FOREST_CULTURE'),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				'DistrictType',	'DISTRICT_HOLY_SITE'),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				'YieldType',	'YIELD_FAITH'),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				'Amount',		1),
('GOLDEN_TRAIT_HOLY_SITE_WOODS_ADJACENCY',				'Description',	'LOC_GOLDEN_DISTRICT_FOREST_FAITH'),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		'DistrictType',	'DISTRICT_INDUSTRIAL_ZONE'),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		'YieldType',	'YIELD_PRODUCTION'),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		'Amount',		1),
('GOLDEN_TRAIT_INDUSTRIAL_ZONE_WOODS_ADJACENCY',		'Description',	'LOC_GOLDEN_DISTRICT_FOREST_PRODUCTION'),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			'DistrictType',	'DISTRICT_COMMERCIAL_HUB'),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			'YieldType',	'YIELD_GOLD'),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			'Amount',		1),
('GOLDEN_TRAIT_COMMERCIAL_HUB_WOODS_ADJACENCY',			'Description',	'LOC_GOLDEN_DISTRICT_FOREST_GOLD'),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					'DistrictType',	'DISTRICT_HARBOR'),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					'FeatureType',	'FEATURE_FOREST'),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					'YieldType',	'YIELD_GOLD'),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					'Amount',		1),
('GOLDEN_TRAIT_HARBOR_WOODS_ADJACENCY',					'Description',	'LOC_GOLDEN_DISTRICT_FOREST_GOLD'),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				'DistrictType',	'DISTRICT_ENCAMPMENT'),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				'FeatureType',	'FEATURE_FOREST'),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				'YieldType',	'YIELD_FOOD'),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				'Amount',		1),
-- ('GOLDEN_TRAIT_ENCAMPMENT_WOODS_ADJACENCY',				'Description',	'LOC_GOLDEN_DISTRICT_FOREST_FOOD'),
('GOLDEN_TRAIT_UNITS_IGNORE_WOOD',		                'AbilityType',	'ABILITY_IGNORE_WOOD'),
('GOLDEN_ALLIANCE_AND_TRADE_ALLIANCEPOINTS',		    'Amount',	    1);
-----------------------------------------------
-- Types
-----------------------------------------------
INSERT OR REPLACE INTO Types (Type,						Kind) VALUES
('ABILITY_IGNORE_WOOD',					'KIND_ABILITY');
-----------------------------------------------
-- TypeTags
-----------------------------------------------		
INSERT OR REPLACE INTO TypeTags (Type,									Tag) VALUES	
('ABILITY_IGNORE_WOOD',				'CLASS_LIGHT_CAVALRY'),
('ABILITY_IGNORE_WOOD',			    'CLASS_HEAVY_CAVALRY'),
('ABILITY_IGNORE_WOOD',			    'CLASS_MELEE'),
('ABILITY_IGNORE_WOOD',			    'CLASS_RANGED'),
('ABILITY_IGNORE_WOOD',			    'CLASS_SIEGE'),
('ABILITY_IGNORE_WOOD',			    'CLASS_RECON'),
('ABILITY_IGNORE_WOOD',			    'CLASS_ANTI_CAVALRY');
INSERT OR REPLACE INTO TypeTags (Type, Tag) SELECT 'ABILITY_IGNORE_WOOD', 'CLASS_AUTOMATIC_GUN' WHERE EXISTS (SELECT UnitType FROM Units WHERE UnitType = 'UNIT_COMPOSITE_BOWMAN');
-----------------------------------------------
-- UnitAbilities
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilities
(UnitAbilityType,						Name,									Description, Inactive) VALUES	
('ABILITY_IGNORE_WOOD',			'LOC_ABILITY_IGNORE_WOOD_NAME',	'LOC_ABILITY_IGNORE_WOOD_DESCRIPTION', 1);
-----------------------------------------------
-- UnitAbilityModifiers
-----------------------------------------------
INSERT OR REPLACE INTO UnitAbilityModifiers (UnitAbilityType,						ModifierId) VALUES	
('ABILITY_IGNORE_WOOD',			            'RANGER_IGNORE_FOREST_MOVEMENT_PENALTY'),
('ABILITY_IGNORE_WOOD',			            'SENTRY_SEE_THROUGH_FEATURES');