-----------------------------------------------
-- TraitModifiers
-----------------------------------------------
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ADJUST_MILITARY_ENGINEER_PRODUCTION';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ADJUST_MILITARY_ENGINEER_BUILDCHARGES';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ADJUST_LIGHTHOUSE_STOCKPILE_CAP';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ADJUST_SHIPYARD_STOCKPILE_CAP';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ADJUST_SEAPORT_STOCKPILE_CAP';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ACCUMULATE_MORE_IRON';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_ACCUMULATE_MORE_COAL';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_POWERED_BUILDINGS_MORE_CULTURE';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_POWERED_BUILDINGS_MORE_GOLD';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_POWERED_BUILDINGS_MORE_PRODUCTION';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_POWERED_BUILDINGS_MORE_SCIENCE';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION' AND ModifierId = 'TRAIT_POWERED_BUILDINGS_MORE_FOOD';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_PAX_BRITANNICA' AND ModifierId = 'TRAIT_ROYAL_NAVY_DOCKYARD_NAVAL_UNIT';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_LEADER_PAX_BRITANNICA' AND ModifierId = 'TRAIT_FOREIGN_CONTINENT_MELEE_UNIT';


INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierID) VALUES	
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_INDUSTRIAL_ZONE_PRODUCTION'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_CITY'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_COASTAL_CITY'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_CULTURE_BOMB'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_INDUSTRIALIZATION'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_SCIENTIFIC_THEORY'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_BALLISTICS'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_RIFLING'),
('TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',	'TRAIT_ROYAL_NAVY_DOCKYARD_NAVAL_UNIT'),
('TRAIT_LEADER_PAX_BRITANNICA',	                'GOLDEN_TRAIT_PAX_BRITANNICA_FOREIGN_CITY_MELEE_UNIT');

INSERT OR REPLACE INTO TraitModifiers (TraitType,				ModifierId)
SELECT	'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',		'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_CITY' ||YieldType FROM Yields;
INSERT OR REPLACE INTO TraitModifiers (TraitType,				ModifierId)
SELECT	'TRAIT_CIVILIZATION_INDUSTRIAL_REVOLUTION',		'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_COASTAL_CITY' ||YieldType FROM Yields;

-----------------------------------------------
-- Modifiers
-----------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,						ModifierType,								                                    SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_INDUSTRIAL_ZONE_PRODUCTION',			'MODIFIER_PLAYER_CITIES_ADJUST_DISTRICT_PRODUCTION',		NULL),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_CULTURE_BOMB',	                        'MODIFIER_PLAYER_ADD_CULTURE_BOMB_TRIGGER',		NULL);

INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_PAX_BRITANNICA_FOREIGN_CITY_MELEE_UNIT',             'MODIFIER_PLAYER_CITIES_GRANT_UNIT_BY_CLASS',         0, 0,                       'GOLDEN_ENGLAND_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS'),
('GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_CITY',                       'MODIFIER_PLAYER_BUILT_CITIES_GRANT_FREE_POPULATION', 0, 1,                       'GOLDEN_ENGLAND_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS'),
('GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_COASTAL_CITY',               'MODIFIER_PLAYER_BUILT_CITIES_GRANT_FREE_POPULATION', 0, 1,                       'GOLDEN_ENGLAND_COASTAL_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_INDUSTRIALIZATION',       'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY',          1, 1,                       'GOLDEN_PLAYER_HAS_TECH_MASS_PRODUCTION_AND_TECH_SQUARE_RIGGING_REQUIREMENTS'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_SCIENTIFIC_THEORY',       'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY',          1, 1,                       'GOLDEN_PLAYER_HAS_TECH_ASTRONOMY_REQUIREMENTS'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_BALLISTICS',              'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY',          1, 1,                       'GOLDEN_PLAYER_HAS_TECH_SIEGE_TACTICS_REQUIREMENTS'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_RIFLING',                 'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY',          1, 1,                       'GOLDEN_PLAYER_HAS_TECH_METAL_CASTING_REQUIREMENTS');

INSERT OR REPLACE INTO Modifiers (ModifierId,										ModifierType,												SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_CITY' ||YieldType,	                        'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				'GOLDEN_ENGLAND_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' FROM Yields;
INSERT OR REPLACE INTO Modifiers (ModifierId,										ModifierType,												SubjectRequirementSetId)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_COASTAL_CITY' ||YieldType,	                'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				'GOLDEN_ENGLAND_COASTAL_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' FROM Yields;
-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,			Name,		        Value) VALUES
('GOLDEN_TRAIT_PAX_BRITANNICA_FOREIGN_CITY_MELEE_UNIT',			                    'UnitPromotionClassType',	    'PROMOTION_CLASS_MELEE'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_INDUSTRIAL_ZONE_PRODUCTION',					'DistrictType',	                'DISTRICT_INDUSTRIAL_ZONE'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_INDUSTRIAL_ZONE_PRODUCTION',					'Amount',	                    100),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_CULTURE_BOMB',                                 'DistrictType',                 'DISTRICT_INDUSTRIAL_ZONE'),
('GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_CITY',					                    'Amount',	                    2),
('GOLDEN_TRAIT_FREE_POPULATION_FOREIGN_COASTAL_CITY',					            'Amount',	                    2),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_INDUSTRIALIZATION',		                'TechType',	                    'TECH_INDUSTRIALIZATION'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_SCIENTIFIC_THEORY',		                'TechType',	                    'TECH_SCIENTIFIC_THEORY'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_BALLISTICS',		                        'TechType',	                    'TECH_BALLISTICS'),
('GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_TECH_RIFLING',		                            'TechType',	                    'TECH_RIFLING');

UPDATE ModifierArguments SET  Value = 100
WHERE ModifierId = 'TRAIT_ADJUST_INDUSTRIAL_ZONE_BUILDINGS_PRODUCTION' AND Name = 'Amount';
UPDATE ModifierArguments SET  Value = 2
WHERE ModifierId = 'TRAIT_FOREIGN_CONTINENT_TRADE_ROUTE' AND Name = 'Amount';

INSERT OR REPLACE INTO ModifierArguments (ModifierId,						Name,			            Value)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_CITY' ||YieldType,	        'Amount',	    8 FROM Yields;
INSERT OR REPLACE INTO ModifierArguments (ModifierId,						Name,			            Value)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_CITY' ||YieldType,	        'YieldType',	YieldType FROM Yields;
INSERT OR REPLACE INTO ModifierArguments (ModifierId,						Name,			            Value)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_COASTAL_CITY' ||YieldType,	        'Amount',	    8 FROM Yields;
INSERT OR REPLACE INTO ModifierArguments (ModifierId,						Name,			            Value)
SELECT	'GOLDEN_TRAIT_INDUSTRIAL_REVOLUTION_FOREIGN_COASTAL_CITY' ||YieldType,	        'YieldType',	YieldType FROM Yields;
---------------------------------------------------------------------------------------------------------------
-- RequirementSets
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,         RequirementSetType) 	VALUES
('GOLDEN_ENGLAND_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		        'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_ENGLAND_COASTAL_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 	    'REQUIREMENTSET_TEST_ALL'),
('GOLDEN_PLAYER_HAS_TECH_MASS_PRODUCTION_AND_TECH_SQUARE_RIGGING_REQUIREMENTS' , 	'REQUIREMENTSET_TEST_ALL');
---------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,         RequirementId) 			VALUES 		
('GOLDEN_ENGLAND_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		            'REQUIRES_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT'),
('GOLDEN_ENGLAND_COASTAL_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		    'REQUIRES_CITY_IS_NOT_OWNER_CAPITAL_CONTINENT'),
('GOLDEN_ENGLAND_COASTAL_CITY_NOT_OWNER_CAPITAL_CONTINENT_REQUIREMENTS' , 		    'GOLDEN_REQUIRES_PLOT_ADJACENT_TO_COAST'),
('GOLDEN_PLAYER_HAS_TECH_MASS_PRODUCTION_AND_TECH_SQUARE_RIGGING_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLAYER_HAS_TECH_SQUARE_RIGGING'),
('GOLDEN_PLAYER_HAS_TECH_MASS_PRODUCTION_AND_TECH_SQUARE_RIGGING_REQUIREMENTS' , 		'GOLDEN_REQUIRES_PLAYER_HAS_TECH_MASS_PRODUCTION');