---------------------------------------------------------------------------------------------------------------
-- TraitModifiers
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType,					ModifierId)	
SELECT DISTINCT 'TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS',	'GOLDEN_TRAIT_FAITH_PURCHASE_' ||PrereqDistrict|| '_BUILDINGS'
FROM Buildings WHERE (PrereqDistrict IS NOT NULL) AND (TraitType IS NULL) AND (InternalOnly = 0);
INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierID) VALUES	
('TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS',	'GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_MASONRY'),
('TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS',	'GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_CASTLES'),
('TRAIT_LEADER_RELIGION_CITY_STATES',	    'GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_RELIGIOUS_PEOPLE');
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS' AND ModifierId = 'TRAIT_WALLS_PRODUCTION';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS' AND ModifierId = 'TRAIT_CASTLE_PRODUCTION';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS' AND ModifierId = 'TRAIT_TSIKHE_PRODUCTION';
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS' AND ModifierId = 'TRAIT_STAR_FORT_PRODUCTION';
---------------------------------------------------------------------------------------------------------------
-- Modifiers
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId,												ModifierType)
SELECT DISTINCT 'GOLDEN_TRAIT_FAITH_PURCHASE_' ||PrereqDistrict|| '_BUILDINGS',	'MODIFIER_PLAYER_CITIES_ENABLE_BUILDING_FAITH_PURCHASE'
FROM Buildings WHERE (PrereqDistrict IS NOT NULL) AND (TraitType IS NULL) AND (InternalOnly = 0);
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId) VALUES	
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_MASONRY',             'MODIFIER_PLAYER_GRANT_SPECIFIC_TECHNOLOGY',               1, 1, NULL),
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_CASTLES',	            'MODIFIER_PLAYER_GRANT_SPECIFIC_TECH_BOOST',               1, 1, NULL),
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_RELIGIOUS_PEOPLE',	'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_PER_POPULATION', 0, 0, 'CITY_HAS_GOVERNOR');
---------------------------------------------------------------------------------------------------------------
-- ModifierArguments
---------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId,													Name,			Value)
SELECT DISTINCT	'GOLDEN_TRAIT_FAITH_PURCHASE_' ||PrereqDistrict|| '_BUILDINGS',	'DistrictType',	PrereqDistrict
FROM Buildings WHERE (PrereqDistrict IS NOT NULL) AND (TraitType IS NULL) AND (InternalOnly = 0);
INSERT OR REPLACE INTO ModifierArguments (ModifierId,			Name,		        Value) VALUES
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_MASONRY',		              'TechType',	    'TECH_MASONRY'),
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_CASTLES',			          'TechType',	    'TECH_CASTLES'),
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_RELIGIOUS_PEOPLE',		  'YieldType',	    'YIELD_FAITH'),
('GOLDEN_TRAIT_CIVILIZATION_GOLDEN_AGE_QUESTS_RELIGIOUS_PEOPLE',		  'Amount',	        1);
