-----------------------------------------------
-- ExcludedDistricts
-----------------------------------------------
INSERT OR REPLACE INTO ExcludedDistricts (DistrictType, 			TraitType) VALUES	
('DISTRICT_ENTERTAINMENT_COMPLEX',	'TRAIT_LEADER_SATYAGRAHA'),
('DISTRICT_WATER_ENTERTAINMENT_COMPLEX',	'TRAIT_LEADER_SATYAGRAHA');
-----------------------------------------------
-- TraitModifiers
-----------------------------------------------
INSERT OR REPLACE INTO TraitModifiers (TraitType, 			ModifierID) VALUES	
('TRAIT_CIVILIZATION_DHARMA',	'GOLDEN_INDIA_FREE_STARTING_FAITH'),
('TRAIT_CIVILIZATION_DHARMA',	'GOLDEN_TRAIT_APOSTLE_SPREADS'),
('TRAIT_LEADER_SATYAGRAHA',	'GOLDEN_TRAIT_SATYAGRAHA_HOLY_SITE_AMENITY'),
('TRAIT_LEADER_SATYAGRAHA',	'GOLDEN_TRAIT_SATYAGRAHA_SHRINE_AMENITY'),
('TRAIT_LEADER_SATYAGRAHA',	'GOLDEN_TRAIT_SATYAGRAHA_TEMPLE_AMENITY'),
('TRAIT_LEADER_SATYAGRAHA',	'GOLDEN_TRAIT_SATYAGRAHA_WORKSHIP_AMENITY'),
('TRAIT_LEADER_ARTHASHASTRA',	'GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER'),
('TRAIT_LEADER_ARTHASHASTRA',	'GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADE_ROUTE'),
('TRAIT_LEADER_ARTHASHASTRA',	'GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER');
DELETE FROM TraitModifiers WHERE TraitType = 'TRAIT_CIVILIZATION_DHARMA' AND ModifierId = 'TRAIT_ORIGIN_DESTINATION_RELIGIOUS_PRESSURE'; 
-----------------------------------------------
-- Modifiers
-----------------------------------------------
INSERT OR REPLACE INTO Modifiers (ModifierId, ModifierType, RunOnce, Permanent, SubjectRequirementSetId) VALUES	
('GOLDEN_INDIA_FREE_STARTING_FAITH', 'MODIFIER_PLAYER_GRANT_YIELD', 1, 1, NULL),
('GOLDEN_TRAIT_APOSTLE_SPREADS',	'MODIFIER_PLAYER_UNITS_RELIGIOUS_SPREADS', 0, 1, 'GOLDEN_UNIT_IS_APOSTLE_REQUIREMENTS'),
('GOLDEN_TRAIT_SATYAGRAHA_HOLY_SITE_AMENITY',	'MODIFIER_PLAYER_DISTRICTS_ADJUST_EXTRA_ENTERTAINMENT', 0, 0, 'DISTRICT_IS_HOLY_SITE'),
('GOLDEN_TRAIT_SATYAGRAHA_SHRINE_AMENITY',	'MODIFIER_PLAYER_CITIES_ADJUST_TRAIT_AMENITY', 0, 0, 'GOLDEN_CITY_HAS_BUILDING_SHRINE_REQUIREMENTS'),
('GOLDEN_TRAIT_SATYAGRAHA_TEMPLE_AMENITY',	'MODIFIER_PLAYER_CITIES_ADJUST_TRAIT_AMENITY', 0, 0, 'GOLDEN_CITY_HAS_BUILDING_TEMPLE_REQUIREMENTS'),
('GOLDEN_TRAIT_SATYAGRAHA_WORKSHIP_AMENITY',	'MODIFIER_PLAYER_CITIES_ADJUST_TRAIT_AMENITY', 0, 0, 'GOLDEN_BUILDING_IS_WORSHIP_BUILDING_REQUIREMENTS'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER',	'MODIFIER_PLAYER_CITIES_ATTACH_MODIFIER', 0, 0, 'GOLDEN_CITY_HAS_DISTRICT_ENCAMPMENT_REQUIREMENTS'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER_MODIFIER',	'MODIFIER_SINGLE_CITY_GRANT_UNIT_IN_CITY', 1, 1, NULL),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADE_ROUTE',	'MODIFIER_PLAYER_CITIES_ADJUST_TRADE_ROUTE_CAPACITY', 0, 0, 'GOLDEN_DISTRICT_IS_ENCAMPMENT_BUILDING_IS_PALACE_REQUIREMENTS'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER',	'MODIFIER_PLAYER_CITIES_ATTACH_MODIFIER', 0, 0, 'GOLDEN_DISTRICT_IS_ENCAMPMENT_BUILDING_IS_PALACE_REQUIREMENTS'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER_MODIFIER',	'MODIFIER_SINGLE_CITY_GRANT_UNIT_IN_CITY', 1, 1, NULL);
-----------------------------------------------
-- ModifierArguments
-----------------------------------------------
INSERT OR REPLACE INTO ModifierArguments (ModifierId, 			Name, 			Type, 			Value) VALUES	
('GOLDEN_INDIA_FREE_STARTING_FAITH', 	'Amount', 	'ScaleByGameSpeed', 	'30'),
('GOLDEN_INDIA_FREE_STARTING_FAITH', 	'YieldType', 	'ARGTYPE_IDENTITY', 	'YIELD_FAITH');	
INSERT OR REPLACE INTO ModifierArguments (ModifierId,				            Name,		        Value) VALUES
('GOLDEN_TRAIT_APOSTLE_SPREADS',					'Amount',	        2),
('GOLDEN_TRAIT_SATYAGRAHA_HOLY_SITE_AMENITY',		'Amount',	        1),
('GOLDEN_TRAIT_SATYAGRAHA_SHRINE_AMENITY',			'Amount',	        2),
('GOLDEN_TRAIT_SATYAGRAHA_TEMPLE_AMENITY',			'Amount',	        3),
('GOLDEN_TRAIT_SATYAGRAHA_WORKSHIP_AMENITY',		'Amount',	        4),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER',			        'ModifierId',	    'GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER_MODIFIER'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER_MODIFIER',		'UnitType',	        'UNIT_BUILDER'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_BUILDER_MODIFIER',		'Amount',	        1),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER',			        'ModifierId',	    'GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER_MODIFIER'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER_MODIFIER',		    'UnitType',	        'UNIT_TRADER'),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADER_MODIFIER',		    'Amount',	        1),
('GOLDEN_TRAIT_ARTHASHASTRA_GRANT_TRADE_ROUTE',		        'Amount',	        1);
UPDATE ModifierArguments SET  Value = 10
WHERE ModifierId = 'TRAIT_FAITH_PEACEFUL_FOUNDERS' AND Name = 'Amount';
-----------------------------------------------
-- RequirementSets
-----------------------------------------------
INSERT OR REPLACE INTO RequirementSets 				(RequirementSetId ,     RequirementSetType) 	
VALUES 		('GOLDEN_DISTRICT_IS_ENCAMPMENT_BUILDING_IS_PALACE_REQUIREMENTS' , 			    'REQUIREMENTSET_TEST_ALL');
-----------------------------------------------
-- RequirementSetRequirements
-----------------------------------------------
INSERT OR REPLACE INTO RequirementSetRequirements 	(RequirementSetId ,     RequirementId) 			
VALUES 		('GOLDEN_DISTRICT_IS_ENCAMPMENT_BUILDING_IS_PALACE_REQUIREMENTS' , 			    'GOLDEN_REQUIRES_CITY_HAS_DISTRICT_ENCAMPMENT'),
            ('GOLDEN_DISTRICT_IS_ENCAMPMENT_BUILDING_IS_PALACE_REQUIREMENTS' , 			    'GOLDEN_REQUIRES_CITY_HAS_BUILDING_PALACE');